/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.airport.views;

import com.rocktasticgames.airport.animated.AnimatedElement;
import com.rocktasticgames.airport.c2m.C2MValues;
import com.rocktasticgames.airport.main.MainActivity;
import com.rocktasticgames.airport.utils.MotionEvent;
import com.rocktasticgames.airport.views.MenuView;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LanguageView {
    private Image bg;
    private AnimatedElement en;
    private AnimatedElement fr;
    private AnimatedElement de;
    private AnimatedElement pt;
    private AnimatedElement es;
    private MainActivity activity;
    private boolean loaded = false;
    private int select_option = 0;
    private long start_time;

    public LanguageView(MainActivity mainActivity) {
        this.activity = mainActivity;
        this.start_time = System.currentTimeMillis();
        try {
            this.bg = Image.createImage((String)"/opening_bg_sky.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        this.en.recycle();
        this.fr.recycle();
        this.de.recycle();
        this.pt.recycle();
        this.es.recycle();
    }

    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        if (animatedElement == null) {
            switch (this.activity.getSharedPref().getInt("language", 0)) {
                default: {
                    return this.en;
                }
                case 1: {
                    return this.fr;
                }
                case 2: {
                    return this.de;
                }
                case 3: {
                    return this.pt;
                }
                case 4: 
            }
            return this.es;
        }
        if (n == 2 || n == 5) {
            return animatedElement;
        }
        if (n == 1) {
            if (animatedElement == this.en || animatedElement == this.fr) {
                return this.en;
            }
            if (animatedElement == this.de) {
                return this.fr;
            }
            if (animatedElement == this.pt) {
                return this.de;
            }
            if (animatedElement == this.es) {
                return this.pt;
            }
        } else if (n == 6) {
            if (animatedElement == this.es || animatedElement == this.pt) {
                return this.es;
            }
            if (animatedElement == this.de) {
                return this.pt;
            }
            if (animatedElement == this.fr) {
                return this.de;
            }
            if (animatedElement == this.en) {
                return this.fr;
            }
        }
        return animatedElement;
    }

    private void loadResources(float f, float f2, float f3) {
        this.activity.registerDimensions(f2, f3);
        this.en = new AnimatedElement(this.activity, "UKUS_flag", 0.3111979f, 0.32421875f, f2, f3, 3, 300L);
        this.fr = new AnimatedElement(this.activity, "france_flag", 0.3111979f, 0.4189453f, f2, f3, 3, 400L);
        this.de = new AnimatedElement(this.activity, "germany_flag", 0.3111979f, 0.5136719f, f2, f3, 3, 500L);
        this.pt = new AnimatedElement(this.activity, "portugal_flag", 0.3111979f, 0.60839844f, f2, f3, 3, 600L);
        this.es = new AnimatedElement(this.activity, "spain_flag", 0.3111979f, 0.703125f, f2, f3, 3, 700L);
        switch (this.activity.getSharedPref().getInt("language", 0)) {
            default: {
                this.activity.getCanvas().setFocus(this.en);
                break;
            }
            case 1: {
                this.activity.getCanvas().setFocus(this.fr);
                break;
            }
            case 2: {
                this.activity.getCanvas().setFocus(this.de);
                break;
            }
            case 3: {
                this.activity.getCanvas().setFocus(this.pt);
                break;
            }
            case 4: {
                this.activity.getCanvas().setFocus(this.es);
            }
        }
        this.loaded = true;
    }

    public void onDraw(Graphics graphics) {
        float f = this.activity.getCanvas().getWidth();
        float f2 = this.activity.getCanvas().getHeight();
        if (!this.loaded) {
            this.loadResources(f / f2, f, f2);
        }
        long l = System.currentTimeMillis() - this.start_time;
        graphics.setColor(-1);
        graphics.fillRect(0, 0, this.activity.getCanvas().getWidth(), this.activity.getCanvas().getHeight());
        boolean bl = false;
        if (!this.en.render(graphics, l)) {
            bl = true;
        }
        if (!this.fr.render(graphics, l)) {
            bl = true;
        }
        if (!this.de.render(graphics, l)) {
            bl = true;
        }
        if (!this.pt.render(graphics, l)) {
            bl = true;
        }
        if (!this.es.render(graphics, l)) {
            bl = true;
        }
        this.activity.getCartoon().renderString(graphics, -16777216, C2MValues.LANGUAGE_NAME[0], (int)(this.en.getX(l) + f / 10.0f), (int)(this.en.getY(l) - f / 30.0f));
        this.activity.getCartoon().renderString(graphics, -16777216, C2MValues.LANGUAGE_NAME[1], (int)(this.fr.getX(l) + f / 10.0f), (int)(this.fr.getY(l) - f / 30.0f));
        this.activity.getCartoon().renderString(graphics, -16777216, C2MValues.LANGUAGE_NAME[2], (int)(this.de.getX(l) + f / 10.0f), (int)(this.de.getY(l) - f / 30.0f));
        this.activity.getCartoon().renderString(graphics, -16777216, C2MValues.LANGUAGE_NAME[3], (int)(this.pt.getX(l) + f / 10.0f), (int)(this.pt.getY(l) - f / 30.0f));
        this.activity.getCartoon().renderString(graphics, -16777216, C2MValues.LANGUAGE_NAME[4], (int)(this.es.getX(l) + f / 10.0f), (int)(this.es.getY(l) - f / 30.0f));
        if (bl) {
            this.activity.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        this.activity.invalidate();
        if (!this.loaded || System.currentTimeMillis() - this.start_time < 700L) {
            return false;
        }
        switch (n) {
            case 1: {
                switch (this.select_option) {
                    case 1: {
                        this.en.setFilter(null);
                        this.activity.getPrefEditor().putInt("language", 0);
                        this.activity.getPrefEditor().commit();
                        this.activity.onLanguageComplete();
                        break;
                    }
                    case 2: {
                        this.fr.setFilter(null);
                        this.activity.getPrefEditor().putInt("language", 1);
                        this.activity.getPrefEditor().commit();
                        this.activity.onLanguageComplete();
                        break;
                    }
                    case 3: {
                        this.de.setFilter(null);
                        this.activity.getPrefEditor().putInt("language", 2);
                        this.activity.getPrefEditor().commit();
                        this.activity.onLanguageComplete();
                        break;
                    }
                    case 4: {
                        this.pt.setFilter(null);
                        this.activity.getPrefEditor().putInt("language", 3);
                        this.activity.getPrefEditor().commit();
                        this.activity.onLanguageComplete();
                        break;
                    }
                    case 5: {
                        this.es.setFilter(null);
                        this.activity.getPrefEditor().putInt("language", 4);
                        this.activity.getPrefEditor().commit();
                        this.activity.onLanguageComplete();
                    }
                }
                this.select_option = 0;
                return false;
            }
            case 2: {
                if (this.en.inRange(this.en.getX(2000L) / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                    this.select_option = 1;
                    this.en.setFilter(MenuView.filter_dark);
                } else if (this.fr.inRange(this.en.getX(2000L) / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                    this.select_option = 2;
                    this.fr.setFilter(MenuView.filter_dark);
                } else if (this.de.inRange(this.en.getX(2000L) / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                    this.select_option = 3;
                    this.de.setFilter(MenuView.filter_dark);
                } else if (this.pt.inRange(this.en.getX(2000L) / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                    this.select_option = 4;
                    this.pt.setFilter(MenuView.filter_dark);
                } else if (this.es.inRange(this.en.getX(2000L) / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) {
                    this.select_option = 5;
                    this.es.setFilter(MenuView.filter_dark);
                }
                return true;
            }
            case 3: {
                switch (this.select_option) {
                    case 1: {
                        if (this.en.inRange(this.en.getX(2000L) / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.en.setFilter(null);
                        break;
                    }
                    case 2: {
                        if (this.fr.inRange(this.en.getX(2000L) / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.fr.setFilter(null);
                        break;
                    }
                    case 3: {
                        if (this.de.inRange(this.en.getX(2000L) / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.de.setFilter(null);
                        break;
                    }
                    case 4: {
                        if (this.pt.inRange(this.en.getX(2000L) / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.pt.setFilter(null);
                        break;
                    }
                    case 5: {
                        if (this.es.inRange(this.en.getX(2000L) / (float)this.activity.getCanvas().getWidth(), (float)motionEvent.getY() / (float)this.activity.getCanvas().getHeight())) break;
                        this.select_option = 0;
                        this.es.setFilter(null);
                    }
                }
                return true;
            }
        }
        return true;
    }

    public static class MenuOption {
        public static final int NONE = 0;
        public static final int EN = 1;
        public static final int FR = 2;
        public static final int DE = 3;
        public static final int PT = 4;
        public static final int ES = 5;
    }
}

