/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.skiresort.main;

import com.rocktasticgames.skiresort.animated.AnimatedElement;
import com.rocktasticgames.skiresort.animated.AnimatedPointer;
import com.rocktasticgames.skiresort.main.MainActivity;
import com.rocktasticgames.skiresort.utils.MotionEvent;
import com.rocktasticgames.skiresort.views.MenuView;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainCanvas
extends Canvas {
    private MainActivity activity;
    private AnimatedElement focus;
    private AnimatedPointer pointer;

    public MainCanvas(MainActivity mainActivity) {
        this.activity = mainActivity;
        try {
            this.pointer = new AnimatedPointer(Image.createImage((String)"/pointerarrow.png"), this.getWidth(), this.getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void paint(Graphics graphics) {
        if (this.getWidth() > this.getHeight() && (this.activity.getState() == 3 || this.activity.getState() == 4 || this.activity.getState() == 2)) {
            String string;
            this.activity.pause();
            switch (this.activity.getLanguage()) {
                default: {
                    string = "Please reorientate handset screen.";
                    break;
                }
                case 1: {
                    string = "Veuillez r\u00c3\u00a9orienter l'\u00c3\u00a9cran de votre appareil.";
                    break;
                }
                case 2: {
                    string = "Bitte den Bildschirm des Handys neu orientieren.";
                    break;
                }
                case 3: {
                    string = "Reorienta o ecr\u00c3\u00a3 do telem\u00c3\u00b3vel.";
                    break;
                }
                case 4: {
                    string = "Reorienta la pantalla del dispositivo.";
                }
            }
            string = string.toUpperCase();
            graphics.setColor(-1);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.translate(this.getWidth() / 2 - this.activity.getBrady().measure(string) / 2, this.getHeight() / 2 - graphics.getFont().getHeight() / 2);
            this.activity.getBrady().renderString(graphics, -16777216, string);
            graphics.translate(-(this.getWidth() / 2 - this.activity.getBrady().measure(string) / 2), -(this.getHeight() / 2 - graphics.getFont().getHeight() / 2));
            this.activity.invalidate();
            return;
        }
        switch (this.activity.getState()) {
            case 3: {
                this.activity.getKitchen().onDraw(graphics);
                break;
            }
            case 4: {
                this.activity.getMap().onDraw(graphics);
                break;
            }
            case 2: {
                this.activity.getMenu().onDraw(graphics);
                break;
            }
            case 6: {
                this.activity.getSplashOne().onDraw(graphics);
                break;
            }
            case 7: {
                this.activity.getSplashTwo().onDraw(graphics);
                break;
            }
            case 8: {
                this.activity.getSoundView().onDraw(graphics);
                break;
            }
            case 9: {
                this.activity.getLanguageView().onDraw(graphics);
            }
        }
        if (this.focus != null) {
            this.pointer.setTarget(this.focus);
        } else if (this.activity.getState() == 9) {
            this.focus = this.activity.getLanguageView().traverse(this.focus, 1);
        } else if (this.activity.getState() == 8) {
            this.focus = this.activity.getSoundView().traverse(this.focus, 2);
        } else if (this.activity.getState() == 2) {
            this.focus = this.activity.getMenu().traverse(this.focus, 1);
            if (this.focus != null) {
                this.pointer.setTarget(this.focus);
            }
        }
        if (this.activity.getState() != 6 && this.activity.getState() != 7 && this.focus != null) {
            this.pointer.render(graphics, 0L);
        }
    }

    private void sendMotionEvent(int n, int n2, int n3) {
        this.activity.invalidate();
        switch (this.activity.getState()) {
            case 3: {
                this.activity.getKitchen().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 4: {
                this.activity.getMap().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 2: {
                this.activity.getMenu().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 6: {
                this.activity.getSplashOne().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 7: {
                this.activity.getSplashTwo().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 8: {
                this.activity.getSoundView().onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 9: {
                this.activity.getLanguageView().onTouchEvent(new MotionEvent(n, n2, n3));
            }
        }
    }

    public AnimatedElement getFocus() {
        return this.focus;
    }

    private AnimatedElement getNeighbor(int n) {
        this.activity.invalidate();
        switch (this.activity.getState()) {
            case 3: {
                return this.activity.getKitchen().traverse(this.focus, n);
            }
            case 4: {
                return this.activity.getMap().traverse(this.focus, n);
            }
            case 2: {
                return this.activity.getMenu().traverse(this.focus, n);
            }
            case 8: {
                return this.activity.getSoundView().traverse(this.focus, n);
            }
            case 9: {
                return this.activity.getLanguageView().traverse(this.focus, n);
            }
        }
        return this.focus;
    }

    public void setFocus(AnimatedElement animatedElement) {
        this.focus = animatedElement;
        this.pointer.setTarget(animatedElement);
    }

    protected void keyPressed(int n) {
        if (n == -11) {
            this.activity.onBackPressed();
            return;
        }
        if (n != 48) {
            if (n == -6) {
                if (this.activity.getState() == 2) {
                    this.activity.getMenu().quitSelect();
                } else if (this.activity.getState() == 4 && !this.activity.isPaused()) {
                    this.activity.openKitchen();
                }
                return;
            }
            if (n == -7) {
                if (this.activity.getState() == 3 && !this.activity.isPaused()) {
                    this.activity.openMap();
                }
                return;
            }
        }
        switch (this.getGameAction(n)) {
            case 8: {
                this.pointer.setFilter(MenuView.filter_dark);
                this.pointer.setPNG("pointerarrow_click");
                if (this.focus != null) {
                    this.pointerPressed((int)this.focus.getX(Long.MAX_VALUE), (int)this.focus.getY(Long.MAX_VALUE));
                    break;
                }
                this.pointerPressed(1, 1);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.focus = this.getNeighbor(this.getGameAction(n));
                if (this.focus == null) break;
                this.pointer.setTarget(this.focus);
            }
        }
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
        long l = this.activity.getTime();
        switch (this.getGameAction(n)) {
            case 8: {
                if (this.focus != null) {
                    this.pointerReleased((int)this.focus.getX(Long.MAX_VALUE), (int)this.focus.getY(Long.MAX_VALUE));
                } else {
                    this.pointerReleased(1, 1);
                }
                this.pointer.setFilter(null);
                this.pointer.setPNG("pointerarrow");
                break;
            }
            case 1: {
                break;
            }
            case 6: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    protected void pointerReleased(int n, int n2) {
        this.sendMotionEvent(1, n, n2);
    }

    protected void pointerPressed(int n, int n2) {
        this.sendMotionEvent(2, n, n2);
    }

    protected void pointerDragged(int n, int n2) {
        this.sendMotionEvent(3, n, n2);
    }
}

