/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.skiresort.views;

import com.rocktasticgames.skiresort.main.MainActivity;
import com.rocktasticgames.skiresort.utils.GraphicsContainer;
import com.rocktasticgames.skiresort.utils.MotionEvent;
import javax.microedition.lcdui.Image;

public class SplashC2MView {
    private MainActivity activity;
    private Image bmp;
    private boolean drawn = false;
    private boolean exec = false;
    private long start_time;

    public SplashC2MView(MainActivity mainActivity) {
        this.activity = mainActivity;
        try {
            this.bmp = Image.createImage((String)"/logo_c2m.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        this.bmp = null;
        System.gc();
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        if (this.drawn && !this.exec) {
            this.activity.splashTaskOne();
            this.exec = true;
        }
        graphicsContainer.setColor(-1);
        graphicsContainer.fillRect(0, 0, this.activity.getCanvas().getRZWidth(), this.activity.getCanvas().getRZHeight());
        graphicsContainer.drawImage(this.bmp, this.activity.getCanvas().getRZWidth() / 2, this.activity.getCanvas().getRZHeight() / 2, 3);
        if (!this.drawn) {
            this.drawn = true;
            this.start_time = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() > this.start_time + 2000L) {
            this.activity.onSplashOneComplete();
        } else if (this.exec) {
            this.activity.postInvalidateDelayed(500L);
        } else {
            this.activity.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        this.activity.invalidate();
        switch (n) {
            case 1: {
                if (this.drawn && this.exec) {
                    this.activity.onSplashOneComplete();
                }
                return false;
            }
        }
        return true;
    }
}

