/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Level {
    public static final int GS_TILE_W = 1;
    public static final int GS_TILE_H = 2;
    public static final int BIND_POINT_LEFT = 1;
    public static final int BIND_POINT_TOP = 2;
    public static Level _instance;
    private int iTileW;
    private int iTileH;
    private int iTileZH;
    public int iLeft;
    public int iTop;
    private int iWidth;
    private int iHeight;
    private int iScreenW;
    private int iScreenH;
    public Mesh[] _Tiles;
    public Mesh[] _TilesDraw;
    public int iMeshCount;
    private int iVolumeX;
    private int iVolumeY;
    private int iVolumeZ;
    public int[][] iZTiles;
    public int[] iZTilesCount;

    public Level() {
        _instance = this;
        this.iMeshCount = 0;
    }

    public Level(int n) {
        _instance = this;
        this._Tiles = new Mesh[n];
        this._TilesDraw = new Mesh[n];
        this.iMeshCount = 0;
    }

    public Level(int n, int n2, int n3) {
        _instance = this;
        this._Tiles = new Mesh[n];
        this._TilesDraw = new Mesh[n];
        this.iMeshCount = 0;
        this.iScreenW = n2;
        this.iScreenH = n3;
    }

    public int getTilesCount() {
        if (this._Tiles != null) {
            return this._Tiles.length;
        }
        return 0;
    }

    public void initVolume(int n, int n2, int n3, int n4, int n5, int n6) {
        this.iTileW = n4;
        this.iTileH = n5;
        this.iTileZH = n6;
        this.iVolumeX = n + 1;
        this.iVolumeY = n2 + 1;
        this.iVolumeZ = n3;
        this.iHeight = this.iVolumeY / 2 * this.iTileH;
        this.iWidth = this.iVolumeX / 2 * this.iTileW;
        this.iLeft = this.iScreenW / 2 - this.iWidth / 2;
        this.iTop = this.iScreenH / 2 - this.iHeight / 2;
    }

    public void initZFields() {
        this.iZTiles = new int[this.iVolumeZ][this._Tiles.length];
        this.iZTilesCount = new int[this.iVolumeZ];
        for (int i = 0; i < this.iVolumeZ; ++i) {
            int n = 0;
            for (int j = 0; j < this._Tiles.length; ++j) {
                if (this._Tiles[j].Layer != i) continue;
                this.iZTiles[i][n] = j;
                int n2 = i;
                this.iZTilesCount[n2] = this.iZTilesCount[n2] + 1;
                ++n;
            }
        }
    }

    public void addMesh(int n, int n2, int n3, int n4) {
        if (this._Tiles[this.iMeshCount] == null) {
            return;
        }
        this._Tiles[this.iMeshCount] = new Mesh(n);
        ++this.iMeshCount;
    }

    public void addMesh(int n, int[] nArray, int n2) {
        if (this._Tiles[this.iMeshCount] != null) {
            return;
        }
        if (nArray == null) {
            return;
        }
        this._Tiles[this.iMeshCount] = new Mesh(n, this.iTileW, this.iTileH, nArray);
        this._Tiles[this.iMeshCount].Y = nArray[1] * (this.iTileH / 2);
        this._Tiles[this.iMeshCount].Z = nArray[2] * this.iTileZH;
        this._Tiles[this.iMeshCount].Layer = nArray[2];
        Mesh cfr_ignored_0 = this._Tiles[this.iMeshCount];
        Mesh.TILES_COUNT_X = n2;
        this._Tiles[this.iMeshCount].setDrawSides(true);
        ++this.iMeshCount;
    }

    public void hideTile(int n) {
        if (this._Tiles == null || this._Tiles[n] == null) {
            return;
        }
        this._Tiles[n].setVisible(false);
    }

    public void showTile(int n) {
        if (this._Tiles == null || this._Tiles[n] == null) {
            return;
        }
        this._Tiles[n].setVisible(true);
    }

    public void Render(Graphics graphics, Image image, Image image2, Image image3, int n, int n2, boolean bl) {
        graphics.drawImage(image2, this.iScreenW / 2 - image2.getWidth() / 2, this.iScreenH / 2 - image2.getHeight() / 2, 0);
        if (this._Tiles == null) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        int n5 = 1;
        if (!bl) {
            n5 = -1;
        }
        for (int i = n3; bl && i < n4 || !bl && i >= n4; i += n5) {
            for (int j = 0; j < this.iZTilesCount[i]; ++j) {
                int n6 = this.iZTiles[i][j];
                this._Tiles[n6].Draw(graphics, image, image3, bl, this.iLeft, this.iTop);
            }
        }
    }

    public void Rotate(int n, boolean bl) {
        if (this._Tiles == null) {
            return;
        }
        for (int i = 0; i < this._Tiles.length; ++i) {
            if (this._Tiles[i] == null) continue;
            this._Tiles[i].Rotate(n, bl);
        }
        this.iWidth = this.iVolumeX / 2 * this.iTileW;
        this.iHeight = this.iVolumeY / 2 * this.iTileH;
        this.iLeft = this.iScreenW / 2 - this.iWidth / 2;
        this.iTop = this.iScreenH / 2 - this.iHeight / 2;
    }

    private void View(int n, int n2) {
    }

    private void Invert() {
        for (int i = 0; i < this._Tiles.length; ++i) {
            int n;
            int n2;
            this._Tiles[i].rcLogicalCell[2] = n2 = this.iVolumeZ - (this._Tiles[i].rcLogicalCell[2] - 1) - 1;
            this._Tiles[i].rcLogicalCell[0] = n = this.iVolumeX - 1 - (this._Tiles[i].rcLogicalCell[0] - 1) - 2;
        }
    }

    private void InvertY() {
        for (int i = 0; i < this._Tiles.length; ++i) {
            int n;
            int n2;
            this._Tiles[i].rcLogicalCell[2] = n2 = this.iVolumeZ - (this._Tiles[i].rcLogicalCell[2] - 1) - 1;
            this._Tiles[i].rcLogicalCell[1] = n = this.iVolumeY - 1 - (this._Tiles[i].rcLogicalCell[1] - 1) - 2;
        }
    }
}

