/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.farmmatch.main;

import com.rocktasticgames.farmmatch.animated.AnimatedElement;
import com.rocktasticgames.farmmatch.animated.AnimatedPointer;
import com.rocktasticgames.farmmatch.main.MainActivity;
import com.rocktasticgames.farmmatch.utils.GraphicsContainer;
import com.rocktasticgames.farmmatch.utils.MotionEvent;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class MainCanvas
extends Canvas {
    private GraphicsContainer gc;
    private MainActivity activity;
    private AnimatedElement focus = null;
    private AnimatedPointer pointer;

    public MainCanvas(MainActivity mainActivity) {
        this.activity = mainActivity;
    }

    public int getRZHeight() {
        return Math.max(super.getHeight(), Math.min(super.getHeight(), super.getWidth()) * 4 / 3);
    }

    public int getRZWidth() {
        return Math.min(super.getHeight(), super.getWidth());
    }

    protected void paint(Graphics graphics) {
        if (this.gc == null) {
            this.setFullScreenMode(true);
            this.gc = new GraphicsContainer(this.getWidth(), this.getHeight());
        }
        this.gc.setGraphics(graphics);
        this.gc.setColor(-16777216);
        this.gc.fillRect(0, 0, 360, 2);
        this.gc.setColor(-1);
        switch (this.activity.getState()) {
            case 10: {
                if (this.activity.gameview == null) break;
                this.activity.gameview.onDraw(this.gc);
                break;
            }
            case 5: {
                if (this.activity.mapview == null) break;
                this.activity.mapview.onDraw(this.gc);
                break;
            }
            case 14: {
                if (this.activity.victoryview == null) break;
                this.activity.victoryview.onDraw(this.gc);
                break;
            }
            case 8: {
                if (this.activity.pregameview == null) break;
                this.activity.pregameview.onDraw(this.gc);
                break;
            }
            case 9: {
                if (this.activity.postgameview == null) break;
                this.activity.postgameview.onDraw(this.gc);
                break;
            }
            case 6: {
                if (this.activity.selectionview == null) break;
                this.activity.selectionview.onDraw(this.gc);
                break;
            }
            case 4: {
                if (this.activity.menu == null) break;
                this.activity.menu.onDraw(this.gc);
                break;
            }
            case 0: {
                if (this.activity.splashone == null) break;
                this.activity.splashone.onDraw(this.gc);
                break;
            }
            case 1: {
                if (this.activity.splashtwo == null) break;
                this.activity.splashtwo.onDraw(this.gc);
                break;
            }
            case 2: {
                if (this.activity.soundview == null) break;
                this.activity.soundview.onDraw(this.gc);
                break;
            }
            case 13: {
                if (this.activity.languageview == null) break;
                this.activity.languageview.onDraw(this.gc);
            }
        }
        this.gc.resetStack();
    }

    private void sendMotionEvent(int n, int n2, int n3) {
        this.activity.invalidate();
        switch (this.activity.getState()) {
            case 10: {
                if (this.activity.gameview == null) break;
                this.activity.gameview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 5: {
                if (this.activity.mapview == null) break;
                this.activity.mapview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 8: {
                if (this.activity.pregameview == null) break;
                this.activity.pregameview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 9: {
                if (this.activity.postgameview == null) break;
                this.activity.postgameview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 6: {
                if (this.activity.selectionview == null) break;
                this.activity.selectionview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 14: {
                if (this.activity.victoryview == null) break;
                this.activity.victoryview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 4: {
                if (this.activity.menu == null) break;
                this.activity.menu.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 0: {
                if (this.activity.splashone == null) break;
                this.activity.splashone.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 1: {
                if (this.activity.splashtwo == null) break;
                this.activity.splashtwo.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 2: {
                if (this.activity.soundview == null) break;
                this.activity.soundview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 13: {
                if (this.activity.languageview == null) break;
                this.activity.languageview.onTouchEvent(new MotionEvent(n, n2, n3));
            }
        }
    }

    public AnimatedElement getFocus() {
        return this.focus;
    }

    private AnimatedElement getNeighbor(int n) {
        this.activity.invalidate();
        switch (this.activity.getState()) {
            case 10: {
                return this.activity.gameview.traverse(this.focus, n);
            }
            case 5: {
                return this.activity.mapview.traverse(this.focus, n);
            }
            case 8: {
                return this.activity.pregameview.traverse(this.focus, n);
            }
            case 9: {
                return this.activity.postgameview.traverse(this.focus, n);
            }
            case 6: {
                return this.activity.selectionview.traverse(this.focus, n);
            }
            case 4: {
                return this.activity.menu.traverse(this.focus, n);
            }
            case 2: {
                return this.activity.soundview.traverse(this.focus, n);
            }
            case 13: {
                return this.activity.languageview.traverse(this.focus, n);
            }
        }
        return this.focus;
    }

    public void setFocus(AnimatedElement animatedElement) {
    }

    protected void keyPressed(int n) {
        if (n == -11) {
            this.activity.onBackPressed();
            return;
        }
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
    }

    protected void pointerReleased(int n, int n2) {
        this.sendMotionEvent(1, n, n2);
    }

    protected void pointerPressed(int n, int n2) {
        this.sendMotionEvent(2, n, n2);
    }

    protected void pointerDragged(int n, int n2) {
        this.sendMotionEvent(3, n, n2);
    }
}

