/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.farmmatch.animated;

import com.rocktasticgames.farmmatch.graphics.AssetLoader;
import com.rocktasticgames.farmmatch.main.MainActivity;
import com.rocktasticgames.farmmatch.utils.ColorMatrixColorFilter;
import com.rocktasticgames.farmmatch.utils.GraphicsContainer;
import javax.microedition.lcdui.Image;

public class AnimatedElement {
    public static final long FLY_TIME = 200L;
    public static final int WIGGLE_DEGREE = 30;
    public static final long WIGGLE_TIME = 600L;
    public static final float STAMP_SMALL = 0.5f;
    public static final float STAMP_LARGE = 2.0f;
    public static final long STAMP_SMALL_TIME = 150L;
    public static final long STAMP_LARGE_TIME = 300L;
    public static final long STAMP_BACK_TIME = 150L;
    public static final long FADE_TIME = 200L;
    public static final long BOUNCE_TIME = 700L;
    public static final float BOUNCE_DIST = 0.03f;
    public static final float GRAVITY = 2.4489796E-7f;
    protected float x;
    protected float y;
    protected float parent_width;
    protected float parent_height;
    private long animate_time;
    private int animation;
    protected Image bmp;
    private boolean fly_out = false;
    protected ColorMatrixColorFilter filter;
    private AssetLoader assetloader;
    private String alresource;
    private float scale_factor = 1.0f;
    private boolean unloaded = false;

    public AnimatedElement(MainActivity mainActivity, String string, float f, float f2, float f3, float f4, int n, long l) {
        this.x = f;
        this.y = f2;
        this.parent_width = f3;
        this.parent_height = f4;
        this.animation = n;
        this.animate_time = l;
        try {
            this.bmp = Image.createImage((String)("/" + string + ".png"));
            System.out.println("loaded " + string);
        }
        catch (Exception exception) {
            System.err.println("Unable to load res: " + string);
        }
    }

    public AnimatedElement(AssetLoader assetLoader, String string, float f, float f2, float f3, float f4, int n, long l) {
        this.x = f;
        this.y = f2;
        this.parent_width = f3;
        this.parent_height = f4;
        this.animation = n;
        this.animate_time = l;
        this.assetloader = assetLoader;
        if (string != null) {
            this.assetloader.load(string, 1);
        }
        this.alresource = string;
    }

    public AnimatedElement(float f, float f2, float f3, float f4, int n, long l) {
        this.x = f;
        this.y = f2;
        this.parent_width = f3;
        this.parent_height = f4;
        this.animation = n;
        this.animate_time = l;
    }

    public AnimatedElement(Image image, float f, float f2, float f3, float f4, int n, long l) {
        this.x = f;
        this.y = f2;
        this.parent_width = f3;
        this.parent_height = f4;
        this.animation = n;
        this.animate_time = l;
        this.bmp = image;
    }

    public void recycle() {
        if (this.bmp != null) {
            this.bmp = null;
            System.gc();
        }
    }

    public long getElapsed(long l) {
        return l - this.animate_time;
    }

    public int getAnimation() {
        return this.animation;
    }

    public boolean isLoaded() {
        if (this.assetloader != null) {
            return this.assetloader.get(this.alresource) != null;
        }
        return this.bmp != null;
    }

    public void unload() {
        if (this.unloaded) {
            return;
        }
        if (this.assetloader != null) {
            this.assetloader.unload(this.alresource);
        } else if (this.bmp != null) {
            this.recycle();
        }
        this.unloaded = true;
    }

    public boolean inRange(float f, float f2) {
        System.out.println("x=" + this.x + ",y=" + this.y + ",rx=" + f + ",ry=" + f2 + ",p_w" + this.parent_width + ",p_h=" + this.parent_height);
        if (this.fly_out) {
            return false;
        }
        return (float)Math.abs((int)(this.x * this.parent_width - f)) < (float)this.getWidth() / 2.0f && (float)Math.abs((int)(this.y * this.parent_height - f2)) < (float)this.getHeight() / 2.0f;
    }

    public int getWidth() {
        if (this.bmp == null) {
            return this.assetloader.get(this.alresource).getWidth();
        }
        return this.bmp.getWidth();
    }

    public int getHeight() {
        if (this.bmp == null) {
            return this.assetloader.get(this.alresource).getHeight();
        }
        return this.bmp.getHeight();
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public float getX(long l) {
        long l2 = this.fly_out ? this.animate_time + 200L - l : l - this.animate_time;
        if (l2 < 200L) {
            float f = this.isLoaded() ? (float)this.getWidth() : this.parent_width;
            if (this.animation == 3) {
                return this.x * this.parent_width - (this.x * this.parent_width + f / 2.0f) * (float)(200L - l2) / 200.0f;
            }
            if (this.animation == 4) {
                return this.x * this.parent_width + ((1.0f - this.x) * this.parent_width + f / 2.0f) * (float)(200L - l2) / 200.0f;
            }
        }
        return this.x * this.parent_width;
    }

    public float getY(long l) {
        long l2 = this.fly_out ? this.animate_time + 200L - l : l - this.animate_time;
        if (l2 < 200L) {
            if (this.animation == 5) {
                return this.y * this.parent_height - (this.y * this.parent_height + (float)(this.getHeight() / 2)) * (float)(200L - l2) / 200.0f;
            }
            if (this.animation == 6) {
                return this.y * this.parent_height + ((1.0f - this.y) * this.parent_height + (float)(this.getHeight() / 2)) * (float)(200L - l2) / 200.0f;
            }
        }
        return this.y * this.parent_height;
    }

    public boolean isAnimatingOut() {
        return this.fly_out;
    }

    public void animateThrough(long l) {
        this.animate_time = l;
        this.fly_out = true;
        if (this.animation == 3) {
            this.animation = 4;
        } else if (this.animation == 4) {
            this.animation = 3;
        } else if (this.animation == 5) {
            this.animation = 6;
        } else if (this.animation == 6) {
            this.animation = 5;
        }
    }

    public void animateOut(long l) {
        this.animate_time = l;
        this.fly_out = true;
    }

    public void animate(int n, long l) {
        this.fly_out = false;
        this.animation = n;
        this.animate_time = l;
    }

    public void setPNG(MainActivity mainActivity, String string) {
        try {
            this.bmp = Image.createImage((String)("/" + string + ".png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPNG(String string) {
        if (string == null || string == this.alresource) {
            return;
        }
        if (this.alresource != null) {
            this.assetloader.unload(this.alresource);
        }
        this.assetloader.load(string, 1);
        this.alresource = string;
    }

    public void setPNG(Image image) {
        this.bmp = image;
    }

    public void setColorFilter(ColorMatrixColorFilter colorMatrixColorFilter) {
        this.filter = colorMatrixColorFilter;
    }

    public void setFilter(ColorMatrixColorFilter colorMatrixColorFilter) {
        this.filter = colorMatrixColorFilter;
    }

    public ColorMatrixColorFilter getFilter() {
        return this.filter;
    }

    public boolean renderAt(GraphicsContainer graphicsContainer, int n, long l, int n2, int n3, float f, float f2, float f3) {
        if (this.assetloader != null) {
            this.bmp = this.assetloader.get(this.alresource);
            if (this.bmp == null) {
                return false;
            }
        }
        boolean bl = this.execRender(graphicsContainer, n, l);
        graphicsContainer.translate(n2, n3);
        if (this.filter != null) {
            this.drawTime(graphicsContainer, n, l);
        } else {
            this.drawTime(graphicsContainer, n, l);
        }
        graphicsContainer.translate(-graphicsContainer.getTranslateX(), -graphicsContainer.getTranslateY());
        return bl;
    }

    public void setScale(float f) {
        this.scale_factor = f;
    }

    public float getScale() {
        return this.scale_factor;
    }

    public boolean render(GraphicsContainer graphicsContainer, int n, long l) {
        if (this.assetloader != null) {
            this.bmp = this.assetloader.get(this.alresource);
            if (this.bmp == null) {
                return false;
            }
        } else if (this.bmp == null) {
            return false;
        }
        graphicsContainer.save();
        boolean bl = this.execRender(graphicsContainer, n, l);
        this.drawTime(graphicsContainer, n, l);
        graphicsContainer.restore();
        return bl;
    }

    private boolean execRender(GraphicsContainer graphicsContainer, int n, long l) {
        long l2 = this.fly_out ? this.animate_time + 200L - l : l - this.animate_time;
        boolean bl = false;
        graphicsContainer.translate((int)(this.x * this.parent_width), (int)(this.y * this.parent_height));
        switch (this.animation) {
            case 7: {
                if (l2 < 0L) {
                    graphicsContainer.translate(-graphicsContainer.getTranslateX(), -graphicsContainer.getTranslateY());
                    return false;
                }
                l2 = Math.abs(l2 % 700L - 350L);
                graphicsContainer.translate(0, (int)((-0.03f + (float)(l2 * l2) * 2.4489796E-7f) * this.parent_width));
                break;
            }
            case 8: {
                if (l2 < 0L) {
                    graphicsContainer.translate(-graphicsContainer.getTranslateX(), -graphicsContainer.getTranslateY());
                    return false;
                }
                bl = true;
                break;
            }
            case 1: {
                if (l2 < 0L) {
                    graphicsContainer.translate(-graphicsContainer.getTranslateX(), -graphicsContainer.getTranslateY());
                    return false;
                }
                if (l2 < 150L) {
                    float f = 1.0f - 0.5f * (float)l2 / 150.0f;
                    break;
                }
                if (l2 < 450L) {
                    float f = 0.5f + 1.5f * (float)(l2 - 150L) / 300.0f;
                    break;
                }
                if (l2 < 600L) {
                    float f = 2.0f - 1.0f * (float)(l2 - 300L - 150L) / 150.0f;
                    break;
                }
                float f = 1.0f;
                bl = true;
                break;
            }
            case 3: {
                if (l2 < 200L) {
                    graphicsContainer.translate((int)(-(this.x * this.parent_width + (float)(this.getWidth() / 2)) * (float)(200L - l2) / 200.0f), 0);
                    break;
                }
                if (l2 < 0L) break;
                bl = true;
                break;
            }
            case 4: {
                if (l2 < 200L) {
                    graphicsContainer.translate((int)(((1.0f - this.x) * this.parent_width + (float)(this.getWidth() / 2)) * (float)(200L - l2) / 200.0f), 0);
                    break;
                }
                if (l2 < 0L) break;
                bl = true;
                break;
            }
            case 5: {
                if (l2 < 200L) {
                    graphicsContainer.translate(0, (int)(-(this.y * this.parent_height + (float)(this.getHeight() / 2)) * (float)(200L - l2) / 200.0f));
                    break;
                }
                if (l2 < 0L) break;
                bl = true;
                break;
            }
            case 6: {
                if (l2 < 200L) {
                    graphicsContainer.translate(0, (int)(((1.0f - this.y) * this.parent_height + (float)(this.getHeight() / 2)) * (float)(200L - l2) / 200.0f));
                    break;
                }
                if (l2 < 0L) break;
                bl = true;
                break;
            }
            case 0: {
                if (l2 < 0L) {
                    graphicsContainer.translate(-graphicsContainer.getTranslateX(), -graphicsContainer.getTranslateY());
                    return false;
                }
                bl = true;
            }
        }
        return bl;
    }

    protected void drawTime(GraphicsContainer graphicsContainer, int n, long l) {
        this.draw(graphicsContainer, n);
    }

    protected void draw(GraphicsContainer graphicsContainer, int n) {
        if (this.filter != null) {
            graphicsContainer.drawImage(this.filter.applyTo(this.bmp), -this.bmp.getWidth() / 2, -this.bmp.getHeight() / 2, n);
        } else {
            graphicsContainer.drawImage(this.bmp, -this.bmp.getWidth() / 2, -this.bmp.getHeight() / 2, n);
        }
    }

    public static class Animation {
        public static final int NONE = 0;
        public static final int STAMP = 1;
        public static final int FLY_LEFT = 3;
        public static final int FLY_RIGHT = 4;
        public static final int FLY_TOP = 5;
        public static final int FLY_BOTTOM = 6;
        public static final int BOUNCE = 7;
        public static final int FADE = 8;
    }
}

