/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.farmmatch.views;

import com.rocktasticgames.farmmatch.animated.AnimatedElement;
import com.rocktasticgames.farmmatch.main.MainActivity;
import com.rocktasticgames.farmmatch.parameters.C2MValues;
import com.rocktasticgames.farmmatch.parameters.Params;
import com.rocktasticgames.farmmatch.utils.ColorMatrixColorFilter;
import com.rocktasticgames.farmmatch.utils.GraphicsContainer;
import com.rocktasticgames.farmmatch.utils.List;
import com.rocktasticgames.farmmatch.utils.MotionEvent;
import com.rocktasticgames.farmmatch.utils.XMath;
import com.rocktasticgames.farmmatch.views.View;
import javax.microedition.lcdui.Image;

public class MenuView
extends View {
    public static final ColorMatrixColorFilter filter_dark = Params.filter_dark;
    public static final ColorMatrixColorFilter filter_light = new ColorMatrixColorFilter(3);
    public static final ColorMatrixColorFilter filter_white = new ColorMatrixColorFilter(4);
    public static final ColorMatrixColorFilter filter_bright = new ColorMatrixColorFilter(3);
    public static final ColorMatrixColorFilter filter_dimmed = new ColorMatrixColorFilter(1);
    public static final int PAUSE_COLOR = -2013265920;
    public static final long EXTRA_DELAY = 400L;
    public static final long FLY_SPACING = 100L;
    public static final int HELP_LINES = 9;
    public static final long INIT_START_TIME = 1000L;
    private int paint;
    private Image backsky;
    private AnimatedElement logo;
    private AnimatedElement play;
    private AnimatedElement options;
    private AnimatedElement help;
    private AnimatedElement moregames;
    private AnimatedElement quit;
    private List aelist;
    private MainActivity activity;
    private boolean loaded = false;
    private long start_time;
    private int select_option = 0;
    private boolean menu_loaded = false;
    private boolean options_loaded = false;
    private AnimatedElement optioncanv;
    private AnimatedElement reset;
    private AnimatedElement sound;
    private AnimatedElement back;
    private long out_time;
    private boolean animate_out = false;
    private boolean reset_confirm = false;
    private AnimatedElement resetcanv;
    private AnimatedElement resetyes;
    private AnimatedElement resetno;
    private boolean help_loaded = false;
    private AnimatedElement helpcanv;
    private AnimatedElement helpnext;
    private AnimatedElement helpprev;
    private AnimatedElement helpback;
    private int target = 0;
    private boolean quit_confirm = false;
    private boolean more_confirm = false;
    private int dialog_index;
    private String[] dialog_lines;
    private boolean initial;
    private boolean isquit = false;
    private AnimatedElement darren;
    private boolean killed = false;
    private boolean indraw = false;
    private boolean isdestroy = false;
    private float scale;

    public MenuView(MainActivity mainActivity, boolean bl) {
        super(mainActivity);
        this.activity = mainActivity;
        this.initial = bl;
        this.paint = this.activity.getPaint();
        this.aelist = new List();
        this.start_time = System.currentTimeMillis();
        this.activity.getAssetLoader().load("opening_veggie", 1);
    }

    public void destroy() {
        if (this.indraw) {
            this.isdestroy = true;
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.logo.recycle();
        this.quit.recycle();
        if (this.menu_loaded) {
            this.unloadMenu();
        }
        if (this.options_loaded) {
            this.unloadOptions();
        }
        this.activity.getAssetLoader().unload("opening_veggie");
    }

    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        if (animatedElement == null) {
            if (this.menu_loaded) {
                return this.play;
            }
            if (this.options_loaded) {
                return this.back;
            }
            if (this.help_loaded) {
                return this.helpback;
            }
            return null;
        }
        if (animatedElement == this.play && this.quit.getElapsed(System.currentTimeMillis() - this.start_time) < 200L) {
            return this.play;
        }
        switch (n) {
            case 1: {
                if (this.reset_confirm || this.quit_confirm || this.more_confirm) {
                    return animatedElement;
                }
                if (this.menu_loaded) {
                    if (animatedElement == this.play) {
                        return this.quit;
                    }
                    if (animatedElement == this.options) {
                        return this.play;
                    }
                    if (animatedElement == this.help) {
                        return this.options;
                    }
                    if (animatedElement == this.moregames) {
                        return this.help;
                    }
                    if (animatedElement == this.quit) {
                        return this.quit;
                    }
                    return this.play;
                }
                if (this.options_loaded) {
                    if (animatedElement == this.reset) {
                        return this.reset;
                    }
                    if (animatedElement == this.sound) {
                        return this.reset;
                    }
                    if (animatedElement == this.back) {
                        return this.sound;
                    }
                    return this.back;
                }
                if (this.help_loaded) {
                    return animatedElement;
                }
                return animatedElement;
            }
            case 6: {
                if (this.reset_confirm || this.quit_confirm || this.more_confirm) {
                    return animatedElement;
                }
                if (this.menu_loaded) {
                    if (animatedElement == this.quit) {
                        return this.play;
                    }
                    if (animatedElement == this.play) {
                        return this.options;
                    }
                    if (animatedElement == this.options) {
                        return this.help;
                    }
                    if (animatedElement == this.help) {
                        try {
                            if (this.activity.getAppProperty("C2M-BuySetup").equals("menu,exit")) {
                                return this.moregames;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return this.quit;
                    }
                    if (animatedElement == this.moregames) {
                        return this.moregames;
                    }
                    return this.play;
                }
                if (this.options_loaded) {
                    if (animatedElement == this.reset) {
                        return this.sound;
                    }
                    if (animatedElement == this.sound) {
                        return this.back;
                    }
                    if (animatedElement == this.back) {
                        return this.back;
                    }
                    return this.back;
                }
                if (this.help_loaded) {
                    return animatedElement;
                }
                return animatedElement;
            }
            case 5: {
                if (this.reset_confirm || this.quit_confirm || this.more_confirm) {
                    return this.resetno;
                }
                if (this.menu_loaded) {
                    return animatedElement;
                }
                if (this.options_loaded) {
                    return animatedElement;
                }
                if (this.help_loaded) {
                    if (animatedElement == this.helpprev || this.dialog_index + 9 >= this.dialog_lines.length) {
                        return this.helpback;
                    }
                    return this.helpnext;
                }
                return animatedElement;
            }
            case 2: {
                if (this.reset_confirm || this.quit_confirm || this.more_confirm) {
                    return this.resetyes;
                }
                if (this.menu_loaded) {
                    return animatedElement;
                }
                if (this.options_loaded) {
                    return animatedElement;
                }
                if (this.help_loaded) {
                    if (animatedElement == this.helpnext || this.dialog_index == 0) {
                        return this.helpback;
                    }
                    return this.helpprev;
                }
                return animatedElement;
            }
        }
        return animatedElement;
    }

    public boolean onBack() {
        if (!this.loaded) {
            return true;
        }
        if (this.isquit) {
            return false;
        }
        if (this.reset_confirm || this.quit_confirm || this.more_confirm) {
            this.invalidate();
            this.unloadConfirm();
            return true;
        }
        if (this.options_loaded && !this.animate_out) {
            this.invalidate();
            this.optionsOut(System.currentTimeMillis() - this.start_time);
            return true;
        }
        if (this.help_loaded && !this.animate_out) {
            this.invalidate();
            this.helpOut(System.currentTimeMillis() - this.start_time);
            return true;
        }
        this.invalidate();
        this.quitConfirm(System.currentTimeMillis() - this.start_time);
        return true;
    }

    private void loadResources(float f, float f2, float f3) {
        this.activity.registerDimensions(f2, f3);
        this.logo = this.activity.getLanguage() == 4 ? new AnimatedElement(this.activity, "logo_es", 0.5f, f * 350.0f / 1536.0f, f2, f3, 0, -1000L) : new AnimatedElement(this.activity, "gamelogo", 0.5f, f * 350.0f / 1536.0f, f2, f3, 0, -1000L);
        this.aelist.add(this.logo);
        if (this.initial) {
            this.loadMenu(f, f2, f3, 1400L);
        } else {
            this.loadMenu(f, f2, f3, 400L);
        }
        this.quit = new AnimatedElement(this.activity, "buttons_quitgame_opening", 0.071614586f, f * 110.0f / 1536.0f, f2, f3, 3, 1100L);
        this.aelist.add(this.quit);
        this.loaded = true;
    }

    private void loadMenu(float f, float f2, float f3, long l) {
        this.play = new AnimatedElement(this.activity, "button_play", 0.5f, f * 1301.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f) / 2.0f, f2, f3, 3, l + 100L);
        this.options = new AnimatedElement(this.activity, "button_options", 0.5f, f * 1542.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f) / 2.0f, f2, f3, 3, l + 200L);
        this.help = new AnimatedElement(this.activity, "button_help", 0.5f, f * 1747.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f) / 2.0f, f2, f3, 3, l + 300L);
        this.moregames = new AnimatedElement(this.activity, "button_moregames", 0.5f, f * 1940.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f) / 2.0f, f2, f3, 3, l + 400L);
        try {
            if (!this.activity.getAppProperty("C2M-BuySetup").equals("menu,exit")) {
                this.moregames.animateOut(-10000L);
            }
        }
        catch (Exception exception) {
            this.moregames.animateOut(-10000L);
        }
        this.aelist.add(this.play);
        this.aelist.add(this.options);
        this.aelist.add(this.help);
        this.aelist.add(this.moregames);
        this.menu_loaded = true;
        this.activity.getCanvas().setFocus(this.play);
    }

    private void menuOut(long l) {
        this.play.animate(4, l);
        this.options.animate(4, l);
        this.help.animate(4, l);
        this.play.animateOut(l);
        this.options.animateOut(l);
        this.help.animateOut(l);
        if (!this.moregames.isAnimatingOut()) {
            this.moregames.animate(4, l);
            this.moregames.animateOut(l);
        }
        this.out_time = l;
        this.animate_out = true;
    }

    private void unloadMenu() {
        this.aelist.remove(this.play);
        this.aelist.remove(this.options);
        this.aelist.remove(this.help);
        this.play.recycle();
        this.options.recycle();
        this.help.recycle();
        if (this.moregames != null) {
            this.aelist.remove(this.moregames);
            this.moregames.recycle();
        }
        this.menu_loaded = false;
        this.animate_out = false;
    }

    private void loadOptions(float f, float f2, float f3, long l) {
        this.optioncanv = new AnimatedElement(this.activity, "options_canvas", 0.5f, f * 1400.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.reset = new AnimatedElement(this.activity, "button_resetprogress", 0.5f, f * 1278.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.sound = this.activity.getSharedPref().getBoolean("sound_on", true) ? new AnimatedElement(this.activity, "toggleon_sound", 0.5f, f * 1479.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l) : new AnimatedElement(this.activity, "toggleoff_sound", 0.5f, f * 1479.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.back = new AnimatedElement(this.activity, "button_back", 0.2578125f, f * 1698.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.optioncanv, this.reset, this.sound, this.back};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            this.aelist.add(animatedElementArray[i]);
        }
        this.options_loaded = true;
        this.activity.getCanvas().setFocus(this.back);
    }

    private void optionsOut(long l) {
        AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.optioncanv, this.reset, this.sound, this.back};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            animatedElementArray[i].animate(4, l);
            animatedElementArray[i].animateOut(l);
        }
        this.out_time = l;
        this.animate_out = true;
    }

    private void unloadOptions() {
        AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.optioncanv, this.reset, this.sound, this.back};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            this.aelist.remove(animatedElementArray[i]);
            animatedElementArray[i].recycle();
        }
        this.options_loaded = false;
        this.animate_out = false;
    }

    private void loadHelp(float f, float f2, float f3, long l) {
        this.helpcanv = new AnimatedElement(this.activity, "help_screen_canvas", 0.5f, f * 940.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.helpback = new AnimatedElement(this.activity, "button_backtohome", 0.5f, f * 1541.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.helpnext = new AnimatedElement(this.activity, "button_279_nextpage", 0.7916667f, f * 1541.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.helpprev = new AnimatedElement(this.activity, "button_279_prevpage", 0.22265625f, f * 1541.0f / 1536.0f + (1.0f - f * 4.0f / 3.0f), f2, f3, 3, l);
        this.dialog_index = 0;
        this.activity.getBrady().setSize(0.033854168f * f2);
        int n = 1;
        float f4 = 0.0f;
        String string = C2MValues.HELP_MENU[this.activity.getLanguage()].toUpperCase() + " ";
        string = string.replace('\u00a9', 'c');
        int n2 = 0;
        while (n2 + 1 < string.length()) {
            if (string.charAt(n2 + 1) == '/') {
                if (string.charAt(n2 + 2) == '/') {
                    n2 += 3;
                    f4 = 0.0f;
                    while ((++n - 1) % 9 != 0) {
                    }
                } else {
                    n2 += 2;
                    f4 = 0.0f;
                    ++n;
                }
            }
            if (f4 + (float)this.activity.getBrady().measure(string.substring(n2, string.indexOf(" ", n2 + 1))) < 1160.0f * f2 / 1536.0f) {
                f4 += (float)this.activity.getBrady().measure(string.substring(n2, string.indexOf(" ", n2 + 1)));
            } else {
                f4 = this.activity.getBrady().measure(string.substring(n2, string.indexOf(" ", n2 + 1)));
                ++n;
            }
            n2 = string.indexOf(" ", n2 + 1);
        }
        this.dialog_lines = new String[n];
        this.dialog_lines[0] = " ";
        n = 0;
        f4 = 0.0f;
        n2 = 0;
        while (n2 + 1 < string.length()) {
            if (string.charAt(n2 + 1) == '/') {
                if (string.charAt(n2 + 2) == '/') {
                    n2 += 3;
                    f4 = 0.0f;
                    do {
                        this.dialog_lines[++n] = "";
                    } while (n % 9 != 0);
                } else {
                    n2 += 2;
                    f4 = 0.0f;
                    this.dialog_lines[++n] = "";
                }
            }
            if (f4 + (float)this.activity.getBrady().measure(string.substring(n2, string.indexOf(" ", n2 + 1))) < 1160.0f * f2 / 1536.0f) {
                f4 += (float)this.activity.getBrady().measure(string.substring(n2, string.indexOf(" ", n2 + 1)));
                int n3 = n;
                this.dialog_lines[n3] = this.dialog_lines[n3] + string.substring(n2, string.indexOf(" ", n2 + 1));
            } else {
                f4 = this.activity.getBrady().measure(string.substring(n2, string.indexOf(" ", n2 + 1)));
                this.dialog_lines[++n] = string.substring(n2, string.indexOf(" ", n2 + 1));
            }
            n2 = string.indexOf(" ", n2 + 1);
        }
        AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.helpcanv, this.helpback, this.helpnext};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            this.aelist.add(animatedElementArray[i]);
        }
        this.help_loaded = true;
        this.activity.getCanvas().setFocus(this.helpback);
    }

    private void helpOut(long l) {
        AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.helpcanv, this.helpback, this.helpnext, this.helpprev};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            animatedElementArray[i].animate(4, l);
            animatedElementArray[i].animateOut(l);
        }
        this.out_time = l;
        this.animate_out = true;
    }

    private void unloadHelp() {
        AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.helpcanv, this.helpback, this.helpnext, this.helpprev};
        for (int i = 0; i < animatedElementArray.length; ++i) {
            this.aelist.remove(animatedElementArray[i]);
            animatedElementArray[i].recycle();
        }
        this.help_loaded = false;
        this.animate_out = false;
        this.dialog_index = 0;
    }

    private void resetConfirm(long l) {
        float f = 128.0f;
        float f2 = (float)this.activity.getCanvas().getHeight() / this.scale;
        float f3 = f / f2;
        this.resetcanv = new AnimatedElement(this.activity, "resetgame_confirmation_canvas", 0.5f, f3 * 1236.0f / 1536.0f + (1.0f - f3 * 4.0f / 3.0f), f, f2, 3, l);
        this.resetyes = new AnimatedElement(this.activity, "button_ok", 0.3580729f, f3 * 1527.0f / 1536.0f + (1.0f - f3 * 4.0f / 3.0f), f, f2, 3, l);
        this.resetno = new AnimatedElement(this.activity, "button_no", 0.64192706f, f3 * 1527.0f / 1536.0f + (1.0f - f3 * 4.0f / 3.0f), f, f2, 3, l);
        this.reset_confirm = true;
        this.activity.getCanvas().setFocus(this.resetno);
    }

    private void quitConfirm(long l) {
        float f = 128.0f;
        float f2 = (float)this.activity.getCanvas().getHeight() / this.scale;
        float f3 = f / f2;
        this.resetcanv = new AnimatedElement(this.activity, "resetgame_confirmation_canvas", 0.5f, f3 * 1236.0f / 1536.0f + (1.0f - f3 * 4.0f / 3.0f), f, f2, 3, l);
        this.resetyes = new AnimatedElement(this.activity, "button_ok", 0.3580729f, f3 * 1527.0f / 1536.0f + (1.0f - f3 * 4.0f / 3.0f), f, f2, 3, l);
        this.resetno = new AnimatedElement(this.activity, "button_no", 0.64192706f, f3 * 1527.0f / 1536.0f + (1.0f - f3 * 4.0f / 3.0f), f, f2, 3, l);
        this.quit_confirm = true;
        this.activity.getCanvas().setFocus(this.resetno);
    }

    private void moreConfirm(long l) {
        float f = (float)this.activity.getCanvas().getRZWidth() / (float)this.backsky.getWidth();
        float f2 = this.backsky.getWidth();
        float f3 = (float)this.activity.getCanvas().getRZHeight() / f;
        float f4 = f2 / f3;
        this.resetcanv = new AnimatedElement(this.activity, "resetgame_confirmation_canvas", 0.5f, f4 * 1236.0f / 1536.0f + (1.0f - f4 * 4.0f / 3.0f), f2, f3, 3, l);
        this.resetyes = new AnimatedElement(this.activity, "button_ok", 0.3580729f, f4 * 1527.0f / 1536.0f + (1.0f - f4 * 4.0f / 3.0f), f2, f3, 3, l);
        this.resetno = new AnimatedElement(this.activity, "button_no", 0.64192706f, f4 * 1527.0f / 1536.0f + (1.0f - f4 * 4.0f / 3.0f), f2, f3, 3, l);
        this.more_confirm = true;
        this.activity.getCanvas().setFocus(this.resetno);
        this.activity.getCanvas().setFocus(this.resetno);
    }

    private void unloadConfirm() {
        this.resetcanv.recycle();
        this.resetyes.recycle();
        this.resetno.recycle();
        this.reset_confirm = false;
        this.quit_confirm = false;
        this.more_confirm = false;
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        String[][] stringArrayArray;
        int n;
        this.indraw = true;
        try {
            if (this.backsky == null) {
                this.backsky = Image.createImage((String)"/opening_bg.png");
            } else if (this.killed) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scale = 1.0f;
        float f = this.activity.getCanvas().getWidth();
        float f2 = this.activity.getCanvas().getHeight();
        if (!this.loaded) {
            this.loadResources(f / f2, f, f2);
            this.activity.getCanvas().setFocus(this.play);
            this.start_time = System.currentTimeMillis();
            if (this.initial) {
                this.start_time += 1000L;
            }
        }
        long l = System.currentTimeMillis() - this.start_time;
        graphicsContainer.setColor(-1);
        if (this.animate_out && l - this.out_time > 200L) {
            if (this.menu_loaded) {
                this.unloadMenu();
                if (this.target == 2) {
                    this.loadOptions(f / f2, f, f2, l);
                } else {
                    this.loadHelp(f / f2, f, f2, l);
                }
            } else if (this.options_loaded) {
                this.unloadOptions();
                this.loadMenu(f / f2, f, f2, l);
            } else if (this.help_loaded) {
                this.unloadHelp();
                this.loadMenu(f / f2, f, f2, l);
            }
        }
        if (this.backsky != null) {
            graphicsContainer.save();
            graphicsContainer.drawImage(this.backsky, 0, 0, this.paint);
            graphicsContainer.scale((float)this.activity.getCanvas().getWidth() / (float)this.backsky.getWidth(), (float)this.activity.getCanvas().getWidth() / (float)this.backsky.getWidth());
            Image image = this.activity.getAssetLoader().get("opening_veggie");
            if (image != null) {
                graphicsContainer.save();
                graphicsContainer.translate(this.activity.getCanvas().getWidth(), this.activity.getCanvas().getHeight());
                graphicsContainer.scale((float)this.activity.getCanvas().getWidth() / (float)this.backsky.getWidth(), (float)this.activity.getCanvas().getWidth() / (float)this.backsky.getWidth());
                graphicsContainer.drawImage(image, -image.getWidth(), -image.getHeight(), this.paint);
                graphicsContainer.restore();
            }
            graphicsContainer.restore();
        }
        graphicsContainer.save();
        graphicsContainer.scale(this.scale, this.scale);
        boolean bl = false;
        for (n = 0; n < this.aelist.size(); ++n) {
            stringArrayArray = (String[][])this.aelist.get(n);
            if (stringArrayArray.render(graphicsContainer, this.paint, l)) continue;
            bl = true;
        }
        if (this.options_loaded) {
            graphicsContainer.save();
            this.activity.getCartoon().setSize(f * 17.0f / 240.0f);
            this.activity.getCartoon().setSize(XMath.min(f * 17.0f / 240.0f, f * 17.0f * f * 0.55f / (float)this.activity.getCartoon().measure(C2MValues.TEXT_OPTIONS[this.activity.getLanguage()]) / 240.0f));
            graphicsContainer.translate(this.optioncanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_OPTIONS[this.activity.getLanguage()]) / 2), f * 1048.0f / 1536.0f + f2 * (1.0f - f / f2 * 4.0f / 3.0f));
            this.activity.getCartoon().renderString(graphicsContainer, this.paint, C2MValues.TEXT_OPTIONS[this.activity.getLanguage()]);
            graphicsContainer.restore();
            graphicsContainer.setColor(-1);
            graphicsContainer.save();
            this.activity.getBrady().setSize((float)this.reset.getHeight() * 0.6f);
            if ((float)this.activity.getBrady().measure(C2MValues.TEXT_RESET_GAME[this.activity.getLanguage()]) > (float)this.reset.getWidth() * 0.8f) {
                this.activity.getBrady().setSize((float)this.reset.getHeight() * 0.6f * ((float)this.reset.getWidth() * 0.8f) / (float)this.activity.getBrady().measure(C2MValues.TEXT_RESET_GAME[this.activity.getLanguage()]));
            }
            graphicsContainer.translate(this.reset.getX(l) - (float)(this.activity.getBrady().measure(C2MValues.TEXT_RESET_GAME[this.activity.getLanguage()]) / 2), this.reset.getY(l) - this.activity.getBrady().getSize(graphicsContainer) / 2.0f);
            this.activity.getBrady().renderString(graphicsContainer, this.paint, C2MValues.TEXT_RESET_GAME[this.activity.getLanguage()]);
            graphicsContainer.restore();
        } else if (this.help_loaded) {
            graphicsContainer.save();
            this.activity.getCartoon().setSize(f * 17.0f / 240.0f);
            this.activity.getCartoon().setSize(XMath.min(f * 17.0f / 240.0f, f * 17.0f * f * 0.55f / (float)this.activity.getCartoon().measure(C2MValues.TEXT_HELP[this.activity.getLanguage()]) / 240.0f));
            graphicsContainer.translate(this.helpcanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_HELP[this.activity.getLanguage()]) / 2), f * 270.0f / 1536.0f + f2 * (1.0f - f / f2 * 4.0f / 3.0f));
            this.activity.getCartoon().renderString(graphicsContainer, this.paint, C2MValues.TEXT_HELP[this.activity.getLanguage()]);
            graphicsContainer.restore();
            graphicsContainer.setColor(-1);
            this.activity.getBrady().setSize(0.033854168f * f);
            for (n = 0; n < 9 && this.dialog_index + n < this.dialog_lines.length; ++n) {
                graphicsContainer.save();
                graphicsContainer.translate(this.helpcanv.getX(l) - f * 568.0f / 1536.0f, this.helpcanv.getY(l) + f * (1000.0f * ((float)(n - 4) - 1.0f) / 9.0f) / 1536.0f);
                this.activity.getBrady().renderString(graphicsContainer, this.paint, this.dialog_lines[this.dialog_index + n]);
                graphicsContainer.restore();
            }
        } else {
            AnimatedElement[] animatedElementArray = new AnimatedElement[]{this.play, this.options, this.help, this.moregames};
            stringArrayArray = new String[][]{C2MValues.TEXT_PLAY, C2MValues.TEXT_OPTIONS, C2MValues.TEXT_HELP, C2MValues.TEXT_MORE_GAMES};
            graphicsContainer.setColor(-1);
            for (int i = 0; i < animatedElementArray.length; ++i) {
                graphicsContainer.save();
                this.activity.getCartoon().setSize((float)animatedElementArray[i].getHeight() * 0.6f);
                if ((float)this.activity.getCartoon().measure(stringArrayArray[i][this.activity.getLanguage()]) > (float)animatedElementArray[i].getWidth() * 0.8f) {
                    this.activity.getCartoon().setSize((float)animatedElementArray[i].getHeight() * 0.6f * ((float)animatedElementArray[i].getWidth() * 0.8f) / (float)this.activity.getCartoon().measure(stringArrayArray[i][this.activity.getLanguage()]));
                }
                graphicsContainer.translate(animatedElementArray[i].getX(l) - (float)(this.activity.getCartoon().measure(stringArrayArray[i][this.activity.getLanguage()]) / 2), animatedElementArray[i].getY(l) - this.activity.getCartoon().getSize(graphicsContainer) / 2.0f);
                this.activity.getCartoon().renderString(graphicsContainer, this.paint, stringArrayArray[i][this.activity.getLanguage()]);
                graphicsContainer.restore();
            }
        }
        if (this.reset_confirm || this.quit_confirm || this.more_confirm) {
            if (!this.resetcanv.render(graphicsContainer, this.paint, l)) {
                bl = true;
            }
            if (!this.resetyes.render(graphicsContainer, this.paint, l)) {
                bl = true;
            }
            if (!this.resetno.render(graphicsContainer, this.paint, l)) {
                bl = true;
            }
            if (this.reset_confirm) {
                graphicsContainer.save();
                this.activity.getCartoon().setSize(f * 17.0f / 240.0f);
                this.activity.getCartoon().setSize(XMath.min(f * 17.0f / 240.0f, f * 17.0f * f * 0.55f / (float)this.activity.getCartoon().measure(C2MValues.TEXT_RESET_GAME[this.activity.getLanguage()]) / 240.0f));
                graphicsContainer.translate(this.resetcanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_RESET_GAME[this.activity.getLanguage()]) / 2), f * 944.0f / 1536.0f + f2 * (1.0f - f / f2 * 4.0f / 3.0f));
                this.activity.getCartoon().renderString(graphicsContainer, this.paint, C2MValues.TEXT_RESET_GAME[this.activity.getLanguage()]);
                graphicsContainer.restore();
                graphicsContainer.save();
                graphicsContainer.setColor(-1);
                this.activity.getKomika().setSize(f * 7.0f / 240.0f);
                graphicsContainer.translate(0.0f, f * 1103.0f / 1536.0f + f2 * (1.0f - f / f2 * 4.0f / 3.0f));
                for (int i = 0; i < C2MValues.TEXT_RESET_MESSAGE[this.activity.getLanguage()].length; ++i) {
                    graphicsContainer.save();
                    graphicsContainer.translate(this.resetcanv.getX(l) - (float)(this.activity.getKomika().measure(C2MValues.TEXT_RESET_MESSAGE[this.activity.getLanguage()][i]) / 2), 0.0f);
                    this.activity.getKomika().renderString(graphicsContainer, this.paint, C2MValues.TEXT_RESET_MESSAGE[this.activity.getLanguage()][i]);
                    graphicsContainer.restore();
                    graphicsContainer.translate(0.0f, f * 18.0f / 240.0f);
                }
                graphicsContainer.restore();
            } else if (this.quit_confirm) {
                graphicsContainer.save();
                this.activity.getCartoon().setSize(f * 17.0f / 240.0f);
                this.activity.getCartoon().setSize(XMath.min(f * 17.0f / 240.0f, f * 17.0f * f * 0.55f / (float)this.activity.getCartoon().measure(C2MValues.TEXT_QUIT_GAME[this.activity.getLanguage()]) / 240.0f));
                graphicsContainer.translate(this.resetcanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_QUIT_GAME[this.activity.getLanguage()]) / 2), f * 944.0f / 1536.0f + f2 * (1.0f - f / f2 * 4.0f / 3.0f));
                this.activity.getCartoon().renderString(graphicsContainer, this.paint, C2MValues.TEXT_QUIT_GAME[this.activity.getLanguage()]);
                graphicsContainer.restore();
                graphicsContainer.save();
                graphicsContainer.setColor(-1);
                this.activity.getKomika().setSize(f * 7.0f / 240.0f);
                graphicsContainer.translate(0.0f, f * 1103.0f / 1536.0f + f2 * (1.0f - f / f2 * 4.0f / 3.0f));
                for (int i = 0; i < C2MValues.TEXT_QUIT_MESSAGE[this.activity.getLanguage()].length; ++i) {
                    graphicsContainer.save();
                    graphicsContainer.translate(this.resetcanv.getX(l) - (float)(this.activity.getKomika().measure(C2MValues.TEXT_QUIT_MESSAGE[this.activity.getLanguage()][i]) / 2), 0.0f);
                    this.activity.getKomika().renderString(graphicsContainer, this.paint, C2MValues.TEXT_QUIT_MESSAGE[this.activity.getLanguage()][i]);
                    graphicsContainer.restore();
                    graphicsContainer.translate(0.0f, f * 18.0f / 240.0f);
                }
                graphicsContainer.restore();
            } else if (this.more_confirm) {
                graphicsContainer.save();
                this.activity.getCartoon().setSize(f * 17.0f / 240.0f);
                this.activity.getCartoon().setSize(XMath.min(f * 17.0f / 240.0f, f * 17.0f * f * 0.55f / (float)this.activity.getCartoon().measure(C2MValues.TEXT_MORE_GAMES[this.activity.getLanguage()]) / 240.0f));
                graphicsContainer.translate(this.resetcanv.getX(l) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_MORE_GAMES[this.activity.getLanguage()]) / 2), f * 944.0f / 1536.0f + f2 * (1.0f - f / f2 * 4.0f / 3.0f));
                this.activity.getCartoon().renderString(graphicsContainer, this.paint, C2MValues.TEXT_MORE_GAMES[this.activity.getLanguage()]);
                graphicsContainer.restore();
                graphicsContainer.save();
                graphicsContainer.setColor(-1);
                this.activity.getKomika().setSize(f * 7.0f / 240.0f);
                graphicsContainer.translate(0.0f, f * 1103.0f / 1536.0f + f2 * (1.0f - f / f2 * 4.0f / 3.0f));
                for (int i = 0; i < C2MValues.TEXT_MORE_MESSAGE[this.activity.getLanguage()].length; ++i) {
                    graphicsContainer.save();
                    graphicsContainer.translate(this.resetcanv.getX(l) - (float)(this.activity.getKomika().measure(C2MValues.TEXT_MORE_MESSAGE[this.activity.getLanguage()][i]) / 2), 0.0f);
                    this.activity.getKomika().renderString(graphicsContainer, this.paint, C2MValues.TEXT_MORE_MESSAGE[this.activity.getLanguage()][i]);
                    graphicsContainer.restore();
                    graphicsContainer.translate(0.0f, f * 18.0f / 240.0f);
                }
                graphicsContainer.restore();
            }
        }
        if (this.initial && l < 300L) {
            graphicsContainer.setColor(-1);
            graphicsContainer.drawPaint(this.paint);
            bl = true;
        }
        graphicsContainer.restore();
        this.indraw = false;
        if (this.isdestroy) {
            this.destroy();
        }
        if (this.select_option == 1) {
            return;
        }
        if (bl || this.animate_out) {
            this.invalidate();
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.killed) {
            return false;
        }
        if (System.currentTimeMillis() - this.start_time < 900L) {
            return false;
        }
        int n = motionEvent.getAction();
        if (this.select_option != 1 || n != 1) {
            this.invalidate();
        }
        switch (n) {
            case 1: {
                if (this.activity.getSharedPref().getInt("maxlevel", 0) < 40) {
                    this.activity.setPlaceholder("gamemap_with_parchment_v4_left");
                }
                if (this.activity.getSharedPref().getInt("maxlevel", 0) < 80) {
                    this.activity.setPlaceholder("gamemap_with_parchment_v4_center");
                } else {
                    this.activity.setPlaceholder("gamemap_with_parchment_v4_right");
                }
                this.activity.unlockMusic();
                switch (this.select_option) {
                    case 16: {
                        this.quit.setFilter(null);
                        this.quitConfirm(System.currentTimeMillis() - this.start_time);
                        break;
                    }
                    case 13: {
                        this.helpOut(System.currentTimeMillis() - this.start_time);
                        this.helpback.setFilter(null);
                        break;
                    }
                    case 14: {
                        this.helpprev.setFilter(null);
                        if (this.dialog_index + 9 >= this.dialog_lines.length) {
                            this.aelist.add(this.helpnext);
                        }
                        this.dialog_index -= 9;
                        if (this.dialog_index != 0) break;
                        this.aelist.remove(this.helpprev);
                        this.activity.getCanvas().setFocus(this.helpback);
                        break;
                    }
                    case 15: {
                        this.helpnext.setFilter(null);
                        if (this.dialog_index == 0) {
                            this.aelist.add(this.helpprev);
                        }
                        this.dialog_index += 9;
                        if (this.dialog_index + 9 < this.dialog_lines.length) break;
                        this.aelist.remove(this.helpnext);
                        this.activity.getCanvas().setFocus(this.helpback);
                        break;
                    }
                    case 11: {
                        if (this.reset_confirm) {
                            this.activity.resetAll();
                            this.unloadConfirm();
                            this.optionsOut(System.currentTimeMillis() - this.start_time);
                            break;
                        }
                        if (this.quit_confirm) {
                            this.isquit = true;
                            this.activity.onBackPressed();
                            break;
                        }
                        if (!this.more_confirm) break;
                        try {
                            this.activity.platformRequest(this.activity.getAppProperty("C2M-URL-" + this.activity.getBMGLang()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.isquit = true;
                        this.activity.onBackPressed();
                        break;
                    }
                    case 12: {
                        this.unloadConfirm();
                        break;
                    }
                    case 7: {
                        this.resetConfirm(System.currentTimeMillis() - this.start_time);
                        this.reset.setFilter(null);
                        break;
                    }
                    case 8: 
                    case 9: {
                        this.activity.getPrefEditor().putBoolean("sound_on", !this.activity.getSharedPref().getBoolean("sound_on", true));
                        this.activity.getPrefEditor().putBoolean("music_on", !this.activity.getSharedPref().getBoolean("music_on", true));
                        this.activity.getPrefEditor().commit();
                        if (this.activity.getSharedPref().getBoolean("sound_on", true)) {
                            this.sound.setPNG(this.activity, "toggleon_sound");
                            this.activity.getMusic().startMusic();
                        } else {
                            this.sound.setPNG(this.activity, "toggleoff_sound");
                            this.activity.getMusic().stopMusic();
                        }
                        this.sound.setFilter(null);
                        break;
                    }
                    case 10: {
                        this.optionsOut(System.currentTimeMillis() - this.start_time);
                        this.back.setFilter(null);
                        break;
                    }
                    case 1: {
                        this.killed = true;
                        this.activity.openKitchen();
                        break;
                    }
                    case 2: {
                        this.menuOut(System.currentTimeMillis() - this.start_time);
                        this.target = 2;
                        this.options.setFilter(null);
                        break;
                    }
                    case 3: {
                        this.menuOut(System.currentTimeMillis() - this.start_time);
                        this.target = 3;
                        this.help.setFilter(null);
                        break;
                    }
                    case 4: {
                        this.moregames.setFilter(null);
                        this.moreConfirm(System.currentTimeMillis() - this.start_time);
                    }
                }
                this.select_option = 0;
                return false;
            }
            case 2: {
                if (this.reset_confirm || this.quit_confirm || this.more_confirm) {
                    System.out.println("yes: " + this.resetyes.getX(Long.MAX_VALUE) + ", " + this.resetyes.getY(Long.MAX_VALUE) + " no: " + this.resetno.getX(Long.MAX_VALUE) + ", " + this.resetno.getY(Long.MAX_VALUE));
                    if (this.resetyes.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                        this.select_option = 11;
                        this.resetyes.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.resetno.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                        this.select_option = 12;
                        this.resetno.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    }
                    return true;
                }
                if (this.help_loaded) {
                    if (this.helpback.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                        this.select_option = 13;
                        this.helpback.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.helpnext.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale) && this.dialog_index + 9 < this.dialog_lines.length) {
                        this.select_option = 15;
                        this.helpnext.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.helpprev.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale) && this.dialog_index > 0) {
                        this.select_option = 14;
                        this.helpprev.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    }
                    return true;
                }
                if (this.animate_out) {
                    return false;
                }
                if (this.menu_loaded) {
                    if (this.play.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                        this.select_option = 1;
                        this.play.setFilter(filter_dark);
                        this.activity.playSound("play");
                    } else if (this.options.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                        this.select_option = 2;
                        this.options.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.help.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                        this.select_option = 3;
                        this.help.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.moregames.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                        this.select_option = 4;
                        this.moregames.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.quit.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                        this.select_option = 16;
                        this.quit.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    }
                } else if (this.options_loaded) {
                    if (this.reset.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                        this.select_option = 7;
                        this.reset.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.sound.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                        this.select_option = 8;
                        this.sound.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    } else if (this.back.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                        this.select_option = 10;
                        this.back.setFilter(filter_dark);
                        this.activity.playSound("standard_click");
                    }
                }
                return true;
            }
            case 3: {
                switch (this.select_option) {
                    case 16: {
                        if (this.quit.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) break;
                        this.select_option = 0;
                        this.quit.setFilter(null);
                        break;
                    }
                    case 13: {
                        if (this.helpback.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) break;
                        this.select_option = 0;
                        this.helpback.setFilter(null);
                        break;
                    }
                    case 15: {
                        if (this.helpnext.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) break;
                        this.select_option = 0;
                        this.helpnext.setFilter(null);
                        break;
                    }
                    case 14: {
                        if (this.helpprev.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) break;
                        this.select_option = 0;
                        this.helpprev.setFilter(null);
                        break;
                    }
                    case 11: {
                        if (this.resetyes.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) break;
                        this.select_option = 0;
                        this.resetyes.setFilter(null);
                        break;
                    }
                    case 12: {
                        if (this.resetno.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) break;
                        this.select_option = 0;
                        this.resetno.setFilter(null);
                        break;
                    }
                    case 7: {
                        if (this.reset.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) break;
                        this.select_option = 0;
                        this.reset.setFilter(null);
                        break;
                    }
                    case 8: {
                        if (this.sound.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) break;
                        this.select_option = 0;
                        this.sound.setFilter(null);
                        break;
                    }
                    case 10: {
                        if (this.back.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) break;
                        this.select_option = 0;
                        this.back.setFilter(null);
                        break;
                    }
                    case 1: {
                        if (this.play.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) break;
                        this.select_option = 0;
                        this.play.setFilter(null);
                        break;
                    }
                    case 2: {
                        if (this.options.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) break;
                        this.select_option = 0;
                        this.options.setFilter(null);
                        break;
                    }
                    case 3: {
                        if (this.help.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) break;
                        this.select_option = 0;
                        this.help.setFilter(null);
                        break;
                    }
                    case 4: {
                        if (this.moregames.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) break;
                        this.select_option = 0;
                        this.moregames.setFilter(null);
                    }
                }
                return true;
            }
        }
        return true;
    }

    public static class MenuOption {
        private static final int NONE = 0;
        private static final int PLAY = 1;
        private static final int OPTIONS = 2;
        private static final int HELP = 3;
        private static final int MOREGAMES = 4;
        private static final int FACEBOOK = 5;
        private static final int TWITTER = 6;
        private static final int RESET = 7;
        private static final int SOUND = 8;
        private static final int MUSIC = 9;
        private static final int BACK = 10;
        private static final int RESET_YES = 11;
        private static final int RESET_NO = 12;
        private static final int HELP_BACK = 13;
        private static final int HELP_PREV = 14;
        private static final int HELP_NEXT = 15;
        private static final int QUIT = 16;
    }
}

