/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.farmmatch.main;

import com.rocktasticgames.farmmatch.graphics.AssetLoader;
import com.rocktasticgames.farmmatch.main.MainCanvas;
import com.rocktasticgames.farmmatch.models.GameModel;
import com.rocktasticgames.farmmatch.parameters.C2MValues;
import com.rocktasticgames.farmmatch.parameters.Params;
import com.rocktasticgames.farmmatch.sounds.MenuMusic;
import com.rocktasticgames.farmmatch.utils.BMPFont;
import com.rocktasticgames.farmmatch.utils.GraphicsContainer;
import com.rocktasticgames.farmmatch.utils.SharedPreferences;
import com.rocktasticgames.farmmatch.views.GameView;
import com.rocktasticgames.farmmatch.views.LanguageView;
import com.rocktasticgames.farmmatch.views.MapView;
import com.rocktasticgames.farmmatch.views.MenuView;
import com.rocktasticgames.farmmatch.views.PostgameView;
import com.rocktasticgames.farmmatch.views.PregameView;
import com.rocktasticgames.farmmatch.views.SelectionView;
import com.rocktasticgames.farmmatch.views.SoundView;
import com.rocktasticgames.farmmatch.views.SplashC2MView;
import com.rocktasticgames.farmmatch.views.SplashRocktasticView;
import com.rocktasticgames.farmmatch.views.VictoryView;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class MainActivity
extends MIDlet
implements Runnable {
    public static final int DIALOG_LINES = 5;
    public static int PLACEHOLDER_BLUR = 4;
    private AssetLoader assetloader;
    private GameModel game;
    protected MapView mapview;
    protected PregameView pregameview;
    protected GameView gameview;
    protected PostgameView postgameview;
    protected SelectionView selectionview;
    protected VictoryView victoryview;
    private int paint;
    private Thread assetthread;
    private boolean inlevel = false;
    private boolean minimized = false;
    private SharedPreferences shared_pref;
    private SharedPreferences.Editor pref_editor;
    protected SplashC2MView splashone;
    protected SplashRocktasticView splashtwo;
    protected SoundView soundview;
    protected LanguageView languageview;
    private MenuMusic music;
    private int state;
    private BMPFont brady;
    private BMPFont komika;
    private BMPFont cartoon;
    private BMPFont titan;
    protected MenuView menu;
    private float width;
    private float height;
    private boolean screen_locked = false;
    private String placeholder_img = null;
    private Image placeholder;
    private String dialog_char = null;
    private String[] dialog_lines;
    private int dialog_seq = 0;
    private int last_dialog = 0;
    private int dialog_ptr = 0;
    private boolean dialog_left = false;
    private boolean dialog_loaded = false;
    private boolean started = false;
    private boolean isminimized = false;
    private MainCanvas maincanv;
    private Thread thread;
    private long invalidate_time;
    private int language = 0;
    private boolean hidden = false;
    private int currthread = 0;

    protected void startApp() throws MIDletStateChangeException {
        if (!this.started) {
            this.started = true;
            this.init();
        } else if (this.isminimized) {
            this.isminimized = false;
            if (this.assetthread == null || !this.assetthread.isAlive()) {
                this.assetthread = new Thread(this.assetloader);
                this.assetthread.start();
            }
            if (this.music != null) {
                this.music.kill();
            }
            this.music = new MenuMusic(this, 50, 50);
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    private void init() {
        this.assetloader = new AssetLoader();
        this.assetthread = new Thread(this.assetloader);
        this.assetthread.start();
        this.invalidate_time = System.currentTimeMillis();
        this.thread = new Thread(this);
        Display display = Display.getDisplay((MIDlet)this);
        this.maincanv = new MainCanvas(this);
        display.setCurrent((Displayable)this.maincanv);
        this.maincanv.setFullScreenMode(true);
        this.paint = 20;
        this.shared_pref = new SharedPreferences();
        this.pref_editor = this.shared_pref.edit();
        this.splashone = new SplashC2MView(this);
        this.state = 0;
        this.thread.start();
        this.setPlaceholder("opening_bg");
    }

    public void run() {
        ++this.currthread;
        int n = this.currthread;
        while (this.state != 12 && n == this.currthread) {
            try {
                while (true) {
                    if (this.isminimized) {
                        return;
                    }
                    long l = this.invalidate_time - System.currentTimeMillis();
                    if (l > 30L) {
                        Thread.sleep(Math.min(50L, l));
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.invalidate_time = System.currentTimeMillis() + 100L;
            if (this.state == 12 || n != this.currthread) break;
            this.maincanv.repaint();
            if (!this.maincanv.isShown() && n == this.currthread || this.isminimized) {
                if (this.inlevel) {
                    this.game.pause();
                }
                if (this.music == null) continue;
                this.music.stopMusic();
                continue;
            }
            if (n != this.currthread) continue;
            if (this.music != null) {
                this.music.startMusic();
                continue;
            }
            if (this.state == 12 || this.state == 13 || this.state == 3 || this.state == 2 || this.state == 0 || this.state == 1) continue;
            this.music = new MenuMusic(this, 50, 50);
            this.music.startMusic();
        }
        if (n == this.currthread) {
            if (this.music != null) {
                this.music.kill();
                this.music = null;
            }
            this.notifyDestroyed();
        }
    }

    public MainCanvas getCanvas() {
        return this.maincanv;
    }

    public void invalidate() {
        this.invalidate_time = System.currentTimeMillis();
    }

    public void postInvalidateDelayed(long l) {
        this.invalidate_time = System.currentTimeMillis() + l;
    }

    public Image getPlaceholder() {
        return this.placeholder;
    }

    public int getState() {
        return this.state;
    }

    public void unloadDialog() {
        if (this.dialog_char != null) {
            this.getAssetLoader().unload(this.dialog_char);
            this.getAssetLoader().unload("dialoguebox");
            this.getAssetLoader().unload("button_272_play");
            this.dialog_char = null;
        }
        this.dialog_loaded = false;
    }

    public boolean progressDialog() {
        if (this.dialog_ptr + 5 < this.dialog_lines.length) {
            this.dialog_ptr += 5;
            return true;
        }
        if (this.dialog_seq > 0) {
            --this.dialog_seq;
            ++this.last_dialog;
            this.loadDialog(this.last_dialog);
            return true;
        }
        this.unloadDialog();
        return false;
    }

    public boolean isDialogLoaded() {
        return this.dialog_loaded;
    }

    public void renderDialog(GraphicsContainer graphicsContainer, int n, float f, boolean bl) {
        Image image = this.getDialogBox();
        Image image2 = this.getDialogImg();
        Image image3 = this.getDialogBtn();
        if (image2 != null) {
            if (this.dialogIsLeft()) {
                graphicsContainer.drawImage(image2, 0, (int)(0.4609375f * (float)this.maincanv.getWidth() / 1.0f / f + (float)(this.maincanv.getHeight() / 1) / f - (float)(this.maincanv.getWidth() / 1) / f * 4.0f / 3.0f), n);
            } else {
                graphicsContainer.drawImage(image2, (float)(this.maincanv.getWidth() / 1) / f - (float)image2.getWidth(), 0.4609375f * (float)this.maincanv.getWidth() / 1.0f / f + (float)(this.maincanv.getHeight() / 1) / f - (float)(this.maincanv.getWidth() / 1) / f * 4.0f / 3.0f, n);
            }
        }
        if (image != null && image3 != null) {
            graphicsContainer.drawImage(image, 0.0f, 0.8183594f * (float)this.maincanv.getWidth() / 1.0f / f + (float)(this.maincanv.getHeight() / 1) / f - (float)(this.maincanv.getWidth() / 1) / f * 4.0f / 3.0f, n);
            if (bl) {
                graphicsContainer.drawImage(Params.filter_dark.applyTo(image3), (float)(this.maincanv.getWidth() / 1) / f / 2.0f - (float)(image3.getWidth() / 2), (float)(this.maincanv.getHeight() / 1) / f - (float)image3.getHeight(), n);
            } else {
                graphicsContainer.drawImage(image3, (float)(this.maincanv.getWidth() / 1) / f / 2.0f - (float)(image3.getWidth() / 2), (float)(this.maincanv.getHeight() / 1) / f - (float)image3.getHeight(), n);
            }
            String[] stringArray = this.getDialogLines();
            this.setKomikaForDialog();
            graphicsContainer.save();
            graphicsContainer.translate(0.104166664f * (float)this.maincanv.getWidth() / 1.0f / f, 0.8984375f * (float)this.maincanv.getWidth() / 1.0f / f + (float)(this.maincanv.getHeight() / 1) / f - (float)(this.maincanv.getWidth() / 1) / f * 4.0f / 3.0f);
            graphicsContainer.setColor(-1);
            for (int i = 0; i < stringArray.length; ++i) {
                this.getKomika().renderString(graphicsContainer, n, stringArray[i]);
                graphicsContainer.translate(0.0f, this.getKomika().getSize(graphicsContainer) * 4.0f / 3.0f);
            }
            graphicsContainer.restore();
        }
    }

    public Image getDialogBox() {
        return this.getAssetLoader().get("dialoguebox");
    }

    public Image getDialogBtn() {
        return this.getAssetLoader().get("button_272_play");
    }

    public Image getDialogImg() {
        if (this.dialog_char == null || this.dialog_char == "0") {
            return null;
        }
        return this.getAssetLoader().get(this.dialog_char);
    }

    public boolean dialogIsLeft() {
        return this.dialog_left;
    }

    public String[] getDialogLines() {
        String[] stringArray = new String[Math.min(5, this.dialog_lines.length - this.dialog_ptr)];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.dialog_lines[this.dialog_ptr + i];
        }
        return stringArray;
    }

    public void setKomikaForDialog() {
    }

    public void loadDialog(int n) {
        if (this.dialog_char == null || !this.dialog_char.equals("0")) {
            if (this.dialog_char != null) {
                this.getAssetLoader().unload(this.dialog_char);
            } else {
                this.getAssetLoader().load("dialoguebox", 1);
                this.getAssetLoader().load("button_272_play", 1);
            }
        }
        if (C2MValues.TUTORIAL_SPEAKER[n] == -1) {
            this.dialog_char = "0";
        } else {
            this.dialog_char = Params.SPEAKER_IMG[C2MValues.TUTORIAL_SPEAKER[n]];
            this.dialog_left = C2MValues.TUTORIAL_SPEAKER[n] % 2 == 0;
            this.getAssetLoader().load(this.dialog_char, 1);
        }
        this.setKomikaForDialog();
        int n2 = 1;
        float f = 0.0f;
        this.dialog_ptr = 0;
        String string = C2MValues.TUTORIAL_DIALOG[this.getLanguage()][n];
        string = string.toUpperCase();
        string = string + " ";
        int n3 = 0;
        while (n3 + 1 < string.length()) {
            if (f + (float)this.getKomika().measure(string.substring(n3, string.indexOf(" ", n3 + 1))) < 1160.0f * this.width / 1536.0f) {
                f += (float)this.getKomika().measure(string.substring(n3, string.indexOf(" ", n3 + 1)));
            } else {
                f = this.getKomika().measure(string.substring(n3, string.indexOf(" ", n3 + 1)));
                ++n2;
            }
            n3 = string.indexOf(" ", n3 + 1);
        }
        this.dialog_lines = new String[n2];
        this.dialog_lines[0] = " ";
        n2 = 0;
        f = 0.0f;
        n3 = 0;
        while (n3 + 1 < string.length()) {
            if (f + (float)this.getKomika().measure(string.substring(n3, string.indexOf(" ", n3 + 1))) < 1160.0f * this.width / 1536.0f) {
                f += (float)this.getKomika().measure(string.substring(n3, string.indexOf(" ", n3 + 1)));
                int n4 = n2;
                this.dialog_lines[n4] = this.dialog_lines[n4] + string.substring(n3, string.indexOf(" ", n3 + 1));
            } else {
                f = this.getKomika().measure(string.substring(n3, string.indexOf(" ", n3 + 1)));
                this.dialog_lines[++n2] = string.substring(n3, string.indexOf(" ", n3 + 1));
            }
            n3 = string.indexOf(" ", n3 + 1);
        }
        this.dialog_loaded = true;
    }

    public boolean checkMessage(int n, int n2) {
        int n3 = 0;
        this.dialog_seq = 0;
        for (int i = 1; i < C2MValues.TUTORIAL_LEVEL.length; ++i) {
            if (n3 == 0) {
                if (C2MValues.TUTORIAL_LEVEL[i] != n || C2MValues.TUTORIAL_SCREEN[i] != n2) continue;
                n3 = i;
                continue;
            }
            if (C2MValues.TUTORIAL_LEVEL[i] != 0) break;
            ++this.dialog_seq;
        }
        if (n3 == 0) {
            return false;
        }
        if (this.getSharedPref().getBoolean("msg_" + n3, false)) {
            return false;
        }
        this.last_dialog = n3;
        this.loadDialog(n3);
        this.getPrefEditor().putBoolean("msg_" + n3, true);
        this.getPrefEditor().commit();
        return true;
    }

    public boolean setPlaceholder(String string) {
        return true;
    }

    public SharedPreferences getSharedPref() {
        return this.shared_pref;
    }

    public SharedPreferences.Editor getPrefEditor() {
        return this.pref_editor;
    }

    public void splashTaskOne() {
        this.komika = this.brady = new BMPFont("brady", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ:/+-x$'!.?()c@,\u00c1\u00c2\u00c0\u00c4\u00c3\u00aa\u00c7\u00c9\u00ca\u00c8\u00cd\u00ce\u00a1\u00bf\u00d1\u00d3\u00d4\u00d6\u00d5\u00ba\u00da\u00db\u00d9\u00dc");
    }

    public void splashTaskTwo() {
        this.titan = this.cartoon = new BMPFont("cartoon", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ,$\u00c1\u00c2\u00c0\u00c4\u00c3\u00aa\u00c7\u00c9\u00ca\u00c8\u00cd\u00bf\u00d1\u00d3\u00d4\u00d6\u00d5\u00ba\u00da\u00db\u00dc/?\u00bf");
    }

    public boolean isGemSelected() {
        return this.gameview != null && this.gameview.isDown();
    }

    public void openKitchen() {
        this.startMap(this.getSharedPref().getInt("maxlevel", 0) / 40);
    }

    public void onSplashOneComplete() {
        this.maincanv.setFullScreenMode(true);
        this.splashone.destroy();
        this.state = 1;
        this.splashtwo = new SplashRocktasticView(this);
    }

    public void onSplashTwoComplete() {
        this.maincanv.setFullScreenMode(true);
        this.splashtwo.destroy();
        this.state = 13;
        this.languageview = new LanguageView(this);
    }

    public void onLanguageComplete() {
        this.languageview.destroy();
        this.soundview = new SoundView(this);
        this.state = 2;
        this.language = this.getSharedPref().getInt("language", 0);
        for (int i = 0; i < C2MValues.TUTORIAL_DIALOG.length; ++i) {
            if (i == this.language) continue;
            C2MValues.TUTORIAL_DIALOG[i] = null;
            C2MValues.HELP_MENU[i] = null;
        }
    }

    public void onSoundComplete() {
        this.soundview.destroy();
        this.state = 3;
        this.music = new MenuMusic(this, 50, 50);
        this.music.startMusic();
        this.openMainMenu();
    }

    public void playSound(String string) {
        this.music.playEffect(string);
    }

    public MenuMusic getMusic() {
        return this.music;
    }

    public void unlockMusic() {
        if (this.screen_locked && this.music != null) {
            this.music.startMusic();
        }
        this.screen_locked = false;
    }

    public void resetAll() {
        this.getPrefEditor().clearAll();
    }

    public int getLanguage() {
        return this.language;
    }

    public String getBMGLang() {
        switch (this.getLanguage()) {
            default: {
                return "en-GB";
            }
            case 1: {
                return "fr-FR";
            }
            case 2: {
                return "de-DE";
            }
            case 3: {
                return "pt-PT";
            }
            case 4: 
        }
        return "es-ES";
    }

    public BMPFont getBrady() {
        return this.brady;
    }

    public BMPFont getKomika() {
        return this.komika;
    }

    public BMPFont getTitan() {
        return this.titan;
    }

    public BMPFont getCartoon() {
        return this.cartoon;
    }

    public void registerDimensions(float f, float f2) {
        this.width = f;
        this.height = f2;
    }

    public void openMainMenu() {
        this.removeAllScreens();
        this.menu = new MenuView(this, this.state == 3);
        this.state = 4;
    }

    public MenuMusic getSounds() {
        return this.music;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    protected void destroyApp(boolean bl) throws MIDletStateChangeException {
        switch (this.state) {
            case 4: {
                this.menu.destroy();
            }
        }
        if (this.music != null) {
            this.music.kill();
        }
        System.gc();
        this.state = 12;
    }

    protected void showNotify() {
        try {
            this.startApp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void hideNotify() {
        this.pauseApp();
    }

    protected void pauseApp() {
        this.isminimized = true;
        if (this.music != null) {
            this.music.stopMusic();
        }
        if (this.music != null) {
            this.music.kill();
            this.music = null;
        }
        this.assetloader.pause();
        if (this.inlevel) {
            this.game.pause();
        }
    }

    public void onBackPressed() {
        if (this.state == 4) {
            if (this.menu != null && !this.menu.onBack()) {
                this.assetloader.destroy();
                if (this.music != null) {
                    this.music.stopMusic();
                }
                System.gc();
                this.state = 12;
            }
        } else {
            if (this.state == 10) {
                if (this.gameview != null && !this.gameview.onBack()) {
                    this.stopLevel();
                    this.startPostgame(this.game.getLevel(), true);
                }
                return;
            }
            if (this.state == 8) {
                if (this.pregameview != null && !this.pregameview.onBack()) {
                    this.stopLevel();
                    this.startSelection(this.pregameview.getLevel() / 10);
                }
                return;
            }
            if (this.state == 6) {
                if (this.selectionview != null && !this.selectionview.onBack()) {
                    this.startMap(this.selectionview.getSection() / 4);
                }
                return;
            }
            if (this.state == 9) {
                if (this.postgameview != null && !this.postgameview.onBack()) {
                    this.startSelection(this.postgameview.getLevel() / 10);
                }
                return;
            }
            if (this.state == 5) {
                if (this.mapview != null && !this.mapview.onBack()) {
                    this.openMainMenu();
                }
                return;
            }
            if (this.state == 14) {
                if (this.victoryview != null && !this.victoryview.onBack()) {
                    this.openMainMenu();
                }
                return;
            }
        }
    }

    public int getPaint() {
        return this.paint;
    }

    public boolean isInLevel() {
        return this.inlevel;
    }

    public GameModel getGameModel() {
        return this.game;
    }

    public void startVictory() {
        this.removeAllScreens();
        this.victoryview = new VictoryView(this);
        this.state = 14;
    }

    public void startPostgame(int n, boolean bl) {
        this.removeAllScreens();
        this.postgameview = new PostgameView(this, bl, n);
        this.state = 9;
    }

    public void startPregame(int n) {
        this.removeAllScreens();
        this.game = new GameModel(this, n);
        this.pregameview = new PregameView(this, this.game, n);
        this.inlevel = true;
        this.state = 8;
    }

    public void startGame(int n) {
        this.getAssetLoader().load("parchmentmid", 1);
        this.removeAllScreens();
        this.gameview = new GameView(this, this.game);
        this.getAssetLoader().unload("parchmentmid");
        this.inlevel = true;
        this.state = 10;
    }

    public void startSelection(int n) {
        this.removeAllScreens();
        this.selectionview = new SelectionView(this, n);
        this.state = 6;
    }

    public void startMap(int n) {
        this.removeAllScreens();
        this.mapview = new MapView(this, n);
        this.state = 5;
    }

    private void removeAllScreens() {
        this.getCanvas().setFocus(null);
        if (this.gameview != null) {
            this.gameview.destroy();
            this.gameview = null;
        }
        if (this.pregameview != null) {
            this.pregameview.destroy();
            this.pregameview = null;
        }
        if (this.postgameview != null) {
            this.postgameview.destroy();
            this.postgameview = null;
        }
        if (this.selectionview != null) {
            this.selectionview.destroy();
            this.selectionview = null;
        }
        if (this.mapview != null) {
            this.mapview.destroy();
            this.mapview = null;
        }
        if (this.victoryview != null) {
            this.victoryview.destroy();
            this.victoryview = null;
        }
        if (this.menu != null) {
            this.menu.destroy();
            this.menu = null;
        }
        System.gc();
    }

    public void stopLevel() {
        this.inlevel = false;
        if (this.game != null) {
            this.game.destroy();
            this.game = null;
        }
        if (this.gameview != null) {
            this.gameview.destroy();
            this.gameview = null;
        }
        System.gc();
    }

    public AssetLoader getAssetLoader() {
        return this.assetloader;
    }

    public static class State {
        public static final int SPLASH_1 = 0;
        public static final int SPLASH_2 = 1;
        public static final int SOUND = 2;
        public static final int OPENING = 3;
        public static final int MENU = 4;
        public static final int MAP = 5;
        public static final int SELECTION = 6;
        public static final int PREGAME = 8;
        public static final int POSTGAME = 9;
        public static final int GAME = 10;
        public static final int EXITING = 12;
        public static final int LANGUAGE = 13;
        public static final int VICTORY = 14;
    }

    public static class bfo {
        public static final int inSampleSize = 1;
    }
}

