/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.farmmatch.views;

import com.rocktasticgames.farmmatch.animated.AnimatedElement;
import com.rocktasticgames.farmmatch.main.MainActivity;
import com.rocktasticgames.farmmatch.parameters.C2MValues;
import com.rocktasticgames.farmmatch.utils.GraphicsContainer;
import com.rocktasticgames.farmmatch.utils.MotionEvent;
import com.rocktasticgames.farmmatch.views.View;
import javax.microedition.lcdui.Image;

public class VictoryView
extends View {
    private MainActivity activity;
    private boolean indraw = false;
    private boolean isdestroy = false;
    private long time = 0L;
    private boolean loaded = false;
    private boolean initialized = false;
    private AnimatedElement background;
    private float scale;
    private long start_time;
    private boolean destroyed = false;
    private String bg_image = "victoryscreen";

    public VictoryView(MainActivity mainActivity) {
        super(mainActivity);
        this.activity = mainActivity;
        this.start_time = System.currentTimeMillis();
        System.out.println("victory launched");
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.isdestroy = true;
        this.destroyed = true;
        if (this.indraw) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.background != null) {
            this.background.unload();
        }
    }

    public boolean onBack() {
        return false;
    }

    public void loadResources(GraphicsContainer graphicsContainer, float f) {
        float f2 = (float)graphicsContainer.getWidth() / (float)graphicsContainer.getHeight();
        this.background = new AnimatedElement(this.activity.getAssetLoader(), this.bg_image, 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        this.indraw = true;
        if (this.isdestroy) {
            return;
        }
        boolean bl = false;
        int n = this.activity.getPaint();
        graphicsContainer.save();
        this.scale = graphicsContainer.getWidth() / 176;
        graphicsContainer.scale(this.scale, this.scale);
        if (!this.initialized) {
            this.loadResources(graphicsContainer, this.scale);
            this.initialized = true;
        }
        if (this.activity.getAssetLoader().isCurrent()) {
            this.loaded = true;
        }
        this.background.render(graphicsContainer, n, this.time);
        if (!this.loaded) {
            Image image = this.activity.getPlaceholder();
            if (image != null) {
                graphicsContainer.save();
                graphicsContainer.translate(0.0f, ((float)graphicsContainer.getHeight() / this.scale - (float)graphicsContainer.getWidth() / this.scale * 16.0f / 9.0f) / 2.0f);
                graphicsContainer.scale(MainActivity.PLACEHOLDER_BLUR, MainActivity.PLACEHOLDER_BLUR);
                graphicsContainer.drawImage(image, 0, 0, n);
                graphicsContainer.restore();
            } else {
                graphicsContainer.setColor(-1);
                graphicsContainer.drawPaint(n);
            }
            graphicsContainer.restore();
            this.postInvalidateDelayed(50L);
            return;
        }
        graphicsContainer.setColor(-16777216);
        this.activity.getBrady().setSize((float)this.background.getWidth() * 0.05f);
        for (int i = 0; i < C2MValues.TEXT_VICTORY[this.activity.getLanguage()].length; ++i) {
            graphicsContainer.save();
            graphicsContainer.translate(this.background.getX(this.time) - (float)(this.activity.getBrady().measure(C2MValues.TEXT_VICTORY[this.activity.getLanguage()][i]) / 2), this.background.getY(this.time) - (float)(this.background.getWidth() * (5 - i) / 10));
            this.activity.getBrady().renderString(graphicsContainer, n, C2MValues.TEXT_VICTORY[this.activity.getLanguage()][i]);
            graphicsContainer.restore();
        }
        graphicsContainer.restore();
        this.time = System.currentTimeMillis() - this.start_time;
        this.indraw = false;
        if (this.isdestroy) {
            this.destroy();
        }
        if (this.time > 8000L) {
            this.activity.openMainMenu();
            this.destroy();
        } else if (bl) {
            this.activity.invalidate();
        } else {
            this.activity.postInvalidateDelayed(50L);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.time > 1000L) {
            this.start_time -= 7000L;
        }
        return false;
    }
}

