/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.farmmatch.views;

import com.rocktasticgames.farmmatch.animated.AnimatedElement;
import com.rocktasticgames.farmmatch.main.MainActivity;
import com.rocktasticgames.farmmatch.models.GameModel;
import com.rocktasticgames.farmmatch.parameters.C2MValues;
import com.rocktasticgames.farmmatch.parameters.Levels;
import com.rocktasticgames.farmmatch.parameters.Params;
import com.rocktasticgames.farmmatch.utils.GraphicsContainer;
import com.rocktasticgames.farmmatch.utils.MotionEvent;
import com.rocktasticgames.farmmatch.utils.XMath;
import com.rocktasticgames.farmmatch.views.GameView;
import com.rocktasticgames.farmmatch.views.View;
import javax.microedition.lcdui.Image;

public class PregameView
extends View {
    private static final int MAX_TOUCHES = 2;
    private MainActivity activity;
    private GameModel model;
    private boolean indraw = false;
    private boolean isdestroy = false;
    private long time = 0L;
    private long last_time = 0L;
    private boolean loaded = false;
    private boolean initialized = false;
    private AnimatedElement scroll;
    private AnimatedElement play;
    private AnimatedElement background;
    private boolean[] pause_tapped = new boolean[2];
    private float scale;
    private float[] mousex = new float[2];
    private float[] mousey = new float[2];
    private boolean[] swipe_active = new boolean[2];
    private long swipe_time = -10000L;
    private int[] touch_ptr = new int[2];
    private boolean play_tapped = false;
    private int level;
    private long start_time;
    private boolean destroyed = false;
    private String bg_image = "bg1";
    private boolean close_page = false;
    private boolean on_dialog = false;
    private boolean dialog_tapped = false;
    private AnimatedElement chicken;
    private AnimatedElement rabbit;
    private AnimatedElement cow;
    private boolean utility_tapped = false;
    private AnimatedElement utility = null;

    public PregameView(MainActivity mainActivity, GameModel gameModel, int n) {
        super(mainActivity);
        this.activity = mainActivity;
        this.model = gameModel;
        this.level = n;
        this.start_time = System.currentTimeMillis();
        this.activity.getMusic().playMusic("gameplay");
        this.bg_image = Params.BACKGROUNDS[this.model.getLevel() / 10 % 3];
        this.activity.getAssetLoader().load("parchmentmid_nogrid", 1);
        switch (this.model.winCondition()) {
            case 4: {
                this.activity.getAssetLoader().load(Params.CRATE_INGAME[this.model.getLevel() / 40], 1);
                break;
            }
            case 3: {
                this.activity.getAssetLoader().load(Params.GEM_IMG[this.model.victoryGem1()], 1);
                this.activity.getAssetLoader().load(GameView.EYERES[this.model.victoryGem1()][0], 1);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.activity.getAssetLoader().load("basetile", 1);
            }
        }
        if (this.model.isDoubleMatchWin()) {
            this.activity.getAssetLoader().load(Params.GEM_IMG[this.model.victoryGem2()], 1);
            this.activity.getAssetLoader().load(GameView.EYERES[this.model.victoryGem2()][0], 1);
        }
        this.on_dialog = this.activity.checkMessage(n + 1, 1);
        this.activity.getAssetLoader().load("utility_bomb_empty", 1);
        this.activity.getAssetLoader().load("utility_bomb_full", 1);
        this.activity.getAssetLoader().load("utility_hammer_empty", 1);
        this.activity.getAssetLoader().load("utility_hammer_full", 1);
        this.activity.getAssetLoader().load("utility_shovel_empty", 1);
        this.activity.getAssetLoader().load("utility_shovel_full", 1);
    }

    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        if (this.play != null && !this.play.isAnimatingOut()) {
            return this.play;
        }
        if (n == 5) {
            if (animatedElement == this.cow) {
                return this.chicken;
            }
            return this.rabbit;
        }
        if (n == 2) {
            if (animatedElement == this.rabbit) {
                return this.chicken;
            }
            return this.cow;
        }
        return animatedElement;
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.isdestroy = true;
        this.destroyed = true;
        if (this.indraw) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.activity.getAssetLoader().unload("parchmentmid_nogrid");
        if (this.scroll != null) {
            this.scroll.unload();
            this.play.unload();
            this.background.unload();
            this.chicken.unload();
            this.cow.unload();
            this.rabbit.unload();
        }
        switch (this.model.winCondition()) {
            case 4: {
                this.activity.getAssetLoader().unload(Params.CRATE_INGAME[this.model.getLevel() / 40]);
                break;
            }
            case 3: {
                this.activity.getAssetLoader().unload(Params.GEM_IMG[this.model.victoryGem1()]);
                this.activity.getAssetLoader().unload(GameView.EYERES[this.model.victoryGem1()][0]);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.activity.getAssetLoader().unload("basetile");
            }
        }
        if (this.model.isDoubleMatchWin()) {
            this.activity.getAssetLoader().unload(Params.GEM_IMG[this.model.victoryGem2()]);
            this.activity.getAssetLoader().unload(GameView.EYERES[this.model.victoryGem2()][0]);
        }
        this.activity.getAssetLoader().unload("utility_bomb_empty");
        this.activity.getAssetLoader().unload("utility_bomb_full");
        this.activity.getAssetLoader().unload("utility_hammer_empty");
        this.activity.getAssetLoader().unload("utility_hammer_full");
        this.activity.getAssetLoader().unload("utility_shovel_empty");
        this.activity.getAssetLoader().unload("utility_shovel_full");
    }

    public boolean onBack() {
        this.activity.setPlaceholder(Params.BACKGROUNDS_BLUR[this.model.getLevel() / 10 % 3]);
        if (this.on_dialog) {
            this.on_dialog = this.activity.progressDialog();
            return true;
        }
        return false;
    }

    public void loadResources(GraphicsContainer graphicsContainer, float f) {
        float f2 = (float)graphicsContainer.getWidth() / (float)graphicsContainer.getHeight();
        this.background = new AnimatedElement(this.activity.getAssetLoader(), this.bg_image, 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        this.scroll = new AnimatedElement(this.activity.getAssetLoader(), "parchmentmid_nogrid", 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        this.play = new AnimatedElement(this.activity.getAssetLoader(), "button_272_play", 0.5f, 0.5f + 0.38f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 3, 2L);
        this.cow = new AnimatedElement(this.activity.getAssetLoader(), "utility_bomb_full", 0.3f, 0.5f + 0.18f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 3, 102L);
        this.chicken = new AnimatedElement(this.activity.getAssetLoader(), "utility_hammer_full", 0.5f, 0.5f + 0.18f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 3, 52L);
        this.rabbit = new AnimatedElement(this.activity.getAssetLoader(), "utility_shovel_full", 0.7f, 0.5f + 0.18f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 3, 2L);
        this.play.animateOut(-10000L);
        this.activity.getCanvas().setFocus(this.chicken);
    }

    public int getLevel() {
        return this.level;
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        graphicsContainer.setColor(-1);
        this.indraw = true;
        if (this.isdestroy) {
            return;
        }
        boolean bl = false;
        int n = this.activity.getPaint();
        graphicsContainer.save();
        this.scale = graphicsContainer.getWidth() / 176;
        graphicsContainer.scale(this.scale, this.scale);
        if (!this.initialized) {
            this.loadResources(graphicsContainer, this.scale);
            this.initialized = true;
        }
        if (!this.loaded && this.activity.getAssetLoader().isCurrent()) {
            this.loaded = true;
            this.start_time = System.currentTimeMillis();
        }
        if (this.on_dialog) {
            this.start_time = System.currentTimeMillis();
            this.time = 0L;
        } else {
            this.time = this.close_page ? this.start_time - System.currentTimeMillis() : System.currentTimeMillis() - this.start_time;
        }
        if (this.time < 0L) {
            this.time = 0L;
        }
        if (this.time < 302L) {
            bl = true;
        }
        float f = -79.44444f * XMath.min(1.0f, (float)this.time / 2.0f);
        float f2 = 79.44444f * XMath.min(1.0f, (float)this.time / 2.0f);
        graphicsContainer.restore();
        graphicsContainer.save();
        graphicsContainer.scale(this.scale, this.scale);
        graphicsContainer.save();
        graphicsContainer.scale(1.6666666f, 1.6666666f);
        this.background.render(graphicsContainer, n, this.time);
        graphicsContainer.restore();
        if (!this.loaded) {
            Image image = this.activity.getPlaceholder();
            if (image != null) {
                graphicsContainer.save();
                graphicsContainer.translate(0.0f, ((float)graphicsContainer.getHeight() / this.scale - (float)graphicsContainer.getWidth() / this.scale * 16.0f / 9.0f) / 2.0f);
                graphicsContainer.scale(MainActivity.PLACEHOLDER_BLUR, MainActivity.PLACEHOLDER_BLUR);
                graphicsContainer.drawImage(image, 0, 0, n);
                graphicsContainer.restore();
            } else {
                graphicsContainer.setColor(-1);
                graphicsContainer.drawPaint(n);
            }
            graphicsContainer.restore();
            this.postInvalidateDelayed(50L);
            return;
        }
        Image image = this.activity.getAssetLoader().get("parchmentmid_nogrid");
        if (image != null && this.loaded && f != f2) {
            float f3 = 1.12f;
            graphicsContainer.drawImage(image, (float)(88 - image.getWidth() / 2), (float)(176 * graphicsContainer.getHeight() / graphicsContainer.getWidth() / 2) + (this.model.getTopBound() + this.model.getBotBound()) * f3 / 2.0f - (float)image.getHeight() / graphicsContainer.getVScale() / 2.0f, n);
        }
        if (this.play_tapped) {
            this.play.setColorFilter(Params.filter_dark);
        }
        this.play.render(graphicsContainer, n, this.time);
        if (this.play_tapped) {
            this.play.setColorFilter(null);
        }
        if (this.utility == this.cow && this.utility_tapped) {
            this.cow.setColorFilter(Params.filter_dark);
        }
        this.cow.render(graphicsContainer, n, this.time);
        this.cow.setColorFilter(null);
        if (this.utility == this.chicken && this.utility_tapped) {
            this.chicken.setColorFilter(Params.filter_dark);
        }
        this.chicken.render(graphicsContainer, n, this.time);
        this.chicken.setColorFilter(null);
        if (this.utility == this.rabbit && this.utility_tapped) {
            this.rabbit.setColorFilter(Params.filter_dark);
        }
        this.rabbit.render(graphicsContainer, n, this.time);
        this.rabbit.setColorFilter(null);
        if (this.scroll.isLoaded()) {
            graphicsContainer.setColor(-16777216);
            String string = C2MValues.TEXT_OBJECTIVE[this.activity.getLanguage()][Levels.WIN_CONDITION[this.model.getLevel()]];
            if (Levels.WIN_CONDITION[this.model.getLevel()] == 1) {
                string = string + Levels.WIN_SCORE[this.model.getLevel()];
            }
            String string2 = this.model.isMoveLimited() ? this.model.movesRemaining() + C2MValues.TEXT_MOVE_LIMITER[this.activity.getLanguage()] : C2MValues.TEXT_TIME_LIMITER[this.activity.getLanguage()];
            this.activity.getCartoon().setSize((float)this.scroll.getWidth() * 0.055f);
            graphicsContainer.save();
            graphicsContainer.translate(this.scroll.getX(this.time) - (float)(this.activity.getCartoon().measure(string) / 2), this.scroll.getY(this.time) - (float)this.scroll.getWidth() * 0.42f);
            if ((double)(-this.scroll.getWidth()) * 0.22 + (double)this.activity.getCartoon().getSize(graphicsContainer) > (double)f) {
                this.activity.getCartoon().renderString(graphicsContainer, n, string);
            }
            graphicsContainer.restore();
            graphicsContainer.save();
            graphicsContainer.translate(this.scroll.getX(this.time) - (float)(this.activity.getCartoon().measure(string2) / 2), this.scroll.getY(this.time) - (float)this.scroll.getWidth() * 0.33f);
            if ((double)(-this.scroll.getWidth()) * 0.13 + (double)this.activity.getCartoon().getSize(graphicsContainer) > (double)f) {
                this.activity.getCartoon().renderString(graphicsContainer, n, string2);
            }
            graphicsContainer.restore();
            graphicsContainer.save();
            graphicsContainer.translate(this.scroll.getX(this.time) - (float)(this.activity.getCartoon().measure(C2MValues.TEXT_CHOOSE_HELPER[this.activity.getLanguage()]) / 2), this.scroll.getY(this.time) + (float)this.scroll.getWidth() * 0.03f);
            if ((double)this.scroll.getWidth() * 0.03 + (double)this.activity.getCartoon().getSize(graphicsContainer) < (double)f2) {
                this.activity.getCartoon().renderString(graphicsContainer, n, C2MValues.TEXT_CHOOSE_HELPER[this.activity.getLanguage()]);
            }
            graphicsContainer.restore();
            graphicsContainer.save();
            graphicsContainer.translate(this.scroll.getX(this.time), this.scroll.getY(this.time) - (float)this.scroll.getWidth() * 0.18f);
            if (this.model.isDoubleMatchWin()) {
                graphicsContainer.translate((float)(-this.scroll.getWidth()) * 0.2f, 0.0f);
            }
            graphicsContainer.save();
            Image image2 = null;
            Image image3 = null;
            switch (this.model.winCondition()) {
                case 4: {
                    image2 = this.activity.getAssetLoader().get(Params.CRATE_INGAME[this.model.getLevel() / 40]);
                    break;
                }
                case 3: {
                    image2 = this.activity.getAssetLoader().get(Params.GEM_IMG[this.model.victoryGem1()]);
                    image3 = this.activity.getAssetLoader().get(GameView.EYERES[this.model.victoryGem1()][0]);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    image2 = this.activity.getAssetLoader().get("basetile");
                }
            }
            if (image2 != null) {
                graphicsContainer.save();
                graphicsContainer.scale(1.0f, 1.0f);
                if ((double)this.scroll.getWidth() * 0.0 - (double)(image2.getHeight() / 2) < (double)f2) {
                    graphicsContainer.drawImage(image2, (float)(-image2.getWidth() / 2), (float)(-image2.getHeight()) / graphicsContainer.getVScale() / 2.0f, n);
                    if (image3 != null) {
                        graphicsContainer.drawImage(image3, (float)(-image3.getWidth() / 2), (float)(-image3.getHeight()) / graphicsContainer.getVScale() / 2.0f, n);
                    }
                }
                graphicsContainer.restore();
            }
            graphicsContainer.translate((float)(-this.activity.getCartoon().measure(this.model.gemTarget1()) / 2), (float)this.scroll.getWidth() * 0.08f);
            if ((double)this.scroll.getWidth() * 0.08 < (double)f2) {
                this.activity.getCartoon().renderString(graphicsContainer, n, this.model.gemTarget1());
            }
            graphicsContainer.restore();
            if (this.model.isDoubleMatchWin()) {
                graphicsContainer.translate((float)this.scroll.getWidth() * 0.4f, 0.0f);
                Image image4 = this.activity.getAssetLoader().get(Params.GEM_IMG[this.model.victoryGem2()]);
                Image image5 = this.activity.getAssetLoader().get(GameView.EYERES[this.model.victoryGem2()][0]);
                if (image4 != null) {
                    graphicsContainer.save();
                    graphicsContainer.scale(1.0f, 1.0f);
                    if ((double)this.scroll.getWidth() * 0.0 - (double)(image4.getHeight() / 2) < (double)f2) {
                        graphicsContainer.drawImage(image4, (float)(-image4.getWidth() / 2), (float)(-image4.getHeight()) / graphicsContainer.getVScale() / 2.0f, n);
                        if (image5 != null) {
                            graphicsContainer.drawImage(image5, (float)(-image5.getWidth() / 2), (float)(-image5.getHeight()) / graphicsContainer.getVScale() / 2.0f, n);
                        }
                    }
                    graphicsContainer.restore();
                }
                graphicsContainer.translate((float)(-this.activity.getCartoon().measure(this.model.gemTarget2()) / 2), (float)this.scroll.getWidth() * 0.08f);
                if ((double)this.scroll.getWidth() * 0.08 < (double)f2) {
                    this.activity.getCartoon().renderString(graphicsContainer, n, this.model.gemTarget2());
                }
            }
            graphicsContainer.restore();
        }
        if (this.on_dialog) {
            this.activity.renderDialog(graphicsContainer, n, this.scale, this.dialog_tapped);
        }
        this.last_time = this.time;
        this.time = this.close_page ? this.start_time - System.currentTimeMillis() : System.currentTimeMillis() - this.start_time;
        this.indraw = false;
        if (this.isdestroy) {
            this.destroy();
        }
        if (this.time < 0L) {
            this.activity.startGame(this.level);
            this.destroy();
        } else if (bl) {
            this.invalidate();
        } else {
            this.postInvalidateDelayed(50L);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isdestroy || !this.loaded || !this.initialized || this.close_page) {
            return false;
        }
        int n = 0;
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        switch (motionEvent.getAction()) {
            case 1: {
                this.activity.setPlaceholder(Params.BACKGROUNDS_BLUR[this.model.getLevel() / 10 % 3]);
                if (this.dialog_tapped) {
                    if (!this.activity.progressDialog()) {
                        this.on_dialog = false;
                    }
                    this.dialog_tapped = false;
                } else if (this.play_tapped) {
                    this.play.animate(4, 2L);
                    this.close_page = true;
                    this.start_time = System.currentTimeMillis() + 2L + 300L;
                } else if (this.utility_tapped) {
                    this.utility_tapped = false;
                    this.activity.getCanvas().setFocus(this.play);
                }
                this.swipe_active[n] = false;
                this.touch_ptr[n] = -1;
                return false;
            }
            case 2: {
                this.swipe_active[n] = false;
                if (this.on_dialog) {
                    if (motionEvent.getX() > this.activity.getCanvas().getWidth() * 4 / 10 && motionEvent.getX() < this.activity.getCanvas().getWidth() * 6 / 10 && motionEvent.getY() > this.activity.getCanvas().getHeight() * 7 / 8) {
                        this.dialog_tapped = true;
                        this.activity.playSound("standard_click");
                    }
                } else if (this.play.isLoaded() && this.play.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.play_tapped = true;
                    this.activity.playSound("standard_click");
                } else if (this.chicken.isLoaded() && this.chicken.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    if (this.play.isAnimatingOut()) {
                        this.play.animate(3, this.last_time);
                    }
                    this.utility = this.chicken;
                    this.model.setUtility(1);
                    this.utility_tapped = true;
                    this.chicken.setPNG("utility_hammer_full");
                    this.cow.setPNG("utility_bomb_empty");
                    this.rabbit.setPNG("utility_shovel_empty");
                } else if (this.cow.isLoaded() && this.cow.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    if (this.play.isAnimatingOut()) {
                        this.play.animate(3, this.last_time);
                    }
                    this.utility = this.cow;
                    this.model.setUtility(0);
                    this.utility_tapped = true;
                    this.chicken.setPNG("utility_hammer_empty");
                    this.cow.setPNG("utility_bomb_full");
                    this.rabbit.setPNG("utility_shovel_empty");
                } else if (this.rabbit.isLoaded() && this.rabbit.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    if (this.play.isAnimatingOut()) {
                        this.play.animate(3, this.last_time);
                    }
                    this.utility = this.rabbit;
                    this.model.setUtility(2);
                    this.utility_tapped = true;
                    this.chicken.setPNG("utility_hammer_empty");
                    this.cow.setPNG("utility_bomb_empty");
                    this.rabbit.setPNG("utility_shovel_full");
                } else if (!this.model.isPaused()) {
                    this.swipe_time = this.last_time;
                    this.swipe_active[n] = true;
                    this.mousex[n] = f;
                    this.mousey[n] = f2;
                }
                return true;
            }
            case 3: {
                if (this.dialog_tapped && (motionEvent.getX() <= this.activity.getCanvas().getWidth() * 4 / 10 || motionEvent.getX() >= this.activity.getCanvas().getWidth() * 6 / 10 || motionEvent.getY() <= this.activity.getCanvas().getHeight() * 7 / 8)) {
                    this.dialog_tapped = false;
                } else if (this.play_tapped && !this.play.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.play_tapped = false;
                } else if (this.utility_tapped && !this.utility.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.utility_tapped = false;
                } else if (this.swipe_active[n]) {
                    // empty if block
                }
                return true;
            }
        }
        return true;
    }
}

