/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.farmmatch.main;

import com.rocktasticgames.farmmatch.animated.AnimatedElement;
import com.rocktasticgames.farmmatch.animated.AnimatedPointer;
import com.rocktasticgames.farmmatch.main.MainActivity;
import com.rocktasticgames.farmmatch.parameters.Params;
import com.rocktasticgames.farmmatch.utils.ColorMatrixColorFilter;
import com.rocktasticgames.farmmatch.utils.GraphicsContainer;
import com.rocktasticgames.farmmatch.utils.MotionEvent;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class MainCanvas
extends Canvas {
    private static GraphicsContainer gc;
    private MainActivity activity;
    private AnimatedElement focus = null;
    private AnimatedPointer pointer;

    public MainCanvas(MainActivity mainActivity) {
        this.activity = mainActivity;
    }

    public static GraphicsContainer getGraphics() {
        return gc;
    }

    public int getWidth() {
        return this.getRZWidth();
    }

    public int getHeight() {
        return this.getRZHeight();
    }

    public int getRZHeight() {
        return Math.max(super.getHeight(), Math.min(super.getHeight(), super.getWidth()) * 4 / 3);
    }

    public int getRZWidth() {
        return Math.min(super.getHeight(), super.getWidth());
    }

    protected void paint(Graphics graphics) {
        if (gc == null) {
            this.setFullScreenMode(true);
            gc = new GraphicsContainer(super.getWidth(), super.getHeight());
            try {
                this.pointer = new AnimatedPointer(this.activity, "pointerarrow", this.getWidth(), this.getHeight());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        gc.setGraphics(graphics);
        gc.setColor(-16777216);
        gc.fillRect(0, 0, 176, 2);
        gc.setColor(-1);
        switch (this.activity.getState()) {
            case 10: {
                if (this.activity.gameview == null) break;
                this.activity.gameview.onDraw(gc);
                break;
            }
            case 5: {
                if (this.activity.mapview == null) break;
                this.activity.mapview.onDraw(gc);
                break;
            }
            case 14: {
                if (this.activity.victoryview == null) break;
                this.activity.victoryview.onDraw(gc);
                break;
            }
            case 8: {
                if (this.activity.pregameview == null) break;
                this.activity.pregameview.onDraw(gc);
                break;
            }
            case 9: {
                if (this.activity.postgameview == null) break;
                this.activity.postgameview.onDraw(gc);
                break;
            }
            case 6: {
                if (this.activity.selectionview == null) break;
                this.activity.selectionview.onDraw(gc);
                break;
            }
            case 4: {
                if (this.activity.menu == null) break;
                this.activity.menu.onDraw(gc);
                break;
            }
            case 0: {
                if (this.activity.splashone == null) break;
                this.activity.splashone.onDraw(gc);
                break;
            }
            case 1: {
                if (this.activity.splashtwo == null) break;
                this.activity.splashtwo.onDraw(gc);
                break;
            }
            case 2: {
                if (this.activity.soundview == null) break;
                this.activity.soundview.onDraw(gc);
                break;
            }
            case 13: {
                if (this.activity.languageview == null) break;
                this.activity.languageview.onDraw(gc);
            }
        }
        gc.resetStack();
        boolean bl = false;
        if (this.activity.isDialogLoaded()) {
            this.pointer.setX(0.5f);
            this.pointer.setY(1.0f - 0.03f * (float)super.getWidth() / (float)super.getHeight());
            bl = true;
        } else if (this.focus != null) {
            this.pointer.setTarget(this.focus);
        } else if (this.activity.getState() == 13 && this.activity.languageview != null) {
            this.focus = this.activity.languageview.traverse(this.focus, 1);
        } else if (this.activity.getState() == 2 && this.activity.soundview != null) {
            this.focus = this.activity.soundview.traverse(this.focus, 2);
        } else if (this.activity.getState() == 4 && this.activity.menu != null) {
            this.focus = this.activity.menu.traverse(this.focus, 1);
            if (this.focus != null) {
                this.pointer.setTarget(this.focus);
            }
        }
        if (this.activity.getState() == 10) {
            if (this.activity.getGameModel() == null || this.activity.getGameModel().showCursor()) {
                if (this.activity.getGameModel() != null && this.activity.getGameModel().isPaused()) {
                    this.pointer.setPNG("pointerarrow");
                    this.pointer.render(gc, 0, Long.MAX_VALUE);
                } else {
                    this.pointer.setPNG("gems_selector");
                    if (this.activity.isGemSelected()) {
                        this.pointer.setFilter(new ColorMatrixColorFilter(4));
                    } else if (this.pointer.getFilter() != Params.filter_dark) {
                        this.pointer.setFilter(null);
                    }
                    this.pointer.render(gc, -1, Long.MAX_VALUE);
                }
            }
        } else if (this.activity.getState() != 0 && this.activity.getState() != 1 && this.focus != null && this.activity.getState() != 5 || bl) {
            this.pointer.setPNG("pointerarrow");
            this.pointer.render(gc, 0, Long.MAX_VALUE);
        } else if (this.activity.getState() == 5) {
            this.pointer.setPNG("pointerarrow");
            if (this.activity.mapview != null && this.activity.mapview.needsTranslate(this.focus)) {
                gc.save();
                gc.translate(-176, 0);
                if (this.activity.mapview.needsDoubleTranslate(this.focus)) {
                    gc.translate(-176, 0);
                }
                this.pointer.render(gc, 0, Long.MAX_VALUE);
                gc.restore();
            } else {
                this.pointer.render(gc, 0, Long.MAX_VALUE);
            }
        }
        gc.resetStack();
    }

    private void sendMotionEvent(int n, int n2, int n3) {
        this.activity.invalidate();
        switch (this.activity.getState()) {
            case 10: {
                if (this.activity.gameview == null) break;
                this.activity.gameview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 5: {
                if (this.activity.mapview == null) break;
                this.activity.mapview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 8: {
                if (this.activity.pregameview == null) break;
                this.activity.pregameview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 9: {
                if (this.activity.postgameview == null) break;
                this.activity.postgameview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 6: {
                if (this.activity.selectionview == null) break;
                this.activity.selectionview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 14: {
                if (this.activity.victoryview == null) break;
                this.activity.victoryview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 4: {
                if (this.activity.menu == null) break;
                this.activity.menu.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 0: {
                if (this.activity.splashone == null) break;
                this.activity.splashone.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 1: {
                if (this.activity.splashtwo == null) break;
                this.activity.splashtwo.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 2: {
                if (this.activity.soundview == null) break;
                this.activity.soundview.onTouchEvent(new MotionEvent(n, n2, n3));
                break;
            }
            case 13: {
                if (this.activity.languageview == null) break;
                this.activity.languageview.onTouchEvent(new MotionEvent(n, n2, n3));
            }
        }
    }

    public AnimatedElement getFocus() {
        return this.focus;
    }

    private AnimatedElement getNeighbor(int n) {
        this.activity.invalidate();
        switch (this.activity.getState()) {
            case 10: {
                return this.activity.gameview.traverse(this.focus, n);
            }
            case 5: {
                return this.activity.mapview.traverse(this.focus, n);
            }
            case 8: {
                return this.activity.pregameview.traverse(this.focus, n);
            }
            case 9: {
                return this.activity.postgameview.traverse(this.focus, n);
            }
            case 6: {
                return this.activity.selectionview.traverse(this.focus, n);
            }
            case 4: {
                return this.activity.menu.traverse(this.focus, n);
            }
            case 2: {
                return this.activity.soundview.traverse(this.focus, n);
            }
            case 13: {
                return this.activity.languageview.traverse(this.focus, n);
            }
        }
        return this.focus;
    }

    public void setFocus(AnimatedElement animatedElement) {
        this.focus = animatedElement;
        if (animatedElement != null) {
            this.pointer.setTarget(animatedElement);
        }
    }

    protected void keyPressed(int n) {
        if (n == -11) {
            this.activity.onBackPressed();
            return;
        }
        if (n != 48) {
            if (n == -6) {
                if (this.activity.getState() == 5 && this.activity.mapview != null) {
                    this.activity.mapview.showLeft();
                } else if (this.activity.getState() == 6 && this.activity.selectionview != null) {
                    this.activity.onBackPressed();
                }
                return;
            }
            if (n == -7) {
                if (this.activity.getState() == 5 && this.activity.mapview != null) {
                    this.activity.mapview.showRight();
                } else if (this.activity.getState() == 10 && this.activity.gameview != null) {
                    this.activity.gameview.lsk();
                }
                return;
            }
        }
        switch (this.getGameAction(n)) {
            case 8: {
                this.pointer.setFilter(Params.filter_dark);
                System.out.println("press at: " + (int)this.pointer.getX(Long.MAX_VALUE) + ", " + (int)this.pointer.getY(Long.MAX_VALUE));
                this.pointerPressed((int)this.pointer.getX(Long.MAX_VALUE), (int)this.pointer.getY(Long.MAX_VALUE));
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.focus = this.getNeighbor(this.getGameAction(n));
                if (this.focus == null) break;
                this.pointer.setTarget(this.focus);
            }
        }
    }

    protected void keyRepeated(int n) {
    }

    protected void keyReleased(int n) {
        switch (this.getGameAction(n)) {
            case 8: {
                this.pointerReleased((int)this.pointer.getX(Long.MAX_VALUE), (int)this.pointer.getY(Long.MAX_VALUE));
                this.pointer.setFilter(null);
                break;
            }
            case 1: {
                break;
            }
            case 6: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    protected void pointerReleased(int n, int n2) {
        this.sendMotionEvent(1, n, n2);
    }

    protected void pointerPressed(int n, int n2) {
        this.sendMotionEvent(2, n, n2);
    }

    protected void pointerDragged(int n, int n2) {
        this.sendMotionEvent(3, n, n2);
    }
}

