/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.farmmatch.graphics;

import com.rocktasticgames.farmmatch.graphics.BackgroundElement;
import com.rocktasticgames.farmmatch.main.MainActivity;
import com.rocktasticgames.farmmatch.main.MainCanvas;
import com.rocktasticgames.farmmatch.models.GameModel;
import com.rocktasticgames.farmmatch.parameters.Params;
import com.rocktasticgames.farmmatch.utils.GraphicsContainer;
import com.rocktasticgames.farmmatch.utils.XMath;
import javax.microedition.lcdui.Image;

public class Tile
extends BackgroundElement {
    private char tile_type;
    private long last_time = -100000L;
    private float dest_x;
    private float dest_y;
    private float vel_x = 0.0f;
    private float vel_y = 0.0f;
    private int tile_color;
    private String overlay = null;
    private long made_time = -100000L;
    private boolean matched_indirectly = false;
    private long target_time = 0L;
    private float start_x;
    private float start_y;
    private boolean just_clicked = false;
    private int pending_hits = 0;
    private long pending_hit_time = Long.MAX_VALUE;
    private MainActivity activity;
    private boolean matched_by_special = false;
    private int count_score = 80;
    private boolean unloaded = false;
    private float hint_scale = 1.0f;

    public Tile(MainActivity mainActivity, String string, int n, int n2, float f) {
        super(mainActivity.getAssetLoader(), string, ((float)n2 - 3.5f) * 19.86111f, ((float)n - 3.5f - f) * 19.86111f, 1, 19.86111f);
        this.dest_x = ((float)n2 - 3.5f) * 19.86111f;
        this.dest_y = ((float)n - 3.5f) * 19.86111f;
        this.tile_color = -1;
        this.tile_type = (char)110;
        this.activity = mainActivity;
    }

    public Tile(MainActivity mainActivity, String string, int n, int n2, float f, char c, int n3, long l) {
        super(mainActivity.getAssetLoader(), string, ((float)n2 - 3.5f) * 19.86111f, ((float)n - 3.5f - f) * 19.86111f, 1, 19.86111f);
        this.dest_x = ((float)n2 - 3.5f) * 19.86111f;
        this.dest_y = ((float)n - 3.5f) * 19.86111f;
        this.tile_color = n3;
        this.setType(c);
        this.last_time = l;
        this.made_time = l;
        this.activity = mainActivity;
    }

    public void unload() {
        if (this.unloaded) {
            return;
        }
        this.unloaded = true;
        super.unload();
        if (this.overlay != null) {
            this.assetloader.unload(this.overlay);
        }
    }

    public float getHintScale() {
        return this.hint_scale;
    }

    public boolean isNew(long l) {
        return l == this.made_time;
    }

    public boolean wasMatchedBySpecial() {
        return this.matched_by_special;
    }

    public void matchSpecial() {
        this.matched_by_special = true;
    }

    public int getColor() {
        return this.tile_color;
    }

    public boolean needsRemoving(long l) {
        if (this.tile_type == 'n') {
            return this.time_internal != 0L && l > this.time_internal;
        }
        return this.time_internal != 0L && l > this.time_internal + 300L;
    }

    public void setOverlay(String string) {
        if (this.overlay != null) {
            this.assetloader.unload(this.overlay);
        }
        this.assetloader.load(string, 1);
        this.overlay = string;
    }

    public void stampTime(long l) {
        if (this.time_internal > 0L && l > this.time_internal) {
            return;
        }
        super.stampTime(l);
    }

    public void stampDestroyed(long l, boolean bl) {
        if (this.time_internal > 0L && l > this.time_internal) {
            return;
        }
        super.stampTime(l);
        this.matched_indirectly = bl;
        this.setOverlay("effect_fadedcircle_white");
    }

    public boolean isIndirectMatch() {
        return this.matched_indirectly;
    }

    public void clearOverlay() {
        if (this.overlay != null) {
            this.assetloader.unload(this.overlay);
        }
        this.overlay = null;
    }

    public int getScore() {
        return this.count_score;
    }

    public void setScore(int n) {
        this.count_score = n;
    }

    public boolean hasPendingHit() {
        return this.pending_hits > 0;
    }

    public void hitCrate(long l) {
        if (this.pending_hits == 0) {
            ++this.pending_hits;
        }
        if (l < this.pending_hit_time) {
            this.pending_hit_time = l;
        }
    }

    public boolean hitDestroys(long l) {
        if (l < this.pending_hit_time) {
            this.pending_hit_time = l;
        }
        ++this.pending_hits;
        if (this.tile_type == 'd' && this.pending_hits <= 2) {
            return false;
        }
        return this.tile_type != 's' && this.tile_type != 'f' || this.pending_hits != 1;
    }

    public void performHit() {
        --this.pending_hits;
        if (this.tile_type == 'd') {
            this.tile_type = (char)115;
            this.setOverlay("chain1");
            this.activity.getSounds().playEffect("break_chains");
        } else if (this.tile_type == 's') {
            this.tile_type = (char)114;
            this.clearOverlay();
            this.activity.getSounds().playEffect("break_chains");
        } else if (this.tile_type == 'f') {
            this.tile_type = (char)114;
            super.setResource(Params.GEM_IMG[this.tile_color]);
            this.activity.getSounds().playEffect("break_ice");
        } else if (this.tile_type == 'c') {
            this.tile_type = (char)114;
            this.tile_color = (int)(XMath.random() * (float)Params.GEM_IMG.length);
            super.setResource(Params.GEM_IMG[this.tile_color]);
            this.activity.playSound("break_crate");
        }
    }

    public boolean isLocked() {
        return this.tile_type == 's' || this.tile_type == 'd' || this.tile_type == 'c' || this.tile_type == 'f' || this.tile_type == 'x';
    }

    public char getType() {
        return this.tile_type;
    }

    public void setType(char c) {
        this.tile_type = c;
        switch (c) {
            case 'm': {
                this.setOverlay("diamond_glow");
                break;
            }
            case 's': {
                this.setOverlay("chain1");
                break;
            }
            case 'd': {
                this.setOverlay("chain2");
                break;
            }
            default: {
                this.clearOverlay();
            }
        }
    }

    public boolean hasChains() {
        return this.tile_type == 'd' || this.tile_type == 's';
    }

    public void drawChains(GraphicsContainer graphicsContainer, int n) {
        graphicsContainer.save();
        graphicsContainer.translate(this.x / this.z, this.y / this.z);
        Image image = this.assetloader.get(this.overlay);
        if (image != null) {
            graphicsContainer.drawImage(image, -image.getWidth() / 2, -image.getHeight() / 2, n);
        }
        graphicsContainer.restore();
    }

    public void setDestXSwap(float f) {
        this.dest_x = f;
        this.vel_x = this.dest_x > this.x ? 122.22222f : -122.22222f;
    }

    public void setDestYSwap(float f) {
        this.dest_y = f;
        this.vel_y = this.dest_y > this.y ? 122.22222f : -122.22222f;
    }

    public void setDestX(float f) {
        this.dest_x = f;
        if (this.dest_x > this.x) {
            this.vel_x = XMath.abs(this.vel_y);
        } else if (this.dest_x < this.x) {
            this.vel_x = -XMath.abs(this.vel_y);
        }
    }

    public void setDestY(float f) {
        if (this.vel_y == -122.22222f && f > this.y) {
            this.vel_y = 0.0f;
        }
        this.dest_y = f;
    }

    public void accelerateTo(float f, float f2, long l) {
        this.target_time = l;
        this.dest_x = f;
        this.dest_y = f2;
        this.start_x = this.x;
        this.start_y = this.y;
    }

    public boolean isMatched() {
        return this.time_internal != 0L;
    }

    public boolean isInPlace() {
        return this.x == this.dest_x && this.y == this.dest_y;
    }

    public int getRow() {
        return XMath.round(this.dest_y / 19.86111f + 3.5f);
    }

    public int getColumn() {
        return XMath.round(this.dest_x / 19.86111f + 3.5f);
    }

    public float getDestX() {
        return this.dest_x;
    }

    public float getDestY() {
        return this.dest_y;
    }

    public boolean didJustClick() {
        return this.just_clicked;
    }

    public boolean render(GraphicsContainer graphicsContainer, int n, long l, GameModel gameModel) {
        this.hint_scale = 1.0f;
        if (this.pending_hits > 0 && l > this.pending_hit_time) {
            this.performHit();
        }
        this.just_clicked = false;
        if (l < this.last_time) {
            return false;
        }
        if (this.isMatched() && (l > this.time_internal || this.tile_type == 'r')) {
            return false;
        }
        float f = (float)(l - this.last_time) / 1000.0f;
        if (this.last_time == 0L) {
            f = 0.0f;
        }
        if (this.vel_y != 122.22222f && this.vel_y != -122.22222f) {
            this.vel_y += XMath.min(11.458333f, (15.277778f + 763.8889f * this.vel_y / 15.277778f) * f);
        }
        if (this.dest_y > this.y) {
            this.y = XMath.min(this.dest_y, this.y + f * this.vel_y);
            if (this.dest_y == this.y && this.vel_y != 122.22222f && this.vel_y != -122.22222f) {
                this.just_clicked = true;
            }
        } else if (this.dest_y < this.y) {
            this.y = XMath.max(this.dest_y, this.y + f * this.vel_y);
        }
        if (this.y == this.dest_y) {
            this.vel_y = 0.0f;
        }
        if (this.dest_x > this.x) {
            this.x = this.vel_x != 122.22222f ? XMath.max(this.x, this.dest_x - XMath.abs(this.y - this.dest_y)) : XMath.min(this.dest_x, this.x + f * this.vel_x);
        } else if (this.dest_x < this.x) {
            this.x = this.vel_x != -122.22222f ? XMath.min(this.x, this.dest_x + XMath.abs(this.y - this.dest_y)) : XMath.max(this.dest_x, this.x + f * this.vel_x);
        }
        if (this.x == this.dest_x) {
            this.vel_x = 0.0f;
        }
        if (this.target_time != 0L) {
            if (l >= this.target_time + 500L) {
                this.x = this.dest_x;
                this.y = this.dest_y;
                this.target_time = 0L;
            } else {
                this.x = this.start_x + (this.dest_x - this.start_x) * XMath.pow((float)(l - this.target_time) / 500.0f, 3);
                this.y = this.start_y + (this.dest_y - this.start_y) * XMath.pow((float)(l - this.target_time) / 500.0f, 3);
            }
        }
        if (this.y <= -9.910694f + gameModel.getBotBound() && this.y >= 9.910694f + gameModel.getTopBound()) {
            if (gameModel.getHint() != null && (this == gameModel.getGems()[gameModel.getHint()[0]][gameModel.getHint()[1]] || this == gameModel.getGems()[gameModel.getHint()[2]][gameModel.getHint()[3]])) {
                this.hint_scale = 1.0f;
                long l2 = (l - gameModel.getIdleTime()) % 7000L;
                if (l2 < 1500L) {
                    this.hint_scale = 1.0f + 0.3f * (1.0f - 2.0f * (float)Math.abs((l2 %= 500L) - 250L) / 500.0f);
                }
                if (!(this.hint_scale > 1.15f)) {
                    super.render(graphicsContainer, n);
                }
            } else if (this.overlay != null && this.overlay != "effect_fadedcircle_white") {
                if (this.tile_type == 's' || this.tile_type == 'd') {
                    super.renderWithBackdrop(graphicsContainer, n, this.overlay, 255);
                } else {
                    super.renderWithBackdrop(graphicsContainer, n, this.overlay, (int)XMath.abs(255.0f - 0.7f * (float)l / 2.0f % 511.0f));
                }
            } else if (this.made_time + 600L > l) {
                super.render(graphicsContainer, n);
            } else {
                super.render(graphicsContainer, n);
            }
        } else if (this.y <= 9.910694f + gameModel.getBotBound() && this.y >= -9.910694f + gameModel.getTopBound()) {
            if (!super.prepare(graphicsContainer, n, 0.0f, 0.0f)) {
                return false;
            }
            int n2 = (int)XMath.max(0.0f, gameModel.getTopBound() - super.getHeight() + (float)this.bitmap.getHeight() / MainCanvas.getGraphics().getVScale() / 2.0f);
            int n3 = (int)XMath.min((float)this.bitmap.getHeight() / MainCanvas.getGraphics().getVScale(), gameModel.getBotBound() - super.getHeight() + (float)this.bitmap.getHeight() / MainCanvas.getGraphics().getVScale() / 2.0f);
            if (n2 < this.bitmap.getWidth() / 2 && n3 > this.bitmap.getWidth() / 2) {
                Image image;
                graphicsContainer.drawImage(this.bitmap, (float)(-this.bitmap.getWidth() / 2), (float)(-this.bitmap.getHeight()) / MainCanvas.getGraphics().getVScale() / 2.0f, n);
                if ((this.overlay != null && this.tile_type == 's' || this.tile_type == 'd') && (image = this.assetloader.get(this.overlay)) != null) {
                    graphicsContainer.drawImage(image, -image.getWidth() / 2, -image.getHeight() / 2, n);
                }
            }
            graphicsContainer.restore();
        }
        this.last_time = l;
        return false;
    }
}

