/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.farmmatch.views;

import com.rocktasticgames.farmmatch.animated.AnimatedElement;
import com.rocktasticgames.farmmatch.main.MainActivity;
import com.rocktasticgames.farmmatch.parameters.C2MValues;
import com.rocktasticgames.farmmatch.parameters.Params;
import com.rocktasticgames.farmmatch.utils.GraphicsContainer;
import com.rocktasticgames.farmmatch.utils.MotionEvent;
import com.rocktasticgames.farmmatch.utils.XMath;
import com.rocktasticgames.farmmatch.views.View;
import javax.microedition.lcdui.Image;

public class PostgameView
extends View {
    private static final int MAX_TOUCHES = 2;
    private MainActivity activity;
    private boolean indraw = false;
    private boolean isdestroy = false;
    private long time = 0L;
    private long last_time = 0L;
    private boolean loaded = false;
    private boolean initialized = false;
    private AnimatedElement scroll;
    private AnimatedElement play;
    private AnimatedElement menu;
    private AnimatedElement background;
    private boolean[] pause_tapped = new boolean[2];
    private float scale;
    private float[] mousex = new float[2];
    private float[] mousey = new float[2];
    private boolean[] swipe_active = new boolean[2];
    private long swipe_time = -10000L;
    private int[] touch_ptr = new int[2];
    private boolean play_tapped = false;
    private boolean menu_tapped = false;
    private int level;
    private long start_time;
    private boolean destroyed = false;
    private String bg_image = "bg1";
    private boolean close_page = false;
    private boolean isdefeat;
    private boolean exit_play = false;
    private boolean exit_menu = false;
    private boolean on_dialog = false;
    private boolean dialog_tapped = false;

    public PostgameView(MainActivity mainActivity, boolean bl, int n) {
        super(mainActivity);
        this.activity = mainActivity;
        this.isdefeat = bl;
        this.level = n;
        this.start_time = System.currentTimeMillis();
        this.bg_image = Params.BACKGROUNDS[this.level / 10 % 3];
        this.activity.getAssetLoader().load("parchmentmid", 1);
        if (!bl) {
            this.on_dialog = this.activity.checkMessage(n + 1, 3);
        }
    }

    public AnimatedElement traverse(AnimatedElement animatedElement, int n) {
        if (animatedElement == null && this.play != null) {
            return this.play;
        }
        if (n == 5) {
            return this.play;
        }
        if (n == 2) {
            return this.menu;
        }
        if (animatedElement != null) {
            return animatedElement;
        }
        return null;
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.isdestroy = true;
        this.destroyed = true;
        if (this.indraw) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.activity.getAssetLoader().unload("parchmentmid");
        if (this.scroll != null) {
            this.scroll.unload();
            this.play.unload();
            this.menu.unload();
            this.background.unload();
        }
    }

    public boolean onBack() {
        if (this.on_dialog) {
            this.on_dialog = this.activity.progressDialog();
            return true;
        }
        return false;
    }

    public void loadResources(GraphicsContainer graphicsContainer, float f) {
        float f2 = (float)graphicsContainer.getWidth() / (float)graphicsContainer.getHeight();
        this.background = new AnimatedElement(this.activity.getAssetLoader(), this.bg_image, 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 0, 0L);
        if (this.isdefeat) {
            this.scroll = new AnimatedElement(this.activity.getAssetLoader(), "levelfail_canvas", 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 6, 50L);
            this.play = new AnimatedElement(this.activity.getAssetLoader(), "button_restart", 0.6f, 0.5f + 0.3f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 4, 50L);
            this.menu = new AnimatedElement(this.activity.getAssetLoader(), "button_backtohome", 0.4f, 0.5f + 0.3f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 3, 50L);
        } else {
            this.scroll = new AnimatedElement(this.activity.getAssetLoader(), "levelcomplete_canvas", 0.5f, 0.5f, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 6, 50L);
            this.play = new AnimatedElement(this.activity.getAssetLoader(), "button_next", 0.6f, 0.5f + 0.3f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 4, 50L);
            this.menu = new AnimatedElement(this.activity.getAssetLoader(), "button_backtohome", 0.4f, 0.5f + 0.3f * f2, (float)graphicsContainer.getWidth() / f, (float)graphicsContainer.getHeight() / f, 3, 50L);
        }
        this.activity.getSounds().playGameOver(!this.isdefeat);
        this.activity.getCanvas().setFocus(this.play);
    }

    public int getLevel() {
        return this.level;
    }

    public int getNextLevel() {
        if (this.isdefeat) {
            return this.level;
        }
        return this.level + 1;
    }

    public void onDraw(GraphicsContainer graphicsContainer) {
        this.indraw = true;
        if (this.isdestroy) {
            return;
        }
        graphicsContainer.setColor(-1);
        boolean bl = false;
        int n = this.activity.getPaint();
        graphicsContainer.save();
        this.scale = graphicsContainer.getWidth() / 240;
        graphicsContainer.scale(this.scale, this.scale);
        if (!this.initialized) {
            this.loadResources(graphicsContainer, this.scale);
            this.initialized = true;
        }
        if (!this.loaded && this.activity.getAssetLoader().isCurrent()) {
            this.loaded = true;
            this.start_time = System.currentTimeMillis();
        }
        if (this.on_dialog) {
            this.start_time = System.currentTimeMillis();
            this.time = 0L;
        } else {
            this.time = this.close_page ? this.start_time - System.currentTimeMillis() : System.currentTimeMillis() - this.start_time;
        }
        if (this.time < 0L) {
            this.time = 0L;
        }
        if (this.time < 302L) {
            bl = true;
        }
        graphicsContainer.restore();
        graphicsContainer.save();
        graphicsContainer.scale(this.scale, this.scale);
        graphicsContainer.save();
        graphicsContainer.scale(1.6666666f, 1.6666666f);
        this.background.render(graphicsContainer, n, this.time);
        graphicsContainer.restore();
        if (!this.loaded) {
            Image image = this.activity.getPlaceholder();
            if (image != null) {
                graphicsContainer.save();
                graphicsContainer.translate(0.0f, ((float)graphicsContainer.getHeight() / this.scale - (float)graphicsContainer.getWidth() / this.scale * 16.0f / 9.0f) / 2.0f);
                graphicsContainer.scale(MainActivity.PLACEHOLDER_BLUR, MainActivity.PLACEHOLDER_BLUR);
                graphicsContainer.drawImage(image, 0, 0, n);
                graphicsContainer.restore();
            } else {
                graphicsContainer.setColor(-1);
                graphicsContainer.drawPaint(n);
            }
            graphicsContainer.restore();
            this.postInvalidateDelayed(50L);
            return;
        }
        this.scroll.render(graphicsContainer, n, this.time);
        if (this.play_tapped) {
            this.play.setColorFilter(Params.filter_dark);
        }
        this.play.render(graphicsContainer, n, this.time);
        if (this.play_tapped) {
            this.play.setColorFilter(null);
        }
        if (this.menu_tapped) {
            this.menu.setColorFilter(Params.filter_dark);
        }
        this.menu.render(graphicsContainer, n, this.time);
        if (this.menu_tapped) {
            this.menu.setColorFilter(null);
        }
        if (this.scroll.isLoaded()) {
            String string = C2MValues.TEXT_LEVEL_FULL[this.activity.getLanguage()] + " " + (this.level + 1);
            String string2 = this.isdefeat ? C2MValues.TEXT_TRY_AGAIN[this.activity.getLanguage()] : C2MValues.TEXT_COMPLETED[this.activity.getLanguage()];
            this.activity.getCartoon().setSize((float)this.scroll.getWidth() * 0.065f);
            graphicsContainer.save();
            graphicsContainer.translate(this.scroll.getX(this.time) - (float)(this.activity.getCartoon().measure(string) / 2), this.scroll.getY(this.time) + (float)this.scroll.getWidth() * 0.06f);
            this.activity.getCartoon().renderString(graphicsContainer, n, string);
            graphicsContainer.restore();
            this.activity.getCartoon().setSize((float)this.scroll.getWidth() * 0.075f);
            graphicsContainer.save();
            graphicsContainer.translate(this.scroll.getX(this.time) - (float)(this.activity.getCartoon().measure(string2) / 2), this.scroll.getY(this.time) + (float)this.scroll.getWidth() * 0.17f);
            this.activity.getCartoon().renderString(graphicsContainer, n, string2);
            graphicsContainer.restore();
            this.activity.getCartoon().setSize((float)this.scroll.getWidth() * 0.045f);
        }
        if (this.on_dialog) {
            this.activity.renderDialog(graphicsContainer, n, this.scale, this.dialog_tapped);
        }
        graphicsContainer.restore();
        this.last_time = this.time;
        this.time = this.close_page ? this.start_time - System.currentTimeMillis() : System.currentTimeMillis() - this.start_time;
        this.indraw = false;
        if (this.isdestroy) {
            this.destroy();
        }
        if (this.time < 0L) {
            if (this.exit_menu && (this.level < 119 || this.isdefeat)) {
                this.activity.startMap(this.level / 40);
            } else if (this.isdefeat) {
                this.activity.startPregame(this.level);
            } else if (this.level < 119) {
                this.activity.startPregame(this.level + 1);
            } else {
                this.activity.startVictory();
            }
            this.destroy();
        } else if (bl) {
            this.invalidate();
        } else {
            this.postInvalidateDelayed(50L);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.isdestroy || !this.loaded || !this.initialized || this.close_page) {
            return false;
        }
        int n = 0;
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        switch (motionEvent.getAction()) {
            case 1: {
                if (this.dialog_tapped) {
                    if (!this.activity.progressDialog()) {
                        this.on_dialog = false;
                    }
                    this.dialog_tapped = false;
                } else if (this.play_tapped) {
                    if (!this.isdefeat && this.level % 10 == 9) {
                        this.exit_menu = true;
                    } else {
                        this.exit_play = true;
                    }
                    this.play_tapped = false;
                    this.close_page = true;
                    this.start_time = System.currentTimeMillis() + (long)XMath.max(500.0f, 300.0f);
                } else if (this.menu_tapped) {
                    this.exit_menu = true;
                    this.menu_tapped = false;
                    this.close_page = true;
                    this.start_time = System.currentTimeMillis() + (long)XMath.max(500.0f, 300.0f);
                }
                this.swipe_active[n] = false;
                this.touch_ptr[n] = -1;
                return false;
            }
            case 2: {
                this.swipe_active[n] = false;
                if (this.on_dialog) {
                    if (motionEvent.getX() > this.activity.getCanvas().getWidth() * 4 / 10 && motionEvent.getX() < this.activity.getCanvas().getWidth() * 6 / 10 && motionEvent.getY() > this.activity.getCanvas().getHeight() * 7 / 8) {
                        this.dialog_tapped = true;
                        this.activity.playSound("standard_click");
                    }
                } else if (this.play.isLoaded() && this.play.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.play_tapped = true;
                    this.activity.playSound("standard_click");
                } else if (this.menu.isLoaded() && this.menu.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.menu_tapped = true;
                    this.activity.playSound("standard_click");
                } else {
                    this.swipe_time = this.last_time;
                    this.swipe_active[n] = true;
                    this.mousex[n] = f;
                    this.mousey[n] = f2;
                }
                return true;
            }
            case 3: {
                if (this.dialog_tapped && (motionEvent.getX() <= this.activity.getCanvas().getWidth() * 4 / 10 || motionEvent.getX() >= this.activity.getCanvas().getWidth() * 6 / 10 || motionEvent.getY() <= this.activity.getCanvas().getHeight() * 7 / 8)) {
                    this.dialog_tapped = false;
                } else if (this.play_tapped && !this.play.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.play_tapped = false;
                } else if (this.menu_tapped && !this.menu.inRange((float)motionEvent.getX() / this.scale, (float)motionEvent.getY() / this.scale)) {
                    this.menu_tapped = false;
                } else if (this.swipe_active[n]) {
                    // empty if block
                }
                return true;
            }
        }
        return true;
    }
}

