/*
 * Decompiled with CFR 0.152.
 */
package com.rocktasticgames.farmmatch.graphics;

import com.rocktasticgames.farmmatch.graphics.AssetLoader;
import com.rocktasticgames.farmmatch.graphics.BackgroundElement;
import com.rocktasticgames.farmmatch.utils.GraphicsContainer;
import com.rocktasticgames.farmmatch.utils.XMath;

public class Missile
extends BackgroundElement {
    private float vel_x;
    private float vel_y;
    private long last_time;
    private long end_time;
    private long begin_time;
    private String toggle1 = null;
    private String toggle2 = null;

    public Missile(AssetLoader assetLoader, String string, float f, float f2, float f3, float f4, float f5, long l) {
        super(assetLoader, string, f, f2, 1, 400.0f);
        float f6 = f4 - f;
        float f7 = f5 - f2;
        float f8 = XMath.sqrt(f6 * f6 + f7 * f7);
        this.vel_x = (f6 /= f8) * 8.0f * 27.083334f;
        this.vel_y = (f7 /= f8) * 8.0f * 27.083334f;
        this.z = 1.0f;
        this.last_time = l;
        this.begin_time = l;
        this.end_time = l + (long)(XMath.sqrt((f4 - f) * (f4 - f) + (f5 - f2) * (f5 - f2)) * 1000.0f / 8.0f / 27.083334f);
    }

    public boolean isDoneAnimating(long l) {
        return l > this.end_time;
    }

    public void setFrames(String string, String string2) {
        this.toggle1 = string;
        this.toggle2 = string2;
    }

    public boolean render(GraphicsContainer graphicsContainer, int n, long l) {
        if (l < this.begin_time) {
            return false;
        }
        if (this.toggle1 != null) {
            if (l / 200L % 2L == 0L) {
                super.setResource(this.toggle1);
            } else {
                super.setResource(this.toggle2);
            }
        }
        float f = (float)(l - this.last_time) / 1000.0f;
        this.x += this.vel_x * f;
        this.y += this.vel_y * f;
        this.last_time = l;
        if (!this.prepare(graphicsContainer, n, 0.0f, 0.0f)) {
            return false;
        }
        graphicsContainer.drawImage(this.bitmap, -this.bitmap.getWidth() / 2, -this.bitmap.getHeight() / 2, n);
        graphicsContainer.restore();
        return false;
    }
}

