/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class DashScrollableText {
    public static final int SCROLLBAR_WIDTH = 6;
    public int scroll_jump;
    String[] m_text;
    DashFont m_font;
    int dx;
    int dy;
    private AEERect m_subWindow;
    private int m_fillColor;
    private int m_borderColor;
    private int scrollPosition;
    private int m_viewableLines;
    private boolean m_allLinesRead;
    private boolean m_drawCellOutline;
    private int m_align;
    private int m_alignOff;
    private boolean m_vAlignCenter;
    private int m_scrollCursor = 0;

    private void init(String string, int n, DashFont dashFont) {
        this.m_vAlignCenter = false;
        this.setAlign(20);
        this.m_font = dashFont;
        this.scroll_jump = this.getLineHeight();
        this.dx = n;
        if (string != null) {
            this.setText(string);
        } else {
            this.m_text = null;
            this.dy = 0;
        }
    }

    public DashScrollableText(String string, int n, DashFont dashFont) {
        this.init(string, n, dashFont);
    }

    public DashScrollableText(AEERect aEERect, int n, int n2, DashFont dashFont) {
        this.m_subWindow = new AEERect(aEERect);
        this.init(null, aEERect.dx - 6 - 4, dashFont);
        this.m_viewableLines = this.m_subWindow.dy / this.getLineHeight();
        this.m_fillColor = n2;
        this.m_borderColor = n;
        this.m_allLinesRead = true;
        this.m_drawCellOutline = true;
    }

    public void setText(String string) {
        if (this.m_text != null) {
            this.clearText();
        }
        this.m_text = this.m_font.wrap(string, this.dx);
        if (this.m_text == null) {
            return;
        }
        this.dy = this.m_text.length * this.getLineHeight();
        this.m_allLinesRead = this.scrollPosition + this.m_viewableLines >= this.m_text.length;
    }

    public void addText(String string) {
        String[] stringArray = this.m_font.wrap(string, this.dx);
        if (this.m_text == null) {
            this.m_text = stringArray;
        } else {
            String[] stringArray2 = new String[this.m_text.length + stringArray.length];
            for (int i = 0; i < this.m_text.length; ++i) {
                stringArray2[i] = this.m_text[i];
            }
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i++] = stringArray[i];
            }
            this.m_text = stringArray2;
        }
        this.dy = this.m_text.length * this.getLineHeight();
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        if (this.m_text == null) {
            System.out.println("drawing a scrollable text without any text, bailing.");
            return;
        }
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        int n8 = n;
        int n9 = n2;
        if ((n3 & 1) != 0) {
            n8 -= this.dx >> 1;
        } else if ((n3 & 8) != 0) {
            n8 -= this.dx;
        }
        if ((n3 & 2) != 0) {
            n9 -= this.dy >> 1;
        } else if ((n3 & 0x20) != 0) {
            n9 -= this.dy;
        }
        graphics.clipRect(n8, n9, this.dx, this.dy);
        int n10 = this.getLineHeight();
        int n11 = (n5 - n2) / n10;
        int n12 = n11 + n7 / n10 + 1;
        n2 -= this.m_scrollCursor;
        if (n11 < 0) {
            n11 = 0;
        }
        if (n12 > this.m_text.length) {
            n12 = this.m_text.length;
        }
        n2 += n10 * n11;
        while (n11 < n12) {
            if (n2 + n10 >= n5 && n2 <= n5 + n7) {
                this.m_font.drawString(graphics, this.m_text[n11], n, n2, n3);
            }
            n2 += n10;
            ++n11;
        }
        graphics.setClip(n4, n5, n6, n7);
    }

    private void draw_faster(Graphics graphics, int n, int n2) {
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipWidth();
        int n6 = graphics.getClipHeight();
        int n7 = this.getLineHeight();
        int n8 = (n4 - n2) / n7;
        int n9 = n8 + n6 / n7;
        n2 -= this.m_scrollCursor;
        if (n8 < 0) {
            n8 = 0;
        }
        if (n9 > this.m_text.length) {
            n9 = this.m_text.length;
        }
        for (int i = n8; i < n9; ++i) {
            if (i == n8 || i == n9 - 1) {
                graphics.setClip(n3, n4, n5, n6);
                this.m_font.drawString(graphics, this.m_text[i], n, n2 + n7 * i, 20);
            }
            this.m_font.drawString_faster(graphics, this.m_text[i], n, n2 + n7 * i);
        }
        graphics.setClip(n3, n4, n5, n6);
    }

    public void Draw(Graphics graphics) {
        if (this.m_subWindow == null) {
            return;
        }
        int n = graphics.getColor();
        int n2 = graphics.getClipX();
        int n3 = graphics.getClipY();
        int n4 = graphics.getClipWidth();
        int n5 = graphics.getClipHeight();
        int n6 = 0;
        graphics.clipRect(this.m_subWindow.x, this.m_subWindow.y, this.m_subWindow.dx, this.m_subWindow.dy + n6);
        if (this.m_fillColor != 0xFF00FF) {
            graphics.setColor(this.m_fillColor);
            graphics.fillRect(this.m_subWindow.x, this.m_subWindow.y, this.m_subWindow.dx, this.m_subWindow.dy + n6);
        }
        int n7 = 0;
        if (this.m_vAlignCenter) {
            n7 = ((this.m_viewableLines - this.m_text.length) / 2 + 1) * this.getLineHeight();
        }
        this.draw(graphics, this.m_subWindow.x + 2 + this.m_alignOff, this.m_subWindow.y - this.scrollPosition + n6 + n7, this.m_align);
        if (this.m_borderColor != 0xFF00FF) {
            if (this.m_drawCellOutline) {
                graphics.setColor(this.m_borderColor);
                graphics.drawRect(this.m_subWindow.x, this.m_subWindow.y, this.m_subWindow.dx - 1, this.m_subWindow.dy - 1 + n6);
            }
            if (this.m_subWindow.dy < this.dy) {
                graphics.setColor(this.m_borderColor);
                graphics.drawRect(this.m_subWindow.x + this.m_subWindow.dx - 6 - 1, this.m_subWindow.y, 6, this.m_subWindow.dy + n6 - 1);
                int n8 = this.m_subWindow.dy * this.m_subWindow.dy / this.dy + n6;
                int n9 = this.scrollPosition * this.m_subWindow.dy / this.dy + this.m_subWindow.y;
                graphics.fillRect(this.m_subWindow.x + this.m_subWindow.dx - 6 - 1, n9, 6, n8);
            }
        }
        graphics.setColor(n);
        graphics.setClip(n2, n3, n4, n5);
    }

    int getHeight() {
        return this.dy;
    }

    public void HandleAction(int n) {
        if (this.m_subWindow != null) {
            if ((n & MetalGear.adGAME_KEY_UP) != 0) {
                this.scrollPosition -= this.scroll_jump;
                if (this.scrollPosition < 0) {
                    this.scrollPosition = 0;
                }
            }
            if ((n & MetalGear.adGAME_KEY_DOWN) != 0) {
                this.scrollPosition += this.scroll_jump;
                if (this.scrollPosition >= this.dy - this.m_subWindow.dy) {
                    this.scrollPosition = this.dy - this.m_subWindow.dy;
                }
                if (this.scrollPosition < 0) {
                    this.scrollPosition = 0;
                }
            }
        }
    }

    public AEERect getTextArea() {
        AEERect aEERect = new AEERect(0, 0, this.dx, this.dy);
        return aEERect;
    }

    public DashFont getFont() {
        return this.m_font;
    }

    public int getNumViewableLines() {
        return this.m_viewableLines;
    }

    public boolean isTextSet() {
        return this.m_text != null;
    }

    public void clearText() {
        this.m_allLinesRead = false;
        this.scrollPosition = 0;
        if (this.m_text != null) {
            this.m_text = null;
        }
    }

    private int getLineHeight() {
        return this.m_font.getHeight() + 2;
    }

    public void setDrawCellOutline(boolean bl) {
        this.m_drawCellOutline = bl;
    }

    public void setPos(int n, int n2) {
        this.m_subWindow.x = n;
        this.m_subWindow.y = n2;
    }

    public void resetScrollbar() {
        this.scrollPosition = 0;
    }

    public void setAlign(int n) {
        this.m_vAlignCenter = false;
        if ((n & 4) != 0) {
            this.m_alignOff = 0;
        } else if ((n & 8) != 0) {
            this.m_alignOff = this.m_subWindow.dx;
        } else if ((n & 1) != 0) {
            this.m_vAlignCenter = true;
            this.m_alignOff = this.m_subWindow.dx / 2 - 3 - 2;
        }
        this.m_align = n;
    }
}

