/*
 * Decompiled with CFR 0.152.
 */
package com.softgames.exoticninja;

import com.softgames.exoticninja.ENPlayScreen;
import com.softgames.exoticninja.ExoticNinjaMidlet;
import com.softgames.exoticninja.PointI;
import java.util.Random;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

class ENFruitImage
extends Sprite {
    int xmov;
    int ymov;
    int width;
    int outx;
    int outy;
    int randnum;
    int height;
    int originx;
    int originy;
    int linetime = 0;
    int imgnum;
    int framecount = 0;
    ExoticNinjaMidlet app;
    ENPlayScreen playScreen;
    boolean full = false;
    boolean hasline = false;
    boolean isupper = false;
    private boolean isbomb = false;
    private boolean hasjewel = false;
    float time = 0.0f;
    float totaltime;
    Image fruitImage;
    double angle = 0.0;
    double gravity = 4.5;
    double dropinterval;
    int velocity;
    int maxheight;
    int ybias = 0;
    boolean rightwards = true;
    boolean upwards = true;
    int drorigx;
    int drorigy;
    int drendx;
    int drendy;
    int cutdx;
    int cutdy;
    int cutcount = 0;
    int armor;
    PointI[] cutPoints;

    ENFruitImage(Image fruitImage, int frameWidth, int frameHeight, ENPlayScreen playScreen, boolean full) {
        super(fruitImage, frameWidth, frameHeight);
        try {
            this.fruitImage = fruitImage;
            this.playScreen = playScreen;
            this.app = playScreen.app;
            this.full = full;
            this.width = frameWidth;
            this.height = frameHeight;
            if (full) {
                int[] nArray = new int[8];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 5;
                nArray[6] = 6;
                nArray[7] = 7;
                int[] framesequence = nArray;
                this.setFrameSequence(framesequence);
            }
        }
        catch (Exception ex) {
            this.app.showMessage("error at FruitImage.init() " + ex);
        }
    }

    void setBomb(boolean isbomb) {
        this.isbomb = isbomb;
        Random numrandom = this.playScreen.globalRandom;
        int pos3 = numrandom.nextInt(1000) % 3;
        int pos5 = 3 + numrandom.nextInt(1000) % 5;
        this.randnum = !isbomb ? this.playScreen.fruit_nums[pos3] : this.playScreen.fruit_nums[pos5];
    }

    boolean isBomb() {
        return this.isbomb;
    }

    boolean hasJewel() {
        return this.hasjewel;
    }

    void setJewel(boolean hasjew) {
        this.hasjewel = hasjew;
    }

    void setArmor(int armor) {
        this.armor = armor;
    }

    int getArmor() {
        return this.armor;
    }

    void reduceArmor() {
        --this.armor;
    }

    void setMotion(int origx, int origy, double angle, int velocity) {
        try {
            this.velocity = velocity;
            this.angle = angle;
            this.originy = origy;
            this.maxheight = (int)((double)(velocity * velocity) * Math.sin(angle) * Math.sin(2.0 * angle) / (this.gravity * 2.0));
            int traveldistance = (int)((double)(velocity * velocity) * Math.sin(2.0 * angle) / this.gravity);
            this.totaltime = (float)((double)velocity / this.gravity);
            this.originy = origy;
            if (origx > this.playScreen.width / 2) {
                this.rightwards = false;
                this.originx = origx - traveldistance > this.playScreen.width - this.width * 2 ? this.playScreen.width + traveldistance - this.width * 2 : origx;
            } else {
                this.rightwards = true;
                this.originx = origx + this.width + 10 < -(traveldistance / 3) ? this.width + 10 - traveldistance / 3 : origx;
            }
            this.setPosition(this.originx, this.originy);
        }
        catch (Exception ex) {
            this.app.showMessage("Error at FruitImage.setMotion() " + ex);
        }
    }

    int getRandNum() {
        if (this.full) {
            return this.randnum;
        }
        return 0;
    }

    void setTime(float time) {
        this.time = time;
    }

    boolean isfull() {
        return this.full;
    }

    int getOutX() {
        return this.getX() + this.width;
    }

    int getOutY() {
        return this.getY() + this.height - this.ybias;
    }

    void doMove() {
        try {
            if (this.hasline && this.linetime >= 0 && this.linetime < 5) {
                this.nextFrame();
                ++this.linetime;
                if (this.linetime >= 5) {
                    this.hasline = false;
                }
                return;
            }
            if (!this.full) {
                if (this.getY() - this.ybias < this.playScreen.getHeight()) {
                    this.doDrop();
                } else {
                    this.playScreen.fruitList.removeElement((Object)this);
                }
                return;
            }
            this.xmov = (int)((double)((float)this.velocity * this.time) * Math.cos(this.angle));
            this.ymov = (int)((double)((float)this.velocity * this.time) * Math.sin(this.angle) - this.gravity * 0.5 * (double)this.time * (double)this.time);
            int curposy = this.originy - (this.ymov + this.ybias);
            if (curposy > this.playScreen.getHeight()) {
                if (!this.isbomb) {
                    this.playScreen.loseFruit(this);
                } else {
                    this.playScreen.fruitList.removeElement((Object)this);
                }
                return;
            }
            if (!this.rightwards && this.originx - this.xmov <= -5) {
                this.doBounce();
                return;
            }
            if (this.rightwards && this.originx + this.xmov >= this.playScreen.width - this.getWidth()) {
                System.out.println(String.valueOf(this.originx) + " reached right end of screen " + this.xmov + "  " + (this.playScreen.getWidth() - 5) + "  width " + this.getWidth());
                this.doBounce();
                return;
            }
            if (this.rightwards) {
                this.setPosition(this.originx + this.xmov, this.originy - (this.ymov + this.ybias));
            } else {
                this.setPosition(this.originx - this.xmov, this.originy - (this.ymov + this.ybias));
            }
            this.time = (float)((double)this.time + this.playScreen.fruit_fly_interval);
            if (this.framecount == 2) {
                this.nextFrame();
                this.framecount = 0;
            } else {
                ++this.framecount;
            }
        }
        catch (Exception ex) {
            this.app.showMessage("Error at FMNFruitImage.doMove()");
        }
    }

    void doBounce() {
        if (this.rightwards) {
            this.rightwards = false;
            this.originx = this.playScreen.width - this.getWidth() + this.xmov;
            System.out.println(String.valueOf(this.originx) + " AFTER BOUNCE " + this.xmov + "  " + (this.playScreen.getWidth() - 5) + "  width " + this.getWidth());
            System.out.println(String.valueOf(this.originx) + " AFTER MOVE " + this.xmov + "  " + (this.playScreen.getWidth() - 5) + "  width " + this.getWidth() + "\n\n");
            this.playScreen.repaint();
            return;
        }
        if (!this.rightwards) {
            this.rightwards = true;
            this.originx = 0 - this.originx;
            this.playScreen.repaint();
            return;
        }
    }

    void doDrop() {
        this.time = (float)((double)this.time + this.dropinterval);
        this.ymov = (int)(0.5 * this.gravity * (double)this.time * (double)this.time);
        this.setPosition(this.originx, this.originy + this.ymov);
        if (this.framecount == 2) {
            this.nextFrame();
            this.framecount = 0;
        } else {
            ++this.framecount;
        }
    }

    void initposition() {
        this.setPosition(this.originx, this.originy);
    }

    ENFruitImage[] splitFruit() throws Exception {
        int[] framesequence1 = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
        int[] framesequence2 = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
        ENFruitImage[] splits = new ENFruitImage[2];
        try {
            splits[0] = new ENFruitImage(this.fruitImage, this.width, this.height, this.playScreen, false);
            splits[1] = new ENFruitImage(this.fruitImage, this.width, this.height, this.playScreen, false);
            splits[0].setTime(0.0f);
            splits[0].setFrameSequence(framesequence1);
            splits[0].hasline = true;
            splits[0].isupper = true;
            splits[0].originx = this.getX() - 20;
            splits[0].originy = this.getY();
            splits[0].initposition();
            splits[0].cutPoints = this.playScreen.cutPoints;
            splits[0].dropinterval = 0.6;
            splits[1].originx = this.getX() + 15;
            splits[1].originy = this.getY();
            splits[1].initposition();
            splits[1].setTime(0.0f);
            splits[1].setFrameSequence(framesequence2);
            splits[1].hasline = true;
            splits[1].dropinterval = 0.45;
        }
        catch (Exception ex) {
            this.app.showMessage("Error at FruitImage.split() " + ex);
        }
        return splits;
    }
}

