/*
 * Decompiled with CFR 0.152.
 */
package com.softgames.exoticninja;

import com.kiwavi.mobileutils.MobileUtils;
import com.softgames.exoticninja.ExoticNinjaMidlet;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

class ENMainMenu
extends GameCanvas {
    ExoticNinjaMidlet app;
    Image img_mbar;
    int width;
    int height;
    int mbarh;
    int mbarw;
    int mbarx;
    int mbary;
    int menu_y;
    int menu_vspace = 7;
    int selectedItem = 0;
    int totalMenuHeight;
    int splashWidth;
    int splashHeight;
    int osh;
    int osw;
    int[] button_diffs;
    boolean selecting = false;
    String[] txtMenuItems;
    Image img_background;

    ENMainMenu(ExoticNinjaMidlet app) {
        super(false);
        this.setFullScreenMode(true);
        this.app = app;
        this.txtMenuItems = app.gameText.getMenuItems(app.getLanguage());
        this.button_diffs = new int[this.txtMenuItems.length];
        this.img_background = app.imggeneralbg;
        try {
            this.width = app.app_width;
            this.height = app.app_height;
            this.img_mbar = MobileUtils.getImage("/menue_button.png");
            this.mbarh = this.img_mbar.getHeight();
            this.mbarw = this.img_mbar.getWidth();
        }
        catch (Exception ex) {
            app.showMessage("Error at ENMainMenu.init() " + ex);
        }
        catch (OutOfMemoryError omex) {
            app.showMessage("Out of memory Error at ENMainMenu.init() " + omex);
        }
        this.redimension();
    }

    void redimension() {
        int trq = this.height * 65 / 100;
        int rawmenuheight = this.mbarh * this.button_diffs.length;
        int pvspace = (trq - rawmenuheight) / (this.button_diffs.length - 1);
        this.menu_vspace = Math.max(this.menu_vspace, pvspace);
        this.totalMenuHeight = this.mbarh * this.button_diffs.length + (this.button_diffs.length - 1) * this.menu_vspace;
        this.menu_y = (this.height - this.totalMenuHeight) / 2;
        this.mbarx = (this.width - this.mbarw) / 2;
        int i = 0;
        while (i < this.button_diffs.length) {
            this.button_diffs[i] = this.menu_y + this.mbarh * i + this.menu_vspace * i;
            ++i;
        }
        this.repaint();
    }

    public void keyPressed(int keycode) {
        int gameAction = this.getGameAction(keycode);
        if (gameAction == 1 && this.selectedItem > 0) {
            --this.selectedItem;
            this.repaint();
            return;
        }
        if (gameAction == 6 && this.selectedItem < this.txtMenuItems.length - 1) {
            ++this.selectedItem;
            this.repaint();
            return;
        }
        if (gameAction == 8) {
            this.goSelection(this.selectedItem);
            return;
        }
    }

    void goSelection(int selnum) {
        try {
            if (selnum == 0) {
                this.app.gotoShopScreen();
                return;
            }
            if (selnum == 1) {
                this.app.gotoLanguageMenu();
                return;
            }
            if (selnum == 2) {
                this.app.gotoTutorialScreen();
                return;
            }
            if (selnum == 3) {
                this.app.gotoAboutScreen();
                return;
            }
            if (selnum == 4) {
                this.app.destroyApp(true);
                return;
            }
        }
        catch (Exception ex) {
            this.app.showMessage(" SELNUM " + selnum + "  Error at MainMenu.goSelection() " + ex);
        }
    }

    void pauseAndSelect() {
        this.selecting = true;
        try {
            this.goSelection(this.selectedItem);
            this.selecting = false;
        }
        catch (Exception ex) {
            this.app.showMessage("Error at MainMenu.pauseAndSelect() " + ex);
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.selecting) {
            return;
        }
        this.selectedItem = -1;
        int i = 0;
        while (i < this.button_diffs.length) {
            if (y >= this.button_diffs[i] && y <= this.button_diffs[i] + this.mbarh && x >= this.mbarx && x <= this.mbarx + this.mbarw) {
                this.selectedItem = i;
            }
            ++i;
        }
        if (this.selectedItem == -1) {
            this.selectedItem = 0;
            return;
        }
        this.pauseAndSelect();
        this.repaint();
        this.pauseAndSelect();
    }

    public void sizeChanged(int w, int h) {
        this.width = w;
        this.height = h;
        try {
            this.splashWidth = w;
            this.splashHeight = h;
            this.img_background = MobileUtils.resizeImage(this.img_background, this.width, this.height);
        }
        catch (Exception ex) {
            System.out.println("Error when size is changed .." + ex);
        }
        this.redimension();
    }

    public void paint(Graphics g) {
        if (this.height < this.app.app_height) {
            this.sizeChanged(this.getWidth(), this.getHeight());
            return;
        }
        g.drawImage(this.img_background, 0, 0, 20);
        g.setFont(this.app.gameAssets.controlFont);
        int textd = (this.mbarh - this.app.gameAssets.controlFont.getHeight()) / 2;
        int i = 0;
        while (i < this.txtMenuItems.length) {
            g.drawImage(this.img_mbar, this.mbarx, this.button_diffs[i], 20);
            if (i == this.selectedItem) {
                g.setColor(this.app.gameAssets.menu_hl_color);
                g.drawString(this.txtMenuItems[i], this.width / 2, this.button_diffs[i] + textd, 17);
            } else {
                g.setColor(this.app.gameAssets.menu_normal_color);
                g.drawString(this.txtMenuItems[i], this.width / 2, this.button_diffs[i] + textd, 17);
            }
            ++i;
        }
    }
}

