/*
 * Decompiled with CFR 0.152.
 */
package com.softgames.exoticninja;

import com.kiwavi.mobileutils.MobileUtils;
import com.kiwavi.mobileutils.StringTokenizer;
import com.softgames.exoticninja.ENGameText;
import com.softgames.exoticninja.ExoticNinjaMidlet;
import java.util.Vector;

class ENShopCatalogue {
    String[] shop_catalogue = new String[]{"More Gold;250 Gold;JEWEL;15;NONE;Gives Player 250 more Gold;coinl1", "More Gold;500 Gold;JEWEL;28;NONE;Gives Player 500 more Gold;coinl2", "More Gold;1500 Gold;JEWEL;80;NONE;Gives Player 1500 more Gold;coinl3", "More Gold;5000 Gold;JEWEL;180;NONE;Gives Player 5000 more Gold;coinl4", "More Jewels;10 Jewels;EURO;0.99;NONE;Gives Player 10 more Jewels;jewell1", "More Jewels;50 Jewels;EURO;3.99;NONE;Gives Player 50 more Jewels;jewell2", "More Jewels;120 Jewels;EURO;9.99;NONE;Gives Player 120 more Jewels;jewell3", "More Jewels;300 Jewels;EURO;24.99;NONE;Gives Player 300 more Jewels;jewell4", "More Lifes;Lifes Level 2;GOLD;75;NONE;Gives Player +1 Life ,so 4 lifes in total;umbrellal1", "More Lifes;Lifes Level 3;GOLD;250;Lifes Level 2;Gives Player +1 Life ,so 5 lifes in total;umbrellal2", "More Specials;More money level 1;GOLD;65;NONE;Gives Player 5% more money;star", "More Specials;More money level 2;GOLD;120;NONE;Gives Player 10% more money;star", "More Specials;More money level 3;JEWEL;5;More money level 1;Gives Player 15% more money;star", "More Specials;More money level 4;JEWEL;15;More money level 2;Gives Player 25% more money;star", "More Specials;More jewels level 1;GOLD;350;NONE; Player has 1,5% chance to find jewels;star", "More Specials;More jewels level 2;JEWEL;15;More jewels level 1;Player has 3,0% chance to find jewels;star", "More Specials;More jewels level 3;JEWEL;35;More jewels level 2; Player has 5,0% chance to find jewels;star", "More Slices;Sword Level 1;GOLD;90;NONE;Increases Sword level attack +1;swordl1", "More Slices;Sword Level 2;GOLD;250;Sword Level 1;Increases Sword level attack +2;swordl2", "More Slices;Sword Level 3;GOLD;500;Sword Level 2;Increases Sword level attack +3;swordl3", "More Slices;Sword Level 4;JEWEL;15;Sword Level 3;Increases Sword level attack +4;swordl4", "More Slices;Sword Level 5;JEWEL;30;Sword Level 4;Increases Sword level attack +5 (also cuts through bombs without loosing game,but loosing -1 life);swordl5"};
    ExoticNinjaMidlet app;
    String[] shop_categories = new String[4];
    Vector allItems = new Vector();
    String[] shop_texts;

    ENShopCatalogue(ExoticNinjaMidlet app) {
        this.app = app;
        this.shop_texts = app.gameText.getShopText(app.GAME_LANGUAGE);
        this.shop_categories[0] = this.shop_texts[ENGameText.SHP_MOGLD];
        this.shop_categories[1] = this.shop_texts[ENGameText.SHP_MOSPCL];
        this.shop_categories[2] = this.shop_texts[ENGameText.SHP_MOLIFE];
        this.shop_categories[3] = this.shop_texts[ENGameText.SHP_MOSLC];
        if (app.GAME_LANGUAGE.equals("DEU")) {
            this.shop_catalogue = app.gameText.shop_catalogue_deu;
        }
        if (app.GAME_LANGUAGE.equals("FRA")) {
            this.shop_catalogue = app.gameText.shop_catalogue_fra;
        }
        if (app.GAME_LANGUAGE.equals("ESP")) {
            this.shop_catalogue = app.gameText.shop_catalogue_esp;
        }
        if (app.GAME_LANGUAGE.equals("ENG")) {
            this.shop_catalogue = app.gameText.shop_catalogue_eng;
        }
        if (app.GAME_LANGUAGE.equals("RUS")) {
            this.shop_catalogue = app.gameText.shop_catalogue_rus;
        }
        if (app.GAME_LANGUAGE.equals("POL")) {
            this.shop_catalogue = app.gameText.shop_catalogue_pol;
        }
        this.processItems();
        System.out.println("Catalogue Dimensions are ENDOFARRy" + ENGameText.CAT_SWRD5 + " ALLI SIZE " + this.allItems.size() + " CATAL LEN " + this.shop_catalogue.length);
    }

    Vector getShopItems(String category) {
        Vector<ShopItem> vctShopItems = new Vector<ShopItem>();
        int i = 0;
        while (i < this.allItems.size()) {
            ShopItem shopItem = (ShopItem)this.allItems.elementAt(i);
            if (shopItem.category.equalsIgnoreCase(category)) {
                vctShopItems.addElement(shopItem);
            }
            ++i;
        }
        return vctShopItems;
    }

    void processItems() {
        try {
            int i = 0;
            while (i < this.shop_catalogue.length) {
                StringTokenizer strItem = new StringTokenizer(this.shop_catalogue[i], ";");
                ShopItem shopItem = new ShopItem();
                if (strItem.hasMoreTokens()) {
                    shopItem.category = strItem.nextToken().trim();
                }
                if (strItem.hasMoreTokens()) {
                    shopItem.name = strItem.nextToken().trim();
                }
                if (strItem.hasMoreTokens()) {
                    shopItem.currency = strItem.nextToken().trim();
                }
                if (strItem.hasMoreTokens()) {
                    shopItem.price = strItem.nextToken().trim();
                }
                if (strItem.hasMoreTokens()) {
                    shopItem.prereq = strItem.nextToken().trim();
                }
                if (strItem.hasMoreTokens()) {
                    shopItem.descr = strItem.nextToken().trim();
                }
                if (strItem.hasMoreTokens()) {
                    shopItem.icon = strItem.nextToken().trim();
                }
                this.allItems.addElement(shopItem);
                ++i;
            }
        }
        catch (Exception ex) {
            System.out.println("Error at Catalog .processItems() " + ex);
        }
    }

    String buyItem(ShopItem item) {
        String buy_result = this.shop_texts[ENGameText.SHP_NOPURCHASE];
        String purchase_prereq_no = MobileUtils.stringReplace(this.shop_texts[ENGameText.SHP_NOPREREQ], "$xx$", item.prereq);
        String success_purchase = MobileUtils.stringReplace(this.shop_texts[ENGameText.SHP_PURCHASEOK], "$xx$", item.name);
        System.out.println("The strings are " + purchase_prereq_no + " \n " + success_purchase);
        System.out.println("Item name is " + item.name);
        int iprice = MobileUtils.getNumberValue(item.price);
        if (item.currency.equals("JEWEL") && this.app.cumjewel >= iprice) {
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_250GOLD))) {
                return buy_result;
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_500GOLD))) {
                return buy_result;
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_1500GOLD))) {
                return buy_result;
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_5000GOLD))) {
                return buy_result;
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_MNY3))) {
                return buy_result;
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_MNY4))) {
                return buy_result;
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_SWRD4))) {
                if (this.app.sword_cut_level >= 4) {
                    return buy_result;
                }
                if (this.app.sword_cut_level < 3) {
                    return purchase_prereq_no;
                }
                this.app.sword_cut_level = 4;
                this.app.hdbSettings.set("SWORD_LEVEL", "4");
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_SWRD5))) {
                if (this.app.sword_cut_level >= 5) {
                    return buy_result;
                }
                if (this.app.sword_cut_level < 4) {
                    return purchase_prereq_no;
                }
                this.app.sword_cut_level = 5;
                this.app.hdbSettings.set("SWORD_LEVEL", "5");
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_JWLP2))) {
                if (this.app.jewels_level > 1.5) {
                    return buy_result;
                }
                if (this.app.jewels_level != 1.5) {
                    return purchase_prereq_no;
                }
                this.app.jewels_level = 3.0;
                this.app.hdbSettings.set("JEWELS_LEVEL", "3.0");
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_JWLP3))) {
                if (this.app.jewels_level > 3.0) {
                    return buy_result;
                }
                if (this.app.jewels_level != 3.0) {
                    return purchase_prereq_no;
                }
                this.app.jewels_level = 5.0;
                this.app.hdbSettings.set("JEWELS_LEVEL", "5.0");
            }
            this.app.cumjewel -= iprice;
            this.app.hdbSettings.set("CUM_JEWEL", "" + this.app.cumjewel);
            this.app.hdbSettings.persistData();
            return "OK:" + success_purchase;
        }
        if (item.currency.equals("GOLD") && this.app.cumgold >= iprice) {
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_MNY1))) {
                return buy_result;
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_MNY2))) {
                return buy_result;
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_LIFE2))) {
                if (this.app.game_lives >= 4) {
                    return buy_result;
                }
                this.app.game_lives = 4;
                this.app.hdbSettings.set("GAME_LIVES", "" + this.app.game_lives);
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_LIFE3))) {
                if (this.app.game_lives < 4) {
                    return purchase_prereq_no;
                }
                if (this.app.game_lives != 4) {
                    return buy_result;
                }
                this.app.game_lives = 5;
                this.app.hdbSettings.set("GAME_LIVES", "" + this.app.game_lives);
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_SWRD1))) {
                if (this.app.sword_cut_level >= 1) {
                    return buy_result;
                }
                this.app.sword_cut_level = 1;
                this.app.hdbSettings.set("SWORD_LEVEL", "1");
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_SWRD2))) {
                if (this.app.sword_cut_level != 1) {
                    return purchase_prereq_no;
                }
                this.app.sword_cut_level = 2;
                this.app.hdbSettings.set("SWORD_LEVEL", "2");
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_SWRD3))) {
                if (this.app.sword_cut_level != 2) {
                    return purchase_prereq_no;
                }
                this.app.sword_cut_level = 3;
                this.app.hdbSettings.set("SWORD_LEVEL", "3");
            }
            if (item.name.equalsIgnoreCase("" + this.allItems.elementAt(ENGameText.CAT_JWLP1))) {
                if (this.app.jewels_level != 1.0) {
                    return buy_result;
                }
                this.app.jewels_level = 1.5;
                this.app.hdbSettings.set("JEWELS_LEVEL", "" + this.app.jewels_level);
            }
            this.app.cumgold -= iprice;
            this.app.hdbSettings.set("CUM_GOLD", "" + this.app.cumgold);
            this.app.hdbSettings.persistData();
            return "OK:" + success_purchase;
        }
        if (item.currency.equals("GOLD") && iprice > this.app.cumgold) {
            return "LESS_CURRENCY";
        }
        if (item.currency.equals("JEWEL") && iprice > this.app.cumjewel) {
            return "LESS_CURRENCY";
        }
        if (item.currency.equals("EURO")) {
            return buy_result;
        }
        return buy_result;
    }

    ShopItem getShopItem(String itemName) {
        int i = 0;
        while (i < this.allItems.size()) {
            ++i;
        }
        return null;
    }

    class ShopItem {
        String category = "";
        String name = "";
        String currency = "";
        String price = "";
        String prereq = "";
        String descr = "";
        String icon = "";

        ShopItem() {
        }
    }
}

