/*
 * Decompiled with CFR 0.152.
 */
package com.softgames.exoticninja;

import com.kiwavi.mobileutils.MobileUtils;
import com.softgames.exoticninja.ExoticNinjaMidlet;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

class ENLanguageMenu
extends GameCanvas {
    ExoticNinjaMidlet app;
    int width;
    int height;
    int menu_x;
    int menu_y;
    int menu_vspace = 7;
    int selectedItem = 0;
    int totalMenuHeight;
    int mbarw;
    int mbarx;
    int mbary;
    int mbarh;
    int splashWidth;
    int splashHeight;
    int osh;
    int osw;
    int[] menu_posy;
    String[] languages = new String[]{"ENG", "POL", "DEU", "RUS", "FRA", "ESP"};
    String[] txtLanguages;
    Image img_background;
    Image img_mbar;

    ENLanguageMenu(ExoticNinjaMidlet app) {
        super(false);
        this.setFullScreenMode(true);
        try {
            this.app = app;
            this.img_background = app.imggeneralbg;
            this.img_mbar = MobileUtils.getImage("/menue_button.png");
            this.menu_posy = new int[this.languages.length];
            this.mbarh = this.img_mbar.getHeight();
            this.mbarw = this.img_mbar.getWidth();
            this.txtLanguages = app.gameText.getLanguageList(app.getLanguage());
        }
        catch (Exception ex) {
            System.out.println("Error at ENLanguageMenu.init() " + ex);
        }
        this.sizeChanged(app.app_width, app.app_height);
    }

    public void sizeChanged(int w, int h) {
        this.width = w;
        this.height = h;
        this.splashWidth = w;
        this.splashHeight = h;
        this.img_background = MobileUtils.resizeImage(this.img_background, this.width, this.height);
        this.redimension();
    }

    void redimension() {
        try {
            int trq = this.height * 65 / 100;
            int rawmenuheight = this.mbarh * this.menu_posy.length;
            int pvspace = (trq - rawmenuheight) / (this.menu_posy.length - 1);
            this.menu_vspace = Math.max(this.menu_vspace, pvspace);
            this.totalMenuHeight = this.mbarh * this.menu_posy.length + (this.menu_posy.length - 1) * this.menu_vspace;
            this.menu_y = (this.height - this.totalMenuHeight) / 2;
            this.mbarx = (this.width - this.mbarw) / 2;
            int i = 0;
            while (i < this.menu_posy.length) {
                this.menu_posy[i] = this.menu_y + this.mbarh * i + this.menu_vspace * i;
                ++i;
            }
            this.repaint();
        }
        catch (Exception ex) {
            System.out.println("Error at ENLanguageMenu.redimension() " + ex);
        }
        this.repaint();
    }

    public void keyPressed(int keycode) {
        this.redimension();
        int gameAction = this.getGameAction(keycode);
        if (gameAction == 1 && this.selectedItem > 0) {
            --this.selectedItem;
            this.repaint();
            return;
        }
        if (gameAction == 6 && this.selectedItem < this.txtLanguages.length - 1) {
            ++this.selectedItem;
            this.repaint();
            return;
        }
        if (gameAction == 8) {
            this.app.setLanguage(this.languages[this.selectedItem]);
            if (this.app.firsttime) {
                this.app.gotoTutorialScreen();
                this.app.firsttime = false;
                return;
            }
            this.app.gotoMainMenu();
            return;
        }
    }

    public void pointerPressed(int x, int y) {
        int cursel = this.selectedItem;
        this.selectedItem = -1;
        int mbarx = (this.width - this.mbarw) / 2;
        int i = 0;
        while (i < this.menu_posy.length) {
            if (y >= this.menu_posy[i] && y < this.menu_posy[i] + this.mbarh && x > mbarx && x <= this.width - mbarx) {
                this.selectedItem = i;
            }
            ++i;
        }
        if (this.selectedItem == -1) {
            this.selectedItem = cursel;
            this.repaint();
            return;
        }
        this.pauseAndSelect();
    }

    synchronized void pauseAndSelect() {
        this.repaint();
        try {
            this.repaint();
            Thread.sleep(600L);
            this.app.setLanguage(this.languages[this.selectedItem]);
            if (this.app.firsttime) {
                this.app.gotoTutorialScreen();
            } else {
                this.app.gotoMainMenu();
            }
        }
        catch (Exception ex) {
            this.app.showMessage("Error at LanguageMenu.pauseAndSelect() " + ex);
        }
    }

    public void paint(Graphics g) {
        if (this.height < this.app.app_height) {
            this.sizeChanged(this.getWidth(), this.getHeight());
            return;
        }
        g.drawImage(this.img_background, 0, 0, 20);
        g.setFont(this.app.gameAssets.controlFont);
        int textd = (this.mbarh - this.app.gameAssets.controlFont.getHeight()) / 2;
        int i = 0;
        while (i < this.txtLanguages.length) {
            g.drawImage(this.img_mbar, this.mbarx, this.menu_posy[i], 20);
            if (this.selectedItem == i) {
                g.setColor(this.app.gameAssets.menu_hl_color);
                g.drawString(this.txtLanguages[i], this.width / 2, this.menu_posy[i] + textd, 17);
            } else {
                g.setColor(this.app.gameAssets.menu_normal_color);
                g.drawString(this.txtLanguages[i], this.width / 2, this.menu_posy[i] + textd, 17);
            }
            ++i;
        }
    }
}

