/*
 * Decompiled with CFR 0.152.
 */
package com.softgames.exoticninja;

import com.kiwavi.mobileutils.MobileUtils;
import com.softgames.exoticninja.ENGameText;
import com.softgames.exoticninja.ENShopCatalogue;
import com.softgames.exoticninja.ENShopConfirmContext;
import com.softgames.exoticninja.ENShopContext;
import com.softgames.exoticninja.ENShopScreen;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class ENShopListContext
implements ENShopContext {
    ENShopScreen shop;
    Image[] img_icons;
    Image img_buybutton;
    Image coin;
    Image jewel;
    Image img_board;
    Image img_arrowup;
    Image img_arrowdown;
    int btnbyw;
    int boardw;
    int boardh;
    int boardx;
    int boardy;
    int arux;
    int aruy;
    int aruw;
    int aruh;
    int ardx;
    int ardy;
    int ardh;
    int ardw;
    int goldScoreX;
    int goldScoreY;
    int jewelScoreX;
    int jewelScoreY;
    int totalmenuheight;
    int[] menu_posy;
    int selectedoption;
    int longest_text;
    int first_item = 0;
    int vspace = 10;
    int maxmenu = 0;
    int menuhl;
    String txtPrice = "PRICE";
    String[] shop_texts;
    boolean ready;
    String item_type;
    Vector shopItems;

    ENShopListContext(String itemType, Vector shopItms) {
        this.shopItems = shopItms;
        this.item_type = itemType;
        this.ready = false;
    }

    public void init(ENShopScreen shp) {
        this.shop = shp;
        try {
            this.shop_texts = shp.app.gameText.getShopText(shp.app.GAME_LANGUAGE);
            this.txtPrice = String.valueOf(this.shop_texts[ENGameText.SHP_PRICE]) + "   ";
            this.menu_posy = new int[this.shopItems.size()];
            this.img_icons = new Image[this.shopItems.size()];
            this.img_buybutton = MobileUtils.getImage("/buy_button.png");
            this.img_board = MobileUtils.getImage("/board_color.png");
            this.boardh = this.img_board.getHeight();
            this.boardw = this.img_board.getWidth();
            this.img_arrowup = MobileUtils.getImage("/arrow_up.png");
            this.img_arrowdown = MobileUtils.getImage("/arrow_down.png");
            this.aruw = this.img_arrowup.getWidth();
            this.aruh = this.img_arrowup.getHeight();
            this.ardw = this.img_arrowdown.getWidth();
            this.ardh = this.img_arrowdown.getHeight();
            int i = 0;
            while (i < this.shopItems.size()) {
                ENShopCatalogue.ShopItem shopItem = (ENShopCatalogue.ShopItem)this.shopItems.elementAt(i);
                this.img_icons[i] = MobileUtils.getImage("/" + shopItem.icon + ".png");
                ++i;
            }
            this.coin = MobileUtils.getImage("/coin_small.png");
            this.jewel = MobileUtils.getImage("/jewel_small.png");
        }
        catch (Exception ex) {
            this.shop.app.showMessage("Error at ENShopListContext.init() " + ex);
        }
    }

    public void resize(int w, int h) {
        try {
            this.maxmenu = Math.min(this.shopItems.size(), (this.shop.height - (this.shop.shopTitleHeight + 10 + this.shop.borderh)) / (this.boardh + this.vspace));
            this.menu_posy = new int[this.maxmenu];
            int i = 0;
            while (i < this.maxmenu) {
                this.menu_posy[i] = 5 + this.shop.shopTopHeight + i * this.boardh + i * this.vspace;
                ++i;
            }
            this.longest_text = Math.max(this.longest_text, this.shop.width * 9 / 10);
            this.boardx = (this.shop.width - this.boardw) / 2;
            this.ardx = this.arux = w - (this.aruw + 6);
            this.aruy = 5 + this.shop.shopTopHeight - (this.aruh + 5);
            this.ardy = h - this.shop.img_border.getHeight() - (this.ardh + 5);
        }
        catch (Exception ex) {
            this.shop.app.showMessage("Error at ShopListContext.resize() " + ex);
        }
        this.ready = true;
        this.shop.repaint();
    }

    public void keyPressed(int gameAction) {
        if (gameAction == 1 && this.selectedoption == 1) {
            --this.selectedoption;
            System.out.println("GOING UP seo=1 FI " + this.first_item + " SO " + this.selectedoption + " MAXM " + this.maxmenu + "  " + this.menuhl);
            this.shop.repaint();
            return;
        }
        if (gameAction == 1 && this.selectedoption > this.shopItems.size()) {
            --this.selectedoption;
            System.out.println("GOING UP gtl FI " + this.first_item + " SO " + this.selectedoption + " MAXM " + this.maxmenu + "  " + this.menuhl);
            this.shop.repaint();
            return;
        }
        if (gameAction == 1 && this.selectedoption <= this.shopItems.size() && this.selectedoption != 0) {
            --this.selectedoption;
            if (this.first_item >= 1 && this.menuhl == 0) {
                --this.first_item;
            }
            if (this.menuhl - 1 >= 0) {
                --this.menuhl;
            }
            System.out.println("GOING UP letl FI " + this.first_item + " SO " + this.selectedoption + " MAXM " + this.maxmenu + "  " + this.menuhl);
            this.shop.repaint();
            return;
        }
        if (gameAction == 6 && this.selectedoption < this.shopItems.size()) {
            ++this.selectedoption;
            if (this.selectedoption > this.maxmenu && this.first_item + this.maxmenu < this.shopItems.size()) {
                ++this.first_item;
            }
            if (this.menuhl + 1 < this.maxmenu && this.selectedoption > 1) {
                ++this.menuhl;
            }
            System.out.println("GOING DOWN ltl FI " + this.first_item + " SO " + this.selectedoption + " MAXM " + this.maxmenu + "  " + this.menuhl);
            this.shop.repaint();
            return;
        }
        if (gameAction == 8) {
            this.goSelectedOption();
        }
    }

    void goSelectedOption() {
        System.out.println("The option is " + this.selectedoption);
        if (this.selectedoption == 0) {
            this.shop.setContext("HOME");
            return;
        }
        if (this.selectedoption > 0) {
            int o = this.selectedoption - 1;
            Image img_curr = null;
            ENShopCatalogue.ShopItem shopItem = (ENShopCatalogue.ShopItem)this.shopItems.elementAt(o);
            img_curr = shopItem.currency.equalsIgnoreCase("JEWEL") ? this.jewel : this.coin;
            this.shop.shopConfirmContext = new ENShopConfirmContext(shopItem, img_curr, this.img_icons[o]);
            this.shop.setContext("SHOP CONFIRM");
            return;
        }
    }

    public void backButton() {
        this.shop.setContext("HOME");
    }

    public void touch(int xpos, int ypos) {
        try {
            if (xpos > this.arux && xpos < this.arux + this.aruw && ypos > this.aruy && ypos < this.aruy + this.aruh && this.first_item > 0) {
                --this.first_item;
                this.shop.repaint();
                return;
            }
            if (xpos > this.ardx && xpos < this.ardx + this.ardw && ypos > this.ardy && ypos < this.ardy + this.ardh && this.first_item + this.maxmenu < this.shopItems.size()) {
                ++this.first_item;
                this.shop.repaint();
                return;
            }
            if (xpos > this.shop.bkbtnx && xpos < this.shop.bkbtnx + this.shop.bkbtnw && ypos > this.shop.bkbtny && ypos < this.shop.bkbtny + this.shop.bkbtnh) {
                this.shop.setContext("HOME");
            }
            int i = 0;
            while (i < this.menu_posy.length) {
                if (xpos > this.boardx && xpos < this.boardx + this.longest_text && ypos > this.menu_posy[i] && ypos < this.menu_posy[i] + this.boardh) {
                    this.selectedoption = i + 1 + this.first_item;
                    this.goSelectedOption();
                    return;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            this.shop.app.showMessage("Error at ENShopListScreen.onTouch() " + ex);
        }
    }

    public void paint(Graphics g) {
        if (!this.ready) {
            return;
        }
        try {
            System.out.println("up to here 1");
            g.setColor(this.shop.app.hlcolor);
            if (this.selectedoption == 0) {
                g.fillRoundRect(this.shop.bkbtnx - 2, this.shop.bkbtny - 2, this.shop.bkbtnw + 4, this.shop.bkbtnh + 4, 6, 6);
            }
            if (this.selectedoption <= this.shopItems.size() && this.selectedoption >= 1) {
                g.fillRoundRect(this.boardx - 2, this.menu_posy[this.menuhl] - 2, this.boardw + 4, this.boardh + 4, 8, 8);
            }
            int i = 0;
            while (i < this.maxmenu) {
                g.drawImage(this.img_board, this.boardx, this.menu_posy[i], 20);
                ++i;
            }
            System.out.println("up to here 2 " + this.maxmenu);
            i = 0;
            while (i < this.maxmenu) {
                ENShopCatalogue.ShopItem shopItem = (ENShopCatalogue.ShopItem)this.shopItems.elementAt(i + this.first_item);
                g.drawImage(this.img_icons[i + this.first_item], this.boardx + 4, this.menu_posy[i] + 2, 20);
                g.drawImage(this.img_buybutton, this.shop.width - (this.boardx + this.img_buybutton.getWidth() + 3), this.menu_posy[i] + 4, 20);
                g.setFont(this.shop.smallFont);
                g.setColor(0xFFFFFF);
                int drawlen = this.shop.width - (this.boardx + this.img_buybutton.getWidth() + 3) - (this.boardx + this.img_icons[i + this.first_item].getWidth() + 5);
                g.drawString(MobileUtils.getShortString(shopItem.name, this.shop.smallFont, drawlen), this.boardx + this.img_icons[i + this.first_item].getWidth() + 5, this.menu_posy[i] + this.boardh / 2 - (this.shop.smallFont.getSize() + 6), 20);
                int textx = this.boardx + this.img_icons[i + this.first_item].getWidth() + 3;
                g.drawString(this.txtPrice, textx, this.menu_posy[i] + this.boardh / 2 + 4, 20);
                textx += this.shop.smallFont.stringWidth(this.txtPrice);
                if (shopItem.currency.equalsIgnoreCase("GOLD")) {
                    g.drawImage(this.coin, textx, this.menu_posy[i] + this.boardh / 2 + 4, 20);
                    textx += this.coin.getWidth() + 3;
                }
                if (shopItem.currency.equalsIgnoreCase("JEWEL")) {
                    g.drawImage(this.jewel, textx, this.menu_posy[i] + this.boardh / 2 + 4, 20);
                    textx += this.jewel.getWidth() + 3;
                }
                g.drawString(shopItem.price, textx, this.menu_posy[i] + this.boardh / 2 + 4, 20);
                ++i;
            }
            System.out.println("up to here 3");
            if (this.first_item > 0) {
                g.drawImage(this.img_arrowup, this.arux, this.aruy, 20);
            }
            if (this.first_item + this.maxmenu < this.img_icons.length) {
                g.drawImage(this.img_arrowdown, this.ardx, this.ardy, 20);
            }
        }
        catch (Exception ex) {
            this.shop.app.showMessage("Error at ShopListContext.paint() " + ex);
        }
    }
}

