/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.MathExt;
import baltorogames.core.VectorF2;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.ControllPoint;
import java.util.Vector;

class CollisionObject {
    static VectorF2 vecOutPos = new VectorF2();
    static VectorF2 vecOutDir = new VectorF2();
    public double m_fX = 0.0;
    public double m_fY = 0.0;
    public double m_fDX = 0.0;
    public double m_fDY = 0.0;
    private Vector m_arrPoints = new Vector();
    private Vector m_arrTransformPoints = null;
    public int m_nObjectID = -1;
    public boolean m_bActive = true;
    public boolean isPowerUp = false;
    public boolean isPaddle = false;
    public boolean isPortal = false;
    public boolean isOrdinary = false;
    public boolean isBorder = false;
    public boolean isDurableWithoutShield = false;
    public int BorderID = -1;

    public void Inactive() {
        this.m_bActive = false;
    }

    public void Destroy() {
        this.m_arrPoints.removeAllElements();
        this.m_arrPoints = null;
    }

    public int GetSize() {
        return this.m_arrPoints.size();
    }

    public ControllPoint Get(int nIndex) {
        if (nIndex < 0 || nIndex >= this.m_arrPoints.size()) {
            return null;
        }
        return (ControllPoint)this.m_arrPoints.elementAt(nIndex);
    }

    public void Add(double x, double y) {
        ControllPoint p = new ControllPoint();
        p.m_fX = x;
        p.m_fY = y;
        this.m_arrPoints.addElement(p);
    }

    public void Render() {
        CGEngineRenderer.RenderCollisionObject(this, this.m_fX, this.m_fY);
    }

    protected double CheckCollisionWithLine(int nIndex, double fStartX, double fStartY, double fStopX, double fStopY) {
        double x1 = this.GetTransform((int)nIndex).m_fX + this.m_fX;
        double y1 = this.GetTransform((int)nIndex).m_fY + this.m_fY;
        double x2 = this.GetTransform((int)(nIndex + 1)).m_fX + this.m_fX;
        double y2 = this.GetTransform((int)(nIndex + 1)).m_fY + this.m_fY;
        VectorF2.vecTmp6.x = -(y2 - y1);
        VectorF2.vecTmp6.y = x2 - x1;
        VectorF2.vecTmp6.Normalize();
        VectorF2.vecTmp7.x = fStopX - fStartX;
        VectorF2.vecTmp7.y = fStopY - fStartY;
        VectorF2.vecTmp7.Normalize();
        double dot1 = VectorF2.vecTmp6.x * VectorF2.vecTmp7.x + VectorF2.vecTmp6.y * VectorF2.vecTmp7.y;
        if (dot1 < 0.0) {
            return -1.0;
        }
        double fRet = MathExt.CheckSections(fStartX, fStartY, fStopX, fStopY, x1, y1, x2, y2);
        if (fRet >= 0.0) {
            CollisionObject.vecOutPos.x = fStartX + fRet * (fStopX - fStartX);
            CollisionObject.vecOutPos.y = fStartY + fRet * (fStopY - fStartY);
            VectorF2.vecTmp3.x = fStopX - fStartX;
            VectorF2.vecTmp3.y = fStopY - fStartY;
            VectorF2.vecTmp3.Normalize();
            VectorF2.vecTmp4.x = -(y2 - y1);
            VectorF2.vecTmp4.y = x2 - x1;
            VectorF2.vecTmp4.Normalize();
            double dot = VectorF2.vecTmp3.x * VectorF2.vecTmp4.x + VectorF2.vecTmp3.y * VectorF2.vecTmp4.y;
            CollisionObject.vecOutDir.x = VectorF2.vecTmp3.x - 2.0 * VectorF2.vecTmp4.x * dot;
            CollisionObject.vecOutDir.y = VectorF2.vecTmp3.y - 2.0 * VectorF2.vecTmp4.y * dot;
            vecOutDir.Normalize();
            return fRet;
        }
        return -1.0;
    }

    protected double CheckCollisionWithMe(double fStartX, double fStartY, double fStopX, double fStopY, VectorF2 vecPosition, VectorF2 vecDirection) {
        if (this.m_arrTransformPoints == null || this.m_arrTransformPoints.size() == 0 || !this.m_bActive) {
            return -1.0;
        }
        if (this.m_fDX != 0.0 || this.m_fDY != 0.0) {
            return this.CheckCollisionWithMeMove(fStartX, fStartY, fStopX, fStopY, vecPosition, vecDirection);
        }
        double fMin = 2.0;
        int nS = this.GetTransformSize();
        for (int i = 0; i < nS - 1; ++i) {
            double fRet = this.CheckCollisionWithLine(i, fStartX, fStartY, fStopX, fStopY);
            if (!(fRet >= 0.0) || !(fRet <= 1.0) || !(fRet < fMin)) continue;
            fMin = fRet;
            vecPosition.x = CollisionObject.vecOutPos.x;
            vecPosition.y = CollisionObject.vecOutPos.y;
            vecDirection.x = CollisionObject.vecOutDir.x;
            vecDirection.y = CollisionObject.vecOutDir.y;
        }
        return fMin;
    }

    protected double CheckCollisionWithLine2(int nIndex, double fStartX, double fStartY, double fStopX, double fStopY) {
        double x1 = this.GetTransform((int)nIndex).m_fX + this.m_fX;
        double y1 = this.GetTransform((int)nIndex).m_fY + this.m_fY;
        double x2 = this.GetTransform((int)(nIndex + 1)).m_fX + this.m_fX;
        double y2 = this.GetTransform((int)(nIndex + 1)).m_fY + this.m_fY;
        VectorF2.vecTmp6.x = -(y2 - y1);
        VectorF2.vecTmp6.y = x2 - x1;
        VectorF2.vecTmp6.Normalize();
        VectorF2.vecTmp7.x = fStopX - fStartX;
        VectorF2.vecTmp7.y = fStopY - fStartY;
        VectorF2.vecTmp7.Normalize();
        double dot1 = VectorF2.vecTmp6.x * VectorF2.vecTmp7.x + VectorF2.vecTmp6.y * VectorF2.vecTmp7.y;
        if (dot1 < 0.0) {
            return -1.0;
        }
        double fRet = MathExt.CheckSections(fStartX, fStartY, fStopX - this.m_fDX, fStopY - this.m_fDY, x1, y1, x2, y2);
        if (fRet >= 0.0) {
            CollisionObject.vecOutPos.x = fStartX + fRet * (fStopX - fStartX);
            CollisionObject.vecOutPos.y = fStartY + fRet * (fStopY - fStartY);
            VectorF2.vecTmp3.x = fStopX - fStartX;
            VectorF2.vecTmp3.y = fStopY - fStartY;
            VectorF2.vecTmp3.Normalize();
            VectorF2.vecTmp4.x = -(y2 - y1);
            VectorF2.vecTmp4.y = x2 - x1;
            VectorF2.vecTmp4.Normalize();
            double dot = VectorF2.vecTmp3.x * VectorF2.vecTmp4.x + VectorF2.vecTmp3.y * VectorF2.vecTmp4.y;
            CollisionObject.vecOutDir.x = VectorF2.vecTmp3.x - 2.0 * VectorF2.vecTmp4.x * dot;
            CollisionObject.vecOutDir.y = VectorF2.vecTmp3.y - 2.0 * VectorF2.vecTmp4.y * dot;
            vecOutDir.Normalize();
            return fRet;
        }
        return -1.0;
    }

    protected double CheckCollisionWithMeMove(double fStartX, double fStartY, double fStopX, double fStopY, VectorF2 vecPosition, VectorF2 vecDirection) {
        double fMin = 2.0;
        int nS = this.GetTransformSize();
        for (int i = 0; i < nS - 1; ++i) {
            double fRet = this.CheckCollisionWithLine2(i, fStartX, fStartY, fStopX, fStopY);
            if (!(fRet >= 0.0) || !(fRet < fMin)) continue;
            fMin = fRet;
            vecPosition.x = CollisionObject.vecOutPos.x;
            vecPosition.y = CollisionObject.vecOutPos.y;
            vecDirection.x = CollisionObject.vecOutDir.x;
            vecDirection.y = CollisionObject.vecOutDir.y;
        }
        return fMin;
    }

    public void CreateTransformPoints(float fBallRadius) {
        this.m_arrTransformPoints = new Vector();
        for (int i = 0; i < this.GetSize(); ++i) {
            ControllPoint p = this.Get(i);
            int nI = i + 1;
            ControllPoint pNext = this.Get(nI %= this.GetSize());
            nI = i - 1;
            if (nI < 0) {
                nI = this.GetSize() - 1;
            }
            ControllPoint pPrev = this.Get(nI);
            VectorF2.vecTmp1.x = pNext.m_fX - p.m_fX;
            VectorF2.vecTmp1.y = pNext.m_fY - p.m_fY;
            VectorF2.vecTmp1.Normalize();
            VectorF2.vecTmp2.x = pPrev.m_fX - p.m_fX;
            VectorF2.vecTmp2.y = pPrev.m_fY - p.m_fY;
            VectorF2.vecTmp2.Normalize();
            VectorF2.vecTmp1.x += VectorF2.vecTmp2.x;
            VectorF2.vecTmp1.y += VectorF2.vecTmp2.y;
            VectorF2.vecTmp1.Normalize();
            ControllPoint pNew = new ControllPoint();
            pNew.m_fX = p.m_fX - VectorF2.vecTmp1.x * (double)fBallRadius * (double)1.4f;
            pNew.m_fY = p.m_fY - VectorF2.vecTmp1.y * (double)fBallRadius * (double)1.4f;
            this.m_arrTransformPoints.addElement(pNew);
        }
        ControllPoint pFirst = this.GetTransform(0);
        ControllPoint pLast = this.GetTransform(this.GetTransformSize() - 1);
        if (pFirst.m_fX != pLast.m_fX || pFirst.m_fY != pLast.m_fY) {
            ControllPoint pNew = new ControllPoint();
            pNew.m_fX = pFirst.m_fX;
            pNew.m_fY = pFirst.m_fY;
            this.m_arrTransformPoints.addElement(pNew);
        }
    }

    public int GetTransformSize() {
        return this.m_arrTransformPoints.size();
    }

    public ControllPoint GetTransform(int nIndex) {
        if (nIndex < 0 || nIndex >= this.m_arrTransformPoints.size()) {
            return null;
        }
        return (ControllPoint)this.m_arrTransformPoints.elementAt(nIndex);
    }

    public double GetCurrentCenterX() {
        double fCenterX = 0.0;
        for (int i = 0; i < this.m_arrTransformPoints.size(); ++i) {
            fCenterX += ((ControllPoint)this.m_arrTransformPoints.elementAt((int)i)).m_fX;
        }
        return this.m_fX + (fCenterX /= (double)this.m_arrTransformPoints.size());
    }

    public double GetCurrentWidth() {
        return ((ControllPoint)this.m_arrTransformPoints.elementAt((int)1)).m_fX - ((ControllPoint)this.m_arrTransformPoints.elementAt((int)0)).m_fX;
    }
}

