/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.VectorF2;
import baltorogames.project_gameplay.CGUserLevelStats;
import baltorogames.system.BGStore;
import baltorogames.system.FileManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CGUserCareer {
    public static final int eNumStarsToUnlockEnv2 = 20;
    public static final int eNumStarsToUnlockEnv3 = 65;
    public static final int[] arrSurvivalStars = new int[]{2, 2, 3, 3, 4, 4, 5, 6, 7};
    public static final int ePowerup_Freeze = 0;
    public static final int ePowerup_Reverse = 1;
    public static final int ePowerup_Bomb = 2;
    public static final int ePowerup_Color = 3;
    public static final int ePowerup_Swap = 4;
    public static final int ePowerup_LaserBall = 5;
    public static final int ePowerup_UniBall = 6;
    public static final int ePowerup_Money = 7;
    public static final int ePowerup_Multi = 8;
    public static boolean tutorial_FirstTime = true;
    public static boolean tutorial_Control = true;
    public static int newPowerUpIDInfo = -1;
    public static int newBlockIDInfo = -1;
    public static final int eMaxLevels = 36;
    public static int[] m_arrLevelBestScore = new int[36];
    public static final int eMaxSurvivalLevels = 3;
    public static int[][] m_arrPowerupPrice = new int[][]{{0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}, {0, 2, 3, 5, 8}};
    public static boolean[] PowerUpTutorialInfo = new boolean[]{true, true, true, true, true, true, true, true, true, true, true};
    public static boolean[] BlockTutorialInfo = new boolean[]{true, true, true, true, true, true, true, true, true, true, true};
    public static int[][] m_arrPowerupTime = new int[][]{{5, 7, 9, 11, 13}, {5, 7, 9, 11, 13}, {8, 10, 12, 14, 16}, {5, 7, 9, 11, 13}, {8, 10, 12, 14, 16}, {5, 7, 9, 11, 13}, {5, 7, 9, 11, 13}, {5, 7, 9, 11, 13}, {5, 7, 9, 11, 13}, {5, 7, 9, 11, 13}};
    public static int[][] m_arrBestForSurvival = new int[][]{{0, 0}, {0, 0}, {0, 0}};
    public static int[][] m_arrBestForTimed = new int[][]{{0, 0}, {0, 0}, {0, 0}};
    public static CGUserLevelStats[] arrLevelStats = new CGUserLevelStats[36];
    protected static String m_szNick;
    protected static String m_szDevicePlatform;
    public static int m_nAdventureLevel;
    protected static int m_nPoints;
    protected static int m_nStars;
    protected static int m_nSurvivalTime;
    protected static int m_nSurvivalScore;
    protected static int[] m_nSpecialPowerups;
    protected static int[] m_nPowerupLevel;
    public static int[] m_arrSpecialPowerupsPrice;
    public static int m_nPowerupSlowDownTime;
    public static float m_fPowerupSlowDownFactor;
    public static int m_nPowerupTimeWarpTime;
    public static float m_fPowerupTimeWarpFactor;
    public static int m_nExplosionBallPoints;
    public static int m_nComboBallPoints;
    public static int m_nChainBallPoints;
    public static int m_nLostBallPoints;
    public static boolean[] m_bSurvivalLevel;
    public static boolean m_bTutorial;

    public static int GetTotalNumberOfStars() {
        int stars = 0;
        for (int i = 0; i < 36; ++i) {
            stars += CGUserCareer.arrLevelStats[i].m_nStars;
        }
        return stars;
    }

    public static boolean IsEnvironmentCompleted(int galaxy) {
        if (galaxy == 0 && CGUserCareer.GetAdventureLevel() >= 11) {
            return true;
        }
        if (galaxy == 1 && CGUserCareer.GetAdventureLevel() >= 23) {
            return true;
        }
        return galaxy == 2 && CGUserCareer.GetAdventureLevel() >= 35;
    }

    public static boolean IsEnvironmentAvailable(int galaxy) {
        if (galaxy == 0 && CGUserCareer.GetAdventureLevel() >= 0) {
            return true;
        }
        if (galaxy == 1 && CGUserCareer.GetAdventureLevel() >= 12) {
            return true;
        }
        return galaxy == 2 && CGUserCareer.GetAdventureLevel() >= 24;
    }

    public static void Reset() {
        int i;
        int j;
        int i2;
        newBlockIDInfo = -1;
        newPowerUpIDInfo = -1;
        tutorial_FirstTime = true;
        tutorial_Control = true;
        m_nPoints = 0;
        CGUserCareer.m_nSpecialPowerups[2] = 0;
        CGUserCareer.m_nSpecialPowerups[1] = 0;
        CGUserCareer.m_nSpecialPowerups[0] = 0;
        if (arrLevelStats != null) {
            for (i2 = 0; i2 < 36; ++i2) {
                CGUserCareer.arrLevelStats[i2] = new CGUserLevelStats();
            }
        }
        if (PowerUpTutorialInfo != null) {
            for (i2 = 0; i2 < PowerUpTutorialInfo.length; ++i2) {
                CGUserCareer.PowerUpTutorialInfo[i2] = true;
            }
        }
        if (BlockTutorialInfo != null) {
            for (i2 = 0; i2 < BlockTutorialInfo.length; ++i2) {
                CGUserCareer.BlockTutorialInfo[i2] = true;
            }
        }
        for (i2 = 0; i2 < 10; ++i2) {
            CGUserCareer.m_nPowerupLevel[i2] = -1;
        }
        for (i2 = 0; i2 < 3; ++i2) {
            for (j = 0; j < 2; ++j) {
                CGUserCareer.m_arrBestForSurvival[i2][j] = 0;
            }
        }
        for (i2 = 0; i2 < 3; ++i2) {
            for (j = 0; j < 2; ++j) {
                CGUserCareer.m_arrBestForTimed[i2][j] = 0;
            }
        }
        m_nAdventureLevel = 0;
        m_szNick = "";
        m_szDevicePlatform = "";
        if (arrLevelStats == null) {
            arrLevelStats = new CGUserLevelStats[36];
        }
        VectorF2 v = new VectorF2();
        for (i = 0; i < 36; ++i) {
            CGUserCareer.arrLevelStats[i] = new CGUserLevelStats();
            int nGalaxy = i / 15;
            int nLevel = i % 15;
            CGUserCareer.arrLevelStats[i].m_nDefaultScore = (int)v.y;
            CGUserCareer.arrLevelStats[i].m_nDefaultTime = (int)v.x;
            System.out.println("LEVEL " + i + ": Score=" + (int)v.y + "  Time=" + (int)v.x);
        }
        for (i = 0; i < 3; ++i) {
            CGUserCareer.m_bSurvivalLevel[i] = i == 0;
        }
        m_arrLevelBestScore = new int[36];
        for (i = 0; i < 36; ++i) {
            CGUserCareer.m_arrLevelBestScore[i] = 0;
        }
    }

    public static int GetLevelTime(int nLevelIndex) {
        if (nLevelIndex >= 0 && nLevelIndex < 36) {
            return CGUserCareer.arrLevelStats[nLevelIndex].m_nTime;
        }
        return 0;
    }

    public static void SetLevelTime(int nLevelIndex, int nT) {
        if (nLevelIndex >= 0 && nLevelIndex < 36 && nT < CGUserCareer.arrLevelStats[nLevelIndex].m_nTime) {
            CGUserCareer.arrLevelStats[nLevelIndex].m_nTime = nT;
        }
    }

    public static int GetLevelDefaultTime(int nLevelIndex) {
        if (nLevelIndex >= 0 && nLevelIndex < 36) {
            return CGUserCareer.arrLevelStats[nLevelIndex].m_nDefaultTime;
        }
        return 0;
    }

    public static int GetLevelScore(int nLevelIndex) {
        if (nLevelIndex >= 0 && nLevelIndex < 36) {
            return CGUserCareer.arrLevelStats[nLevelIndex].m_nScore;
        }
        return 0;
    }

    public static void SetLevelScore(int nLevelIndex, int nS) {
        if (nLevelIndex >= 0 && nLevelIndex < 36 && nS > CGUserCareer.arrLevelStats[nLevelIndex].m_nScore) {
            CGUserCareer.arrLevelStats[nLevelIndex].m_nScore = nS;
        }
    }

    public static int GetLevelDefaultScore(int nLevelIndex) {
        if (nLevelIndex >= 0 && nLevelIndex < 36) {
            return CGUserCareer.arrLevelStats[nLevelIndex].m_nDefaultScore;
        }
        return 0;
    }

    public static int GetLevelStars(int nLevelIndex, int nS) {
        if (nLevelIndex >= 0 && nLevelIndex < 36) {
            return CGUserCareer.arrLevelStats[nLevelIndex].m_nStars;
        }
        return 0;
    }

    public static void SetLevelStars(int nLevelIndex, int nS, int nV) {
        if (nLevelIndex >= 0 && nLevelIndex < 36 && CGUserCareer.arrLevelStats[nLevelIndex].m_nStars == 0) {
            CGUserCareer.arrLevelStats[nLevelIndex].m_nStars = nV;
        }
    }

    public static int GetNextUpgradePrice(int nPowerupIndex) {
        if (m_nPowerupLevel[nPowerupIndex] >= 4) {
            return 1000000;
        }
        if (m_nPowerupLevel[nPowerupIndex] < 0) {
            return 0;
        }
        return m_arrPowerupPrice[nPowerupIndex][m_nPowerupLevel[nPowerupIndex] + 1];
    }

    public static int GetCurrentUpgradeParam(int nPowerupIndex) {
        if (m_nPowerupLevel[nPowerupIndex] > 4) {
            return 1000000;
        }
        if (m_nPowerupLevel[nPowerupIndex] < 0) {
            return -1;
        }
        return m_arrPowerupTime[nPowerupIndex][m_nPowerupLevel[nPowerupIndex]];
    }

    public static int GetNextUpgradeParam(int nPowerupIndex) {
        if (m_nPowerupLevel[nPowerupIndex] >= 4) {
            return 1000000;
        }
        if (m_nPowerupLevel[nPowerupIndex] < 0) {
            return -1;
        }
        return m_arrPowerupTime[nPowerupIndex][m_nPowerupLevel[nPowerupIndex] + 1];
    }

    public static void UnlockPowerup(int nIndex) {
        if (m_nPowerupLevel[nIndex] < 0) {
            CGUserCareer.m_nPowerupLevel[nIndex] = 0;
        }
    }

    public static void UnlockAllPowerups() {
        for (int i = 0; i < m_nPowerupLevel.length; ++i) {
            CGUserCareer.m_nPowerupLevel[i] = 0;
        }
    }

    public static boolean IsPowerupUnlocked(int nIndex) {
        return m_nPowerupLevel[nIndex] >= 0;
    }

    public static void Load() {
        BGStore store = BGStore.openStoreToRead("UserCareer");
        if (store == null) {
            return;
        }
        try {
            DataInputStream inputStream = store.getInStream();
            if (inputStream != null && inputStream.available() > 0) {
                int j;
                int i;
                newBlockIDInfo = inputStream.readInt();
                newPowerUpIDInfo = inputStream.readInt();
                if (PowerUpTutorialInfo != null) {
                    for (i = 0; i < PowerUpTutorialInfo.length; ++i) {
                        CGUserCareer.PowerUpTutorialInfo[i] = inputStream.readBoolean();
                    }
                }
                if (BlockTutorialInfo != null) {
                    for (i = 0; i < BlockTutorialInfo.length; ++i) {
                        CGUserCareer.BlockTutorialInfo[i] = inputStream.readBoolean();
                    }
                }
                tutorial_FirstTime = inputStream.readBoolean();
                tutorial_Control = inputStream.readBoolean();
                m_nAdventureLevel = inputStream.readInt();
                m_nPoints = inputStream.readInt();
                for (i = 0; i < 3; ++i) {
                    CGUserCareer.m_nSpecialPowerups[i] = inputStream.readInt();
                }
                for (i = 0; i < 10; ++i) {
                    CGUserCareer.m_nPowerupLevel[i] = inputStream.readInt();
                }
                for (i = 0; i < 36; ++i) {
                    CGUserCareer.arrLevelStats[i].m_nScore = inputStream.readInt();
                    CGUserCareer.arrLevelStats[i].m_nTime = inputStream.readInt();
                    CGUserCareer.arrLevelStats[i].m_nStars = inputStream.readInt();
                }
                for (i = 0; i < 3; ++i) {
                    for (j = 0; j < 2; ++j) {
                        CGUserCareer.m_arrBestForSurvival[i][j] = inputStream.readInt();
                    }
                }
                for (i = 0; i < 3; ++i) {
                    for (j = 0; j < 2; ++j) {
                        CGUserCareer.m_arrBestForTimed[i][j] = inputStream.readInt();
                    }
                }
                m_szNick = inputStream.readUTF();
                m_szDevicePlatform = inputStream.readUTF();
                for (i = 0; i < 3; ++i) {
                    CGUserCareer.m_bSurvivalLevel[i] = inputStream.readBoolean();
                }
                m_arrLevelBestScore = new int[36];
                for (i = 0; i < 36; ++i) {
                    CGUserCareer.m_arrLevelBestScore[i] = inputStream.readInt();
                }
            }
            store.close();
        }
        catch (Exception e) {
            CGUserCareer.Reset();
            return;
        }
    }

    public static void Save() {
        if (arrLevelStats == null || arrLevelStats[0] == null) {
            return;
        }
        if (m_arrLevelBestScore == null) {
            return;
        }
        BGStore store = BGStore.openStoreToWrite("UserCareer");
        if (store == null) {
            return;
        }
        try {
            int j;
            int i;
            DataOutputStream outputStream = store.getOutStream();
            outputStream.writeInt(newBlockIDInfo);
            outputStream.writeInt(newPowerUpIDInfo);
            if (PowerUpTutorialInfo != null) {
                for (i = 0; i < PowerUpTutorialInfo.length; ++i) {
                    outputStream.writeBoolean(PowerUpTutorialInfo[i]);
                }
            }
            if (BlockTutorialInfo != null) {
                for (i = 0; i < BlockTutorialInfo.length; ++i) {
                    outputStream.writeBoolean(BlockTutorialInfo[i]);
                }
            }
            outputStream.writeBoolean(tutorial_FirstTime);
            outputStream.writeBoolean(tutorial_Control);
            outputStream.writeInt(m_nAdventureLevel);
            outputStream.writeInt(m_nPoints);
            for (i = 0; i < 3; ++i) {
                outputStream.writeInt(m_nSpecialPowerups[i]);
            }
            for (i = 0; i < 10; ++i) {
                outputStream.writeInt(m_nPowerupLevel[i]);
            }
            for (i = 0; i < 36; ++i) {
                outputStream.writeInt(CGUserCareer.arrLevelStats[i].m_nScore);
                outputStream.writeInt(CGUserCareer.arrLevelStats[i].m_nTime);
                outputStream.writeInt(CGUserCareer.arrLevelStats[i].m_nStars);
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 2; ++j) {
                    outputStream.writeInt(m_arrBestForSurvival[i][j]);
                }
            }
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 2; ++j) {
                    outputStream.writeInt(m_arrBestForTimed[i][j]);
                }
            }
            outputStream.writeUTF(m_szNick);
            outputStream.writeUTF(m_szDevicePlatform);
            for (i = 0; i < 3; ++i) {
                outputStream.writeBoolean(m_bSurvivalLevel[i]);
            }
            for (i = 0; i < 36; ++i) {
                outputStream.writeInt(m_arrLevelBestScore[i]);
            }
            store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void Actualize(int nLevelIndex, int nInitScore, int m_nInitTime) {
        if (nLevelIndex >= 1 && nLevelIndex <= 36 && CGUserCareer.arrLevelStats[nLevelIndex - 1].m_nScore == 0 && CGUserCareer.arrLevelStats[nLevelIndex - 1].m_nScore == 0) {
            CGUserCareer.arrLevelStats[nLevelIndex - 1].m_nScore = nInitScore;
            CGUserCareer.arrLevelStats[nLevelIndex - 1].m_nTime = m_nInitTime;
        }
    }

    public static int GetPoints() {
        return m_nPoints;
    }

    public static void AddPoints(int n) {
        m_nPoints += n;
    }

    public static void SetAdventureLevel(int i) {
        m_nAdventureLevel = i;
    }

    public static int GetAdventureLevel() {
        return m_nAdventureLevel;
    }

    public static int GetSpecialPowerupNr(int nPowerupIndex) {
        return m_nSpecialPowerups[nPowerupIndex];
    }

    public static void AddSpecialPowerupNr(int nPowerupIndex, int nNr) {
        int n = nPowerupIndex;
        m_nSpecialPowerups[n] = m_nSpecialPowerups[n] + nNr;
    }

    public static void SubSpecialPowerupNr(int nPowerupIndex) {
        if (m_nSpecialPowerups[nPowerupIndex] > 0) {
            int n = nPowerupIndex;
            m_nSpecialPowerups[n] = m_nSpecialPowerups[n] - 1;
        }
    }

    public static int GetPowerupLevel(int nPowerupIndex) {
        return m_nPowerupLevel[nPowerupIndex];
    }

    public static void AddPowerupLevel(int nPowerupIndex) {
        if (m_nPowerupLevel[nPowerupIndex] < 4) {
            int n = nPowerupIndex;
            m_nPowerupLevel[n] = m_nPowerupLevel[n] + 1;
        }
    }

    public static void SetNick(String s) {
        m_szNick = s;
    }

    public static String GetNick() {
        return m_szNick;
    }

    public static void SetDevicePlatform(String s) {
        m_szDevicePlatform = s;
    }

    public static String GetDevicePlatform() {
        return m_szDevicePlatform;
    }

    public static void LoadGlobalParams() {
        InputStream is = null;
        try {
            is = FileManager.OpenFile("/Powerups.aaa");
            if (is == null && (is = FileManager.OpenURLFile("/Powerups.aaa")) == null) {
                return;
            }
            DataInputStream dis = new DataInputStream(is);
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < 5; ++j) {
                    CGUserCareer.m_arrPowerupTime[i][j] = dis.readInt();
                    CGUserCareer.m_arrPowerupPrice[i][j] = dis.readInt();
                }
            }
            CGUserCareer.m_arrSpecialPowerupsPrice[0] = dis.readInt();
            CGUserCareer.m_arrSpecialPowerupsPrice[1] = dis.readInt();
            m_nPowerupSlowDownTime = dis.readInt();
            m_fPowerupSlowDownFactor = dis.readFloat();
            CGUserCareer.m_arrSpecialPowerupsPrice[2] = dis.readInt();
            m_nPowerupTimeWarpTime = dis.readInt();
            m_fPowerupTimeWarpFactor = dis.readFloat();
            m_nExplosionBallPoints = dis.readInt();
            m_nComboBallPoints = dis.readInt();
            m_nChainBallPoints = dis.readInt();
            m_nLostBallPoints = dis.readInt();
        }
        catch (Exception e2) {
            System.out.println("Error reading GlobalParams.sts");
            e2.printStackTrace();
            return;
        }
    }

    public static void UnlockAllLevels() {
        m_nAdventureLevel = 100;
    }

    public static void UnlockAllSurvivals() {
        for (int i = 0; i < 3; ++i) {
            CGUserCareer.m_bSurvivalLevel[i] = true;
        }
    }

    static {
        m_nAdventureLevel = 0;
        m_nSpecialPowerups = new int[3];
        m_nPowerupLevel = new int[10];
        m_arrSpecialPowerupsPrice = new int[3];
        m_nExplosionBallPoints = 10;
        m_nComboBallPoints = 30;
        m_nChainBallPoints = 20;
        m_nLostBallPoints = -50;
        m_bSurvivalLevel = new boolean[3];
        m_bTutorial = false;
    }
}

