/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.MathExt;
import baltorogames.core_gui.UIScreen;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGActivePowerUp;
import baltorogames.project_gameplay.CGBall;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGFallingPowerUp;
import baltorogames.project_gameplay.CGHit;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CollisionObject;
import baltorogames.project_gameplay.CollisionScene;
import baltorogames.project_gameplay.GameObject;
import baltorogames.project_gameplay.LevelScenario;
import baltorogames.project_gameplay.LevelScenarioSurvivalManager;
import baltorogames.project_gameplay.PaddleObject;
import baltorogames.project_gui.LevelLostScreen;
import baltorogames.project_gui.LevelWinScreen;
import baltorogames.project_gui.SurvivalLevelScreen;
import baltorogames.project_gui.TimedLevelScreen;
import java.io.DataInputStream;

public class CGEngine {
    public static int m_nCurrentGalaxy = 0;
    public static int m_nCurrentLevel = 0;
    public static int m_nSurvivalLevel = 0;
    public static int m_nCurrentTimeInLevel = 0;
    public static boolean bIsTimeSlowMotion = false;
    public static boolean blevelLost = false;
    public static final int eGameGalaxy_1 = 0;
    public static final int eGameGalaxy_2 = 1;
    public static final int eGameGalaxy_3 = 2;
    public static final int eGameMode_Story = 1;
    public static final int eGameMode_Survival = 2;
    public static final int eGameMode_Timed = 3;
    public static final int eLevelsPerWorld = 12;
    public static int m_nGameMode = 2;
    public static boolean m_bGameActive = false;
    public static boolean m_btut1 = true;
    public static float m_fCameraPosX = 0.0f;
    public static float m_fCameraPosY = 0.0f;
    public static int m_nSterringValue = 0;
    public static int m_nViewMode = 0;
    public static int globalTime = 0;
    public static int m_TimedModeTime = CGBoard.eTimedStartTime;
    public static float m_PaddleScale = 1.0f;
    public static int[] m_nSelectedBoosts = new int[]{-1, -1, -1};
    public static int m_nLastBoardDownTime = 0;
    public static boolean m_bGameOver;
    public static int m_nGameOverDelay;
    public static int m_nGameResult;
    public static CGBoard m_Board;
    public static int m_nParams_CurrentLevelInitScore;
    public static int m_nParams_CurrentLevelInitTime;
    public static float m_fEngineScale;
    public static boolean m_bPause;
    public static int m_nEngineTime;
    protected static int m_nUpdateDeltaTime;
    public static boolean m_bEngineChangeAxis;
    public static LevelScenarioSurvivalManager m_LevelScenarioSurvivalManager;
    public static CollisionScene m_CollisionScene;
    public static CGBall[] m_Ball;
    public static PaddleObject m_PaddleObject;
    public static float m_fTouchX;
    public static float m_fTouchY;

    public static void IncCurrentLevel() {
        if (m_nCurrentLevel < 12) {
            ++m_nCurrentLevel;
        } else {
            ++m_nCurrentGalaxy;
            m_nCurrentLevel = 1;
        }
    }

    public static void InitParams() {
    }

    public static void Load1(DataInputStream dis) {
        CGEngine.Destroy();
        m_bEngineChangeAxis = false;
        try {
            int nScreenX = 480;
            int nScreenY = 800;
            float fScaleX = (float)ApplicationData.screenWidth / (float)nScreenX;
            float fScaleY = (float)ApplicationData.screenHeight / (float)nScreenY;
            m_fEngineScale = fScaleX < fScaleY ? fScaleX : fScaleY;
            m_fEngineScale = 0.37f;
            CGEngineRenderer.m_fScreenOffsetX = ((float)ApplicationData.screenWidth - m_fEngineScale * (float)nScreenX) / 2.0f;
            CGEngineRenderer.m_fScreenOffsetY = ((float)ApplicationData.screenHeight - m_fEngineScale * (float)nScreenY) / 2.0f;
            ApplicationData.setGameMode();
        }
        catch (Exception e) {
            return;
        }
    }

    public static void Load2(DataInputStream dis) {
        m_bGameOver = false;
        m_bPause = false;
        m_CollisionScene = new CollisionScene();
        m_nEngineTime = 0;
        if (m_nGameMode == 1) {
            m_LevelScenarioSurvivalManager = null;
            LevelScenario ls = new LevelScenario();
            String fileName = "/map_" + (m_nCurrentGalaxy + 1) + "_" + (m_nCurrentLevel + 1) + ".txt";
            ls.Load(fileName);
            m_Board = new CGBoard(ls);
            m_TimedModeTime = 1000000;
        } else if (m_nGameMode == 2) {
            m_Board = new CGBoard();
            m_Board.PrepareSurvival();
            m_TimedModeTime = 1000000;
        } else {
            m_Board = new CGBoard();
            m_Board.PrepareTimed();
            m_TimedModeTime = CGBoard.eTimedStartTime;
        }
        m_nCurrentTimeInLevel = 0;
        CGLevelStats.Reset();
        CGHit.Reset();
        CGFallingPowerUp.Reset();
        CGActivePowerUp.Reset();
        CollisionObject pCollisionObject = new CollisionObject();
        pCollisionObject.Add(-70.0, -10000.0);
        pCollisionObject.Add(30.0, -10000.0);
        pCollisionObject.Add(30.0, 10000.0);
        pCollisionObject.Add(-70.0, 10000.0);
        pCollisionObject.CreateTransformPoints(CGBall.eRadius);
        pCollisionObject.isBorder = true;
        pCollisionObject.BorderID = 1;
        m_CollisionScene.Add(pCollisionObject);
        pCollisionObject = new CollisionObject();
        pCollisionObject.Add(450.0, -10000.0);
        pCollisionObject.Add(550.0, -10000.0);
        pCollisionObject.Add(550.0, 10000.0);
        pCollisionObject.Add(450.0, 10000.0);
        pCollisionObject.CreateTransformPoints(CGBall.eRadius);
        pCollisionObject.isBorder = true;
        pCollisionObject.BorderID = 3;
        m_CollisionScene.Add(pCollisionObject);
        pCollisionObject = new CollisionObject();
        pCollisionObject.Add(-1000.0, CGBoard.eBoardStartY - 100);
        pCollisionObject.Add(1000.0, CGBoard.eBoardStartY - 100);
        pCollisionObject.Add(1000.0, CGBoard.eBoardStartY);
        pCollisionObject.Add(-1000.0, CGBoard.eBoardStartY);
        pCollisionObject.CreateTransformPoints(CGBall.eRadius);
        pCollisionObject.isBorder = true;
        pCollisionObject.BorderID = 2;
        m_CollisionScene.Add(pCollisionObject);
        m_PaddleObject = new PaddleObject();
        m_PaddleObject.Init(240.0, 650.0, 140.0, 31.200000000000003, 100, 1000000, m_PaddleScale);
        m_Ball = new CGBall[3];
        CGEngine.m_Ball[0] = new CGBall();
        CGEngine.m_Ball[0].isReady = false;
        m_Ball[0].SetPos((float)CGEngine.m_PaddleObject.centerXforBall, (float)CGEngine.m_PaddleObject.centerYforBall);
        m_bGameActive = true;
        CGDynamicObj.ClearCurrentDynamics();
    }

    public static int Init() {
        return 1;
    }

    public static void Destroy() {
        m_Board = null;
    }

    public static void Create3Balls() {
        if (m_Ball[0] != null) {
            CGEngine.m_Ball[1] = new CGBall();
            m_Ball[1].SetPos((float)CGEngine.m_Ball[0].vecPos.x, (float)CGEngine.m_Ball[0].vecPos.y);
            CGEngine.m_Ball[1].isReady = true;
            CGEngine.m_Ball[2] = new CGBall();
            m_Ball[2].SetPos((float)CGEngine.m_Ball[0].vecPos.x, (float)CGEngine.m_Ball[0].vecPos.y);
            CGEngine.m_Ball[2].isReady = true;
            if (!CGEngine.m_Ball[0].isBallFalling) {
                m_Ball[1].ShootBall(CGEngine.m_Ball[0].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[0].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
                m_Ball[2].ShootBall(CGEngine.m_Ball[0].vecTarget.x - (double)CGBall.eRadius, CGEngine.m_Ball[0].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
            } else {
                m_Ball[1].ShootBall(CGEngine.m_Ball[0].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[0].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
                m_Ball[2].ShootBall(CGEngine.m_Ball[0].vecTarget.x - (double)CGBall.eRadius, CGEngine.m_Ball[0].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
            }
        } else if (m_Ball[1] != null) {
            CGEngine.m_Ball[0] = new CGBall();
            m_Ball[0].SetPos((float)CGEngine.m_Ball[1].vecPos.x, (float)CGEngine.m_Ball[1].vecPos.y);
            CGEngine.m_Ball[0].isReady = true;
            CGEngine.m_Ball[2] = new CGBall();
            m_Ball[2].SetPos((float)CGEngine.m_Ball[1].vecPos.x, (float)CGEngine.m_Ball[1].vecPos.y);
            CGEngine.m_Ball[2].isReady = true;
            if (!CGEngine.m_Ball[1].isBallFalling) {
                m_Ball[0].ShootBall(CGEngine.m_Ball[1].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[1].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
                m_Ball[2].ShootBall(CGEngine.m_Ball[1].vecTarget.x - (double)CGBall.eRadius, CGEngine.m_Ball[1].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
            } else {
                m_Ball[0].ShootBall(CGEngine.m_Ball[1].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[1].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
                m_Ball[2].ShootBall(CGEngine.m_Ball[1].vecTarget.x - (double)CGBall.eRadius, CGEngine.m_Ball[1].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
            }
        } else if (m_Ball[2] != null) {
            CGEngine.m_Ball[0] = new CGBall();
            m_Ball[0].SetPos((float)CGEngine.m_Ball[2].vecPos.x, (float)CGEngine.m_Ball[2].vecPos.y);
            CGEngine.m_Ball[0].isReady = true;
            CGEngine.m_Ball[1] = new CGBall();
            m_Ball[1].SetPos((float)CGEngine.m_Ball[2].vecPos.x, (float)CGEngine.m_Ball[2].vecPos.y);
            CGEngine.m_Ball[1].isReady = true;
            if (!CGEngine.m_Ball[2].isBallFalling) {
                m_Ball[0].ShootBall(CGEngine.m_Ball[2].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[2].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
                m_Ball[1].ShootBall(CGEngine.m_Ball[2].vecTarget.x - (double)CGBall.eRadius, CGEngine.m_Ball[2].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
            } else {
                m_Ball[0].ShootBall(CGEngine.m_Ball[2].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[2].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
                m_Ball[1].ShootBall(CGEngine.m_Ball[2].vecTarget.x - (double)CGBall.eRadius, CGEngine.m_Ball[2].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
            }
        }
    }

    public static void Update(int nDeltaTimeInMs) {
        m_nUpdateDeltaTime = nDeltaTimeInMs;
        globalTime += nDeltaTimeInMs;
        if (m_nSurvivalLevel >= 0 && m_nGameMode == 2) {
            CGAchievements.AddSurvivalTime(nDeltaTimeInMs);
        } else if (m_nGameMode == 3) {
            CGAchievements.AddTimedTime(nDeltaTimeInMs);
        }
        if (nDeltaTimeInMs <= 30) {
            CGEngine.UpdateInternal(nDeltaTimeInMs);
        } else {
            int nT = 0;
            for (nT = 30; nT < nDeltaTimeInMs; nT += 30) {
                CGEngine.UpdateInternal(30);
            }
            nT = nDeltaTimeInMs % 30;
            if (nT > 0) {
                CGEngine.UpdateInternal(nT);
            }
        }
    }

    public static void UpdateInternal(int nDeltaTimeInMs) {
        if (m_bPause) {
            return;
        }
        if (m_Board == null) {
            return;
        }
        if (m_bGameActive) {
            if (CGEngine.m_Board.m_nDeadLineParticle == null && m_nGameMode == 2) {
                CGEngine.m_Board.m_nDeadLineParticle = CGDynamicObj.AddToCurrentDynamics("survival_line.do", 240.0f, (float)(CGBoard.eSurvivalDeadLineY + 24.0), 0.0f);
            }
            if (m_nGameMode == 3) {
                if ((m_TimedModeTime -= nDeltaTimeInMs) < 0) {
                    m_TimedModeTime = 0;
                }
                if (m_TimedModeTime <= 0) {
                    CGEngine.m_Board.timedModeResult = 1;
                }
            }
            m_Board.PreUpdate(nDeltaTimeInMs);
            double fRealStep = 1.0;
            int nMS = nDeltaTimeInMs;
            if (ApplicationData.isLeftPressed() || m_nSterringValue == 1) {
                m_PaddleObject.SetDeltaNewPosX(ApplicationData.screenWidth / 48);
            } else if (ApplicationData.isRightPressed() || m_nSterringValue == -1) {
                m_PaddleObject.SetDeltaNewPosX(-ApplicationData.screenWidth / 48);
            }
            if (m_Ball != null) {
                int i;
                double fMin = 1.0;
                for (i = 0; i < 3; ++i) {
                    double fR;
                    if (m_Ball[i] == null || !((fR = m_Ball[i].PreUpdate(nDeltaTimeInMs)) < fMin)) continue;
                    fMin = fR;
                }
                nMS = (int)(fMin * (double)nDeltaTimeInMs);
                for (i = 0; i < 3; ++i) {
                    GameObject go;
                    if (m_Ball[i] == null) continue;
                    m_Ball[i].Update(nDeltaTimeInMs);
                    if (CGEngine.m_Ball[i].m_nCurrentCollisionObjectID >= 0 && (go = m_Board.GetObjectByID(CGEngine.m_Ball[i].m_nCurrentCollisionObjectID)) != null) {
                        if (go.m_nType == 12 && !CGEngine.m_Ball[i].isPupBlockerBall) {
                            m_Board.RemoveBombBlock(go.m_nID);
                        } else if (CGEngine.m_Ball[i].isPupFireBall) {
                            go.CollisionAction(i, true);
                        } else {
                            go.CollisionAction(i, false);
                        }
                    }
                    m_Ball[i].ActualizePosAndDir();
                    if (!m_Ball[i].bIsLifeLost()) continue;
                    if (CGEngine.CountBalls() == 0) {
                        ++CGLevelStats.m_nLostBalls;
                        blevelLost = true;
                        CGEngine.destroyBallAndDeck();
                        if (CGLevelStats.m_nLifes <= 0) continue;
                        --CGLevelStats.m_nLifes;
                        CGActivePowerUp.Reset();
                        continue;
                    }
                    CGEngine.m_Ball[i] = null;
                }
            }
            if (blevelLost && !m_bGameOver) {
                CGEngine.setBallAndDeck();
                blevelLost = false;
            }
            m_Board.Update(nMS);
            CGEngine.UpdateSurvivalBoard();
            CGEngine.UpdateTimedBoard();
            CGFallingPowerUp.UpdateAll(nDeltaTimeInMs);
            CGActivePowerUp.UpdateAll(nDeltaTimeInMs);
            CGHit.StepAll(nDeltaTimeInMs);
            CGLevelStats.m_nTimeStatsInMs += nDeltaTimeInMs;
            CGLevelStats.m_nTimeInMs -= nDeltaTimeInMs;
            m_nEngineTime += m_nUpdateDeltaTime;
        }
        if (!m_bGameOver) {
            if (m_nSurvivalLevel < 0 && m_nGameMode == 1) {
                CGLevelStats.m_nTime = (m_nCurrentTimeInLevel += bIsTimeSlowMotion ? nDeltaTimeInMs * 8 / 10 : nDeltaTimeInMs) / 1000;
                int result = m_Board.CheckGameIsOver();
                if (result < 0) {
                    CGEngine.stopBallAndDeck();
                    CGFallingPowerUp.m_Vector.removeAllElements();
                    CGEngine.EventLost(true);
                } else if (result > 0) {
                    CGEngine.stopBallAndDeck();
                    CGDynamicObj.AddToCurrentDynamics("level_win_01.do", 240.0f, 480.0f, 0.0f);
                    CGFallingPowerUp.m_Vector.removeAllElements();
                    CGEngine.EventWin();
                }
            } else if (m_nSurvivalLevel > 0 && m_nGameMode == 2) {
                CGLevelStats.m_nSurvTime = (m_nCurrentTimeInLevel += nDeltaTimeInMs) / 1000;
            } else if (m_nGameMode == 3 && CGEngine.m_Board.timedModeResult > 0) {
                CGEngine.stopBallAndDeck();
                CGFallingPowerUp.m_Vector.removeAllElements();
                CGEngine.EventLost(true);
            }
        } else if (m_nGameOverDelay > 0) {
            m_nCurrentTimeInLevel = 0;
            if ((m_nGameOverDelay -= nDeltaTimeInMs) <= 0) {
                m_nGameOverDelay = 0;
                if (m_nGameResult < 0) {
                    if (m_nGameMode == 1) {
                        UIScreen.SetCurrentScreen(new LevelLostScreen());
                    } else if (m_nGameMode == 2) {
                        UIScreen.SetCurrentScreen(new SurvivalLevelScreen());
                    } else if (m_nGameMode == 3) {
                        UIScreen.SetCurrentScreen(new TimedLevelScreen());
                    }
                } else if (m_nGameMode == 1) {
                    UIScreen.SetCurrentScreen(new LevelWinScreen());
                }
            }
        }
    }

    protected static void UpdateSurvivalBoard() {
        if (m_nGameMode == 2) {
            int nCurrentTimestamp = CGBoard.eSurvivalStartStepTimestamp - CGEngine.m_Board.m_nSurvivalStepsCounter * CGBoard.eSurvivalNextStepTimestamp;
            if (nCurrentTimestamp < CGBoard.eSurvivalMinStepTimestamp) {
                nCurrentTimestamp = CGBoard.eSurvivalMinStepTimestamp;
            }
            if (globalTime - m_nLastBoardDownTime > nCurrentTimestamp) {
                boolean bOK = true;
                for (int i = 0; i < 3; ++i) {
                    if (m_Ball[i] == null || m_CollisionScene.CheckCarePosition(CGEngine.m_Ball[i].vecPos.x, CGEngine.m_Ball[i].vecPos.y)) continue;
                    bOK = false;
                    break;
                }
                if (bOK) {
                    int nRes = m_Board.ActionDown();
                    m_nLastBoardDownTime = globalTime;
                    if (nRes < 0) {
                        if (CGEngine.m_Board.m_nDeadLineParticle != null) {
                            CGEngine.m_Board.m_nDeadLineParticle.SetPosition(-1000.0f, -1000.0f, 0.0f);
                            CGDynamicObj.RemoveFromCurrentDynamics(CGEngine.m_Board.m_nDeadLineParticle, '\u0000');
                        }
                        CGEngine.stopBallAndDeck();
                        CGFallingPowerUp.m_Vector.removeAllElements();
                        CGEngine.EventLost(true);
                    }
                }
            }
        }
    }

    protected static void UpdateTimedBoard() {
        if (m_nGameMode == 3) {
            m_Board.CheckNewTimedLevel();
        }
    }

    public static void stopBallAndDeck() {
        CGDynamicObj.AddToCurrentDynamics("block_teleport_in.do", (float)(CGEngine.m_PaddleObject.m_fX - CGEngine.m_PaddleObject.m_fW / 2.0), (float)CGEngine.m_PaddleObject.m_fY, 0.0f);
        CGDynamicObj.AddToCurrentDynamics("block_teleport_out.do", (float)(CGEngine.m_PaddleObject.m_fX + CGEngine.m_PaddleObject.m_fW / 2.0), (float)CGEngine.m_PaddleObject.m_fY, 0.0f);
        m_CollisionScene.Remove(CGEngine.m_PaddleObject.m_CollisionObject);
        m_CollisionScene.Remove(CGEngine.m_PaddleObject.m_CollisionObjectAlt);
        m_Board.RemoveByID(1000000);
        if (m_Ball != null) {
            for (int i = 0; i < m_Ball.length; ++i) {
                if (m_Ball[i] == null) continue;
                CGDynamicObj.AddToCurrentDynamics("block_teleport_in.do", (float)CGEngine.m_Ball[i].vecPos.x, (float)CGEngine.m_Ball[i].vecPos.y, 0.0f);
                CGEngine.m_Ball[i].m_fVelocity = 0.0;
                CGEngine.m_Ball[i].bRenderBall = false;
            }
        }
    }

    public static void Render() {
        if (m_bGameActive) {
            CGEngineRenderer.RenderBackground();
            m_Board.Render();
            CGEngineRenderer.RenderHUD();
            for (int i = 0; i < 3; ++i) {
                if (m_Ball[i] == null) continue;
                m_Ball[i].Render();
            }
            CGFallingPowerUp.RenderAll();
            CGHit.RenderAll();
        }
        CGDynamicObj.StepCurrentDynamics(m_nUpdateDeltaTime);
    }

    public static void EventWin() {
        if (!m_bGameOver) {
            m_bGameOver = true;
            m_nGameOverDelay = 2000;
            m_nGameResult = 1;
            CGHit.NewHit(8, 240.0f, 400.0f, 1400L);
        }
    }

    public static void EventLost(boolean bPlaySound) {
        if (!m_bGameOver) {
            m_bGameOver = true;
            m_nGameOverDelay = 2000;
            m_nGameResult = -1;
            if (m_nGameMode == 1) {
                CGHit.NewHit(9, 240.0f, 400.0f, 1400L);
            } else if (m_nGameMode == 2) {
                CGHit.NewHit(7, 240.0f, 400.0f, 1400L);
            } else if (m_nGameMode == 3) {
                CGHit.NewHit(6, 240.0f, 400.0f, 1400L);
            }
            if (bPlaySound) {
                // empty if block
            }
        }
    }

    public static float AngleFromVector(float dx, float dy) {
        if (dx == 0.0f && dy == 0.0f) {
            return -3000.0f;
        }
        float vec1_X = 0.0f;
        float vec1_Y = -1.0f;
        float fLength = dx * dx + dy * dy;
        if (fLength <= 1.0E-6f) {
            return -3000.0f;
        }
        fLength = (float)Math.sqrt(fLength);
        float vec2_X = dx / fLength;
        float vec2_Y = dy / fLength;
        float fCos = vec1_X * vec2_X + vec1_Y * vec2_Y;
        float fAngle = (float)MathExt.acos(fCos);
        fAngle *= 57.29579f;
        if (dx < 0.0f) {
            fAngle = 360.0f - fAngle;
        }
        if (fAngle < 0.0f) {
            fAngle += 360.0f;
        }
        return fAngle;
    }

    public static void resetBoostModifications() {
        m_PaddleScale = 1.0f;
        CGBall.m_BaseVelocity = 400.0;
        bIsTimeSlowMotion = false;
        CGBall.isSuperBall = false;
        CGBall.isMagnetoOn = false;
    }

    private static void destroyBallAndDeck() {
        CGDynamicObj.AddToCurrentDynamics("deck_destroy.do", (float)(CGEngine.m_PaddleObject.m_fX - CGEngine.m_PaddleObject.m_fW / 2.0), (float)(CGEngine.m_PaddleObject.m_fY + CGEngine.m_PaddleObject.m_fH / 2.0), 0.0f);
        CGDynamicObj.AddToCurrentDynamics("deck_destroy.do", (float)(CGEngine.m_PaddleObject.m_fX + CGEngine.m_PaddleObject.m_fW / 2.0), (float)(CGEngine.m_PaddleObject.m_fY + CGEngine.m_PaddleObject.m_fH / 2.0), 0.0f);
        m_CollisionScene.Remove(CGEngine.m_PaddleObject.m_CollisionObject);
        m_CollisionScene.Remove(CGEngine.m_PaddleObject.m_CollisionObjectAlt);
        m_Board.RemoveByID(1000000);
        for (int i = 0; i < m_Ball.length; ++i) {
            if (m_Ball[i] == null) continue;
            CGDynamicObj.AddToCurrentDynamics("block_teleport_out.do", (float)CGEngine.m_Ball[i].vecPos.x, (float)CGEngine.m_Ball[i].vecPos.y, 0.0f);
            CGEngine.m_Ball[i] = null;
        }
    }

    private static void setBallAndDeck() {
        if (m_PaddleObject != null) {
            m_CollisionScene.Remove(CGEngine.m_PaddleObject.m_CollisionObject);
            m_CollisionScene.Remove(CGEngine.m_PaddleObject.m_CollisionObjectAlt);
            m_Board.RemoveByID(1000000);
            m_PaddleObject = null;
        }
        m_PaddleObject = new PaddleObject();
        m_PaddleObject.Init(240.0, 650.0, 140.0, 31.200000000000003, 100, 1000000, m_PaddleScale);
        CGEngine.m_Ball[0] = new CGBall();
        CGEngine.m_Ball[0].isReady = false;
        m_Ball[0].SetPos((float)CGEngine.m_PaddleObject.centerXforBall, (float)CGEngine.m_PaddleObject.centerYforBall);
    }

    public static void startBallAfterTap(float fX, float fY) {
        for (int i = 0; i < m_Ball.length; ++i) {
            if (m_Ball[i] == null || m_PaddleObject == null || !((double)fY < CGEngine.m_PaddleObject.m_fY)) continue;
            if ((double)fX < CGEngine.m_Ball[i].vecPos.x) {
                if (CGEngine.m_Ball[i].isReady) continue;
                m_Ball[i].ShootBall(-(CGEngine.m_Ball[i].vecPos.x - (double)fX), -(CGEngine.m_Ball[i].vecPos.y - (double)fY));
                continue;
            }
            if (!((double)fX >= CGEngine.m_Ball[i].vecPos.x) || CGEngine.m_Ball[i].isReady) continue;
            m_Ball[i].ShootBall(-(CGEngine.m_Ball[i].vecPos.x - (double)fX), -(CGEngine.m_Ball[i].vecPos.y - (double)fY));
        }
    }

    private static int CountBalls() {
        int nC = 0;
        for (int i = 0; i < 3; ++i) {
            if (m_Ball[i] == null || m_Ball[i].bIsLifeLost()) continue;
            ++nC;
        }
        return nC;
    }

    public static void fillUp3Balls() {
        int balls = CGEngine.CountBalls();
        if (balls < 1) {
            return;
        }
        int ball_ID = CGEngine.findIDofBall();
        if (ball_ID == 0 && balls == 2) {
            int emptyBallID = CGEngine.findEmptyBallSlot();
            CGEngine.m_Ball[emptyBallID] = new CGBall();
            m_Ball[emptyBallID].SetPos((float)CGEngine.m_Ball[0].vecPos.x, (float)CGEngine.m_Ball[0].vecPos.y);
            m_Ball[emptyBallID].cloneSettingsOfBall(m_Ball[0]);
            if (!CGEngine.m_Ball[0].isBallFalling && CGEngine.m_Ball[0].isReady) {
                m_Ball[emptyBallID].ShootBall(CGEngine.m_Ball[0].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[0].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
            } else if (CGEngine.m_Ball[0].isReady) {
                m_Ball[emptyBallID].ShootBall(CGEngine.m_Ball[0].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[0].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
            }
        } else if (ball_ID == 0 && balls == 1) {
            CGEngine.m_Ball[1] = new CGBall();
            CGEngine.m_Ball[2] = new CGBall();
            m_Ball[1].cloneSettingsOfBall(m_Ball[0]);
            m_Ball[2].cloneSettingsOfBall(m_Ball[0]);
            m_Ball[1].SetPos((float)CGEngine.m_Ball[0].vecPos.x, (float)CGEngine.m_Ball[0].vecPos.y);
            m_Ball[2].SetPos((float)CGEngine.m_Ball[0].vecPos.x, (float)CGEngine.m_Ball[0].vecPos.y);
            if (!CGEngine.m_Ball[0].isBallFalling && CGEngine.m_Ball[0].isReady) {
                m_Ball[1].ShootBall(CGEngine.m_Ball[0].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[0].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
                m_Ball[2].ShootBall(CGEngine.m_Ball[0].vecTarget.x - (double)CGBall.eRadius, CGEngine.m_Ball[0].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
            } else if (CGEngine.m_Ball[0].isReady) {
                m_Ball[1].ShootBall(CGEngine.m_Ball[0].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[0].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
                m_Ball[2].ShootBall(CGEngine.m_Ball[0].vecTarget.x - (double)CGBall.eRadius, CGEngine.m_Ball[0].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
            }
        } else if (ball_ID == 1 && balls == 2) {
            int emptyBallID = CGEngine.findEmptyBallSlot();
            CGEngine.m_Ball[emptyBallID] = new CGBall();
            m_Ball[emptyBallID].cloneSettingsOfBall(m_Ball[1]);
            m_Ball[emptyBallID].SetPos((float)CGEngine.m_Ball[1].vecPos.x, (float)CGEngine.m_Ball[1].vecPos.y);
            if (!CGEngine.m_Ball[1].isBallFalling && CGEngine.m_Ball[1].isReady) {
                m_Ball[emptyBallID].ShootBall(CGEngine.m_Ball[1].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[1].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
            } else if (CGEngine.m_Ball[1].isReady) {
                m_Ball[emptyBallID].ShootBall(CGEngine.m_Ball[1].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[1].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
            }
        } else if (ball_ID == 1 && balls == 1) {
            CGEngine.m_Ball[0] = new CGBall();
            CGEngine.m_Ball[2] = new CGBall();
            m_Ball[0].cloneSettingsOfBall(m_Ball[1]);
            m_Ball[2].cloneSettingsOfBall(m_Ball[1]);
            m_Ball[0].SetPos((float)CGEngine.m_Ball[1].vecPos.x, (float)CGEngine.m_Ball[1].vecPos.y);
            m_Ball[2].SetPos((float)CGEngine.m_Ball[1].vecPos.x, (float)CGEngine.m_Ball[1].vecPos.y);
            if (!CGEngine.m_Ball[1].isBallFalling && CGEngine.m_Ball[1].isReady) {
                m_Ball[0].ShootBall(CGEngine.m_Ball[1].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[1].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
                m_Ball[2].ShootBall(CGEngine.m_Ball[1].vecTarget.x - (double)CGBall.eRadius, CGEngine.m_Ball[1].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
            } else if (CGEngine.m_Ball[1].isReady) {
                m_Ball[0].ShootBall(CGEngine.m_Ball[1].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[1].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
                m_Ball[2].ShootBall(CGEngine.m_Ball[1].vecTarget.x - (double)CGBall.eRadius, CGEngine.m_Ball[1].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
            }
        } else if (ball_ID == 2 && balls == 2) {
            int emptyBallID = CGEngine.findEmptyBallSlot();
            CGEngine.m_Ball[emptyBallID] = new CGBall();
            m_Ball[emptyBallID].cloneSettingsOfBall(m_Ball[2]);
            m_Ball[emptyBallID].SetPos((float)CGEngine.m_Ball[2].vecPos.x, (float)CGEngine.m_Ball[2].vecPos.y);
            if (!CGEngine.m_Ball[2].isBallFalling && CGEngine.m_Ball[2].isReady) {
                m_Ball[emptyBallID].ShootBall(CGEngine.m_Ball[2].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[2].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
            } else if (CGEngine.m_Ball[2].isReady) {
                m_Ball[emptyBallID].ShootBall(CGEngine.m_Ball[2].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[2].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
            }
        } else if (ball_ID == 2 && balls == 1) {
            CGEngine.m_Ball[0] = new CGBall();
            CGEngine.m_Ball[1] = new CGBall();
            m_Ball[0].cloneSettingsOfBall(m_Ball[2]);
            m_Ball[1].cloneSettingsOfBall(m_Ball[2]);
            m_Ball[0].SetPos((float)CGEngine.m_Ball[2].vecPos.x, (float)CGEngine.m_Ball[2].vecPos.y);
            m_Ball[1].SetPos((float)CGEngine.m_Ball[2].vecPos.x, (float)CGEngine.m_Ball[2].vecPos.y);
            if (!CGEngine.m_Ball[2].isBallFalling && CGEngine.m_Ball[2].isReady) {
                m_Ball[0].ShootBall(CGEngine.m_Ball[2].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[2].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
                m_Ball[1].ShootBall(CGEngine.m_Ball[2].vecTarget.x - (double)CGBall.eRadius, CGEngine.m_Ball[2].vecTarget.y - (double)(CGBall.eRadius * 4.0f));
            } else if (CGEngine.m_Ball[2].isReady) {
                m_Ball[0].ShootBall(CGEngine.m_Ball[2].vecTarget.x + (double)CGBall.eRadius, CGEngine.m_Ball[2].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
                m_Ball[1].ShootBall(CGEngine.m_Ball[2].vecTarget.x - (double)CGBall.eRadius, CGEngine.m_Ball[2].vecTarget.y + (double)(CGBall.eRadius * 4.0f));
            }
        }
    }

    private static int findIDofBall() {
        for (int i = 0; i < 3; ++i) {
            if (m_Ball[i] == null) continue;
            return i;
        }
        return 0;
    }

    private static int findEmptyBallSlot() {
        for (int i = 0; i < 3; ++i) {
            if (m_Ball[i] != null) continue;
            return i;
        }
        return -1;
    }

    static {
        m_nGameResult = 0;
        m_nParams_CurrentLevelInitScore = 0;
        m_nParams_CurrentLevelInitTime = 0;
        m_fEngineScale = 1.0f;
        m_bPause = false;
        m_nEngineTime = 0;
        m_nUpdateDeltaTime = 0;
        m_bEngineChangeAxis = true;
        m_LevelScenarioSurvivalManager = null;
        m_CollisionScene = null;
        m_Ball = null;
        m_PaddleObject = null;
    }
}

