/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.GameObject;
import baltorogames.project_gameplay.LevelScenario;
import baltorogames.system.Platform;
import java.util.Vector;

public class CGBoard {
    public static final int POINTS_NORMAL = 100;
    public static final int POINTS_WITH_POWERDOWN = 200;
    public static final int POINTS_POWERUP = 50;
    public static final int POWERUP_TIME_INTERVAL = 1500;
    public static final int eGridSizeX = 6;
    public static final int eGridSizeY = 15;
    public static final int eBlockWidth = 70;
    public static final int eBlockHeight = 24;
    public static final int eBoardStartX = 30;
    public static final int eBoardStopX = 450;
    public static final int eBoardStartY = Platform.eBoardMarginUp;
    public int m_DestructableLeft = 0;
    public static int[][] tableOfBombNeighborsCords = new int[][]{{-1, -1}, {0, -1}, {1, -1}, {-1, 0}, {0, 0}, {1, 0}, {-1, 1}, {0, 1}, {1, 1}};
    public static int probabilityOfPowerUp = 0;
    private Vector m_arrObjects = null;
    public static double eSurvivalDeadLineY = 600.0;
    public static int eNrOfSurvivalLevels = 10;
    public static int eNrOfTimedLevels = 10;
    public static int eSurvivalStartStepTimestamp = 6000;
    public static int eSurvivalNextStepTimestamp = 100;
    public static int eSurvivalMinStepTimestamp = 2000;
    public static int eTimedStartTime = 80000;
    public static int eTimedIncementValue = 10000;
    public int timedModeResult = -1;
    protected LevelScenario[] m_SurvivalLevels = null;
    protected int m_CurrentSurvivalLevel = -1;
    protected int m_CurrentSurvivalLevelLine = 0;
    public int m_nSurvivalStepsCounter = 0;
    public CGDynamicObj m_nDeadLineParticle = null;

    public static void Init() {
    }

    public CGBoard(LevelScenario ls) {
        this.LoadLevel(ls, true);
    }

    public void LoadLevel(LevelScenario ls, boolean bNewArray) {
        if (bNewArray) {
            this.m_arrObjects = new Vector();
        }
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 15; ++y) {
                if (ls.m_Data[x][y] <= '\u0000') continue;
                GameObject go = new GameObject();
                float xx = 30 + x * 70;
                float yy = eBoardStartY + y * 24;
                int nID = y * 6 + x;
                go.Init(xx, yy, 70.0, 24.0, ls.m_Data[x][y], nID);
                go.setObjectCords(x, y);
                this.m_arrObjects.addElement(go);
                if (go.m_nType <= 9) {
                    go.m_CollisionObject.isOrdinary = true;
                }
                if (go.m_nType == 10) {
                    go.m_nCollisionCounter = 4;
                } else if (go.m_nType == 11) {
                    go.m_nCollisionCounter = 1000000;
                    go.m_bPermanent = true;
                } else if (go.m_nType != 12) {
                    if (go.m_nType == 13) {
                        go.m_nCollisionCounter = 1000000;
                    } else if (go.m_nType == 16) {
                        go.m_nCollisionCounter = 1000000;
                        go.m_bPermanent = true;
                        go.m_CollisionObject.isPortal = true;
                    } else if (go.m_nType == 14) {
                        go.m_fMaxDX = 140.0;
                        go.m_fMaxDY = 0.0;
                        go.m_fMoveXPerSec = 70.0;
                        go.m_fMoveYPerSec = 0.0;
                        go.m_nCollisionCounter = 1;
                    } else if (go.m_nType == 15) {
                        go.m_fMaxDX = 0.0;
                        go.m_fMaxDY = 96.0;
                        go.m_fMoveXPerSec = 0.0;
                        go.m_fMoveYPerSec = 48.0;
                        go.m_nCollisionCounter = 1;
                    }
                }
                if (go.m_bPermanent) continue;
                ++this.m_DestructableLeft;
            }
        }
    }

    public void AddObject(GameObject go) {
        this.m_arrObjects.addElement(go);
    }

    public void RemoveByID(int nID) {
        if (this.m_arrObjects == null) {
            return;
        }
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            GameObject go = (GameObject)this.m_arrObjects.elementAt(i);
            if (go.m_nID != nID) continue;
            go.Destroy();
            this.m_arrObjects.removeElementAt(i);
            return;
        }
    }

    public void RemoveBombBlock(int bombID) {
        if (this.m_arrObjects == null) {
            return;
        }
        GameObject go = this.GetObjectByID(bombID);
        int centerX = go.m_nCordOnBoardX;
        int centerY = go.m_nCordOnBoardY;
        CGDynamicObj.AddToCurrentDynamics("block_exp_boom.do", go.m_CenterX, (float)((double)go.m_CenterY + go.m_fH), 0.0f);
        block0: for (int i = 0; i < 9; ++i) {
            go = this.GetObjectByCords(centerX + tableOfBombNeighborsCords[i][0], centerY + tableOfBombNeighborsCords[i][1]);
            if (go == null) continue;
            for (int j = 0; j < 3; ++j) {
                if (CGEngine.m_Ball[j] == null) continue;
                go.CollisionAction(j, true);
                continue block0;
            }
        }
    }

    public void removeBlockLinesInSurvival(int startLine) {
        if (this.m_arrObjects == null) {
            return;
        }
        for (int i = startLine; i < 15; ++i) {
            for (int j = 0; j < 6; ++j) {
                int id = i * 6 + j;
                GameObject go = this.GetObjectByID(id);
                if (go == null) continue;
                try {
                    this.RemoveByID(id);
                    CGEngine.m_CollisionScene.Remove(go.m_CollisionObject);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public GameObject GetObjectByID(int nID) {
        if (this.m_arrObjects == null) {
            return null;
        }
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            GameObject go = (GameObject)this.m_arrObjects.elementAt(i);
            if (go.m_nID != nID) continue;
            return go;
        }
        return null;
    }

    public GameObject GetObjectByCords(int cordX, int cordY) {
        if (this.m_arrObjects == null) {
            return null;
        }
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            GameObject go = (GameObject)this.m_arrObjects.elementAt(i);
            if (go.m_nCordOnBoardX != cordX || go.m_nCordOnBoardY != cordY) continue;
            return go;
        }
        return null;
    }

    public void PreUpdate(int nDeltatTimeinMs) {
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            GameObject go = (GameObject)this.m_arrObjects.elementAt(i);
            go.PreUpdate(nDeltatTimeinMs);
        }
    }

    public void Update(int nDeltatTimeinMs) {
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            GameObject go = (GameObject)this.m_arrObjects.elementAt(i);
            go.Update(nDeltatTimeinMs);
        }
    }

    public void Render() {
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            GameObject go = (GameObject)this.m_arrObjects.elementAt(i);
            go.Render();
        }
    }

    public int numberOfDestructableBlock() {
        return this.m_DestructableLeft;
    }

    public int findSecondPortal(int IDofFirstPortal) {
        if (this.m_arrObjects == null) {
            return -1;
        }
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            GameObject go = (GameObject)this.m_arrObjects.elementAt(i);
            if (go.m_nType != 16 || go.m_nID == IDofFirstPortal) continue;
            return go.m_nID;
        }
        return -1;
    }

    public int CheckGameIsOver() {
        if (CGLevelStats.m_nLifes <= 0) {
            return -1;
        }
        if (this.numberOfDestructableBlock() > 0) {
            return 0;
        }
        if (CGEngine.m_nGameMode == 1) {
            int nLevel = CGEngine.m_nCurrentGalaxy * 12 + CGEngine.m_nCurrentLevel;
            int currentNumberOfStars = CGUserCareer.arrLevelStats[nLevel].m_nStars;
            int numStars = 1;
            if (CGLevelStats.m_nLostBalls >= 2 && CGLevelStats.m_nLostBalls <= 3) {
                numStars = 2;
            } else if (CGLevelStats.m_nLostBalls <= 1) {
                numStars = 3;
            }
            if (numStars > currentNumberOfStars) {
                CGUserCareer.arrLevelStats[nLevel].m_nStars = numStars;
            }
            CGUserCareer.arrLevelStats[nLevel].m_nScore = (int)(1.0f / (float)CGUserCareer.arrLevelStats[nLevel].m_nTime * 1000.0f * (float)CGLevelStats.m_nLifes);
            CGLevelStats.m_nScore += CGLevelStats.m_nLifes * 400;
            if ((CGLevelStats.m_nScore += 20000 / CGLevelStats.m_nTime) > CGUserCareer.m_arrLevelBestScore[nLevel] || CGUserCareer.m_arrLevelBestScore[nLevel] == 0) {
                CGUserCareer.m_arrLevelBestScore[nLevel] = CGLevelStats.m_nScore;
            }
            if (CGLevelStats.m_nLostBalls <= 0) {
                CGAchievements.completeAchievement(1);
            }
            if (!CGLevelStats.m_nDidAnyPowersTaken && CGUserCareer.GetAdventureLevel() >= 3) {
                CGAchievements.completeAchievement(2);
            }
        }
        return 1;
    }

    public CGBoard() {
    }

    public void LoadSurvivalLevels() {
        this.m_SurvivalLevels = new LevelScenario[eNrOfSurvivalLevels];
        for (int i = 0; i < eNrOfSurvivalLevels; ++i) {
            this.m_SurvivalLevels[i] = new LevelScenario();
            String fileName = "/map_survival_" + (i + 1) + ".txt";
            this.m_SurvivalLevels[i].Load(fileName);
        }
    }

    public void PrepareSurvival() {
        this.LoadSurvivalLevels();
        int nRandomStartLevel = RandSync.nextInt() % eNrOfSurvivalLevels;
        this.LoadLevel(this.m_SurvivalLevels[nRandomStartLevel], true);
        this.m_CurrentSurvivalLevel = RandSync.nextInt() % eNrOfSurvivalLevels;
        this.m_CurrentSurvivalLevelLine = 14;
        this.m_nSurvivalStepsCounter = 0;
    }

    protected void AddSurvivalLine() {
        LevelScenario ls = this.m_SurvivalLevels[this.m_CurrentSurvivalLevel];
        for (int x = 0; x < 6; ++x) {
            if (ls.m_Data[x][this.m_CurrentSurvivalLevelLine] <= '\u0000') continue;
            GameObject go = new GameObject();
            int y = 0;
            float xx = 30 + x * 70;
            float yy = eBoardStartY + y * 24;
            int nID = y * 6 + x;
            go.Init(xx, yy, 70.0, 24.0, ls.m_Data[x][this.m_CurrentSurvivalLevelLine], nID);
            go.setObjectCords(x, y);
            this.m_arrObjects.addElement(go);
            if (go.m_nType <= 9) {
                go.m_CollisionObject.isOrdinary = true;
            }
            if (go.m_nType == 10) {
                go.m_nCollisionCounter = 4;
            } else if (go.m_nType == 11) {
                go.m_nCollisionCounter = 1000000;
                go.m_bPermanent = true;
            } else if (go.m_nType != 12) {
                if (go.m_nType == 13) {
                    go.m_nCollisionCounter = 1000000;
                } else if (go.m_nType == 16) {
                    go.m_nCollisionCounter = 1000000;
                    go.m_bPermanent = true;
                    go.m_CollisionObject.isPortal = true;
                } else if (go.m_nType == 14) {
                    go.m_fMaxDX = 140.0;
                    go.m_fMaxDY = 0.0;
                    go.m_fMoveXPerSec = 70.0;
                    go.m_fMoveYPerSec = 0.0;
                    go.m_nCollisionCounter = 1;
                } else if (go.m_nType == 15) {
                    go.m_fMaxDX = 0.0;
                    go.m_fMaxDY = 96.0;
                    go.m_fMoveXPerSec = 0.0;
                    go.m_fMoveYPerSec = 48.0;
                    go.m_nCollisionCounter = 1;
                }
            }
            if (go.m_bPermanent) continue;
            ++this.m_DestructableLeft;
        }
    }

    public int ActionDown() {
        if (this.m_arrObjects == null) {
            return 1;
        }
        double fMaxY = 0.0;
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            GameObject go = (GameObject)this.m_arrObjects.elementAt(i);
            if (go.m_CollisionObject.m_nObjectID == 1000000) continue;
            go.m_fY += 24.0;
            go.m_fStartY += 24.0;
            go.m_CollisionObject.m_fY += 24.0;
            go.m_nID += 6;
            go.incObjectCordsY();
            go.m_CollisionObject.m_nObjectID = go.m_nID;
            if (!(go.m_fY > fMaxY)) continue;
            fMaxY = go.m_fY;
        }
        if (fMaxY >= eSurvivalDeadLineY) {
            return -1;
        }
        if (this.m_CurrentSurvivalLevelLine > 0) {
            this.AddSurvivalLine();
            --this.m_CurrentSurvivalLevelLine;
            ++this.m_nSurvivalStepsCounter;
        } else {
            this.m_CurrentSurvivalLevel = RandSync.nextInt() % eNrOfSurvivalLevels;
            this.m_CurrentSurvivalLevelLine = 14;
            this.AddSurvivalLine();
            --this.m_CurrentSurvivalLevelLine;
            ++this.m_nSurvivalStepsCounter;
        }
        return 1;
    }

    public void LoadTimedLevels() {
        this.m_SurvivalLevels = new LevelScenario[eNrOfTimedLevels];
        for (int i = 0; i < eNrOfTimedLevels; ++i) {
            this.m_SurvivalLevels[i] = new LevelScenario();
            String fileName = "/map_timed_" + (i + 1) + ".txt";
            this.m_SurvivalLevels[i].Load(fileName);
        }
    }

    public void PrepareTimed() {
        this.LoadTimedLevels();
        int nRandomStartLevel = RandSync.nextInt() % eNrOfTimedLevels;
        this.LoadLevel(this.m_SurvivalLevels[nRandomStartLevel], true);
    }

    public boolean IsBoardEmpty() {
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            GameObject go = (GameObject)this.m_arrObjects.elementAt(i);
            if (go.m_CollisionObject.m_nObjectID == 1000000) continue;
            return false;
        }
        return true;
    }

    public void CheckNewTimedLevel() {
        if (this.IsBoardEmpty()) {
            System.out.println("CheckNewTimedLevel 2...");
            boolean bOK = true;
            for (int i = 0; i < 3; ++i) {
                if (CGEngine.m_Ball[i] == null || !(CGEngine.m_Ball[i].vecPos.y < (double)(eBoardStartY + 384))) continue;
                bOK = false;
            }
            if (bOK) {
                System.out.println("CheckNewTimedLevel 3...");
                int nRandomStartLevel = RandSync.nextInt() % eNrOfTimedLevels;
                this.LoadLevel(this.m_SurvivalLevels[nRandomStartLevel], false);
            }
        }
    }
}

