/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class NewPowerupInfoScreen
extends MainScreen {
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public static int selectedPowerup = 0;
    private int nStartBoxY = 0;
    private int nStopBoxY = 0;
    private int nBoxWidth = 0;
    private UIFloatingTextBox infoBox;
    private String csText1;
    private String csText2;
    private String csText3;
    private CGTexture powerupImage = null;

    protected void Clean() {
        TextureManager.DeleteTexture(this.powerupImage);
        this.powerupImage = null;
    }

    public void onFocusBack() {
        super.onFocusBack();
        if (selectedPowerup == 0) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_freeze.png");
        } else if (selectedPowerup == 1) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_reverse.png");
        } else if (selectedPowerup == 2) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_bomb.png");
        } else if (selectedPowerup == 3) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_laser.png");
        } else if (selectedPowerup == 4) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_swap.png");
        } else if (selectedPowerup == 5) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_laser.png");
        } else if (selectedPowerup == 6) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_uniball.png");
        } else if (selectedPowerup == 7) {
            this.powerupImage = TextureManager.AddTexture("/menu/shop_upgrade_empty.png");
        } else if (selectedPowerup == 8) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_multi.png");
        }
    }

    public NewPowerupInfoScreen(int nPowerupIndex) {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        CGEngine.m_bPause = true;
        selectedPowerup = nPowerupIndex;
        this.drawTop = true;
        this.drawTitle = true;
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_HEADER_HELP"));
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        if (selectedPowerup == 0) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_freeze.png");
        } else if (selectedPowerup == 1) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_reverse.png");
        } else if (selectedPowerup == 2) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_bomb.png");
        } else if (selectedPowerup == 3) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_laser.png");
        } else if (selectedPowerup == 4) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_swap.png");
        } else if (selectedPowerup == 5) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_laser.png");
        } else if (selectedPowerup == 6) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_uniball.png");
        } else if (selectedPowerup == 7) {
            this.powerupImage = TextureManager.AddTexture("/menu/shop_upgrade_empty.png");
        } else if (selectedPowerup == 8) {
            this.powerupImage = TextureManager.AddTexture("/menu/p_multi.png");
        }
        int trackIconX = ApplicationData.screenWidth / 2 - this.powerupImage.GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 2 - this.powerupImage.GetHeight();
        int arrowsY = trackIconY + this.powerupImage.GetHeight() / 2 - ObjectsCache.arrowLeft.GetHeight() / 2;
        int arrowLeftX = ApplicationData.screenWidth / 2 - this.powerupImage.GetWidth() - ObjectsCache.arrowLeft.GetWidth();
        int arrowRightX = ApplicationData.screenWidth / 2 + this.powerupImage.GetWidth();
        this.nStartBoxY = arrowsY + ApplicationData.getFontByID(0).getFontHeight();
        this.nStopBoxY = ApplicationData.screenHeight - ObjectsCache.menuSbOK.GetHeight() - ApplicationData.getFontByID(0).getFontHeight() - ApplicationData.getFontByID(0).getFontHeight() / 4;
        this.nBoxWidth = ApplicationData.screenWidth;
        this.infoBox = new UIFloatingTextBox(false, (ApplicationData.screenWidth - this.nBoxWidth) / 2, this.nStartBoxY, this.nBoxWidth, this.nStopBoxY - this.nStartBoxY);
        this.updateAchievementInfo();
    }

    private void updateAchievementInfo() {
        this.csText1 = ApplicationData.defaultFont.encodeDynamicString("" + (selectedPowerup + 1) + " / " + 12);
        this.csText2 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_POWERUP_SHORT_DESCRIPTION_" + selectedPowerup);
        this.infoBox.setText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_POWERUP_FULL_DESCRIPTION_" + selectedPowerup));
    }

    public void autoSize() {
    }

    public void draw() {
        int trackIconX = ApplicationData.screenWidth / 2 - this.powerupImage.GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 2 - this.powerupImage.GetHeight();
        Graphic2D.DrawImage(this.powerupImage, trackIconX, trackIconY, 20);
        Utils.drawString(this.csText2, ApplicationData.screenWidth >> 1, trackIconY - ApplicationData.getFontByID(0).getFontHeight() / 4, 33, 0);
        this.infoBox.draw();
    }

    public boolean rightSoftButton() {
        this.Clean();
        CGEngine.m_bPause = false;
        UIScreen.SetCurrentScreen(null);
        return true;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean selectLeftAction() {
        return false;
    }

    public boolean selectRightAction() {
        return false;
    }

    public boolean onRightAction() {
        return false;
    }

    public boolean onLeftAction() {
        return false;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }
}

