/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;

public class LoadingLevelScreen
extends MainScreen {
    private static final int MAX_NUM_LOADING_HINTS = 4;
    private static final int NUM_PLAYED_GAMES_WE_NEED_MORE_INFO = 10;
    private static final int LEFT_RIGHT_MARGIN = 5;
    private static int numPlayedGames = 0;
    private static Random rnd = new Random();
    private int counterDraw = 0;
    private int fontID = 0;
    protected int ballDistance = 0;
    protected int loadingBallStep = 0;
    protected int ballsFilled = 0;
    protected int centerX = 0;
    protected int bottomY = 0;
    protected int fontHeight = ApplicationData.getFontByID(this.fontID).getFontHeight();
    private Vector textLines = new Vector();

    public LoadingLevelScreen() {
        this.drawTop = false;
        this.drawTitle = false;
        ApplicationData.soundEngine.stopMID();
        this.centerX = ApplicationData.screenWidth / 2 - ObjectsCache.loadingBar[0].GetWidth() * 3;
        this.bottomY = ApplicationData.screenHeight - ObjectsCache.loadingBar[0].GetHeight() * 2;
        int nNr = Math.abs(ApplicationData.rnd.nextInt()) % 4;
        this.setText("");
        this.loadingBallStep = 8;
        this.ballDistance = ObjectsCache.loadingBar[0].GetWidth();
        this.setupDrawingArea();
    }

    public void updateSize() {
    }

    public void drawWindowBackground() {
        super.drawWindowBackground();
    }

    public void drawWindowForeground() {
    }

    public static void deSerialize(DataInputStream dis) throws IOException {
        numPlayedGames = dis.readInt();
    }

    public static void serialize(DataOutputStream dos) throws IOException {
        dos.writeInt(numPlayedGames);
    }

    private void setupDrawingArea() {
    }

    public void setText(String newText, String separator) {
        int nLeft = 0;
        int nRight = ApplicationData.screenWidth;
        this.textLines = Utils.splitText(newText, separator, nRight - nLeft, this.fontID);
    }

    public void setText(String newText) {
        this.setText(newText, "+");
    }

    public void draw() {
        int i;
        Graphic2D.DrawImage(ObjectsCache.loadingBarBkg, ApplicationData.screenWidth / 2, this.bottomY, 3);
        for (i = 0; i < 6; ++i) {
            Graphic2D.DrawImage(ObjectsCache.loadingBar[0], this.centerX + this.ballDistance * i, this.bottomY, 6);
        }
        for (i = 0; i < this.ballsFilled; ++i) {
            Graphic2D.DrawImage(ObjectsCache.loadingBarFull[0], this.centerX + this.ballDistance * i, this.bottomY, 6);
        }
        int nL = this.textLines.size();
        int y = ApplicationData.screenHeight / 2;
        y -= nL * this.fontHeight / 2;
        for (int i2 = 0; i2 < nL; ++i2) {
            Utils.drawString((String)this.textLines.elementAt(i2), ApplicationData.screenWidth / 2, y, 17, 0);
            y += this.fontHeight;
        }
        if (this.counterDraw == 21) {
            // empty if block
        }
        if (this.counterDraw < 50) {
            ++this.counterDraw;
        }
        ApplicationData.generalGameMode = 3;
    }

    public void onUpdate(float deltaTime) {
        for (int i = 1; i <= 6; ++i) {
            if (this.counterDraw != this.loadingBallStep * i) continue;
            this.ballsFilled = i;
        }
        if (this.counterDraw >= 50) {
            String fileName = "/map_1_1.lrs";
            if (CGEngine.m_nSurvivalLevel >= 0 || CGEngine.m_nGameMode == 3) {
                fileName = "/map_1_1.lrs";
            }
            ApplicationData.getGame().startLoading(fileName);
            ApplicationData.getGame().stepLoading(fileName);
            ApplicationData.getGame().stepLoading(fileName);
            ApplicationData.getGame().stepLoading(fileName);
            ApplicationData.getGame().stepLoading(fileName);
            ApplicationData.getGame().endLoading(fileName);
            ApplicationData.generalGameMode = 4;
            UIScreen.SetCurrentScreen(null);
        }
    }
}

