/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.util.Vector;

public class AchievementsScreen
extends MainScreen {
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public static int selectedAchiev = 0;
    private Vector headerText = null;
    private int nStartBoxY = 0;
    private int nStopBoxY = 0;
    private int nBoxWidth = 0;
    private UIFloatingTextBox infoBox;
    private String csText1;
    private String csText2;
    private String[] achiHeaders = new String[]{"TID_ACHIEVEMENT_HEADER_0", "TID_ACHIEVEMENT_HEADER_1", "TID_ACHIEVEMENT_HEADER_2", "TID_ACHIEVEMENT_HEADER_5", "TID_ACHIEVEMENT_HEADER_6", "TID_ACHIEVEMENT_HEADER_7", "TID_ACHIEVEMENT_HEADER_8", "TID_ACHIEVEMENT_HEADER_9", "TID_ACHIEVEMENT_HEADER_10", "TID_ACHIEVEMENT_HEADER_11", "TID_ACHIEVEMENT_HEADER_12", "TID_ACHIEVEMENT_HEADER_13"};
    private String[] achiDescript = new String[]{"TID_ACHIEVEMENT_LONG_DESCRIPTION_0", "TID_ACHIEVEMENT_LONG_DESCRIPTION_1", "TID_ACHIEVEMENT_LONG_DESCRIPTION_2", "TID_ACHIEVEMENT_LONG_DESCRIPTION_5", "TID_ACHIEVEMENT_LONG_DESCRIPTION_6", "TID_ACHIEVEMENT_LONG_DESCRIPTION_7", "TID_ACHIEVEMENT_LONG_DESCRIPTION_8", "TID_ACHIEVEMENT_LONG_DESCRIPTION_9", "TID_ACHIEVEMENT_LONG_DESCRIPTION_10", "TID_ACHIEVEMENT_LONG_DESCRIPTION_11", "TID_ACHIEVEMENT_LONG_DESCRIPTION_12", "TID_ACHIEVEMENT_LONG_DESCRIPTION_13"};
    private CGTexture[] achievImages = null;

    protected void Clean() {
        for (int i = 0; i < 2; ++i) {
            TextureManager.DeleteTexture(this.achievImages[i]);
            this.achievImages[i] = null;
        }
        this.achievImages = null;
    }

    public void onFocusBack() {
        super.onFocusBack();
        if (this.achievImages == null) {
            this.achievImages = new CGTexture[2];
            this.achievImages[0] = TextureManager.AddTexture("/menu/a_achive_on.png");
            this.achievImages[1] = TextureManager.AddTexture("/menu/a_achive_of.png");
        }
    }

    public AchievementsScreen() {
        int arrowRightX;
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        selectedAchiev = 0;
        this.drawTop = true;
        this.drawTitle = false;
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENTS"));
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        this.achievImages = new CGTexture[2];
        this.achievImages[0] = TextureManager.AddTexture("/menu/a_achive_on.png");
        this.achievImages[1] = TextureManager.AddTexture("/menu/a_achive_of.png");
        int trackIconX = ApplicationData.screenWidth / 2 - this.achievImages[0].GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 2 - this.achievImages[0].GetHeight();
        int arrowsY = trackIconY + this.achievImages[0].GetHeight() / 2 - ObjectsCache.arrowLeft.GetHeight() / 2;
        int arrowLeftX = (ApplicationData.screenWidth / 2 - this.achievImages[0].GetWidth() / 2) / 2 - ObjectsCache.arrowLeft.GetWidth() / 2;
        if (arrowLeftX < 0) {
            arrowLeftX = 0;
        }
        if ((arrowRightX = ApplicationData.screenWidth / 2 + this.achievImages[0].GetWidth() / 2 + (ApplicationData.screenWidth - (ApplicationData.screenWidth / 2 + this.achievImages[0].GetWidth() / 2)) / 2 - ObjectsCache.arrowLeft.GetWidth() / 2) > ApplicationData.screenWidth - ObjectsCache.arrowLeft.GetWidth()) {
            arrowRightX = ApplicationData.screenWidth - ObjectsCache.arrowLeft.GetWidth();
        }
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(arrowRightX, arrowsY, ObjectsCache.arrowRight, ObjectsCache.arrowRight_a, 101);
        rightB.setScreen(this);
        rightB.setAnimDir(1.0f);
        this.addButton(rightB);
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(arrowLeftX, arrowsY, ObjectsCache.arrowLeft, ObjectsCache.arrowLeft_a, 100);
        leftB.setScreen(this);
        leftB.setAnimDir(-1.0f);
        this.addButton(leftB);
        this.nStartBoxY = trackIconY + this.achievImages[0].GetHeight();
        this.nStopBoxY = ApplicationData.screenHeight - ObjectsCache.menuSbOK.GetHeight() - ApplicationData.getFontByID(0).getFontHeight() / 4;
        if (ApplicationData.screenWidth <= 128) {
            this.nStartBoxY -= ApplicationData.getFontByID(0).getFontHeight() / 2;
            this.nStopBoxY += ApplicationData.getFontByID(0).getFontHeight() / 2;
        }
        this.nBoxWidth = ApplicationData.screenWidth;
        this.infoBox = new UIFloatingTextBox(false, (ApplicationData.screenWidth - this.nBoxWidth) / 2, this.nStartBoxY, this.nBoxWidth, this.nStopBoxY - this.nStartBoxY);
        this.updateAchievementInfo();
    }

    private void updateAchievementInfo() {
        this.csText1 = ApplicationData.defaultFont.encodeDynamicString("" + (selectedAchiev + 1) + " / " + 12);
        this.csText2 = ApplicationData.lp.getTranslatedString(Options.languageID, this.achiHeaders[selectedAchiev]);
        this.infoBox.setText(ApplicationData.lp.getTranslatedString(Options.languageID, this.achiDescript[selectedAchiev]));
        this.headerText = null;
        this.headerText = Utils.splitText(this.csText2, ApplicationData.defaultFont.encodeDynamicString("+"));
    }

    public void autoSize() {
    }

    public void draw() {
        int trackIconX = ApplicationData.screenWidth / 2 - this.achievImages[0].GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 2 - this.achievImages[0].GetHeight();
        boolean unlocked = CGAchievements.isAchievementCompleted(selectedAchiev);
        if (unlocked) {
            Graphic2D.DrawImage(this.achievImages[0], trackIconX, trackIconY, 20);
        } else {
            Graphic2D.DrawImage(this.achievImages[1], trackIconX, trackIconY, 20);
        }
        Utils.drawString(this.csText1, ApplicationData.screenWidth >> 1, trackIconY - ApplicationData.getFontByID(0).getFontHeight() / 2 - ApplicationData.getFontByID(0).getFontHeight() - ApplicationData.getFontByID(0).getFontHeight() / 4, 33, 0);
        int offset = 0;
        if (this.headerText.size() == 1) {
            offset = ApplicationData.getFontByID(0).getFontHeight() / 2;
        }
        if (this.headerText.elementAt(0) != null) {
            Utils.drawString((String)this.headerText.elementAt(0), ApplicationData.screenWidth >> 1, trackIconY - ApplicationData.getFontByID(0).getFontHeight() + offset, 33, 0);
        }
        if (this.headerText.size() > 1 && this.headerText.elementAt(1) != null) {
            Utils.drawString((String)this.headerText.elementAt(1), ApplicationData.screenWidth >> 1, trackIconY + offset, 33, 0);
        }
        this.infoBox.draw();
    }

    public boolean rightSoftButton() {
        this.Clean();
        UIScreen.SetCurrentScreen(new MainMenu());
        return true;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean onRightAction() {
        if (++selectedAchiev >= 12) {
            selectedAchiev = 0;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onLeftAction() {
        if (--selectedAchiev < 0) {
            selectedAchiev = 11;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }
}

