/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.VectorF2;
import baltorogames.project_gameplay.CGBall;
import baltorogames.project_gameplay.CollisionObject;
import java.util.Vector;

class CollisionScene {
    static VectorF2 vecOutPos = new VectorF2();
    static VectorF2 vecOutDir = new VectorF2();
    private Vector m_arrObjects = new Vector();
    public int m_nCollisionObjectIndex = -1;

    public void Destroy() {
        this.m_arrObjects.removeAllElements();
        this.m_arrObjects = null;
    }

    public int GetSize() {
        return this.m_arrObjects.size();
    }

    public CollisionObject Get(int nIndex) {
        if (nIndex < 0 || nIndex >= this.m_arrObjects.size()) {
            return null;
        }
        return (CollisionObject)this.m_arrObjects.elementAt(nIndex);
    }

    public void Add(CollisionObject p) {
        this.m_arrObjects.addElement(p);
    }

    public void Remove(CollisionObject o) {
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            CollisionObject c = (CollisionObject)this.m_arrObjects.elementAt(i);
            if (c != o) continue;
            this.m_arrObjects.removeElementAt(i);
            return;
        }
    }

    public void Render() {
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
        }
    }

    protected double CheckCollision(double fStartX, double fStartY, double fStopX, double fStopY, VectorF2 vecPosition, VectorF2 vecDirection) {
        double fMinRes = 2.0;
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            double fR;
            CollisionObject p = (CollisionObject)this.m_arrObjects.elementAt(i);
            if (!(Math.abs(p.m_fY + 12.0 - fStartY) < (double)(CGBall.eRadius * 6.0f) && Math.abs(p.m_fX + 35.0 - fStartX) < (double)(CGBall.eRadius * 6.0f) || p.isBorder) && (!(fStartY > 600.0) || !p.isPaddle) || !((fR = p.CheckCollisionWithMe(fStartX, fStartY, fStopX, fStopY, VectorF2.vecTmp9, VectorF2.vecTmp10)) >= 0.0) || !(fR <= 1.0) || !(fR < fMinRes) || p.isPowerUp) continue;
            vecPosition.x = VectorF2.vecTmp9.x;
            vecPosition.y = VectorF2.vecTmp9.y;
            vecDirection.x = VectorF2.vecTmp10.x;
            vecDirection.y = VectorF2.vecTmp10.y;
            if (p.m_nObjectID != 1000000) {
                double fLength;
                double fMargin = 30.0;
                double fMarginVert = 5.0;
                double angle = VectorF2.AngleFromVector(vecDirection);
                if (angle < 90.0 && angle > 90.0 - fMargin) {
                    fLength = vecDirection.Length();
                    VectorF2.VectorFromAngle(90.0 - fMargin, vecDirection);
                    vecDirection.x *= fLength;
                    vecDirection.y *= fLength;
                } else if (angle >= 90.0 && angle < 90.0 + fMargin) {
                    fLength = vecDirection.Length();
                    VectorF2.VectorFromAngle(90.0 + fMargin, vecDirection);
                    vecDirection.x *= fLength;
                    vecDirection.y *= fLength;
                }
                if (angle < 180.0 && angle > 180.0 - fMarginVert) {
                    fLength = vecDirection.Length();
                    VectorF2.VectorFromAngle(180.0 - fMarginVert, vecDirection);
                    vecDirection.x *= fLength;
                    vecDirection.y *= fLength;
                } else if (angle >= 180.0 && angle < 180.0 + fMarginVert) {
                    fLength = vecDirection.Length();
                    VectorF2.VectorFromAngle(180.0 + fMarginVert, vecDirection);
                    vecDirection.x *= fLength;
                    vecDirection.y *= fLength;
                }
                if (angle < 360.0 && angle > 360.0 - fMarginVert) {
                    fLength = vecDirection.Length();
                    VectorF2.VectorFromAngle(360.0 - fMarginVert, vecDirection);
                    vecDirection.x *= fLength;
                    vecDirection.y *= fLength;
                } else if (angle >= 0.0 && angle < 0.0 + fMarginVert) {
                    fLength = vecDirection.Length();
                    VectorF2.VectorFromAngle(0.0 + fMarginVert, vecDirection);
                    vecDirection.x *= fLength;
                    vecDirection.y *= fLength;
                } else if (angle < 270.0 && angle > 270.0 - fMargin) {
                    fLength = vecDirection.Length();
                    VectorF2.VectorFromAngle(270.0 - fMargin, vecDirection);
                    vecDirection.x *= fLength;
                    vecDirection.y *= fLength;
                } else if (angle >= 270.0 && angle < 270.0 + fMargin) {
                    fLength = vecDirection.Length();
                    VectorF2.VectorFromAngle(270.0 + fMargin, vecDirection);
                    vecDirection.x *= fLength;
                    vecDirection.y *= fLength;
                }
            } else {
                double fXX = p.GetCurrentCenterX();
                double fWW = p.GetCurrentWidth() / 2.0;
                double fColXX = vecPosition.x;
                double fAddAngle = 0.0;
                double fFactor = (fColXX - fXX) / fWW;
                if (fFactor > 1.0) {
                    fFactor = 1.0;
                } else if (fFactor < -1.0) {
                    fFactor = -1.0;
                }
                fAddAngle = fFactor * 45.0;
                double angle = VectorF2.AngleFromVector(vecDirection);
                double fLength = vecDirection.Length();
                angle += fAddAngle;
                if (angle < 0.0) {
                    angle += 360.0;
                } else if (angle >= 360.0) {
                    angle -= 360.0;
                }
                double fMargin = 30.0;
                if (angle < 90.0 && angle > 90.0 - fMargin) {
                    VectorF2.VectorFromAngle(90.0 - fMargin, vecDirection);
                    vecDirection.x *= fLength;
                    vecDirection.y *= fLength;
                } else if (angle >= 90.0 && angle < 90.0 + fMargin) {
                    VectorF2.VectorFromAngle(90.0 + fMargin, vecDirection);
                    vecDirection.x *= fLength;
                    vecDirection.y *= fLength;
                } else if (angle < 270.0 && angle > 270.0 - fMargin) {
                    VectorF2.VectorFromAngle(270.0 - fMargin, vecDirection);
                    vecDirection.x *= fLength;
                    vecDirection.y *= fLength;
                } else if (angle >= 270.0 && angle < 270.0 + fMargin) {
                    VectorF2.VectorFromAngle(270.0 + fMargin, vecDirection);
                    vecDirection.x *= fLength;
                    vecDirection.y *= fLength;
                } else {
                    VectorF2.VectorFromAngle(angle, vecDirection);
                    vecDirection.x *= fLength;
                    vecDirection.y *= fLength;
                }
            }
            fMinRes = fR;
            this.m_nCollisionObjectIndex = i;
        }
        return fMinRes;
    }

    protected double CheckCollisionWithPaddle(double fStartX, double fStartY, double fStopX, double fStopY, VectorF2 vecPosition, VectorF2 vecDirection) {
        double fMinRes = 2.0;
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            double fR;
            CollisionObject p = (CollisionObject)this.m_arrObjects.elementAt(i);
            if (!p.isPaddle || !((fR = p.CheckCollisionWithMe(fStartX, fStartY, fStopX, fStopY, VectorF2.vecTmp9, VectorF2.vecTmp10)) >= 0.0) || !(fR <= 1.0) || !(fR < fMinRes)) continue;
            fMinRes = fR;
            this.m_nCollisionObjectIndex = i;
        }
        return fMinRes;
    }

    protected double CheckCollisionExceptPowerUp(double fStartX, double fStartY, double fStopX, double fStopY, VectorF2 vecPosition, VectorF2 vecDirection) {
        double fMinRes = 2.0;
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            CollisionObject p = (CollisionObject)this.m_arrObjects.elementAt(i);
            if (p.isPowerUp) {
                return fMinRes;
            }
            double fR = p.CheckCollisionWithMe(fStartX, fStartY, fStopX, fStopY, VectorF2.vecTmp9, VectorF2.vecTmp10);
            if (!(fR >= 0.0) || !(fR <= 1.0) || !(fR < fMinRes)) continue;
            vecPosition.x = VectorF2.vecTmp9.x;
            vecPosition.y = VectorF2.vecTmp9.y;
            vecDirection.x = VectorF2.vecTmp10.x;
            vecDirection.y = VectorF2.vecTmp10.y;
            fMinRes = fR;
            this.m_nCollisionObjectIndex = i;
        }
        return fMinRes;
    }

    protected boolean CheckCarePosition(double x, double y) {
        int nS = this.m_arrObjects.size();
        for (int i = 0; i < nS; ++i) {
            CollisionObject p = (CollisionObject)this.m_arrObjects.elementAt(i);
            if (p.isPaddle || p.isBorder || !(Math.abs(p.m_fY + 12.0 - y) < 48.0) || !(Math.abs(p.m_fX + 35.0 - x) < 140.0)) continue;
            return false;
        }
        return true;
    }
}

