/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.VectorF2;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CollisionObject;

public class CGShot {
    public static float eStartSpeed = 15.0f;
    public static float eHalfWidth = 25.0f;
    public static float eHalfHeight = 25.0f;
    public double m_fCurrentCollisionT = 1.0;
    public int m_nCurrentCollisionObjectID = -1;
    public int currFrame;
    public double m_fX;
    public double m_fY;
    public boolean bLaunched = false;
    public boolean bisLaserShot = true;
    public float m_fCurrentSpeed;
    public int m_nTime;

    public void Init(double x, double y) {
        this.m_fX = x;
        this.m_fY = y;
        this.m_nTime = 0;
        this.currFrame = 0;
        this.m_fCurrentSpeed = eStartSpeed;
    }

    public double Update(int nDeltaTimeInMs) {
        this.m_nTime += nDeltaTimeInMs;
        this.m_fCurrentSpeed = eStartSpeed;
        this.currFrame = this.m_nTime / 50 % CGEngineRenderer.m_ShotTexture.length;
        if (this.currFrame >= CGEngineRenderer.m_ShotTexture.length - 1) {
            this.bLaunched = true;
            this.currFrame = CGEngineRenderer.m_ShotTexture.length - 1;
        }
        if (this.bLaunched) {
            double fStartX = this.m_fX;
            double fStartY = this.m_fY;
            this.currFrame = CGEngineRenderer.m_ShotTexture.length - 1;
            this.m_fY -= (double)this.m_fCurrentSpeed;
            double fNewX = fStartX;
            double fNewY = fStartY - (double)this.m_fCurrentSpeed;
            this.m_nCurrentCollisionObjectID = -1;
            double fRet = CGEngine.m_CollisionScene.CheckCollision(fStartX, fStartY, fNewX, fNewY, VectorF2.vecTmp1, VectorF2.vecTmp2);
            if (fRet <= 1.0 && fRet >= 0.0) {
                int nObjectIndex = CGEngine.m_CollisionScene.m_nCollisionObjectIndex;
                CollisionObject co = CGEngine.m_CollisionScene.Get(nObjectIndex);
                if (co.m_nObjectID >= 0) {
                    this.m_nCurrentCollisionObjectID = co.m_nObjectID;
                    return fRet;
                }
            }
        } else if (!this.bLaunched) {
            this.m_fX = CGEngine.m_PaddleObject.centerXforBall;
        }
        return -1.0;
    }

    public void Render() {
        CGEngineRenderer.RenderShot((float)this.m_fX, (float)this.m_fY, this.currFrame);
    }

    public void Destroy() {
    }
}

