/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.core.VectorF2;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.CGActivePowerUp;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGFallingPowerUp;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CollisionObject;
import baltorogames.project_gameplay.GameObject;

public class PowerupObject
extends GameObject {
    public static float eStartSpeed = 5.0f;
    public static float eGravitySpeed = 120.0f;
    public float m_fCurrentSpeed;
    public int m_nCurrentCollisionObjectID = -1;
    public int m_nActivePowerUpLifeTime = 0;
    public boolean m_bIsActive = false;
    public boolean bisPowerDown = false;
    public boolean bisPowerUp = false;
    private int[] sba = new int[11];

    public void Init(double fX, double fY, double fW, double fH, int nType, int nID) {
        this.m_fStartX = fX;
        this.m_fStartY = fY;
        this.m_fX = fX;
        this.m_fY = fY;
        this.m_fW = fW;
        this.m_fH = fH;
        this.m_nID = nID;
        this.m_nType = nType;
        this.m_bIsActive = false;
        this.m_nCollisionCounter = 1;
        if (this.m_nType <= 5) {
            this.bisPowerUp = true;
        } else {
            this.bisPowerDown = true;
        }
        this.m_CollisionObject = new CollisionObject();
        this.m_CollisionObject.Add(-fW / 2.0, 0.0);
        this.m_CollisionObject.Add(fW / 2.0, 0.0);
        this.m_CollisionObject.Add(fW / 2.0, fH);
        this.m_CollisionObject.Add(-fW / 2.0, fH);
        this.m_CollisionObject.CreateTransformPoints(CGFallingPowerUp.eHalfWidth);
        this.m_CollisionObject.m_nObjectID = nID;
        this.m_CollisionObject.m_fX = fX;
        this.m_CollisionObject.m_fY = fY;
        this.m_CollisionObject.isPowerUp = true;
        CGEngine.m_CollisionScene.Add(this.m_CollisionObject);
        this.m_fMoveXPerSec = 0.0;
        this.m_fMoveYPerSec = 0.0;
        this.m_fMaxDX = 0.0;
        this.m_fMaxDY = 0.0;
    }

    public void Update(int deltaTimeInMs) {
        super.Update(deltaTimeInMs);
        if (!this.m_bIsActive) {
            double fRet;
            float t = (float)deltaTimeInMs / 1000.0f;
            double old_fY = this.m_fY;
            this.m_fCurrentSpeed += eGravitySpeed * t;
            this.m_fY += (double)(this.m_fCurrentSpeed * t);
            this.m_nCurrentCollisionObjectID = -1;
            if (this.m_fY > 600.0 && (fRet = CGEngine.m_CollisionScene.CheckCollisionWithPaddle(this.m_fX + this.m_fW / 2.0, old_fY, this.m_fX + this.m_fW / 2.0, this.m_fY, VectorF2.vecTmp1, VectorF2.vecTmp2)) <= 1.0 && fRet >= 0.0) {
                int nObjectIndex = CGEngine.m_CollisionScene.m_nCollisionObjectIndex;
                CollisionObject co = CGEngine.m_CollisionScene.Get(nObjectIndex);
                if (co.m_nObjectID >= 0) {
                    this.CollisionAction();
                }
            }
        } else {
            this.actualizeActivePowerUp();
            this.m_nActivePowerUpLifeTime -= deltaTimeInMs;
        }
    }

    public void CollisionAction() {
        --this.m_nCollisionCounter;
        if (this.m_nCollisionCounter == 0) {
            CGActivePowerUp.NewActivePowerUp(this);
            this.DestroyPowerUp();
            if (this.m_nType <= 5) {
                CGDynamicObj.AddToCurrentDynamics("take_powerup.do", (float)(this.m_fX + this.m_fW / 2.0), (float)(this.m_fY + this.m_fH / 2.0), 0.0f);
            } else if (this.m_nType > 5) {
                CGDynamicObj.AddToCurrentDynamics("take_powerdown.do", (float)(this.m_fX + this.m_fW / 2.0), (float)(this.m_fY + this.m_fH / 2.0), 0.0f);
            }
            CGLevelStats.m_nDidAnyPowersTaken = true;
        }
    }

    public void DestroyPowerUp() {
        if (!this.m_bIsActive) {
            CGFallingPowerUp.RemoveByID(this.m_nID);
        }
    }

    public void DestroyActivePowerUp() {
        if (this.m_bIsActive) {
            CGActivePowerUp.RemoveByID(this.m_nID);
        }
    }

    public void Render() {
        if (!this.m_bIsActive) {
            CGEngineRenderer.RenderFallingPowerUp(this.m_nTime, this.m_nType, (float)this.m_fX, (float)this.m_fY);
        }
    }

    private void actualizeActivePowerUp() {
        int i;
        boolean flague = false;
        if (this.sba[this.m_nType] == 1) {
            flague = true;
        }
        if (this.m_nActivePowerUpLifeTime > 0 && this.m_nType == 4 && flague) {
            CGEngine.Create3Balls();
            this.setPowerUpFlagueState(false);
        }
        if (this.m_nActivePowerUpLifeTime > 0 && this.m_nType == 7 && flague) {
            for (i = 0; i < 3; ++i) {
                if (CGEngine.m_Ball[i] == null) continue;
                CGEngine.m_Ball[i].setSpeedUpPU();
            }
            this.setPowerUpFlagueState(false);
        }
        if (this.m_nActivePowerUpLifeTime > 0 && this.m_nType == 0 && flague) {
            CGEngine.m_PaddleObject.bIsLaserPaddle = true;
            this.setPowerUpFlagueState(false);
        }
        if (this.m_nActivePowerUpLifeTime > 0 && this.m_nType == 5 && flague) {
            for (i = 0; i < 3; ++i) {
                if (CGEngine.m_Ball[i] == null) continue;
                CGEngine.m_Ball[i].setBallSpeedByMultiplier(0.7);
            }
            this.setPowerUpFlagueState(false);
        }
        if (this.m_nActivePowerUpLifeTime > 0 && this.m_nType == 3 && flague) {
            CGEngine.m_PaddleObject.DoubleWidthOfPaddle(CGEngine.m_PaddleObject.m_fX, CGEngine.m_PaddleObject.m_fY);
            this.setPowerUpFlagueState(false);
        }
        if (this.m_nActivePowerUpLifeTime > 0 && this.m_nType == 9 && flague) {
            CGEngine.m_PaddleObject.ShrinkWidthOfPaddle(CGEngine.m_PaddleObject.m_fX, CGEngine.m_PaddleObject.m_fY);
            this.setPowerUpFlagueState(false);
        }
        if (this.m_nActivePowerUpLifeTime > 0 && this.m_nType == 6 && flague) {
            CGEngine.m_PaddleObject.SetInvertedStearing(true);
            this.setPowerUpFlagueState(false);
        }
        if (this.m_nActivePowerUpLifeTime > 0 && this.m_nType == 8 && flague) {
            for (i = 0; i < 3; ++i) {
                if (CGEngine.m_Ball[i] == null) continue;
                CGEngine.m_Ball[i].isPupBlockerBall = true;
            }
            this.setPowerUpFlagueState(false);
        }
        if (this.m_nActivePowerUpLifeTime > 0 && this.m_nType == 1 && flague) {
            for (i = 0; i < 3; ++i) {
                if (CGEngine.m_Ball[i] == null) continue;
                CGEngine.m_Ball[i].isPupFireBall = true;
            }
            this.setPowerUpFlagueState(false);
        }
        if (this.m_nActivePowerUpLifeTime <= 0 || this.m_nType != 10 || flague) {
            // empty if block
        }
        if (this.m_nActivePowerUpLifeTime > 0 && this.m_nType == 2 && flague) {
            for (i = 0; i < 3; ++i) {
                if (CGEngine.m_Ball[i] == null) continue;
                CGEngine.m_Ball[i].isPupGlueBall = true;
            }
            this.setPowerUpFlagueState(false);
        }
    }

    public void resetCurrPowerUp() {
        switch (this.m_nType) {
            case 0: {
                CGEngine.m_PaddleObject.bIsLaserPaddle = false;
                break;
            }
            case 1: {
                for (int i = 0; i < 3; ++i) {
                    if (CGEngine.m_Ball[i] == null) continue;
                    CGEngine.m_Ball[i].isPupFireBall = false;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 3; ++i) {
                    if (CGEngine.m_Ball[i] == null) continue;
                    CGEngine.m_Ball[i].isPupGlueBall = false;
                    if (CGEngine.m_Ball[i].isReady) continue;
                    float fX = ((float)(180 + RandSync.nextInt(120)) - CGEngineRenderer.m_fScreenOffsetX) * 0.37f;
                    float fY = (300.0f - CGEngineRenderer.m_fScreenOffsetY) * 0.37f;
                    CGEngine.m_Ball[i].ShootBall(-(CGEngine.m_Ball[i].vecPos.x - (double)fX), -(CGEngine.m_Ball[i].vecPos.y - (double)fY));
                }
                break;
            }
            case 3: {
                CGEngine.m_PaddleObject.ResetWidthOfPaddle(CGEngine.m_PaddleObject.m_fX, CGEngine.m_PaddleObject.m_fY, CGEngine.m_PaddleScale);
                break;
            }
            case 4: {
                this.powerup3ballsDeactivation();
                break;
            }
            case 5: {
                for (int i = 0; i < 3; ++i) {
                    if (CGEngine.m_Ball[i] == null) continue;
                    CGEngine.m_Ball[i].setBallSpeedByMultiplier(1.0);
                }
                break;
            }
            case 6: {
                CGEngine.m_PaddleObject.SetInvertedStearing(false);
                break;
            }
            case 7: {
                for (int i = 0; i < 3; ++i) {
                    if (CGEngine.m_Ball[i] == null) continue;
                    CGEngine.m_Ball[i].setBallSpeedByMultiplier(1.0);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < 3; ++i) {
                    if (CGEngine.m_Ball[i] == null) continue;
                    CGEngine.m_Ball[i].isPupBlockerBall = false;
                }
                break;
            }
            case 9: {
                CGEngine.m_PaddleObject.ResetWidthOfPaddle(CGEngine.m_PaddleObject.m_fX, CGEngine.m_PaddleObject.m_fY, CGEngine.m_PaddleScale);
                break;
            }
        }
    }

    public void setLifeTimeOfActivePowerUp() {
        this.m_nActivePowerUpLifeTime = 10000;
    }

    public void setPowerUpFlagueState(boolean nState) {
        this.sba[this.m_nType] = nState ? 1 : -1;
    }

    private void powerup3ballsDeactivation() {
        int i;
        int nC = 0;
        for (i = 0; i < 3; ++i) {
            if (CGEngine.m_Ball[i] == null || CGEngine.m_Ball[i].bIsLifeLost()) continue;
            ++nC;
        }
        for (i = 0; i < 3; ++i) {
            if (CGEngine.m_Ball[i] == null || nC <= 1) continue;
            CGEngine.m_Ball[i] = null;
            --nC;
        }
    }
}

