/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.CGBall;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGShot;
import baltorogames.project_gameplay.CollisionObject;
import baltorogames.project_gameplay.GameObject;

class PaddleObject
extends GameObject {
    public static final int PADDLE_COLLID = 1000000;
    public static final double PADDLE_HEIGHT = 650.0;
    private boolean bisInvertedStearing = false;
    public int m_nHitAnimTime = 0;
    public int m_nAnimType = 0;
    public int currentFrame;
    public float globalAnimTime;
    public double deltaX;
    public double centerXforBall = 0.0;
    public double centerYforBall = 0.0;
    public boolean bIsLaserPaddle = false;
    public boolean isDoubleWidth = false;
    public boolean isShrinked = false;
    public CGShot laserShot = null;
    double m_fTargetX;
    private double m_fNewX;
    CollisionObject m_CollisionObjectAlt;

    public void Init(double fX, double fY, double fW, double fH, int nType, int nID, float nScale) {
        this.m_fStartX = fX;
        this.m_fStartY = fY;
        this.m_fX = fX;
        this.m_fY = fY;
        this.m_fW = fW * (double)nScale;
        this.m_fH = fH;
        this.m_nID = nID;
        this.m_nType = nType;
        this.centerXforBall = this.m_fX;
        this.centerYforBall = this.m_fY;
        this.m_fNewX = fX;
        this.m_fTargetX = fX;
        this.m_nCollisionCounter = 100000000;
        this.m_CollisionObject = new CollisionObject();
        this.m_CollisionObject.Add(-this.m_fW / 2.0, 0.0);
        this.m_CollisionObject.Add(this.m_fW / 2.0, 0.0);
        this.m_CollisionObject.Add(this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObject.Add(-this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObject.CreateTransformPoints(CGBall.eRadius);
        this.m_CollisionObject.m_nObjectID = 1000000;
        this.m_CollisionObject.m_fX = fX;
        this.m_CollisionObject.m_fY = fY;
        this.m_CollisionObject.isPaddle = true;
        this.m_CollisionObjectAlt = new CollisionObject();
        this.m_CollisionObjectAlt.Add(-this.m_fW / 2.0, 0.0);
        this.m_CollisionObjectAlt.Add(this.m_fW / 2.0, 0.0);
        this.m_CollisionObjectAlt.Add(this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObjectAlt.Add(-this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObjectAlt.CreateTransformPoints(CGBall.eRadius);
        this.m_CollisionObjectAlt.m_nObjectID = 1000000;
        this.m_CollisionObjectAlt.m_fX = fX;
        this.m_CollisionObjectAlt.m_fY = fY + this.m_fH / 5.0;
        this.m_CollisionObjectAlt.isPaddle = true;
        CGEngine.m_CollisionScene.Add(this.m_CollisionObject);
        CGEngine.m_CollisionScene.Add(this.m_CollisionObjectAlt);
        this.m_fMoveXPerSec = 0.0;
        this.m_fMoveYPerSec = 0.0;
        this.m_fMaxDX = 0.0;
        this.m_fMaxDY = 0.0;
        this.globalAnimTime = 0.0f;
        CGEngine.m_Board.AddObject(this);
        this.isDoubleWidth = false;
        this.isShrinked = false;
    }

    public void DoubleWidthOfPaddle(double fX, double fY) {
        this.m_fX = fX;
        this.m_fY = fY;
        this.m_fW = 224.0;
        if (this.m_fX + this.m_fW / 2.0 > 450.0) {
            this.m_fX = 450.0 - this.m_fW / 2.0;
        } else if (this.m_fX - this.m_fW / 2.0 < 30.0) {
            this.m_fX = 30.0 + this.m_fW / 2.0;
        }
        this.m_fH = 31.200000000000003;
        CGEngine.m_CollisionScene.Remove(this.m_CollisionObject);
        CGEngine.m_CollisionScene.Remove(this.m_CollisionObjectAlt);
        this.m_CollisionObject = new CollisionObject();
        this.m_CollisionObject.Add(-this.m_fW / 2.0, 0.0);
        this.m_CollisionObject.Add(this.m_fW / 2.0, 0.0);
        this.m_CollisionObject.Add(this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObject.Add(-this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObject.CreateTransformPoints(CGBall.eRadius);
        this.m_CollisionObject.m_nObjectID = 1000000;
        this.m_CollisionObject.m_fX = fX;
        this.m_CollisionObject.m_fY = fY;
        this.m_CollisionObject.isPaddle = true;
        this.m_CollisionObjectAlt = new CollisionObject();
        this.m_CollisionObjectAlt.Add(-this.m_fW / 2.0, 0.0);
        this.m_CollisionObjectAlt.Add(this.m_fW / 2.0, 0.0);
        this.m_CollisionObjectAlt.Add(this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObjectAlt.Add(-this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObjectAlt.CreateTransformPoints(CGBall.eRadius);
        this.m_CollisionObjectAlt.m_nObjectID = 1000000;
        this.m_CollisionObjectAlt.m_fX = fX;
        this.m_CollisionObjectAlt.m_fY = fY + this.m_fH / 5.0;
        this.m_CollisionObjectAlt.isPaddle = true;
        CGEngine.m_CollisionScene.Add(this.m_CollisionObject);
        CGEngine.m_CollisionScene.Add(this.m_CollisionObjectAlt);
        this.isDoubleWidth = true;
        this.m_nCollisionCounter = 100000000;
    }

    public void ShrinkWidthOfPaddle(double fX, double fY) {
        this.m_fX = fX;
        this.m_fY = fY;
        this.m_fW = 105.0;
        this.m_fH = 28.799999999999997;
        CGEngine.m_CollisionScene.Remove(this.m_CollisionObject);
        CGEngine.m_CollisionScene.Remove(this.m_CollisionObjectAlt);
        this.m_CollisionObject = new CollisionObject();
        this.m_CollisionObject.Add(-this.m_fW / 2.0, 0.0);
        this.m_CollisionObject.Add(this.m_fW / 2.0, 0.0);
        this.m_CollisionObject.Add(this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObject.Add(-this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObject.CreateTransformPoints(CGBall.eRadius);
        this.m_CollisionObject.m_nObjectID = 1000000;
        this.m_CollisionObject.m_fX = fX;
        this.m_CollisionObject.m_fY = fY;
        this.m_CollisionObject.isPaddle = true;
        this.m_CollisionObjectAlt = new CollisionObject();
        this.m_CollisionObjectAlt.Add(-this.m_fW / 2.0, 0.0);
        this.m_CollisionObjectAlt.Add(this.m_fW / 2.0, 0.0);
        this.m_CollisionObjectAlt.Add(this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObjectAlt.Add(-this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObjectAlt.CreateTransformPoints(CGBall.eRadius);
        this.m_CollisionObjectAlt.m_nObjectID = 1000000;
        this.m_CollisionObjectAlt.m_fX = fX;
        this.m_CollisionObjectAlt.m_fY = fY + this.m_fH / 5.0;
        this.m_CollisionObjectAlt.isPaddle = true;
        this.isShrinked = true;
        CGEngine.m_CollisionScene.Add(this.m_CollisionObject);
        CGEngine.m_CollisionScene.Add(this.m_CollisionObjectAlt);
        this.m_nCollisionCounter = 100000000;
    }

    public void ResetWidthOfPaddle(double fX, double fY, float nScale) {
        this.m_fX = fX;
        this.m_fY = fY;
        this.m_fW = 140.0f * nScale;
        this.m_fH = 31.200000000000003;
        CGEngine.m_CollisionScene.Remove(this.m_CollisionObject);
        CGEngine.m_CollisionScene.Remove(this.m_CollisionObjectAlt);
        this.m_CollisionObject = new CollisionObject();
        this.m_CollisionObject.Add(-this.m_fW / 2.0, 0.0);
        this.m_CollisionObject.Add(this.m_fW / 2.0, 0.0);
        this.m_CollisionObject.Add(this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObject.Add(-this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObject.CreateTransformPoints(CGBall.eRadius);
        this.m_CollisionObject.m_nObjectID = 1000000;
        this.m_CollisionObject.m_fX = fX;
        this.m_CollisionObject.m_fY = fY;
        this.m_CollisionObject.isPaddle = true;
        this.m_CollisionObjectAlt = new CollisionObject();
        this.m_CollisionObjectAlt.Add(-this.m_fW / 2.0, 0.0);
        this.m_CollisionObjectAlt.Add(this.m_fW / 2.0, 0.0);
        this.m_CollisionObjectAlt.Add(this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObjectAlt.Add(-this.m_fW / 2.0, this.m_fH);
        this.m_CollisionObjectAlt.CreateTransformPoints(CGBall.eRadius);
        this.m_CollisionObjectAlt.m_nObjectID = 1000000;
        this.m_CollisionObjectAlt.m_fX = fX;
        this.m_CollisionObjectAlt.m_fY = fY + this.m_fH / 5.0;
        this.m_CollisionObjectAlt.isPaddle = true;
        this.isDoubleWidth = false;
        this.isShrinked = false;
        CGEngine.m_CollisionScene.Add(this.m_CollisionObject);
        CGEngine.m_CollisionScene.Add(this.m_CollisionObjectAlt);
        this.m_nCollisionCounter = 100000000;
    }

    public void Destroy() {
    }

    public void Reset() {
    }

    public void PreUpdate(int deltaTimeInMs) {
        this.m_CollisionObject.m_fX = this.m_fX;
        this.m_CollisionObject.m_fY = this.m_fY;
        this.m_CollisionObjectAlt.m_fX = this.m_fX;
        this.m_CollisionObjectAlt.m_fY = this.m_fY + this.m_fH / 5.0;
        if (this.m_fTargetX + this.m_fW / 2.0 > 450.0) {
            this.m_fTargetX = 450.0 - this.m_fW / 2.0;
        } else if (this.m_fTargetX - this.m_fW / 2.0 < 30.0) {
            this.m_fTargetX = 30.0 + this.m_fW / 2.0;
        }
        if (this.m_fX < this.m_fTargetX) {
            double fDeltaMove = (double)deltaTimeInMs * 10000.0 / 1000.0;
            this.m_fNewX = this.m_fX + fDeltaMove;
            this.m_CollisionObject.m_fDX = this.m_fNewX - this.m_fX;
            this.m_CollisionObjectAlt.m_fDX = this.m_fNewX - this.m_fX;
            if (this.m_fNewX > this.m_fTargetX) {
                this.m_fNewX = this.m_fTargetX;
                this.m_CollisionObject.m_fDX = this.m_fNewX - this.m_fX;
                this.m_CollisionObjectAlt.m_fDX = this.m_fNewX - this.m_fX;
            }
        } else if (this.m_fX > this.m_fTargetX) {
            double fDeltaMove = (double)deltaTimeInMs * 10000.0 / 1000.0;
            this.m_fNewX = this.m_fX - fDeltaMove;
            this.m_CollisionObject.m_fDX = this.m_fNewX - this.m_fX;
            this.m_CollisionObjectAlt.m_fDX = this.m_fNewX - this.m_fX;
            if (this.m_fNewX < this.m_fTargetX) {
                this.m_fNewX = this.m_fTargetX;
                this.m_CollisionObject.m_fDX = this.m_fNewX - this.m_fX;
                this.m_CollisionObjectAlt.m_fDX = this.m_fNewX - this.m_fX;
            }
        } else {
            this.m_fX = this.m_fNewX = this.m_fTargetX;
            this.m_CollisionObject.m_fDX = 0.0;
            this.m_CollisionObjectAlt.m_fDX = 0.0;
        }
        this.m_CollisionObject.m_fDY = 0.0;
        this.m_CollisionObjectAlt.m_fDY = 0.0;
    }

    public void Update(int deltaTimeInMs) {
        this.m_CollisionObject.m_fX = this.m_fX = this.m_fNewX;
        this.m_CollisionObject.m_fDX = 0.0;
        this.m_CollisionObjectAlt.m_fX = this.m_fX;
        this.m_CollisionObjectAlt.m_fDX = 0.0;
        this.globalAnimTime += (float)deltaTimeInMs;
        if (!this.isDoubleWidth && !this.isShrinked) {
            this.currentFrame = 0;
        } else if (this.isDoubleWidth) {
            this.currentFrame = 1;
        } else if (this.isShrinked) {
            this.currentFrame = 2;
        }
        this.centerXforBall = this.m_fTargetX;
        if (this.bIsLaserPaddle && this.laserShot == null) {
            this.laserShot = new CGShot();
            this.laserShot.Init(this.centerXforBall, this.m_fY - this.m_fH / 2.0);
        } else if (this.laserShot != null) {
            GameObject go;
            this.laserShot.Update(deltaTimeInMs);
            if (this.laserShot.m_nCurrentCollisionObjectID >= 0 && (go = CGEngine.m_Board.GetObjectByID(this.laserShot.m_nCurrentCollisionObjectID)) != null) {
                boolean isAnyBlocker = false;
                if (go.m_nType == 12) {
                    for (int i = 0; i < CGEngine.m_Ball.length; ++i) {
                        if (CGEngine.m_Ball[i] == null || !CGEngine.m_Ball[i].isPupBlockerBall) continue;
                        isAnyBlocker = true;
                    }
                    if (!isAnyBlocker) {
                        CGEngine.m_Board.RemoveBombBlock(go.m_nID);
                    }
                } else if (!go.m_bPermanent && go.m_nType != 13) {
                    for (int i = 0; i < 3; ++i) {
                        if (CGEngine.m_Ball[i] == null) continue;
                        go.CollisionAction(i, false);
                        this.laserShot = null;
                        break;
                    }
                } else if (go.m_nType == 13 || go.m_bPermanent || go.m_nType == 16) {
                    for (int i = 0; i < 3; ++i) {
                        if (CGEngine.m_Ball[i] == null) continue;
                        go.CollisionAction(i, false);
                        this.laserShot = null;
                        break;
                    }
                }
            }
            if (this.laserShot != null && this.laserShot.m_fY < 0.0) {
                this.laserShot = null;
            }
        }
    }

    public void CollisionAction() {
    }

    public void Render() {
        CGEngineRenderer.RenderPaddle(this);
        if (this.bIsLaserPaddle && this.laserShot != null) {
            this.laserShot.Render();
        }
    }

    public void SetNewPosX(double x) {
        this.m_fTargetX = x;
    }

    public void SetDeltaNewPosX(double x) {
        this.m_fTargetX = this.bisInvertedStearing ? (this.m_fTargetX += x) : (this.m_fTargetX -= x);
    }

    public void SetInvertedStearing(boolean isInverted) {
        this.bisInvertedStearing = isInverted;
    }

    public boolean GetInvertedStearing() {
        return this.bisInvertedStearing;
    }

    public void SetSmoothlyNewPosX(double x) {
        if (x > this.m_fTargetX) {
            this.m_fTargetX += 10.0;
        } else if (x < this.m_fTargetX) {
            this.m_fTargetX -= 10.0;
        }
    }

    public void SetNewPosY(double y) {
        this.m_CollisionObject.m_fY = this.m_fY = y;
        this.m_CollisionObject.m_fDY = 0.0;
    }

    public double GetNewPosX() {
        return this.m_fNewX;
    }
}

