/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.core_gui.UIScreen;
import baltorogames.project_gameplay.CGLevelStats;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.LoadingLevelScreen;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectModeScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import baltorogames.system.Platform;

public class TimedLevelScreen
extends MainScreen {
    private UIFloatingTextBox infoBox;
    String userPoints = null;
    String UserTime = null;
    String bestPoints = null;
    String bestTime = null;
    String repeatInfo = null;
    int centerX = 0;
    int frame = 0;
    private int fontHeight = 0;
    private String[][] requirements;

    public TimedLevelScreen() {
        this.drawTop = false;
        this.drawTitle = false;
        this.setCaption("");
        this.centerX = ApplicationData.screenWidth / 2;
        this.fontHeight = ApplicationData.defaultFont.getFontHeight();
        if (CGLevelStats.m_nScore > CGUserCareer.m_arrBestForTimed[1][0]) {
            CGUserCareer.m_arrBestForTimed[1][0] = CGLevelStats.m_nScore;
        }
        if (CGLevelStats.m_nTimeStatsInMs / 1000 > CGUserCareer.m_arrBestForTimed[1][1] / 1000) {
            CGUserCareer.m_arrBestForTimed[1][1] = CGLevelStats.m_nTimeStatsInMs;
        }
        this.requirements = new String[4][2];
        this.requirements[0][0] = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_USER_SCORE_SURVIVE");
        this.requirements[0][1] = ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nScore);
        this.requirements[1][0] = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_USER_TIME_SURVIVE");
        this.requirements[1][1] = ApplicationData.defaultFont.encodeDynamicString("" + CGLevelStats.m_nTimeStatsInMs / 1000);
        this.requirements[2][0] = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_BEST_SCORE_SURVIVE");
        this.requirements[2][1] = ApplicationData.defaultFont.encodeDynamicString("" + CGUserCareer.m_arrBestForTimed[1][0]);
        this.requirements[3][0] = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_LONGEST_TIME_SURVIVE");
        this.requirements[3][1] = ApplicationData.defaultFont.encodeDynamicString("" + CGUserCareer.m_arrBestForTimed[1][1] / 1000);
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, null, null);
        this.updateInfo();
        ApplicationData.generalGameMode = 3;
    }

    public void autoSize() {
        this.clientAreaX = Platform.WND_MARGIN_LEFT;
        this.clientAreaWidth = this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT;
        this.clientAreaY = Platform.WND_MARGIN_TOP;
        this.clientAreaHeight = this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM;
    }

    private void updateInfo() {
    }

    public void onUpdate(float deltaTime) {
        super.onUpdate(deltaTime);
    }

    public void draw() {
        this.drawRequirements(this.requirements, 0, this.fontHeight);
    }

    private void drawRequirements(String[][] req, int x, int y) {
        int sizeFirstDim = req.length;
        int sizeSecondDim = req[0].length;
        for (int i = 0; i < sizeFirstDim; ++i) {
            Utils.drawString(req[i][0], x, y + 12 * this.fontHeight * i * 2 / 10, 20, 0);
            for (int j = 0; j < sizeSecondDim; ++j) {
                if (j == 0) continue;
                Utils.drawString(req[i][j], ApplicationData.screenWidth / 2, y + 12 * this.fontHeight * (i * 2 + 1) / 10, 17, 0);
            }
        }
    }

    public boolean rightSoftButton() {
        ApplicationData.SetMusic();
        CGUserCareer.Save();
        UIScreen.SetCurrentScreen(new LoadingLevelScreen());
        return true;
    }

    public boolean leftSoftButton() {
        CGUserCareer.Save();
        UIScreen.SetCurrentScreen(new SelectModeScreen());
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }
}

