/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.KeyCommand;
import baltorogames.core.Log;
import baltorogames.core.RandSync;
import baltorogames.core.TouchCommand;
import baltorogames.core_gui.UIScreen;
import baltorogames.gameplay.Game;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.particles.CGDynamicObj;
import baltorogames.project_gameplay.AchievementPopup;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGActivePowerUp;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CGFallingPowerUp;
import baltorogames.project_gameplay.CGHit;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gameplay.WorldMap;
import baltorogames.project_gui.InGameMainMenu;
import baltorogames.system.FileManager;
import baltorogames.system.ObjectsCache;
import java.io.DataInputStream;
import java.io.InputStream;

public class MyGame
extends Game {
    public WorldMap m_WorldMap = null;
    protected DataInputStream m_dis = null;
    public int m_nLoadingStepNr = 0;
    public static final int NUM_WAVES = 10;
    public CGTexture[] m_HUDIcon = null;
    public CGTexture[] m_SpecialPowerupsIcon = null;
    public CGTexture[] m_SpecialPowerupsInactiveIcon = null;
    protected int currPosCamX = 240;
    protected int deltaCamX = 0;
    protected int currentX = 0;
    protected final int xMinScreenBorder;
    protected final int xMaxScreenBorder;

    public MyGame() {
        this.xMinScreenBorder = 0;
        this.xMaxScreenBorder = 480;
    }

    public int init() {
        CGUserCareer.LoadGlobalParams();
        CGUserCareer.Reset();
        CGUserCareer.Load();
        CGAchievements.Load();
        AchievementPopup.Init();
        this.m_HUDIcon = new CGTexture[3];
        this.m_HUDIcon[0] = TextureManager.CreateTexture("/menu/hud_ico_time.png");
        this.m_HUDIcon[1] = TextureManager.CreateTexture("/menu/hud_ico_item.png");
        this.m_HUDIcon[2] = TextureManager.CreateTexture("/menu/hud_ico_ball.png");
        this.m_SpecialPowerupsIcon = new CGTexture[3];
        this.m_SpecialPowerupsIcon[0] = TextureManager.CreateTexture("/menu/hud_ka.png");
        this.m_SpecialPowerupsIcon[1] = TextureManager.CreateTexture("/menu/hud_sd.png");
        this.m_SpecialPowerupsIcon[2] = TextureManager.CreateTexture("/menu/hud_tw.png");
        this.m_SpecialPowerupsInactiveIcon = new CGTexture[3];
        this.m_SpecialPowerupsInactiveIcon[0] = TextureManager.CreateTexture("/menu/hud_ka_i.png");
        this.m_SpecialPowerupsInactiveIcon[1] = TextureManager.CreateTexture("/menu/hud_sd_i.png");
        this.m_SpecialPowerupsInactiveIcon[2] = TextureManager.CreateTexture("/menu/hud_tw_i.png");
        CGBoard.Init();
        CGFallingPowerUp.Init();
        CGActivePowerUp.Init();
        RandSync.Init();
        RandSync.SetStartValue((int)System.currentTimeMillis() % 1000);
        return CGEngine.Init();
    }

    public void destroy() {
        CGDynamicObj.Uninitialize();
        CGUserCareer.Save();
        CGEngine.Destroy();
    }

    public int startLoading(String fileName) {
        TextureManager.ClearTextures();
        CGEngineRenderer.Init();
        CGHit.Initialize();
        this.m_dis = null;
        this.m_nLoadingStepNr = 0;
        return 1;
    }

    public int stepLoading(String fileName) {
        try {
            if (this.m_nLoadingStepNr == 0) {
                System.out.println("Start loading " + fileName);
                InputStream is = null;
                is = FileManager.OpenFile(fileName);
                if (is == null) {
                    is = FileManager.OpenURLFile(fileName);
                }
                if (is == null) {
                    return 0;
                }
                this.m_dis = new DataInputStream(is);
                this.m_nLoadingStepNr = 1;
            } else if (this.m_nLoadingStepNr == 1) {
                if (this.m_dis != null) {
                    this.m_WorldMap = new WorldMap();
                    this.m_WorldMap.Load(this.m_dis);
                }
                this.m_nLoadingStepNr = 2;
            } else if (this.m_nLoadingStepNr == 2) {
                if (this.m_dis != null) {
                    CGEngine.Load1(this.m_dis);
                }
                this.m_nLoadingStepNr = 3;
            } else if (this.m_nLoadingStepNr == 3) {
                if (this.m_dis != null) {
                    CGEngine.Load2(this.m_dis);
                }
                this.m_nLoadingStepNr = 4;
            }
            return 1;
        }
        catch (Exception e) {
            Log.DEBUG_LOG(16, "Engine " + fileName + " loading error!!!");
            return 0;
        }
    }

    public int endLoading(String fileName) {
        if (CGEngine.m_nGameMode == 2) {
            CGEngine.m_Board.removeBlockLinesInSurvival(6);
        }
        ApplicationData.setGameMode();
        return 1;
    }

    public void updateLogic(long deltaTimeInMs) {
        CGEngine.Update((int)deltaTimeInMs);
    }

    public void drawGamePlay() {
        CGEngine.Render();
        if (ApplicationData.isMainMenuMode()) {
            CGEngine.m_fCameraPosX = 0.0f;
            CGEngine.m_fCameraPosY = 0.0f;
            return;
        }
        if (Game.pauseTouchKeyPressed) {
            Graphic2D.DrawImage(ObjectsCache.menuSbPAUSE_a, ApplicationData.screenWidth, ApplicationData.screenHeight, 40);
        } else {
            Graphic2D.DrawImage(ObjectsCache.menuSbPAUSE, ApplicationData.screenWidth, ApplicationData.screenHeight, 40);
        }
    }

    public void processTouchCommand(TouchCommand cmd) {
        CGEngine.m_nSterringValue = cmd.onPressed ? (cmd.areaX > ApplicationData.screenWidth / 2 ? -1 : 1) : 0;
        if (cmd.onPressed) {
            if (cmd.areaY > ApplicationData.screenHeight - ObjectsCache.menuSbPAUSE.GetHeight() && cmd.areaX > ApplicationData.screenWidth - ObjectsCache.menuSbPAUSE.GetWidth()) {
                Game.pauseTouchKeyPressed = true;
                return;
            }
            Game.pauseTouchKeyPressed = false;
        }
        if (cmd.onPressed) {
            float fViewModeScale = 1.0f * CGEngine.m_fEngineScale;
            float fX = ((float)cmd.areaX - CGEngineRenderer.m_fScreenOffsetX) / fViewModeScale;
            float fY = ((float)cmd.areaY - CGEngineRenderer.m_fScreenOffsetY) / fViewModeScale;
            CGEngine.m_fTouchX = fX;
            CGEngine.m_fTouchY = fY;
            if (CGEngine.m_Ball[0] != null && CGEngine.m_PaddleObject != null && (double)fY < CGEngine.m_PaddleObject.m_fY) {
                if ((double)fX < CGEngine.m_Ball[0].vecPos.x) {
                    if (!CGEngine.m_Ball[0].isReady) {
                        CGEngine.m_Ball[0].ShootBall(-(CGEngine.m_Ball[0].vecPos.x - (double)fX), -(CGEngine.m_Ball[0].vecPos.y - (double)fY));
                    }
                } else if ((double)fX >= CGEngine.m_Ball[0].vecPos.x && !CGEngine.m_Ball[0].isReady) {
                    CGEngine.m_Ball[0].ShootBall(-(CGEngine.m_Ball[0].vecPos.x - (double)fX), -(CGEngine.m_Ball[0].vecPos.y - (double)fY));
                }
            }
        } else if (!cmd.onPressed) {
            if (Game.pauseTouchKeyPressed) {
                Game.pauseTouchKeyPressed = false;
                UIScreen.SetCurrentScreen(new InGameMainMenu());
                return;
            }
        } else if (!cmd.onPressed) {
            CGEngine.m_nSterringValue = 0;
        }
    }

    public void processKeyCommand(KeyCommand cmd) {
        if (cmd.pressed) {
            if (cmd.keyCode == 8) {
                float rndX = RandSync.nextInt(ApplicationData.screenWidth);
                float rndY = ApplicationData.screenHeight / 3 + RandSync.nextInt(ApplicationData.screenWidth / 3);
                CGEngine.startBallAfterTap(rndX, rndY);
            } else if (cmd.keyCode != ApplicationData.SoftButton1_Code && cmd.keyCode == ApplicationData.SoftButton2_Code) {
                Game.pauseTouchKeyPressed = true;
                return;
            }
        } else if (!cmd.pressed && (Game.pauseTouchKeyPressed || cmd.keyCode == ApplicationData.SoftButton2_Code)) {
            Game.pauseTouchKeyPressed = false;
            System.out.println("new InGameMainMenu()");
            UIScreen.SetCurrentScreen(new InGameMainMenu());
            return;
        }
    }
}

