/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.core.VectorF2;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.CollisionObject;

public class CGBall {
    public static float eRadius = 10.0f;
    public boolean isReady = false;
    public boolean isPupGlueBall = false;
    public boolean isPupFireBall = false;
    public boolean isPupConfuseBall = false;
    public boolean isPupBlockerBall = false;
    public boolean bRenderBall = true;
    private boolean isLifeLost = false;
    public VectorF2 g_vector = new VectorF2();
    public VectorF2 vecNewPos = new VectorF2();
    public VectorF2 vecNewTarget = new VectorF2();
    public VectorF2 vecTarget = null;
    public VectorF2 vecPos = new VectorF2();
    public double fXBallSticked = 0.0;
    public float vecTargetTime = 0.0f;
    public double m_fVelocity = 200.0;
    public double m_fCurrentCollisionT = 1.0;
    public int m_nCurrentCollisionObjectID = -1;
    public int m_nDestroyTime = 0;
    public boolean isBallFalling = false;
    public static boolean isMagnetoOn = false;
    public static boolean isSuperBall = false;
    public static double m_BaseVelocity = 270.0;

    protected void Init() {
    }

    public CGBall() {
        this.vecTarget = new VectorF2();
        this.Init();
    }

    public double PreUpdate(int nDeltaTimeInMs) {
        double fStartX = this.vecPos.x;
        double fStartY = this.vecPos.y;
        double fNewX = fStartX + this.vecTarget.x * this.m_fVelocity * (double)nDeltaTimeInMs / 1000.0;
        double fNewY = fStartY + this.vecTarget.y * this.m_fVelocity * (double)nDeltaTimeInMs / 1000.0;
        this.m_nCurrentCollisionObjectID = -1;
        double fRet = CGEngine.m_CollisionScene.CheckCollision(fStartX, fStartY, fNewX, fNewY, VectorF2.vecTmp1, VectorF2.vecTmp2);
        return fRet;
    }

    public double Update(int nDeltaTimeInMs) {
        this.m_fVelocity += 1.5 * (double)nDeltaTimeInMs / 1000.0;
        if (this.m_fVelocity > 600.0) {
            this.m_fVelocity = 600.0;
        }
        double fStartX = this.vecPos.x;
        double fStartY = this.vecPos.y;
        double fNewX = fStartX + this.vecTarget.x * this.m_fVelocity * (double)nDeltaTimeInMs / 1000.0;
        double fNewY = fStartY + this.vecTarget.y * this.m_fVelocity * (double)nDeltaTimeInMs / 1000.0;
        this.m_nCurrentCollisionObjectID = -1;
        double fRet = CGEngine.m_CollisionScene.CheckCollision(fStartX, fStartY, fNewX, fNewY, VectorF2.vecTmp1, VectorF2.vecTmp2);
        if (fRet <= 1.0 && fRet >= 0.0) {
            int nObjectIndex = CGEngine.m_CollisionScene.m_nCollisionObjectIndex;
            CollisionObject co = CGEngine.m_CollisionScene.Get(nObjectIndex);
            if (co.m_nObjectID >= 0) {
                this.m_nCurrentCollisionObjectID = co.m_nObjectID;
                if (co.isPortal && !this.isPupBlockerBall) {
                    return -1.0;
                }
                if (this.isPupFireBall && co.isOrdinary && !this.isPupBlockerBall) {
                    return -1.0;
                }
                if (this.isPupFireBall && co.isDurableWithoutShield) {
                    return -1.0;
                }
            }
            if (this.m_nCurrentCollisionObjectID == 1000000 && this.isReady) {
                CGEngine.m_PaddleObject.m_nHitAnimTime = 500;
                if (this.isPupGlueBall) {
                    this.fXBallSticked = this.vecPos.x - CGEngine.m_PaddleObject.m_fX;
                    this.isReady = false;
                }
            }
            this.vecNewPos.x = VectorF2.vecTmp1.x;
            this.vecNewPos.y = VectorF2.vecTmp1.y;
            this.vecNewTarget.x = VectorF2.vecTmp2.x;
            this.vecNewTarget.y = VectorF2.vecTmp2.y;
            this.vecNewTarget.Normalize();
            double fRet2 = CGEngine.m_CollisionScene.CheckCollision(this.vecNewPos.x, this.vecNewPos.y, this.vecNewPos.x + this.vecNewTarget.x * 0.01, this.vecNewPos.y + this.vecNewTarget.y * 0.01, VectorF2.vecTmp1, VectorF2.vecTmp2);
            if (fRet2 < 0.0 || fRet2 > 1.0) {
                this.vecNewPos.x += this.vecNewTarget.x * (double)0.01f;
                this.vecNewPos.y += this.vecNewTarget.y * (double)0.01f;
            } else {
                this.vecPos.x += 0.5 * fRet * this.vecTarget.x * 0.01;
                this.vecPos.y += 0.5 * fRet * this.vecTarget.y * 0.01;
                this.vecTarget.x = 0.0;
                this.vecTarget.y = 0.0;
            }
            this.m_fCurrentCollisionT = fRet;
            return fRet;
        }
        this.vecNewTarget.x = this.vecTarget.x;
        this.vecNewTarget.y = this.vecTarget.y;
        this.vecNewPos.y = this.vecPos.y + this.vecNewTarget.y * this.m_fVelocity * (double)nDeltaTimeInMs / 1000.0;
        this.vecNewPos.x = this.vecPos.x + this.vecNewTarget.x * this.m_fVelocity * (double)nDeltaTimeInMs / 1000.0;
        if (this.vecNewPos.y > 650.0 + (double)(5.0f * (eRadius * 2.0f))) {
            this.isLifeLost = true;
        }
        this.m_fCurrentCollisionT = 1.0;
        return this.m_fCurrentCollisionT;
    }

    public void QuickUpdate(int nDeltaTimeInMs) {
        this.vecNewTarget.x = this.vecTarget.x;
        this.vecNewTarget.y = this.vecTarget.y;
        this.vecNewPos.y = this.vecPos.y + this.vecNewTarget.y * this.m_fVelocity * (double)nDeltaTimeInMs / 1000.0;
        this.vecNewPos.x = this.vecPos.x + this.vecNewTarget.x * this.m_fVelocity * (double)nDeltaTimeInMs / 1000.0;
        if (this.vecNewPos.y > (double)(800.0f - eRadius)) {
            this.vecNewPos.y = 800.0f - eRadius;
            this.vecNewTarget.y = -this.vecNewTarget.y;
            this.vecNewTarget.x += (double)(RandSync.nextInt(3) - 1);
            this.vecNewTarget.Normalize();
        }
    }

    public boolean bIsLifeLost() {
        return this.isLifeLost;
    }

    public void Render() {
        if (this.bRenderBall) {
            CGEngineRenderer.RenderBall(this, CGEngine.globalTime);
        }
    }

    public void SetPos(float x, float y) {
        this.vecPos.x = x;
        this.vecPos.y = y;
    }

    public void SetTarget(double dx, double dy) {
        this.vecTarget.x = dx;
        this.vecTarget.y = dy;
        this.vecTarget.Normalize();
    }

    public void setBallSpeedByMultiplier(double multiplier) {
        this.m_fVelocity = multiplier * m_BaseVelocity;
    }

    public void setSpeedUpPU() {
        this.m_fVelocity *= 1.5;
        System.out.println(this.m_fVelocity);
    }

    void ActualizePosAndDir() {
        if (!this.isReady) {
            this.vecPos.x = CGEngine.m_PaddleObject.m_fX + this.fXBallSticked;
            this.vecPos.y = CGEngine.m_PaddleObject.centerYforBall;
        } else {
            this.vecTarget.x = this.vecNewTarget.x;
            this.vecTarget.y = this.vecNewTarget.y;
            this.vecPos.x = this.vecNewPos.x;
            this.vecPos.y = this.vecNewPos.y;
        }
        this.isBallFalling = !(this.vecTarget.y < 0.0);
        if (this.isBallFalling && isMagnetoOn) {
            if (this.vecPos.x < CGEngine.m_PaddleObject.centerXforBall) {
                this.vecTarget.x += 0.01;
                this.vecTarget.y += 0.01;
            } else if (this.vecPos.x > CGEngine.m_PaddleObject.centerXforBall) {
                this.vecTarget.x -= 0.01;
                this.vecTarget.y += 0.01;
            }
        }
    }

    public void ShootBall(double x, double y) {
        this.m_fVelocity = m_BaseVelocity;
        this.SetTarget(x, y);
        this.isReady = true;
    }

    public void cloneSettingsOfBall(CGBall patternBall) {
        this.isPupGlueBall = patternBall.isPupGlueBall;
        this.isPupConfuseBall = patternBall.isPupConfuseBall;
        this.isPupBlockerBall = patternBall.isPupBlockerBall;
        this.isPupFireBall = patternBall.isPupFireBall;
    }
}

