/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGFallingPowerUp;
import baltorogames.project_gameplay.PowerupObject;
import java.util.Vector;

public class CGActivePowerUp {
    public static Vector m_VectorActivePU = null;

    public static void Init() {
        m_VectorActivePU = new Vector();
    }

    public static void NewActivePowerUp(PowerupObject po) {
        CGEngine.m_CollisionScene.Remove(po.m_CollisionObject);
        po.m_bIsActive = true;
        po.setLifeTimeOfActivePowerUp();
        po.setPowerUpFlagueState(true);
        if (po.m_nType == 4) {
            CGEngine.fillUp3Balls();
        } else if (po.m_nType == 10 && CGEngine.m_nGameMode == 3) {
            CGEngine.m_TimedModeTime += CGBoard.eTimedIncementValue;
        } else {
            int index = CGActivePowerUp.GetIndexInVector(po.m_nType);
            if (index != -1) {
                ((PowerupObject)CGActivePowerUp.m_VectorActivePU.elementAt((int)index)).m_nActivePowerUpLifeTime += po.m_nActivePowerUpLifeTime;
            } else if (m_VectorActivePU.size() != 0) {
                ((PowerupObject)CGActivePowerUp.m_VectorActivePU.elementAt((int)0)).m_nActivePowerUpLifeTime = -1;
                m_VectorActivePU.addElement(po);
            } else {
                m_VectorActivePU.addElement(po);
            }
        }
        CGFallingPowerUp.RemoveByID(po.m_nID);
    }

    public static void UpdateAll(int nDeltaTimeInMs) {
        int nS = m_VectorActivePU.size();
        for (int i = nS - 1; i >= 0; --i) {
            PowerupObject fb = (PowerupObject)m_VectorActivePU.elementAt(i);
            fb.Update(nDeltaTimeInMs);
            if (fb.m_nActivePowerUpLifeTime >= 0) continue;
            ((PowerupObject)m_VectorActivePU.elementAt(i)).resetCurrPowerUp();
            ((PowerupObject)m_VectorActivePU.elementAt(i)).DestroyActivePowerUp();
        }
    }

    public static void GeneratePowerup() {
    }

    public static void Reset() {
        m_VectorActivePU.removeAllElements();
    }

    public static void RemoveByID(int nID) {
        if (m_VectorActivePU == null) {
            return;
        }
        int nS = m_VectorActivePU.size();
        for (int i = 0; i < nS; ++i) {
            PowerupObject go = (PowerupObject)m_VectorActivePU.elementAt(i);
            if (go.m_nID != nID) continue;
            go.Destroy();
            m_VectorActivePU.removeElementAt(i);
            return;
        }
    }

    public static PowerupObject GetObjectByID(int nID) {
        if (m_VectorActivePU == null) {
            return null;
        }
        int nS = m_VectorActivePU.size();
        for (int i = 0; i < nS; ++i) {
            PowerupObject go = (PowerupObject)m_VectorActivePU.elementAt(i);
            if (go.m_nID != nID) continue;
            return go;
        }
        return null;
    }

    public static PowerupObject GetObjectByType(int nType) {
        if (m_VectorActivePU == null) {
            return null;
        }
        int nS = m_VectorActivePU.size();
        for (int i = 0; i < nS; ++i) {
            PowerupObject go = (PowerupObject)m_VectorActivePU.elementAt(i);
            if (go.m_nType != nType) continue;
            return go;
        }
        return null;
    }

    public static int GetIndexInVector(int nType) {
        if (m_VectorActivePU == null) {
            return -1;
        }
        int nS = m_VectorActivePU.size();
        for (int i = 0; i < nS; ++i) {
            PowerupObject go = (PowerupObject)m_VectorActivePU.elementAt(i);
            if (go.m_nType != nType) continue;
            return i;
        }
        return -1;
    }

    public static boolean IsAnyPowerDownActive() {
        if (m_VectorActivePU == null) {
            return false;
        }
        int nS = m_VectorActivePU.size();
        for (int i = 0; i < nS; ++i) {
            PowerupObject go = (PowerupObject)m_VectorActivePU.elementAt(i);
            if (!go.bisPowerDown) continue;
            return true;
        }
        return false;
    }

    public static boolean IsAnyPowerUpActive() {
        if (m_VectorActivePU == null) {
            return false;
        }
        int nS = m_VectorActivePU.size();
        for (int i = 0; i < nS; ++i) {
            PowerupObject go = (PowerupObject)m_VectorActivePU.elementAt(i);
            if (!go.bisPowerUp) continue;
            return true;
        }
        return false;
    }

    public static PowerupObject GetFirstElement() {
        if (m_VectorActivePU == null) {
            return null;
        }
        return (PowerupObject)m_VectorActivePU.firstElement();
    }
}

