/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.MainScreen;
import baltorogames.project_gui.SelectModeScreen;
import baltorogames.project_gui.SelectPlanet;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import baltorogames.system.Platform;

public class SelectGalaxy
extends MainScreen {
    public static boolean forceLevelsUnlock = false;
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public static final int WORLD_1 = 0;
    public static final int WORLD_2 = 1;
    public static final int WORLD_3 = 2;
    private UIFloatingTextBox infoBox;
    public static int selectedCountry = 0;
    private boolean bAvailable = true;
    private CGTexture worldTexture = null;
    private CGTexture lockedTexture = null;

    public SelectGalaxy() {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        this.drawTop = true;
        this.drawTitle = true;
        this.windowCaptionText = "";
        this.bAvailable = true;
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        int x = 9 * ApplicationData.screenWidth / 10 - ObjectsCache.arrowRight.GetWidth() / 2;
        int y = ApplicationData.screenHeight / 3 - ObjectsCache.arrowRight.GetHeight() / 2;
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(x, y, ObjectsCache.arrowRight, ObjectsCache.arrowRight_a, 101);
        rightB.setScreen(this);
        rightB.setAnimDir(1.0f);
        this.addButton(rightB);
        x = ApplicationData.screenWidth / 10 - ObjectsCache.arrowRight.GetWidth() / 2;
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(x, y, ObjectsCache.arrowLeft, ObjectsCache.arrowLeft_a, 100);
        leftB.setScreen(this);
        leftB.setAnimDir(-1.0f);
        this.addButton(leftB);
        this.lockedTexture = TextureManager.AddTexture("/menu/b_locked.png");
        this.updateInfo();
    }

    public void autoSize() {
        this.clientAreaX = Platform.WND_MARGIN_LEFT;
        this.clientAreaWidth = this.width - Platform.WND_MARGIN_LEFT - Platform.WND_MARGIN_RIGHT;
        this.clientAreaY = Platform.WND_MARGIN_TOP;
        this.clientAreaHeight = this.height - Platform.WND_MARGIN_TOP - Platform.WND_MARGIN_BOTTOM;
    }

    private void updateInfo() {
        this.bAvailable = CGUserCareer.IsEnvironmentAvailable(selectedCountry);
        this.worldTexture = TextureManager.AddTexture("/menu/galaxy_" + (selectedCountry + 1) + ".png");
        if (this.infoBox == null) {
            this.infoBox = new UIFloatingTextBox(false, 0, ApplicationData.screenHeight / 3 + this.worldTexture.GetHeight() / 2, ApplicationData.screenWidth, ApplicationData.screenHeight / 4);
        }
        String text = "";
        if (selectedCountry == 1) {
            text = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_INFO_STORY_W2_UNLOCK");
        }
        if (selectedCountry == 2) {
            text = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_INFO_STORY_W3_UNLOCK");
        }
        this.infoBox.setText(text);
        this.findByID(UIScreen.ID_BUTTON_OK).setVisible(this.bAvailable);
    }

    public void onUpdate(float deltaTime) {
        super.onUpdate(deltaTime);
    }

    public void draw() {
        Graphic2D.DrawImage(this.worldTexture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 3, 3);
        if (!this.bAvailable) {
            Graphic2D.DrawImage(this.lockedTexture, ApplicationData.screenWidth / 2, ApplicationData.screenHeight / 3, 3);
        }
        Utils.drawString(ApplicationData.defaultFont.encodeDynamicString(selectedCountry + 1 + "/3"), ApplicationData.screenWidth >> 1, ApplicationData.screenHeight / 3 - this.worldTexture.GetHeight() / 2 >> 1, 3, 0);
        if (!this.bAvailable) {
            this.infoBox.draw();
        }
    }

    public boolean rightSoftButton() {
        TextureManager.DeleteTexture(this.worldTexture);
        UIScreen.SetCurrentScreen(new SelectModeScreen());
        return true;
    }

    public boolean leftSoftButton() {
        CGEngine.m_nCurrentGalaxy = selectedCountry;
        TextureManager.DeleteTexture(this.worldTexture);
        UIScreen.SetCurrentScreen(new SelectPlanet(selectedCountry));
        return true;
    }

    public boolean onRightAction() {
        if (++selectedCountry >= 3) {
            selectedCountry = 0;
        }
        this.updateInfo();
        return true;
    }

    public boolean onLeftAction() {
        if (--selectedCountry < 0) {
            selectedCountry = 2;
        }
        this.updateInfo();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }
}

