/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.Utils;
import baltorogames.core_gui.UIAnimatedButtonH;
import baltorogames.core_gui.UIButton;
import baltorogames.core_gui.UIFloatingTextBox;
import baltorogames.core_gui.UIScreen;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.MainScreen;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;

public class PowerupInfoScreen
extends MainScreen {
    private final int LEFT_ARROW_ID;
    private final int RIGHT_ARROW_ID;
    public static int selectedPowerup = 0;
    private int nStartBoxY = 0;
    private int nStopBoxY = 0;
    private int nBoxWidth = 0;
    private UIFloatingTextBox infoBox;
    private String csText1;
    private String csText2;
    private String csText3;
    private CGTexture[] powerupImages = null;

    protected void Clean() {
        for (int i = 0; i < 12; ++i) {
            TextureManager.DeleteTexture(this.powerupImages[i]);
            this.powerupImages[i] = null;
        }
        this.powerupImages = null;
    }

    public void onFocusBack() {
        super.onFocusBack();
        if (this.powerupImages == null) {
            this.powerupImages = new CGTexture[12];
            this.powerupImages[0] = TextureManager.AddTexture("/menu/p_freeze.png");
            this.powerupImages[1] = TextureManager.AddTexture("/menu/p_reverse.png");
            this.powerupImages[2] = TextureManager.AddTexture("/menu/p_bomb.png");
            this.powerupImages[3] = TextureManager.AddTexture("/menu/p_laser.png");
            this.powerupImages[4] = TextureManager.AddTexture("/menu/p_swap.png");
            this.powerupImages[5] = TextureManager.AddTexture("/menu/p_laser.png");
            this.powerupImages[6] = TextureManager.AddTexture("/menu/p_uniball.png");
            this.powerupImages[7] = TextureManager.AddTexture("/menu/shop_upgrade_empty.png");
            this.powerupImages[8] = TextureManager.AddTexture("/menu/p_multi.png");
            this.powerupImages[9] = TextureManager.AddTexture("/menu/p_ka.png");
            this.powerupImages[10] = TextureManager.AddTexture("/menu/p_sd.png");
            this.powerupImages[11] = TextureManager.AddTexture("/menu/p_tw.png");
        }
    }

    public PowerupInfoScreen() {
        this.LEFT_ARROW_ID = 100;
        this.RIGHT_ARROW_ID = 101;
        selectedPowerup = 0;
        this.drawTop = true;
        this.drawTitle = true;
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_HEADER_HELP"));
        this.setSoftButtonImage(null, null, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        if (this.powerupImages == null) {
            this.powerupImages = new CGTexture[12];
            this.powerupImages[0] = TextureManager.AddTexture("/menu/p_freeze.png");
            this.powerupImages[1] = TextureManager.AddTexture("/menu/p_reverse.png");
            this.powerupImages[2] = TextureManager.AddTexture("/menu/p_bomb.png");
            this.powerupImages[3] = TextureManager.AddTexture("/menu/p_laser.png");
            this.powerupImages[4] = TextureManager.AddTexture("/menu/p_swap.png");
            this.powerupImages[5] = TextureManager.AddTexture("/menu/p_laser.png");
            this.powerupImages[6] = TextureManager.AddTexture("/menu/p_uniball.png");
            this.powerupImages[7] = TextureManager.AddTexture("/menu/shop_upgrade_empty.png");
            this.powerupImages[8] = TextureManager.AddTexture("/menu/p_multi.png");
            this.powerupImages[9] = TextureManager.AddTexture("/menu/p_ka.png");
            this.powerupImages[10] = TextureManager.AddTexture("/menu/p_sd.png");
            this.powerupImages[11] = TextureManager.AddTexture("/menu/p_tw.png");
        }
        int trackIconX = ApplicationData.screenWidth / 2 - this.powerupImages[0].GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 2 - this.powerupImages[0].GetHeight();
        int arrowsY = trackIconY + this.powerupImages[0].GetHeight() / 2 - ObjectsCache.arrowLeft.GetHeight() / 2;
        int arrowLeftX = ApplicationData.screenWidth / 2 - this.powerupImages[0].GetWidth() - ObjectsCache.arrowLeft.GetWidth();
        int arrowRightX = ApplicationData.screenWidth / 2 + this.powerupImages[0].GetWidth();
        UIAnimatedButtonH rightB = new UIAnimatedButtonH(arrowRightX, arrowsY, ObjectsCache.arrowRight, ObjectsCache.arrowRight_a, 101);
        rightB.setScreen(this);
        rightB.setAnimDir(1.0f);
        this.addButton(rightB);
        UIAnimatedButtonH leftB = new UIAnimatedButtonH(arrowLeftX, arrowsY, ObjectsCache.arrowLeft, ObjectsCache.arrowLeft_a, 100);
        leftB.setScreen(this);
        leftB.setAnimDir(-1.0f);
        this.addButton(leftB);
        this.nStartBoxY = arrowsY + ApplicationData.getFontByID(0).getFontHeight();
        this.nStopBoxY = ApplicationData.screenHeight - ObjectsCache.menuSbOK.GetHeight() - ApplicationData.getFontByID(0).getFontHeight() - ApplicationData.getFontByID(0).getFontHeight() / 4;
        this.nBoxWidth = ApplicationData.screenWidth;
        this.infoBox = new UIFloatingTextBox(false, (ApplicationData.screenWidth - this.nBoxWidth) / 2, this.nStartBoxY, this.nBoxWidth, this.nStopBoxY - this.nStartBoxY);
        this.updateAchievementInfo();
    }

    private void updateAchievementInfo() {
        this.csText1 = ApplicationData.defaultFont.encodeDynamicString("" + (selectedPowerup + 1) + " / " + 12);
        this.csText2 = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_POWERUP_SHORT_DESCRIPTION_" + selectedPowerup);
        this.infoBox.setText(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_POWERUP_FULL_DESCRIPTION_" + selectedPowerup));
    }

    public void autoSize() {
    }

    public void draw() {
        int trackIconX = ApplicationData.screenWidth / 2 - this.powerupImages[0].GetWidth() / 2;
        int trackIconY = ApplicationData.screenHeight / 2 - this.powerupImages[0].GetHeight();
        Graphic2D.DrawImage(this.powerupImages[selectedPowerup], trackIconX, trackIconY, 20);
        Utils.drawString(this.csText1, ApplicationData.screenWidth >> 1, trackIconY - ApplicationData.getFontByID(0).getFontHeight() / 4 - ApplicationData.getFontByID(0).getFontHeight() - ApplicationData.getFontByID(0).getFontHeight() / 4, 33, 0);
        Utils.drawString(this.csText2, ApplicationData.screenWidth >> 1, trackIconY - ApplicationData.getFontByID(0).getFontHeight() / 4, 33, 0);
        this.infoBox.draw();
    }

    public boolean rightSoftButton() {
        this.Clean();
        UIScreen.SetCurrentScreen(new MainMenu());
        return true;
    }

    public boolean leftSoftButton() {
        return false;
    }

    public boolean selectLeftAction() {
        UIButton b = this.findByID(100);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean selectRightAction() {
        UIButton b = this.findByID(101);
        if (b != null) {
            b.setSelect(true);
            return true;
        }
        return false;
    }

    public boolean onRightAction() {
        if (++selectedPowerup == 7) {
            ++selectedPowerup;
        }
        if (selectedPowerup >= 12) {
            selectedPowerup = 0;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onLeftAction() {
        if (--selectedPowerup == 7) {
            --selectedPowerup;
        }
        if (selectedPowerup < 0) {
            selectedPowerup = 11;
        }
        this.updateAchievementInfo();
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (super.actionSoftButton(nID, pressed)) {
            return true;
        }
        if (!pressed) {
            this.unselectAllButtons();
            if (nID == 100) {
                this.onLeftAction();
                return true;
            }
            if (nID == 101) {
                this.onRightAction();
                return true;
            }
        }
        return false;
    }
}

