/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.RandSync;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.LevelScenario;
import baltorogames.project_gameplay.PowerupObject;
import java.util.Vector;

public class CGFallingPowerUp {
    public static int minIDNumber = 5000;
    public static int maxIDNumber = 5100;
    public static final int POWER_LASER = 0;
    public static final int POWER_FIREBALL = 1;
    public static final int POWER_GLUE = 2;
    public static final int POWER_DOUBLE = 3;
    public static final int POWER_3BALL = 4;
    public static final int POWER_SLOWBALL = 5;
    public static final int POWER_INVERT = 6;
    public static final int POWER_SPEEDUP = 7;
    public static final int POWER_BLOCKER = 8;
    public static final int POWER_SHRINK = 9;
    public static final int POWER_ADDTIME = 10;
    public static final int NUM_OF_POWERUPS = 11;
    public static float eHalfWidth = 30.0f;
    public static float eHalfHeight = 30.0f;
    public static int timeIntervalBetweenPowerUps = 1500;
    public float m_fX;
    public float m_fY;
    public float m_fCurrentSpeed;
    public int m_nTime;
    public int nType = 0;
    public static Vector m_Vector = null;

    public static void Init() {
        m_Vector = new Vector();
    }

    public static void UpdateAll(int nDeltaTimeInMs) {
        int nS = m_Vector.size();
        for (int i = nS - 1; i >= 0; --i) {
            PowerupObject fb = (PowerupObject)m_Vector.elementAt(i);
            fb.Update(nDeltaTimeInMs);
            if (!(fb.m_fY > 900.0)) continue;
            ((PowerupObject)m_Vector.elementAt(i)).DestroyPowerUp();
        }
        timeIntervalBetweenPowerUps -= nDeltaTimeInMs;
    }

    public static void RenderAll() {
        int nS = m_Vector.size();
        for (int i = nS - 1; i >= 0; --i) {
            PowerupObject fb = (PowerupObject)m_Vector.elementAt(i);
            fb.Render();
        }
    }

    public static void NewPowerUp(float x, float y) {
        if (RandSync.nextInt() % 100 > CGBoard.probabilityOfPowerUp) {
            return;
        }
        int nID = 0;
        int nType = CGFallingPowerUp.GenerateTypeOfPowerup();
        if (nType == -1) {
            return;
        }
        nID = m_Vector.isEmpty() ? minIDNumber : ((PowerupObject)CGFallingPowerUp.m_Vector.lastElement()).m_nID + 1;
        PowerupObject fb = new PowerupObject();
        fb.Init(x, y, eHalfWidth * 2.0f, eHalfHeight * 2.0f, nType, nID);
        m_Vector.addElement(fb);
    }

    public static void Reset() {
        m_Vector.removeAllElements();
    }

    public static void RemoveByID(int nID) {
        if (m_Vector == null) {
            return;
        }
        int nS = m_Vector.size();
        for (int i = 0; i < nS; ++i) {
            PowerupObject go = (PowerupObject)m_Vector.elementAt(i);
            if (go.m_nID != nID) continue;
            go.Destroy();
            m_Vector.removeElementAt(i);
            return;
        }
    }

    public static PowerupObject GetObjectByID(int nID) {
        if (m_Vector == null) {
            return null;
        }
        int nS = m_Vector.size();
        for (int i = 0; i < nS; ++i) {
            PowerupObject go = (PowerupObject)m_Vector.elementAt(i);
            if (go.m_nID != nID) continue;
            return go;
        }
        return null;
    }

    public static int GenerateTypeOfPowerup() {
        int type = -1;
        int percents = 0;
        int nR = RandSync.nextInt(100);
        for (int i = 0; i < 11; ++i) {
            if ((percents += LevelScenario.sortedProbabilitiesOfPowerUps[i][1]) > 100) {
                System.out.println("ERROR! Sum of probability > 100%");
                return -1;
            }
            if (nR >= percents) continue;
            type = LevelScenario.sortedProbabilitiesOfPowerUps[i][0];
            break;
        }
        return type;
    }
}

