/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.system.BGStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CGAchievements {
    public static final int eAchievements_FirstTimeWinner = 0;
    public static final int eAchievements_NoLostBall = 1;
    public static final int eAchievements_NoPowerUpDown = 2;
    public static final int eAchievements_PowersUnlocked = 3;
    public static final int eAchievements_3StarsForAlllvls = 4;
    public static final int eAchievements_Timed30Minutes = 5;
    public static final int eAchievements_Timed60Minutes = 6;
    public static final int eAchievements_Stage1Completed = 7;
    public static final int eAchievements_Stage2Completed = 8;
    public static final int eAchievements_Stage3Completed = 9;
    public static final int eAchievements_Survi30Minutes = 10;
    public static final int eAchievements_Survi60Minutes = 11;
    public static final int eMaxAchievements = 12;
    protected static boolean[] arrAchievementsCompleted = new boolean[12];
    public static int m_nTimedTimeInMs;
    public static int m_nSurvivalTimeInMs;
    public static int m_nCombosNr;
    public static int m_nChainsNr;
    public static int m_nMaxCombo;
    public static int m_nMaxChain;
    protected static boolean m_bLoaded;

    public static void Reset() {
        for (int i = 0; i < 12; ++i) {
            CGAchievements.arrAchievementsCompleted[i] = false;
        }
        m_nTimedTimeInMs = 0;
        m_nSurvivalTimeInMs = 0;
        m_nCombosNr = 0;
        m_nChainsNr = 0;
        m_nMaxCombo = 0;
        m_nMaxChain = 0;
    }

    public static void completeAchievement(int nIndex) {
        if (!arrAchievementsCompleted[nIndex]) {
            CGAchievements.arrAchievementsCompleted[nIndex] = true;
        }
    }

    public static boolean isAchievementCompleted(int nIndex) {
        return arrAchievementsCompleted[nIndex];
    }

    public static void Load() {
        BGStore store = BGStore.openStoreToRead("Achievements");
        if (store == null) {
            System.out.println("No Achievements store!!!!!!!!!!!!!!!!!!!!!!!");
            m_bLoaded = true;
            return;
        }
        try {
            DataInputStream inputStream = store.getInStream();
            if (inputStream != null && inputStream.available() > 0) {
                for (int i = 0; i < 12; ++i) {
                    CGAchievements.arrAchievementsCompleted[i] = inputStream.readBoolean();
                }
                m_nTimedTimeInMs = inputStream.readInt();
                m_nSurvivalTimeInMs = inputStream.readInt();
                m_nCombosNr = inputStream.readInt();
                m_nChainsNr = inputStream.readInt();
                m_nMaxCombo = inputStream.readInt();
                m_nMaxChain = inputStream.readInt();
            }
            store.close();
            m_bLoaded = true;
        }
        catch (Exception e) {
            CGAchievements.Reset();
            m_bLoaded = true;
            return;
        }
    }

    public static void Save() {
        if (!m_bLoaded) {
            System.out.println("No Achievements loaded!!!!!!!!!!!!!!!!!!!!!!!");
            return;
        }
        BGStore store = BGStore.openStoreToWrite("Achievements");
        if (store == null) {
            return;
        }
        try {
            DataOutputStream outputStream = store.getOutStream();
            for (int i = 0; i < 12; ++i) {
                outputStream.writeBoolean(arrAchievementsCompleted[i]);
            }
            outputStream.writeInt(m_nTimedTimeInMs);
            outputStream.writeInt(m_nSurvivalTimeInMs);
            outputStream.writeInt(m_nCombosNr);
            outputStream.writeInt(m_nChainsNr);
            outputStream.writeInt(m_nMaxCombo);
            outputStream.writeInt(m_nMaxChain);
            store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void AddSurvivalTime(int nDeltaTimeInMs) {
        m_nSurvivalTimeInMs += nDeltaTimeInMs;
        if (!arrAchievementsCompleted[10]) {
            if ((double)m_nSurvivalTimeInMs >= 1800000.0) {
                CGAchievements.completeAchievement(10);
            } else if (!arrAchievementsCompleted[11] && m_nSurvivalTimeInMs >= 3600000) {
                CGAchievements.completeAchievement(11);
            }
        }
    }

    public static void AddTimedTime(int nDeltaTimeInMs) {
        m_nTimedTimeInMs += nDeltaTimeInMs;
        if (!arrAchievementsCompleted[5]) {
            if ((double)m_nTimedTimeInMs >= 1800000.0) {
                CGAchievements.completeAchievement(5);
            } else if (!arrAchievementsCompleted[6] && m_nTimedTimeInMs >= 3600000) {
                CGAchievements.completeAchievement(6);
            }
        }
    }

    public static void CheckAllLevels3Stars() {
        if (CGAchievements.isAchievementCompleted(4)) {
            return;
        }
        for (int i = 0; i < 36; ++i) {
            if (CGUserCareer.arrLevelStats[i].m_nStars >= 3) continue;
            return;
        }
        CGAchievements.completeAchievement(4);
    }

    public static void CheckBeatAllLevelsTime() {
    }

    public static void CheckGalaxy1Completed() {
        if (CGUserCareer.IsEnvironmentCompleted(0)) {
            CGAchievements.completeAchievement(7);
        }
    }

    public static void CheckGalaxy2Completed() {
        if (CGUserCareer.IsEnvironmentCompleted(1)) {
            CGAchievements.completeAchievement(8);
        }
    }

    public static void CheckGalaxy3Completed() {
        if (CGUserCareer.IsEnvironmentCompleted(2)) {
            CGAchievements.completeAchievement(9);
        }
    }

    public static void CheckAdventureCompleted() {
    }

    public static void SetMaxCombo(int n) {
        if (CGEngine.m_nSurvivalLevel >= 0) {
            return;
        }
        if (m_nMaxCombo < n) {
            m_nMaxCombo = n;
        }
    }

    public static void SetMaxChain(int n) {
        if (CGEngine.m_nSurvivalLevel >= 0) {
            return;
        }
        if (m_nMaxChain < n) {
            m_nMaxChain = n;
        }
    }

    static {
        m_bLoaded = false;
    }
}

