/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGEngineRenderer;
import baltorogames.project_gameplay.ListInt;
import baltorogames.system.Options;
import java.util.Vector;

public class AchievementPopup {
    private static Vector infoList = new Vector();
    private static long startTime = 0L;
    private static float m_xpos;
    private static float m_ypos;
    private static float m_width;
    private static float m_height;
    private static CGTexture backTexture;
    private static String text;
    private static String textHeader;

    public static void Init() {
        startTime = 0L;
        backTexture = TextureManager.CreateFilteredTexture("/menu/achieve_popup_bg.png");
        m_width = 480.0f;
        m_height = 130.0f;
        m_xpos = 0.0f;
        m_ypos = 700.0f - m_height;
    }

    public static boolean IsEnabled() {
        return startTime > 0L;
    }

    public static void Step() {
        if (startTime > 0L) {
            long lDeltaTime = ApplicationData.getAppTime() - startTime;
            if (lDeltaTime > 2000L) {
                if (infoList.size() > 0) {
                    int nCurrentID = ((ListInt)AchievementPopup.infoList.elementAt((int)0)).nValue;
                    infoList.removeElementAt(0);
                    AchievementPopup.NewAchievementInfoInternal(nCurrentID);
                } else {
                    startTime = 0L;
                }
            } else {
                AchievementPopup.Render(lDeltaTime);
            }
        }
    }

    public static void NewAchievement(int nIndex) {
        if (startTime > 0L) {
            ListInt obj = new ListInt();
            obj.nValue = nIndex;
            infoList.addElement(obj);
        } else {
            AchievementPopup.NewAchievementInfoInternal(nIndex);
        }
    }

    private static void NewAchievementInfoInternal(int nIndex) {
        startTime = ApplicationData.getAppTime();
        if (nIndex < 100) {
            text = ApplicationData.lp.getTranslatedString(Options.languageID, "TID_ACHIEVEMENT_HEADER_" + nIndex);
        }
    }

    private static void Render(long lDeltaTime) {
        float fAlpha = 0.0f;
        if (lDeltaTime <= 300L) {
            fAlpha = (float)lDeltaTime / 300.0f;
        } else if (lDeltaTime <= 2500L) {
            fAlpha = 1.0f;
        } else if (lDeltaTime <= 2800L) {
            fAlpha = 1.0f - (float)(lDeltaTime - 2500L) / 300.0f;
        } else if (lDeltaTime <= 3000L) {
            fAlpha = 0.0f;
        }
        if (fAlpha == 1.0f) {
            Graphic2D.DrawRegion(backTexture, CGEngineRenderer.m_fScreenOffsetX + m_xpos * CGEngine.m_fEngineScale, CGEngineRenderer.m_fScreenOffsetY + m_ypos * CGEngine.m_fEngineScale, 0.0f, 0.0f, CGEngineRenderer.m_fScreenOffsetX + (m_xpos + m_width) * CGEngine.m_fEngineScale, CGEngineRenderer.m_fScreenOffsetY + (m_ypos + m_height) * CGEngine.m_fEngineScale, 1.0f, 1.0f);
        }
    }

    static {
        backTexture = null;
        text = new String();
        textHeader = new String();
    }
}

