/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.core;

import baltorogames.core.MathExt;
import baltorogames.core.MatrixF22;

public class VectorF2 {
    public double x;
    public double y;
    public static VectorF2 vecTmp1 = new VectorF2();
    public static VectorF2 vecTmp2 = new VectorF2();
    public static VectorF2 vecTmp3 = new VectorF2();
    public static VectorF2 vecTmp4 = new VectorF2();
    public static VectorF2 vecTmp5 = new VectorF2();
    public static VectorF2 vecTmp6 = new VectorF2();
    public static VectorF2 vecTmp7 = new VectorF2();
    public static VectorF2 vecTmp8 = new VectorF2();
    public static VectorF2 vecTmp9 = new VectorF2();
    public static VectorF2 vecTmp10 = new VectorF2();

    public double Normalize() {
        double fL = Math.sqrt(this.x * this.x + this.y * this.y);
        if (fL > 0.0) {
            this.x /= fL;
            this.y /= fL;
        } else {
            this.x = 0.0;
            this.y = 0.0;
        }
        return fL;
    }

    public double Length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public static void VectorFromAngle(double fAngle, VectorF2 dst) {
        VectorF2 vec = new VectorF2();
        vec.x = 0.0;
        vec.y = 1.0;
        double fRA = fAngle * (double)3.1415f / 180.0;
        MatrixF22 m = new MatrixF22();
        m.MatrixF22_Rot((float)Math.sin(fRA), (float)Math.cos(fRA), (float)fAngle);
        m.MatrixF22_Mul_VectorF2(vec, dst);
    }

    public static double AngleFromVector(VectorF2 src) {
        if (src.x == 0.0 && src.y == 0.0) {
            return -3000.0;
        }
        float vec1_X = 0.0f;
        float vec1_Y = 1.0f;
        double fLength = src.x * src.x + src.y * src.y;
        if (fLength <= 1.0E-6) {
            return -3000.0;
        }
        fLength = (float)Math.sqrt(fLength);
        double vec2_X = src.x / fLength;
        double vec2_Y = src.y / fLength;
        double fCos = (double)vec1_X * vec2_X + (double)vec1_Y * vec2_Y;
        double fAngle = MathExt.acos(fCos);
        fAngle *= 57.29579162597656;
        if (src.x > 0.0) {
            fAngle = 360.0 - fAngle;
        }
        if (fAngle < 0.0) {
            fAngle += 360.0;
        }
        return fAngle;
    }
}

