/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.top;

import Default.Common;
import Default.Draw;
import Default.GameCanvas;
import com.lemonquest.text.LQFont;
import com.lemonquest.top.DrawHttpTop;
import com.lemonquest.top.TopCanvas;
import com.lemonquest.utils.SSFunctions;
import com.lemonquest.utils.SSKeyboard;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TopEngine {
    public static final int MAX_NAME_LENGTH = 7;
    private static final int CHARACTER_SPACING = 13;
    public static final int POPUP_TILE_SIZE = 14;
    public int totalPercentage;
    public long totalTime;
    public String formatedPercentage;
    public static final char[][] letters = new char[][]{{'A', 'B', 'C'}, {'D', 'E', 'F'}, {'G', 'H', 'I'}, {'J', 'K', 'L'}, {'M', 'N', '?', 'O'}, {'P', 'Q', 'R', 'S'}, {'T', 'U', 'V'}, {'W', 'X', 'Y', 'Z'}};
    public String[] highScoresNames;
    public int[] highScores;
    public int posHighScore;
    public int posLetter;
    public int posSymbol;
    public char actualChar;
    public StringBuffer actualName;
    public String url;
    public SSKeyboard keyboard;
    public DrawHttpTop con = null;
    TopCanvas canvas;

    public TopEngine(TopCanvas c) {
        c.setFullScreenMode(true);
        this.canvas = c;
        this.keyboard = new SSKeyboard();
        this.highScores = new int[5];
        this.highScoresNames = new String[5];
    }

    public void setUrl(String u) {
        this.url = u;
    }

    public String formatPercentage(int percentage2Format) {
        int formatedPercentageDecimal = percentage2Format % 100;
        int formatedPercentageInteger = percentage2Format / 100;
        this.formatedPercentage = formatedPercentageDecimal > 0 && formatedPercentageDecimal < 10 ? formatedPercentageInteger + ".0" + formatedPercentageDecimal : formatedPercentageInteger + "." + formatedPercentageDecimal;
        if (formatedPercentageDecimal == 0) {
            this.formatedPercentage = this.formatedPercentage + "0";
        }
        return this.formatedPercentage;
    }

    public void processKeysHighScoreNew() {
        this.highScores[this.posHighScore] = this.totalPercentage;
        while (this.keyboard.getHasMoreKeys()) {
            char key = this.keyboard.nextChar();
            if (this.keyboard.getLastEvent() != 0) continue;
            if (key >= '2' && key <= '9') {
                int posNewLetter = key - 50;
                if (posNewLetter != this.posLetter) {
                    this.posSymbol = 0;
                    this.posLetter = posNewLetter;
                } else {
                    this.posSymbol = this.nextPart(this.posSymbol, letters[this.posLetter].length);
                }
            } else if (key == '\u0000' || key == '\u0002') {
                this.actualName.append(this.actualChar);
                this.highScoresNames[this.posHighScore] = this.actualName.toString();
                this.saveHighscores();
                this.con = new DrawHttpTop(this, this.totalPercentage, this.totalTime, this.url);
                this.canvas.setStateHighScoreOnline();
            } else if (key == '\u0001') {
                this.con = new DrawHttpTop(this, this.totalPercentage, this.totalTime, this.url);
                this.canvas.setStateHighScoreOnline();
            } else if (key == '\u0005') {
                if (this.posSymbol > 0) {
                    --this.posSymbol;
                } else {
                    do {
                        if (this.posLetter > 0) {
                            --this.posLetter;
                            continue;
                        }
                        this.posLetter = letters.length - 1;
                    } while (letters[this.posLetter].length == 0);
                    this.posSymbol = letters[this.posLetter].length - 1;
                }
            } else if (key == '\u0006') {
                if (this.posSymbol < letters[this.posLetter].length - 1) {
                    ++this.posSymbol;
                } else {
                    do {
                        if (this.posLetter < letters.length - 1) {
                            ++this.posLetter;
                            continue;
                        }
                        this.posLetter = 0;
                    } while (letters[this.posLetter].length == 0);
                    this.posSymbol = 0;
                }
            } else if (key == '\u0004') {
                if (this.actualName.length() < 7) {
                    this.actualName.append(this.actualChar);
                }
            } else if (key == '\u0003' && this.actualName.length() > 0) {
                this.searchSymbol(this.actualName.charAt(this.actualName.length() - 1), letters);
                this.actualName.deleteCharAt(this.actualName.length() - 1);
            }
            this.actualChar = letters[this.posLetter][this.posSymbol];
        }
    }

    private int nextPart(int posPart, int maxPart) {
        if (++posPart == maxPart) {
            posPart = 0;
        }
        return posPart;
    }

    private void searchSymbol(char symbol, char[][] letters) {
        for (int j = 0; j < letters.length; ++j) {
            for (int i = 0; i < letters[j].length; ++i) {
                if (letters[j][i] != symbol) continue;
                this.posLetter = j;
                this.posSymbol = i;
                return;
            }
        }
    }

    private void saveHighscores() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 5; ++i) {
                sb.append(this.highScores[i]);
                sb.append("#");
                sb.append(this.highScoresNames[i]);
                sb.append("#");
            }
            dos.writeUTF(sb.toString());
            SSFunctions.store("highscores", baos);
            dos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isHighScoreNew() {
        int i;
        boolean isHighScoreNew = false;
        for (i = 0; i < 5; ++i) {
            if (this.totalPercentage <= 0 || this.totalPercentage < this.highScores[i]) continue;
            isHighScoreNew = true;
            this.posHighScore = i;
            break;
        }
        if (isHighScoreNew) {
            for (i = 4; i > this.posHighScore; --i) {
                this.highScores[i] = this.highScores[i - 1];
                this.highScoresNames[i] = this.highScoresNames[i - 1];
            }
            this.highScores[this.posHighScore] = 0;
            this.highScoresNames[this.posHighScore] = "";
            return true;
        }
        return false;
    }

    private void resetClip(Graphics g) {
        g.setClip(0, 0, 500, 500);
    }

    public void paintConfirm(Graphics g, String text) {
        this.con.paintBackGroundStatic(g);
        g.setClip(0, 0, 500, 500);
        int newGameMenuHeight = 260;
        int newGameMenuWidth = 0;
        int yMainMenu = 0;
        Image logo = this.canvas.getLogo();
        LQFont ft = this.canvas.getFont();
        if (logo != null) {
            g.drawImage(logo, 120 - logo.getWidth() / 2, 0, 20);
            newGameMenuHeight -= logo.getHeight();
            yMainMenu = logo.getHeight();
        }
        if ((newGameMenuWidth = ft.getLineWidth(text.toCharArray())) > 240) {
            newGameMenuWidth = 240;
        }
        int xMainMenu = 120 - newGameMenuWidth / 2;
        ft.drawString(g, text, xMainMenu, yMainMenu, newGameMenuWidth, newGameMenuHeight, 1 | 2);
        this.paintYesOrNo(g, xMainMenu, yMainMenu + newGameMenuHeight, xMainMenu + newGameMenuWidth, yMainMenu + newGameMenuHeight);
    }

    private void paintYesOrNo(Graphics g, int x1, int y1, int x2, int y2) {
        LQFont ft = this.canvas.getFont();
        int iconw = this.canvas.getSoftBtnW();
        int iconh = this.canvas.getSoftBtnH();
        Draw.draw_YesNo_state(GameCanvas.gg, this.canvas.getFont(), null, Common.t_yes, Common.t_no, -1, 0);
    }

    public void paintSetTel(Graphics g, char[] initials, int score, long totalTime, int indexPos, String tituloTel) {
        this.con.paintBackGroundStatic(g);
        LQFont ft = this.canvas.getFont();
        ft.drawString(g, tituloTel, 120, 100, 0x10 | 1);
        ft.drawString(g, new String("" + initials[0]), 68, 130, 0x10 | 1);
        ft.drawString(g, new String("" + initials[1]), 81, 130, 0x10 | 1);
        ft.drawString(g, new String("" + initials[2]), 94, 130, 0x10 | 1);
        ft.drawString(g, new String("" + initials[3]), 107, 130, 0x10 | 1);
        ft.drawString(g, new String("" + initials[4]), 120, 130, 0x10 | 1);
        ft.drawString(g, new String("" + initials[5]), 133, 130, 0x10 | 1);
        ft.drawString(g, new String("" + initials[6]), 146, 130, 0x10 | 1);
        ft.drawString(g, new String("" + initials[7]), 159, 130, 0x10 | 1);
        ft.drawString(g, new String("" + initials[8]), 172, 130, 0x10 | 1);
        ft.drawString(g, new String("-"), 81 + (indexPos - 1) * 13, 140, 0x10 | 1);
        int iconw = this.canvas.getSoftBtnW();
        int iconh = this.canvas.getSoftBtnH();
        this.canvas.drawOk(g, 0, 260 - iconh);
        this.canvas.drawCancel(g, 240 - iconw, 260 - iconh);
    }

    public void pintarBarraSeleccion(Graphics g, int x, int y, int w, int h, Image tile) {
        int ciclos = w / tile.getWidth() + 1;
        int xPintar = x;
        g.setClip(x, y, w, h + 2);
        for (int i = 0; i < ciclos; ++i) {
            g.drawImage(tile, xPintar, y, 20);
            xPintar += tile.getWidth();
        }
    }

    public void paintHighScore(Graphics g) {
    }

    public void paintSetHighscore(Graphics g, char[] initials, int score, long totalTime, int indexPos, String titulo) {
        this.con.paintBackGroundStatic(g);
        LQFont ft = this.canvas.getFont();
        ft.drawString(g, titulo, 120, 90, 0x10 | 1);
        ft.drawString(g, new String("" + initials[0]), 100, 130, 0x10 | 1);
        ft.drawString(g, new String("" + initials[1]), 120, 130, 0x10 | 1);
        ft.drawString(g, new String("" + initials[2]), 140, 130, 0x10 | 1);
        ft.drawString(g, new String("-"), 120 + (indexPos - 1) * 20, 140, 0x10 | 1);
        this.canvas.drawOk(g, 0, 260 - this.canvas.getSoftBtnH());
        this.canvas.drawCancel(g, 240 - this.canvas.getSoftBtnW(), 260 - this.canvas.getSoftBtnH());
    }
}

