/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me.graphics;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PWPifLifeAnimations {
    public static final byte TRANSFORM_NONE = 0;
    public static final byte TRANSFORM_ROT_90 = 5;
    public static final byte TRANSFORM_ROT_180 = 3;
    public static final byte TRANSFORM_ROT_270 = 6;
    public static final byte TRANSFORM_FLIP_HORIZONTAL = 2;
    public static final byte TRANSFORM_FLIP_HOR_ROT_90 = 7;
    public static final byte TRANSFORM_FLIP_HOR_ROT_180 = 1;
    public static final byte TRANSFORM_FLIP_HOR_ROT_270 = 4;
    public static Vector staticPifs;
    boolean staticCache = false;
    public static final int BUFFER_STATIC_SIZE = 16000;
    int bufferSize;
    int[] bufferTmp = null;
    int[] bufferTmpStatic = null;
    int[] bufferToUse;
    int[] beginSprite;
    static int lastPositionBufferStatic;
    int lastPositionBuffer;
    public int[] palettes;
    int[] pixelsStartIndex;
    byte[] pixels;
    byte numBitsIndex;
    int indexMask;
    public int paletteNumColors;
    public int numBitsPalette;
    public int numRepetitions;
    byte[] cachePalettes = null;
    public Image[] images;
    public byte numPalettes;
    public byte currentPalette = 0;
    public int numSprites;
    byte[] spritesDim;
    short[] frameBegins;
    byte[] frames;
    public short[] animationsBegins;
    public byte[] animations;
    public int[] animationLengths;
    public short numAnimations;
    boolean animFinish;
    int framePainted;
    boolean pngMode;
    boolean isLongFormatted;
    byte[][] groupSprites;
    byte[] groupSets;
    boolean isNMSF = false;
    int[] buffer;
    int[] buff2Draw = null;
    private static int[] crc_table;

    public PWPifLifeAnimations(byte[] data, int sizeBuffer, boolean staticCache) {
        this(data, 0, null, false, sizeBuffer, false, false, staticCache);
    }

    public PWPifLifeAnimations(byte[] data, int sizeBuffer, boolean isGroupMode, boolean isNMSF, boolean staticCache) {
        this(data, 0, null, false, sizeBuffer, isGroupMode, isNMSF, staticCache);
    }

    public PWPifLifeAnimations(byte[] data, int offset, int[] palettesToLoad, boolean cachePalettes, int sizeBuffer, boolean staticCache) {
        this(data, offset, palettesToLoad, cachePalettes, sizeBuffer, false, false, staticCache);
    }

    public PWPifLifeAnimations(byte[] data, int offset, int[] palettesToLoad, boolean cachePalettes, int sizeBuffer, boolean groupMode, boolean isNMSF, boolean staticCache) {
        this.isNMSF = isNMSF;
        this.staticCache = staticCache;
        try {
            int k;
            int j;
            int k2;
            int elementId;
            ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, data.length - offset);
            DataInputStream dis = new DataInputStream(bais);
            this.pngMode = false;
            int minBufferSize = 0;
            byte version = dis.readByte();
            if (version == 1) {
                this.isLongFormatted = dis.readByte() == 1;
            }
            int numSprites = dis.readShort();
            this.numSprites = numSprites;
            this.spritesDim = this.isLongFormatted ? new byte[numSprites << 2] : new byte[numSprites << 1];
            for (int j2 = 0; j2 < numSprites; ++j2) {
                elementId = j2 << 1;
                this.updateArray(dis, this.spritesDim, elementId);
                this.updateArray(dis, this.spritesDim, elementId + 1);
                int dim = this.getUnsignedIntValueFromArray(this.spritesDim, elementId) * this.getUnsignedIntValueFromArray(this.spritesDim, elementId + 1);
                minBufferSize = dim > minBufferSize ? dim : minBufferSize;
            }
            int maxPalettes = dis.readByte();
            this.paletteNumColors = 0xFF & dis.readByte();
            this.numBitsPalette = 0xFF & dis.readByte();
            int n = this.numRepetitions = this.numBitsPalette == 0 ? 1 : 2 << this.numBitsPalette - 1;
            if (palettesToLoad == null) {
                palettesToLoad = new int[maxPalettes];
                for (int k3 = 0; k3 < maxPalettes; ++k3) {
                    palettesToLoad[k3] = k3;
                }
            }
            this.numPalettes = (byte)palettesToLoad.length;
            this.palettes = new int[this.numPalettes * this.paletteNumColors * this.numRepetitions];
            byte[] arrayAux = new byte[maxPalettes * this.paletteNumColors * 2];
            dis.read(arrayAux);
            if (palettesToLoad != null) {
                for (int pal = 0; pal < palettesToLoad.length; ++pal) {
                    int pos = palettesToLoad[pal] * this.paletteNumColors * 2;
                    int c2 = 0;
                    while (c2 < this.paletteNumColors) {
                        int color = PWPifLifeAnimations.toIntRGBA(arrayAux, pos);
                        for (k2 = 0; k2 < this.numRepetitions; ++k2) {
                            this.palettes[this.numRepetitions * this.paletteNumColors * pal + this.numRepetitions * c2 + k2] = color;
                        }
                        ++c2;
                        pos += 2;
                    }
                }
            }
            if (cachePalettes) {
                this.cachePalettes = new byte[maxPalettes * (this.paletteNumColors << 1)];
                System.arraycopy(arrayAux, 0, this.cachePalettes, 0, maxPalettes * (this.paletteNumColors << 1));
            }
            this.beginSprite = new int[numSprites * this.numPalettes << 1];
            this.initBeginSpriteArray();
            int numPixels = dis.readInt();
            this.pixelsStartIndex = new int[numSprites + 1];
            for (int n2 = 0; n2 < numSprites; ++n2) {
                this.pixelsStartIndex[n2] = dis.readInt();
            }
            this.pixelsStartIndex[numSprites] = numPixels;
            this.pixels = new byte[numPixels];
            for (int j3 = 0; j3 < numPixels; ++j3) {
                this.pixels[j3] = dis.readByte();
            }
            this.numBitsIndex = (byte)(8 - this.numBitsPalette);
            this.indexMask = 255 >>> this.numBitsPalette;
            int numFrames = dis.readShort();
            this.frameBegins = new short[numFrames + 1];
            this.frameBegins[0] = 0;
            for (j = 0; j < numFrames; ++j) {
                this.frameBegins[j + 1] = (short)(dis.readShort() * 3);
            }
            if (this.isLongFormatted) {
                this.frames = new byte[this.frameBegins[j] << 1];
                for (k = 0; k < this.frames.length / 6; ++k) {
                    elementId = k * 3;
                    this.updateArray(dis, this.frames, elementId);
                    this.updateArray(dis, this.frames, elementId + 1);
                    this.updateArray(dis, this.frames, elementId + 2);
                }
            } else {
                this.frames = new byte[this.frameBegins[j]];
                for (k = 0; k < this.frames.length / 3; ++k) {
                    elementId = k * 3;
                    this.updateArray(dis, this.frames, elementId);
                    this.updateArray(dis, this.frames, elementId + 1);
                    this.updateArray(dis, this.frames, elementId + 2);
                }
            }
            this.numAnimations = dis.readShort();
            this.animationsBegins = new short[this.numAnimations + 1];
            this.animationsBegins[0] = 0;
            for (j = 0; j < this.numAnimations; ++j) {
                this.animationsBegins[j + 1] = (short)(dis.readShort() * 3);
            }
            this.animations = new byte[this.animationsBegins[j]];
            dis.read(this.animations);
            this.animationLengths = new int[this.animationsBegins.length - 1];
            for (j = 0; j < this.animationLengths.length; ++j) {
                this.animationLengths[j] = 0;
                int n3 = (this.animationsBegins[j + 1] - this.animationsBegins[j]) / 3;
                for (k2 = 0; k2 < n3; ++k2) {
                    int n4 = j;
                    this.animationLengths[n4] = this.animationLengths[n4] + (0xFF & this.animations[this.animationsBegins[j] + k2 * 3 + 1]);
                }
            }
            if (staticCache) {
                this.bufferSize = 16000;
            } else {
                int n5 = this.bufferSize = minBufferSize > sizeBuffer ? minBufferSize : sizeBuffer;
            }
            if (staticCache) {
                if (this.bufferTmpStatic == null) {
                    this.bufferTmpStatic = new int[this.bufferSize];
                    lastPositionBufferStatic = 0;
                }
                this.bufferTmp = this.bufferTmpStatic;
            } else {
                this.bufferTmp = new int[this.bufferSize];
            }
            if (staticCache) {
                if (staticPifs == null) {
                    staticPifs = new Vector();
                }
                staticPifs.addElement(this);
            }
            System.gc();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    static final int isPaletteToLoad(int[] palettesToLoad, int palette) {
        for (int i2 = 0; i2 < palettesToLoad.length; ++i2) {
            if (palettesToLoad[i2] != palette) continue;
            return i2;
        }
        return -1;
    }

    public void resetBeginSpriteArray() {
        if (this.staticCache) {
            this.resetAllStaticPifsBeginSpriteArray();
            lastPositionBufferStatic = 0;
        } else {
            this.initBeginSpriteArray();
            this.lastPositionBuffer = 0;
        }
    }

    public void initBeginSpriteArray() {
        int numSprites = this.beginSprite.length;
        for (int i2 = 0; i2 < numSprites; ++i2) {
            this.beginSprite[i2] = -1;
        }
    }

    public void resetAllStaticPifsBeginSpriteArray() {
        Enumeration enumPifs = staticPifs.elements();
        while (enumPifs.hasMoreElements()) {
            PWPifLifeAnimations staticPif = (PWPifLifeAnimations)enumPifs.nextElement();
            staticPif.initBeginSpriteArray();
        }
    }

    public void setPalette(int palette) {
        if (palette >= this.numPalettes) {
            return;
        }
        this.currentPalette = (byte)palette;
    }

    final void changePaletteColors(short[] colors, int paletteID) {
        if (paletteID < this.palettes.length / (this.paletteNumColors * this.numRepetitions)) {
            for (int j = 0; j < this.paletteNumColors; ++j) {
                int color = 0;
                if (colors.length <= j + 1) {
                    color = colors[j];
                }
                for (int k = 0; k < this.numRepetitions; ++k) {
                    this.palettes[this.paletteNumColors * this.numRepetitions * paletteID + this.numRepetitions * j + k] = color;
                }
            }
        }
    }

    public final void changePalettes(int[] palettesToLoad) {
        if (this.palettes == null || this.palettes.length < palettesToLoad.length * this.paletteNumColors * this.numRepetitions) {
            this.palettes = new int[palettesToLoad.length * this.paletteNumColors * this.numRepetitions];
        }
        for (int pal = 0; pal < palettesToLoad.length; ++pal) {
            int i2 = palettesToLoad[pal] * this.paletteNumColors << 1;
            for (int j = 0; j < this.paletteNumColors; ++j) {
                int color = PWPifLifeAnimations.toIntRGBA(this.cachePalettes, i2);
                i2 += 2;
                for (int k = 0; k < this.numRepetitions; ++k) {
                    this.palettes[pal * this.numRepetitions * this.paletteNumColors + j * this.numRepetitions + k] = color;
                }
            }
        }
        this.numPalettes = (byte)palettesToLoad.length;
        this.setPalette(0);
        this.initBeginSpriteArray();
    }

    public int getPaletteColor(int palette, int colorIndex) {
        int color = this.palettes[palette * this.paletteNumColors * this.numRepetitions + this.numRepetitions * colorIndex];
        return color;
    }

    public void changePaletteColor(int palette, int colorIndex, int newColor) {
        for (int i2 = 0; i2 < this.numRepetitions; ++i2) {
            this.palettes[palette * this.paletteNumColors * this.numRepetitions + this.numRepetitions * colorIndex + i2] = newColor;
        }
    }

    public void flipSprite(int sprite, int width, int height) {
        if (this.buffer == null || this.buffer.length < width) {
            this.buffer = new int[width];
        }
        int src_position = this.beginSprite[sprite];
        int posFila = 0;
        for (int j = 0; j < height; ++j) {
            System.arraycopy(this.bufferTmp, src_position + j * width, this.buffer, 0, width);
            posFila = src_position + j * width;
            for (int i2 = 0; i2 < width; ++i2) {
                this.bufferTmp[posFila + i2] = this.buffer[width - 1 - i2];
            }
        }
    }

    public final void drawSpritePIF(Graphics g2, int sprite, int x, int y, int transformation) {
        if (this.staticCache) {
            this.lastPositionBuffer = lastPositionBufferStatic;
        }
        int bitsCount = 0;
        int width = this.getSpriteW(sprite);
        int height = this.getSpriteH(sprite);
        int spriteBase = sprite;
        int offset = 0;
        offset = this.beginSprite[this.numSprites * this.currentPalette + sprite];
        if (offset == -1) {
            bitsCount = this.lastPositionBuffer;
            if (this.bufferSize - (bitsCount + width * height) < 0) {
                this.resetBeginSpriteArray();
                bitsCount = 0;
            }
            this.beginSprite[this.numSprites * this.currentPalette + sprite] = bitsCount;
            offset = bitsCount;
            for (int i2 = this.pixelsStartIndex[spriteBase]; i2 < this.pixelsStartIndex[spriteBase + 1]; ++i2) {
                int index = this.indexMask & this.pixels[i2];
                int rep = ((0xFF & this.pixels[i2]) >>> this.numBitsIndex) + 1;
                System.arraycopy(this.palettes, this.currentPalette * this.numRepetitions * this.paletteNumColors + index * this.numRepetitions, this.bufferTmp, bitsCount, rep);
                bitsCount += rep;
            }
            this.lastPositionBuffer = bitsCount;
            if (this.staticCache) {
                lastPositionBufferStatic = this.lastPositionBuffer;
            }
        }
        this.bufferToUse = this.bufferTmp;
        boolean restoreTranslation = false;
        int tx = 0;
        int ty = 0;
        restoreTranslation = x < 0 || y < 0;
        if (restoreTranslation) {
            tx = x;
            ty = y;
            y = 0;
            x = 0;
            g2.translate(tx, ty);
        }
        if (this.buff2Draw == null || this.buff2Draw.length < width * height) {
            this.buff2Draw = new int[width * height];
        }
        System.arraycopy(this.bufferToUse, offset, this.buff2Draw, 0, width * height);
        Image img = Image.createRGBImage((int[])this.buff2Draw, (int)width, (int)height, (boolean)true);
        g2.drawRegion(img, 0, 0, width, height, transformation, x, y, 20);
        if (restoreTranslation) {
            g2.translate(-tx, -ty);
        }
    }

    public void drawSpritePIF(Graphics g2, int sprite, int x, int y, int transformation, int anchor) {
        int width = this.getSpriteW(sprite);
        int height = this.getSpriteH(sprite);
        if ((1 & anchor) != 0) {
            x -= width >> 1;
        } else if ((8 & anchor) != 0) {
            x -= width;
        }
        if ((2 & anchor) != 0) {
            y -= height >> 1;
        } else if ((0x20 & anchor) != 0) {
            y -= height;
        }
        this.drawSpritePIF(g2, sprite, x, y, transformation);
    }

    public PWPifLifeAnimations(byte[] data, int offset) {
        int i2 = 0;
        this.pngMode = true;
        try {
            int j;
            ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, data.length - offset);
            DataInputStream dis = new DataInputStream(bais);
            byte version = dis.readByte();
            if (version == 1) {
                this.isLongFormatted = dis.readByte() == 1;
            }
            this.numSprites = dis.readShort();
            this.spritesDim = this.isLongFormatted ? new byte[this.numSprites << 2] : new byte[this.numSprites << 1];
            int elementId = 0;
            for (int j2 = 0; j2 < this.numSprites; ++j2) {
                elementId = j2 << 1;
                this.updateArray(dis, this.spritesDim, elementId);
                this.updateArray(dis, this.spritesDim, elementId + 1);
            }
            this.images = new Image[this.numSprites << 1];
            byte[] header = new byte[dis.readInt()];
            dis.read(header);
            byte[] palette = new byte[dis.readInt()];
            dis.read(palette);
            byte[] end = new byte[dis.readInt()];
            dis.read(end);
            byte[] tempArrayImage = new byte[dis.readInt() + header.length + palette.length + end.length];
            System.arraycopy(header, 0, tempArrayImage, 0, header.length);
            System.arraycopy(palette, 0, tempArrayImage, header.length, palette.length);
            for (int j3 = 0; j3 < this.numSprites; ++j3) {
                elementId = j3 << 1;
                this.images[j3] = this.readImageDat(dis, tempArrayImage, header, palette, end, this.getUnsignedIntValueFromArray(this.spritesDim, elementId), this.getUnsignedIntValueFromArray(this.spritesDim, elementId + 1));
            }
            int numMirrors = 0xFF & dis.readByte();
            for (int j4 = 0; j4 < numMirrors; ++j4) {
                int id = 0xFF & dis.readByte();
                this.images[id + this.numSprites] = this.readImageDat(dis, tempArrayImage, header, palette, end, this.getSpriteW(id), this.getSpriteH(id));
            }
            tempArrayImage = null;
            int numFrames = dis.readShort();
            i2 += 2;
            this.frameBegins = new short[numFrames + 1];
            this.frameBegins[0] = 0;
            for (j = 0; j < numFrames; ++j) {
                this.frameBegins[j + 1] = (short)(dis.readShort() * 3);
                i2 += 2;
            }
            this.frames = this.isLongFormatted ? new byte[this.frameBegins[j] << 1] : new byte[this.frameBegins[j]];
            dis.read(this.frames);
            this.numAnimations = dis.readShort();
            i2 += 2;
            this.animationsBegins = new short[this.numAnimations + 1];
            this.animationsBegins[0] = 0;
            for (j = 0; j < this.numAnimations; ++j) {
                this.animationsBegins[j + 1] = (short)(dis.readShort() * 3);
                i2 += 2;
            }
            this.animations = new byte[this.animationsBegins[j]];
            dis.read(this.animations);
            i2 += this.animations.length;
            this.animationLengths = new int[this.animationsBegins.length - 1];
            for (j = 0; j < this.animationLengths.length; ++j) {
                this.animationLengths[j] = 0;
                int n = (this.animationsBegins[j + 1] - this.animationsBegins[j]) / 3;
                for (int k = 0; k < n; ++k) {
                    int n2 = j;
                    this.animationLengths[n2] = this.animationLengths[n2] + (0xFF & this.animations[this.animationsBegins[j] + k * 3 + 1]);
                }
            }
            this.numPalettes = 1;
            this.currentPalette = 0;
            System.gc();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private Image readImageDat(DataInputStream dis, byte[] tempArrayImage, byte[] header, byte[] palette, byte[] end, int w, int h2) throws IOException {
        int posData = header.length + palette.length;
        int length = dis.readInt();
        dis.read(tempArrayImage, posData, length);
        System.arraycopy(end, 0, tempArrayImage, posData + length, end.length);
        PWPifLifeAnimations.toBytes(w, tempArrayImage, 16);
        PWPifLifeAnimations.toBytes(h2, tempArrayImage, 20);
        long crc = PWPifLifeAnimations.getCRC32(tempArrayImage, 12, 17);
        PWPifLifeAnimations.toBytes((int)crc, tempArrayImage, 29);
        return Image.createImage((byte[])tempArrayImage, (int)0, (int)(length + posData + end.length));
    }

    public void drawSpritePNG(Graphics g2, int sprite, int x, int y, int transformation) {
        if (transformation == 2 && this.images[sprite + this.numSprites] != null) {
            sprite += this.numSprites;
        }
        g2.drawImage(this.images[sprite], x, y, 20);
    }

    public void drawSpritePNG(Graphics g2, int sprite, int x, int y, int transformation, int anchor) {
        if ((1 & anchor) != 0) {
            x -= this.images[sprite].getWidth() >> 1;
        } else if ((8 & anchor) != 0) {
            x -= this.images[sprite].getWidth();
        }
        if ((2 & anchor) != 0) {
            y -= this.images[sprite].getHeight() >> 1;
        } else if ((0x20 & anchor) != 0) {
            y -= this.images[sprite].getHeight();
        }
        this.drawSpritePNG(g2, sprite, x, y, transformation);
    }

    public static long getCRC32(byte[] buf, int off, int len) {
        int c2;
        if (crc_table == null) {
            crc_table = new int[256];
            for (int n = 0; n < 256; ++n) {
                c2 = n;
                int k = 8;
                while (--k >= 0) {
                    if ((c2 & 1) != 0) {
                        c2 = 0xEDB88320 ^ c2 >>> 1;
                        continue;
                    }
                    c2 >>>= 1;
                }
                PWPifLifeAnimations.crc_table[n] = c2;
            }
        }
        int crc = 0;
        c2 = ~crc;
        while (--len >= 0) {
            c2 = crc_table[(c2 ^ buf[off++]) & 0xFF] ^ c2 >>> 8;
        }
        crc = ~c2;
        return (long)crc & 0xFFFFFFFFL;
    }

    static final short toShort(byte[] data, int i2) {
        return (short)((0xFF & data[i2]) << 8 | 0xFF & data[i2 + 1]);
    }

    final int updateArray(DataInputStream dis, byte[] array, int idx) {
        try {
            if (this.isLongFormatted) {
                array[idx <<= 1] = dis.readByte();
                array[idx + 1] = dis.readByte();
                return 2;
            }
            array[idx] = dis.readByte();
            return 1;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    static final int toInt(byte[] data, int start) {
        return (0xFF & data[start]) << 24 | (0xFF & data[start + 1]) << 16 | (0xFF & data[start + 2]) << 8 | 0xFF & data[start + 3];
    }

    static final void toBytes(int num, byte[] data, int start) {
        data[start] = (byte)((num & 0xFF000000) >> 24);
        data[start + 1] = (byte)((num & 0xFF0000) >> 16);
        data[start + 2] = (byte)((num & 0xFF00) >> 8);
        data[start + 3] = (byte)(num & 0xFF);
    }

    static final short intColortoShortColor(int color) {
        short a2 = (short)((0xFF & color >> 24) / 16);
        short r = (short)((0xFF & color >> 16) / 16);
        short g2 = (short)((0xFF & color >> 8) / 16);
        short b2 = (short)((0xFF & color) / 16);
        return (short)(a2 << 12 | r << 8 | g2 << 4 | b2);
    }

    static final int shortColorToIntColor(short color) {
        int a2 = (0xF & color >> 12) * 16;
        int r = (0xF & color >> 8) * 16;
        int g2 = (0xF & color >> 4) * 16;
        int b2 = (0xF & color) * 16;
        return a2 << 24 | r << 16 | g2 << 8 | b2;
    }

    static final int toIntRGBA(byte[] data, int start) {
        return (0xF0 & data[start]) * 17 << 20 | (0xF & data[start]) * 17 << 16 | (0xF0 & data[start + 1]) * 17 << 4 | (0xF & data[start + 1]) * 17;
    }

    public void arraycopy(int color, int[] dst, int dst_position, int length) {
        switch (length) {
            case 1: {
                dst[dst_position] = color;
                break;
            }
            case 2: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                break;
            }
            case 3: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                break;
            }
            case 4: {
                int n = color;
                dst[dst_position + 1] = n;
                dst[dst_position] = n;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                break;
            }
            case 5: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                break;
            }
            case 6: {
                int n = color;
                dst[dst_position + 1] = n;
                dst[dst_position] = n;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                break;
            }
            case 7: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                break;
            }
            case 8: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                break;
            }
            case 9: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                break;
            }
            case 10: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                break;
            }
            case 11: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                break;
            }
            case 12: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                break;
            }
            case 13: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                break;
            }
            case 14: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                dst[dst_position + 13] = color;
                break;
            }
            case 15: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                dst[dst_position + 13] = color;
                dst[dst_position + 14] = color;
                break;
            }
            case 16: {
                dst[dst_position] = color;
                dst[dst_position + 1] = color;
                dst[dst_position + 2] = color;
                dst[dst_position + 3] = color;
                dst[dst_position + 4] = color;
                dst[dst_position + 5] = color;
                dst[dst_position + 6] = color;
                dst[dst_position + 7] = color;
                dst[dst_position + 8] = color;
                dst[dst_position + 9] = color;
                dst[dst_position + 10] = color;
                dst[dst_position + 11] = color;
                dst[dst_position + 12] = color;
                dst[dst_position + 13] = color;
                dst[dst_position + 14] = color;
                dst[dst_position + 15] = color;
                break;
            }
            default: {
                this.arraycopy(color, dst, dst_position, 16);
                this.arraycopy(color, dst, dst_position + 16, length - 16);
            }
        }
    }

    public final int getSpriteW(int sprite) {
        int desArray = 1;
        return this.getUnsignedIntValueFromArray(this.spritesDim, sprite << desArray);
    }

    public final int getSpriteH(int sprite) {
        int desArray = 1;
        return this.getUnsignedIntValueFromArray(this.spritesDim, (sprite << desArray) + 1);
    }

    public int getFrameWidth(int frame) {
        int p0X = Integer.MAX_VALUE;
        int p1X = Integer.MIN_VALUE;
        for (int i2 = this.frameBegins[frame]; i2 < this.frameBegins[frame + 1]; i2 += 3) {
            int despX = this.getIntValueFromArray(this.frames, i2 + 1);
            int w = this.getSpriteW(this.getUnsignedIntValueFromArray(this.frames, i2));
            p0X = Math.min(p0X, despX);
            p1X = Math.max(p1X, despX + w);
        }
        return p1X - p0X;
    }

    private int getIntValueFromArray(byte[] array, int offset) {
        if (this.isLongFormatted) {
            return array[offset <<= 1] << 8 | array[offset + 1];
        }
        return array[offset];
    }

    private int getUnsignedIntValueFromArray(byte[] array, int offset) {
        if (this.isLongFormatted) {
            return 0xFFFF & (array[offset <<= 1] << 8 | array[offset + 1]);
        }
        return 0xFF & array[offset];
    }

    public int getFrameHeight(int frame) {
        int p0Y = Integer.MAX_VALUE;
        int p1Y = Integer.MIN_VALUE;
        for (int i2 = this.frameBegins[frame]; i2 < this.frameBegins[frame + 1]; i2 += 3) {
            int despY = this.getIntValueFromArray(this.frames, i2 + 2);
            int h2 = this.getSpriteH(this.getUnsignedIntValueFromArray(this.frames, i2));
            p0Y = Math.min(p0Y, despY);
            p1Y = Math.max(p1Y, despY + h2);
        }
        return p1Y - p0Y;
    }

    public void drawSprite(Graphics g2, int sprite, int x, int y, int transformation) {
        if (this.pngMode) {
            this.drawSpritePNG(g2, sprite, x, y, transformation);
        }
        if (!this.pngMode) {
            this.drawSpritePIF(g2, sprite, x, y, transformation);
        }
    }

    public void drawSprite(Graphics g2, int sprite, int x, int y, int transformation, int anchor) {
        if (this.pngMode) {
            this.drawSpritePNG(g2, sprite, x, y, transformation, anchor);
        }
        if (!this.pngMode) {
            this.drawSpritePIF(g2, sprite, x, y, transformation, anchor);
        }
    }

    public final void drawFrame(Graphics g2, int frame, int x, int y, int transformation) {
        for (int i2 = this.frameBegins[frame]; i2 < this.frameBegins[frame + 1]; i2 += 3) {
            int spr = this.getIntValueFromArray(this.frames, i2);
            if (transformation == 2) {
                this.drawSprite(g2, spr, x - this.getIntValueFromArray(this.frames, i2 + 1) - this.getSpriteW(spr), y + this.getIntValueFromArray(this.frames, i2 + 2), transformation);
                continue;
            }
            this.drawSprite(g2, spr, x + this.getIntValueFromArray(this.frames, i2 + 1), y + this.getIntValueFromArray(this.frames, i2 + 2), transformation);
        }
    }

    public void setGroupSet(int group, int set) {
        this.groupSets[group] = (byte)set;
    }

    public final int drawAnimation(Graphics g2, int animation, long time, int x, int y, int globalTransformation, boolean cyclical) {
        int frp = this.getFramePos(animation, time, cyclical);
        this.drawFrame(g2, this.animations[frp] & 0xFF, x, y, globalTransformation);
        return this.animFinish ? -1 : this.framePainted;
    }

    public void drawAnimation(Graphics g2, int animation, long time, int x, int y, byte globalTransformation) {
        this.drawAnimation(g2, animation, time, x, y, globalTransformation, true);
    }

    public void drawAnimation(Graphics g2, int animation, int time, int x, int y, boolean cyclical) {
        this.drawAnimation(g2, animation, time, x, y, 0, cyclical);
    }

    public void drawAnimation(Graphics g2, int animation, long time, int x, int y, boolean cyclical) {
        this.drawAnimation(g2, animation, time, x, y, 0, cyclical);
    }

    final int getFramePos(int animId, long time, boolean cyclical) {
        this.animFinish = false;
        time /= 10L;
        if (cyclical) {
            time %= (long)this.animationLengths[animId];
        } else if (time >= (long)this.animationLengths[animId]) {
            this.animFinish = true;
            time = this.animationLengths[animId];
        }
        int t = 0;
        int frame = 0;
        while ((long)t < time) {
            if ((long)(t += this.animations[this.animationsBegins[animId] + frame * 3 + 1] & 0xFF) >= time) continue;
            ++frame;
        }
        this.framePainted = frame;
        return this.animationsBegins[animId] + frame * 3;
    }

    public boolean animationIsOver(int animId, int time) {
        return time / 10 >= this.animationLengths[animId];
    }

    public final int getFrameId(int animationId, int index) {
        int frp = this.animationsBegins[animationId] + index * 3;
        if (frp >= this.animationsBegins[animationId + 1]) {
            return -1;
        }
        return this.animations[frp];
    }

    public static void detroyAllStatic() {
        staticPifs = null;
    }

    public static PWPifLifeAnimations destroy(PWPifLifeAnimations pifToDestroy) {
        staticPifs.removeElement(pifToDestroy);
        return null;
    }
}

