/*
 * Decompiled with CFR 0.152.
 */
package z.playw.planet51racer;

import javax.microedition.lcdui.Graphics;
import z.playw.planet51racer.MainCanvas;
import z.playw.planet51racer.Mid;

public class TrashCar {
    public static final int TURN_LEFT = -1;
    public static final int TURN_NONE = 0;
    public static final int TURN_RIGHT = 1;
    public static final int SPEED_STOP = 0;
    public static final int SPEED_ACCEL = 1;
    public static final int SPEED_BRAKE = 2;
    public static final int SPEED_HANDBRAKE = 3;
    public static final int SPEED_REVERSE = 4;
    public static final int SPEED_OUT_OF_CONTROL = 5;
    public static final int OD_UP = 0;
    public static final int OD_RIGHT = 90;
    public static final int OD_DOWN = 180;
    public static final int OD_LEFT = 270;
    public static final int FULL_CIRCLE = 360;
    public static final byte ANIM_MOVE_UP = 0;
    public static final byte ANIM_MOVE_30 = 1;
    public static final byte ANIM_MOVE_60 = 2;
    public static final byte ANIM_MOVE_LR = 3;
    public static final byte ANIM_MOVE_120 = 4;
    public static final byte ANIM_MOVE_150 = 5;
    public static final byte ANIM_MOVE_DOWN = 6;
    private static TrashCar instance = null;
    public static byte animation;
    public static int[] coords;
    private int[] coordsOld;
    public int[] boundingBoxes;
    private static final int BOUNDING_BOX_LIMIT = 100;
    private static int collisionPoint;
    private static int collisionAnim;
    private static long collisionTime;
    public static final int COLLISION_CRASH = 1;
    public static final int COLLISION_CHECK = 2;
    public static final int COLLISION_FINISH = 3;
    public static final int NO_COLLISION = -1;
    public static int maxSpeed;
    public static final int MAX_SPEED = 384;
    public static final int SPEED_PRECISION = 5;
    public static int wheelsDirection;
    private int oldWheelsDirection;
    public static int wheelsSpeed;
    private int speedMode;
    private int sideMovement;
    private int sideDirection;
    private static final int SIDE_MOVEMENT_COUNT = 4;
    public static byte ANGLE_AMPLITUDE;
    public static byte[] CIRCLE_ANIM_INDEX;
    private static final int MAX_CENTRIFUGAL_STRENGTH = 64;
    public static final int CENTRIFUGAL_PRECISION = 6;
    private static final int MAX_INERTIA = 45;
    public int turnDirection;
    public static int turnAngle;
    public static int centrifugalStrength;
    public static int inertiaAngle;
    private boolean movesTooFast;
    private static final int OUT_OF_CONTROL_LIMIT = 20;
    private static final int OUT_OF_CONTROL_ANGLE = 30;
    private static int outOfControlIndex;
    private static int outOfControlDirection;
    public static final int MOD_SPEED = 0;
    public static final int MOD_CENTRIFUGAL = 1;
    public static final int MOD_INERTIA = 2;
    public static final int MOD_OUTOFCONTROL = 3;
    public static final int MOD_MAXSPEED = 4;
    private static int speedMod;
    private static int centrifugalMod;
    private static int inertiaMod;
    private static int outOfControlMod;
    private static int maxSpeedMod;
    public static int collisionCount;
    public static int[] lastGoodPositions;
    public static int TAIL_LENGTH;
    public static int[][] carTail;
    public static int lastTailIndex;
    public static int indexGoodPositions;
    public static int oldestGoodPosition;
    private static boolean explosionCarPainted;
    private static int truckLoad;
    public static final int MAX_LOAD = 20;
    public static final int MAX_LIFE = 1000;
    private static int truckLife;
    private static int invincibleTime;
    public static final int INVINCIBLE_TIME = 30;
    public static final int INVINCIBLE_TIME_PURSUIT = 16;
    public static int[] powerUpData;
    public static final int TURBO = 0;
    public static final int SLOW_DOWN = 1;
    public static final int WRENCH = 2;
    public static final int TIRES = 3;
    public static final int BROOM = 4;
    private static final int PU_ACTIVE = 65536;
    private static final int PU_TIME = 255;
    private static final int PU_UPGRADE_DURATION = 200;
    private static final int PU_UPGRADE_DURATION_PURSUIT = 100;

    private TrashCar() {
        coords = new int[2];
        this.coordsOld = new int[2];
        this.boundingBoxes = new int[48];
        for (int shadowIndex = 0; shadowIndex < 12; ++shadowIndex) {
            this.boundingBoxes[shadowIndex * 4 + 1] = 100;
            this.boundingBoxes[shadowIndex * 4] = 100;
            this.boundingBoxes[shadowIndex * 4 + 3] = -100;
            this.boundingBoxes[shadowIndex * 4 + 2] = -100;
            for (int cpIndex = 0; cpIndex < 8; ++cpIndex) {
                if (this.boundingBoxes[shadowIndex * 4] > Mid.COLLISION_POINTS_OFFSETS[shadowIndex * 16 + (cpIndex << 1)]) {
                    this.boundingBoxes[shadowIndex * 4] = Mid.COLLISION_POINTS_OFFSETS[shadowIndex * 16 + (cpIndex << 1)];
                } else if (this.boundingBoxes[shadowIndex * 4 + 2] < Mid.COLLISION_POINTS_OFFSETS[shadowIndex * 16 + (cpIndex << 1)]) {
                    this.boundingBoxes[shadowIndex * 4 + 2] = Mid.COLLISION_POINTS_OFFSETS[shadowIndex * 16 + (cpIndex << 1)];
                }
                if (this.boundingBoxes[shadowIndex * 4 + 1] > Mid.COLLISION_POINTS_OFFSETS[shadowIndex * 16 + (cpIndex << 1) + 1]) {
                    this.boundingBoxes[shadowIndex * 4 + 1] = Mid.COLLISION_POINTS_OFFSETS[shadowIndex * 16 + (cpIndex << 1) + 1];
                    continue;
                }
                if (this.boundingBoxes[shadowIndex * 4 + 3] >= Mid.COLLISION_POINTS_OFFSETS[shadowIndex * 16 + (cpIndex << 1) + 1]) continue;
                this.boundingBoxes[shadowIndex * 4 + 3] = Mid.COLLISION_POINTS_OFFSETS[shadowIndex * 16 + (cpIndex << 1) + 1];
            }
        }
    }

    public void init(int x, int y, int direction, int speed) {
        TrashCar.get();
        this.coordsOld[0] = TrashCar.coords[0] = x << 16;
        this.coordsOld[1] = TrashCar.coords[1] = y << 16;
        collisionPoint = -1;
        wheelsDirection = direction;
        this.oldWheelsDirection = direction;
        wheelsSpeed = speed;
        this.sideMovement = 0;
        this.speedMode = 0;
        centrifugalStrength = 0;
        inertiaAngle = 0;
        this.movesTooFast = false;
        outOfControlIndex = 0;
        this.heal();
        invincibleTime = 0;
        this.unload();
        powerUpData = new int[15];
        explosionCarPainted = false;
        this.changeCarBehaviour(0, 24);
        this.changeCarBehaviour(1, 1);
        this.changeCarBehaviour(2, 1);
        this.changeCarBehaviour(3, 1);
        this.changeCarBehaviour(4, 32);
        collisionCount = 0;
        for (int i2 = 0; i2 < 20; ++i2) {
            TrashCar.lastGoodPositions[i2] = 0;
        }
        indexGoodPositions = 0;
        oldestGoodPosition = 0;
    }

    public static TrashCar get() {
        if (instance == null) {
            instance = new TrashCar();
        }
        return instance;
    }

    public void forceMovement(int pixX, int pixY) {
        this.coordsOld[0] = coords[0];
        this.coordsOld[1] = coords[1];
        coords[0] = coords[0] + (pixX << 16);
        coords[1] = coords[1] + (pixY << 16);
    }

    public void changeSpeedMode(int mode) {
        if (this.speedMode != 5) {
            this.speedMode = mode;
            if (mode == 5) {
                outOfControlDirection = (wheelsDirection + 360) % 360;
                outOfControlIndex = outOfControlIndex >= 20 ? 60 : 40;
                centrifugalStrength = 0;
                if (this.turnDirection == 0) {
                    this.turnDirection = 1;
                }
            }
        }
    }

    public void changeSpeed(int value) {
        wheelsSpeed = Math.max(-maxSpeed, Math.min(value, maxSpeed));
    }

    public void turn(int angle, int direction) {
        if (this.speedMode != 5) {
            this.turnDirection = direction;
            turnAngle = angle;
        }
    }

    public void move() {
        this.updateUpgrades();
        this.changeDirection();
        this.advance();
        this.accelerate();
        this.checkOutOfControlStatus();
        if (invincibleTime > 0) {
            --invincibleTime;
        }
    }

    public void changeCarBehaviour(int modifier, int value) {
        switch (modifier) {
            case 0: {
                speedMod = value;
                break;
            }
            case 1: {
                centrifugalMod = value;
                break;
            }
            case 2: {
                inertiaMod = value;
                break;
            }
            case 3: {
                outOfControlMod = value;
                break;
            }
            case 4: {
                maxSpeedMod = value;
                maxSpeed = 384 * maxSpeedMod / 32;
            }
        }
    }

    public void undoMovement() {
        TrashCar.coords[0] = this.coordsOld[0];
        TrashCar.coords[1] = this.coordsOld[1];
        inertiaAngle = 0;
        centrifugalStrength = 0;
        if ((this.oldWheelsDirection + 15) % 360 / 30 != (wheelsDirection + 15) % 360 / 30 && this.turnDirection != 0) {
            int offsetIndex = (this.oldWheelsDirection + 15) % 360 / 30;
            if (this.turnDirection == 1 && this.getSpeed() > 0 || this.turnDirection == -1 && this.getSpeed() < 0) {
                coords[0] = coords[0] + (Mid.COLLISION_TURNS_OFFSETS[offsetIndex << 1] << 16);
                coords[1] = coords[1] + (Mid.COLLISION_TURNS_OFFSETS[(offsetIndex << 1) + 1] << 16);
            } else {
                coords[0] = coords[0] - (Mid.COLLISION_TURNS_OFFSETS[offsetIndex << 1] << 16);
                coords[1] = coords[1] - (Mid.COLLISION_TURNS_OFFSETS[(offsetIndex << 1) + 1] << 16);
            }
            if (this.getSpeedMode() != 3) {
                collisionPoint = -1;
            }
        } else {
            turnAngle = 0;
            wheelsDirection = this.oldWheelsDirection;
            this.turnDirection = 0;
            if (wheelsSpeed < 0) {
                if (collisionPoint != 0 && collisionPoint != 2 && collisionPoint != 1) {
                    this.changeSpeed(-wheelsSpeed);
                }
            } else if (collisionPoint != 3 && collisionPoint != 5 && collisionPoint != 4) {
                if (wheelsSpeed >> 7 > 0) {
                    this.changeSpeed(-wheelsSpeed >> 1);
                } else {
                    this.changeSpeed(-wheelsSpeed);
                }
            }
        }
        if (collisionPoint == 3 || collisionPoint == 6 || collisionPoint == 0) {
            this.sideMovement = 4;
            int n = this.sideDirection = wheelsSpeed > 0 ? -1 : 1;
        }
        if (collisionPoint == 4 || collisionPoint == 7 || collisionPoint == 1) {
            this.sideMovement = 4;
            this.sideDirection = wheelsSpeed > 0 ? 1 : -1;
        }
    }

    private void changeDirection() {
        this.oldWheelsDirection = wheelsDirection;
        if (this.speedMode != 5) {
            if (this.speedMode == 1 || this.speedMode == 3 || this.speedMode == 2) {
                wheelsDirection = this.turnDirection == 0 ? (wheelsDirection + 360 + inertiaAngle) % 360 : (wheelsDirection + 360 + turnAngle * this.turnDirection) % 360;
            } else if (this.speedMode == 4) {
                wheelsDirection = (wheelsDirection + 360 - turnAngle * this.turnDirection) % 360;
            }
            this.directionAssistance();
        } else {
            wheelsDirection = (wheelsDirection + 360 + 30 * this.turnDirection) % 360;
        }
    }

    private void directionAssistance() {
        if (inertiaAngle != 0) {
            return;
        }
        if (this.turnDirection == 0) {
            if (wheelsDirection != 90 && wheelsDirection > 90 - ANGLE_AMPLITUDE && wheelsDirection < 90 + ANGLE_AMPLITUDE) {
                wheelsDirection += Math.min(5, MainCanvas.abs(90 - wheelsDirection)) * MainCanvas.abs(90 - wheelsDirection) / (90 - wheelsDirection);
            } else if (wheelsDirection != 180 && wheelsDirection > 180 - ANGLE_AMPLITUDE && wheelsDirection < 180 + ANGLE_AMPLITUDE) {
                wheelsDirection += Math.min(5, MainCanvas.abs(180 - wheelsDirection)) * MainCanvas.abs(180 - wheelsDirection) / (180 - wheelsDirection);
            } else if (wheelsDirection != 270 && wheelsDirection > 270 - ANGLE_AMPLITUDE && wheelsDirection < 270 + ANGLE_AMPLITUDE) {
                wheelsDirection += Math.min(5, MainCanvas.abs(270 - wheelsDirection)) * MainCanvas.abs(270 - wheelsDirection) / (270 - wheelsDirection);
            } else if (wheelsDirection != 0 && wheelsDirection > 360 - ANGLE_AMPLITUDE) {
                if ((wheelsDirection += Math.min(5, MainCanvas.abs(360 - wheelsDirection)) * MainCanvas.abs(360 - wheelsDirection) / (360 - wheelsDirection)) == 360) {
                    wheelsDirection = 0;
                }
            } else if (wheelsDirection != 0 && wheelsDirection < 0 + ANGLE_AMPLITUDE) {
                wheelsDirection += Math.min(5, MainCanvas.abs(0 - wheelsDirection)) * MainCanvas.abs(0 - wheelsDirection) / (0 - wheelsDirection);
            }
        }
    }

    private void advance() {
        this.coordsOld[0] = coords[0];
        this.coordsOld[1] = coords[1];
        int movementDirection = wheelsDirection;
        if (this.speedMode == 5) {
            movementDirection = outOfControlDirection;
        }
        coords[0] = (int)((long)coords[0] + ((long)wheelsSpeed * MainCanvas.sin(movementDirection) << 11 >> MainCanvas.TRIGONOM_PRECISION));
        coords[1] = (int)((long)coords[1] + ((long)wheelsSpeed * -MainCanvas.cos(movementDirection) << 11 >> MainCanvas.TRIGONOM_PRECISION));
        if (this.sideMovement > 0) {
            --this.sideMovement;
            coords[0] = (int)((long)coords[0] + ((long)(maxSpeed >> 1) * MainCanvas.sin(movementDirection + 90 * this.sideDirection) << 11 >> MainCanvas.TRIGONOM_PRECISION));
            coords[1] = (int)((long)coords[1] + ((long)(maxSpeed >> 1) * -MainCanvas.cos(movementDirection + 90 * this.sideDirection) << 11 >> MainCanvas.TRIGONOM_PRECISION));
        }
        int centrifugalDirection = 0;
        if (this.turnDirection == -1 || inertiaAngle < 0) {
            if (wheelsSpeed > 0) {
                centrifugalDirection = (movementDirection + 90) % 360;
            } else if (wheelsSpeed < 0) {
                centrifugalDirection = (movementDirection + 270) % 360;
            }
            coords[1] = (int)((long)coords[1] + ((long)(wheelsSpeed * centrifugalStrength) * -MainCanvas.cos(centrifugalDirection) << 11 >> MainCanvas.TRIGONOM_PRECISION + 6));
            coords[0] = (int)((long)coords[0] + ((long)(wheelsSpeed * centrifugalStrength) * MainCanvas.sin(centrifugalDirection) << 11 >> MainCanvas.TRIGONOM_PRECISION + 6));
        } else if (this.turnDirection == 1 || inertiaAngle > 0) {
            if (wheelsSpeed > 0) {
                centrifugalDirection = (movementDirection + 270) % 360;
            } else if (wheelsSpeed < 0) {
                centrifugalDirection = (movementDirection + 90) % 360;
            }
            coords[1] = (int)((long)coords[1] + ((long)(wheelsSpeed * centrifugalStrength) * -MainCanvas.cos(centrifugalDirection) << 11 >> MainCanvas.TRIGONOM_PRECISION + 6));
            coords[0] = (int)((long)coords[0] + ((long)(wheelsSpeed * centrifugalStrength) * MainCanvas.sin(centrifugalDirection) << 11 >> MainCanvas.TRIGONOM_PRECISION + 6));
        }
    }

    private void accelerate() {
        switch (this.speedMode) {
            case 0: {
                wheelsSpeed = 0;
                break;
            }
            case 1: {
                wheelsSpeed = Math.min(maxSpeed, wheelsSpeed + speedMod);
                break;
            }
            case 2: {
                wheelsSpeed = Math.max(0, wheelsSpeed - (speedMod << 1));
                break;
            }
            case 5: {
                wheelsSpeed >>= 1;
                break;
            }
            case 3: {
                wheelsSpeed = 192;
                if (this.turnDirection == 0) {
                    this.turnDirection = 1;
                }
                this.turn(30, this.turnDirection);
                break;
            }
            case 4: {
                wheelsSpeed = Math.max(-96, wheelsSpeed - (speedMod << 1));
            }
        }
    }

    private void checkOutOfControlStatus() {
        if (this.speedMode != 5) {
            boolean bl = this.movesTooFast = !(wheelsSpeed != maxSpeed && this.speedMode != 3 || inertiaAngle <= 22 && inertiaAngle >= -22 && centrifugalStrength <= 32);
            if (this.movesTooFast) {
                if ((outOfControlIndex += outOfControlMod) >= 20) {
                    this.changeSpeedMode(5);
                } else {
                    this.updateMomentum();
                }
            } else {
                outOfControlIndex = 0;
                this.updateMomentum();
            }
        } else {
            this.movesTooFast = false;
            this.updateMomentum();
            if ((outOfControlIndex -= 2) <= 0) {
                this.speedMode = 1;
                this.turn(0, 0);
            }
        }
    }

    private void updateMomentum() {
        if (this.speedMode == 5 || this.turnDirection == 0) {
            if (centrifugalStrength > 0) {
                centrifugalStrength = Math.max(0, centrifugalStrength - 2);
            }
            if (inertiaAngle > 0) {
                inertiaAngle = Math.max(0, inertiaAngle - 5);
            } else if (inertiaAngle < 0) {
                inertiaAngle = Math.min(0, inertiaAngle + 5);
            }
        } else {
            inertiaAngle = Math.min(45, Math.max(-45, inertiaAngle + this.turnDirection * inertiaMod));
            centrifugalStrength = Math.min(64, centrifugalStrength + centrifugalMod);
        }
    }

    public void paint(Graphics g2) {
        int paintDirection = (wheelsDirection + 360 + inertiaAngle) % 360;
        animation = CIRCLE_ANIM_INDEX[paintDirection / ANGLE_AMPLITUDE];
        int transform = 0;
        if (paintDirection >= 195 && paintDirection <= 345) {
            transform = 2;
        }
        int truckX = (coords[0] - MainCanvas.coorCam[0] >> 16) + 0;
        int truckY = (coords[1] - MainCanvas.coorCam[1] >> 16) + 64;
        TrashCar.carTail[TrashCar.lastTailIndex][0] = coords[0];
        TrashCar.carTail[TrashCar.lastTailIndex][1] = coords[1];
        TrashCar.carTail[TrashCar.lastTailIndex][2] = animation;
        TrashCar.carTail[TrashCar.lastTailIndex][3] = transform;
        lastTailIndex = (lastTailIndex + 1) % TAIL_LENGTH;
        if (invincibleTime <= 0 || invincibleTime % 2 == 0 || MainCanvas.avatarFreezesGameplay == 1) {
            if (this.getUpgradeStatus(0) && !this.getUpgradeStatus(1)) {
                for (int tailIndex = 0; tailIndex < TAIL_LENGTH - 1; ++tailIndex) {
                    int currentTailIndex = (lastTailIndex + tailIndex) % TAIL_LENGTH;
                    int tailX = (carTail[currentTailIndex][0] - MainCanvas.coorCam[0] >> 16) + 0;
                    int tailY = (carTail[currentTailIndex][1] - MainCanvas.coorCam[1] >> 16) + 64;
                    if (MainCanvas.level >= 7 && MainCanvas.level != 10 && MainCanvas.level != 8) {
                        MainCanvas.mainCarGraphics.drawAnimation(g2, 7 + carTail[currentTailIndex][2], MainCanvas.processTime, tailX, tailY, carTail[currentTailIndex][3], true);
                        continue;
                    }
                    MainCanvas.mainCarGraphics.drawAnimation(g2, carTail[currentTailIndex][2], MainCanvas.processTime, tailX, tailY, carTail[currentTailIndex][3], true);
                }
            }
            if (MainCanvas.level >= 7 && MainCanvas.level != 10 && MainCanvas.level != 8) {
                MainCanvas.mainCarGraphics.drawAnimation(g2, animation + 7, MainCanvas.processTime, truckX, truckY, transform, true);
            } else {
                MainCanvas.mainCarGraphics.drawAnimation(g2, animation, MainCanvas.processTime, truckX, truckY, transform, true);
            }
        }
    }

    public static void paintCollisionPoint(Graphics g2) {
        if (!explosionCarPainted) {
            int paintDirection = (wheelsDirection + 360 + inertiaAngle) % 360;
            int truckX = (coords[0] - MainCanvas.coorCam[0] >> 16) + 0;
            int truckY = (coords[1] - MainCanvas.coorCam[1] >> 16) + 64;
            int truckCPIndex = 0;
            if (collisionPoint != -1) {
                truckCPIndex = ((paintDirection / ANGLE_AMPLITUDE + 1) % 24 >> 1) * 16 + (collisionPoint << 1);
                if (collisionAnim == 1 && !MainCanvas.crashGraphics.animationIsOver(0, (int)(MainCanvas.processTime - collisionTime))) {
                    MainCanvas.crashGraphics.drawAnimation(g2, 0, MainCanvas.processTime - collisionTime, truckX + Mid.COLLISION_POINTS_OFFSETS[truckCPIndex], truckY + Mid.COLLISION_POINTS_OFFSETS[truckCPIndex + 1], 0, false);
                }
                if (!MainCanvas.crashGraphics.animationIsOver(collisionAnim, (int)(MainCanvas.processTime - collisionTime))) {
                    MainCanvas.crashGraphics.drawAnimation(g2, collisionAnim, MainCanvas.processTime - collisionTime, truckX, truckY, 0, false);
                } else {
                    collisionPoint = -1;
                }
            }
        }
    }

    public void paintExplosion(Graphics g2) {
        collisionAnim = 0;
        if (!explosionCarPainted) {
            this.paint(g2);
            explosionCarPainted = true;
        }
        int paintDirection = (wheelsDirection + 360 + inertiaAngle) % 360;
        animation = CIRCLE_ANIM_INDEX[paintDirection / ANGLE_AMPLITUDE];
        int transform = 0;
        if (paintDirection > 180) {
            transform = 2;
        }
        int truckX = (coords[0] - MainCanvas.coorCam[0] >> 16) + 0;
        int truckY = (coords[1] - MainCanvas.coorCam[1] >> 16) + 64;
        int carDeathFrame = 86;
        if (MainCanvas.level >= 7 && MainCanvas.level != 10 && MainCanvas.level != 8) {
            carDeathFrame += 7;
        }
        MainCanvas.mainCarGraphics.drawFrame(g2, carDeathFrame + animation, truckX, truckY, transform);
        MainCanvas.mainCarGraphics.drawFrame(g2, 84, truckX, truckY, transform);
        MainCanvas.mainCarGraphics.drawAnimation(g2, 29 + animation, MainCanvas.processTime, truckX, truckY, transform, true);
    }

    public int getMovementDirection() {
        if (this.speedMode != 5) {
            return wheelsDirection;
        }
        return outOfControlDirection;
    }

    public int getGraphDirection() {
        if (this.speedMode != 5) {
            return (wheelsDirection + 360 + inertiaAngle) % 360;
        }
        return wheelsDirection;
    }

    public int getSpeed() {
        return wheelsSpeed;
    }

    public int getSpeedMode() {
        return this.speedMode;
    }

    public void setMovementDirection(int newDirection) {
        wheelsDirection = newDirection % 360;
    }

    public int getLoad() {
        return truckLoad;
    }

    public void incrementLoad(int amount) {
        truckLoad = Math.min(20, Math.max(0, truckLoad + amount));
    }

    public void unload() {
        truckLoad = 0;
    }

    public int getLife() {
        return truckLife;
    }

    public void incrementLife(int amount) {
        if (invincibleTime != 0 && amount < 0) {
            return;
        }
        truckLife = Math.min(1000, Math.max(0, truckLife + amount));
    }

    public void heal() {
        if (MainCanvas.gameState != 7) {
            truckLife = 1000;
        }
    }

    public void startInvincible() {
        if (invincibleTime == 0) {
            invincibleTime = MainCanvas.LEVEL_TYPES[MainCanvas.level] == 4 ? 16 : 30;
        }
    }

    public boolean isInvincible() {
        return invincibleTime != 0;
    }

    public void activateUpgrade(int upgrade, int x, int y) {
        if (upgrade == 0 && this.getUpgradeStatus(1)) {
            this.desactivateUpgrade(1);
        } else if (upgrade == 1 && this.getUpgradeStatus(0)) {
            this.desactivateUpgrade(0);
        }
        TrashCar.powerUpData[upgrade * 3] = x;
        TrashCar.powerUpData[upgrade * 3 + 1] = y;
        if (upgrade != 2) {
            TrashCar.powerUpData[upgrade * 3 + 2] = MainCanvas.LEVEL_TYPES[MainCanvas.level] == 4 ? powerUpData[upgrade * 3 + 2] | 0x10000 | 0x64 : powerUpData[upgrade * 3 + 2] | 0x10000 | 0xC8;
        }
        if (upgrade == 2) {
            this.incrementLife(250);
        }
    }

    public boolean getUpgradeStatus(int upgrade) {
        if (upgrade < 0 || upgrade > 5) {
            return false;
        }
        return (powerUpData[upgrade * 3 + 2] & 0x10000) != 0;
    }

    public void desactivateUpgrade(int upgrade) {
        TrashCar.powerUpData[upgrade * 3 + 2] = 0;
    }

    public void updateUpgrades() {
        int time = 0;
        for (int upgrade = 0; upgrade < 5; ++upgrade) {
            short hudUpgradeX = Mid.HUD_UPGRADES[upgrade << 1];
            short hudUpgradeY = Mid.HUD_UPGRADES[(upgrade << 1) + 1];
            if (MainCanvas.LEVEL_TYPES[MainCanvas.level] == 1) {
                hudUpgradeX = Mid.HUD_UPGRADES_COMPETITION[upgrade << 1];
                hudUpgradeY = Mid.HUD_UPGRADES_COMPETITION[(upgrade << 1) + 1];
            }
            if ((powerUpData[upgrade * 3 + 2] & 0x10000) != 65536) continue;
            time = powerUpData[upgrade * 3 + 2] & 0xFF;
            TrashCar.powerUpData[upgrade * 3 + 2] = --time == 0 ? powerUpData[upgrade * 3 + 2] & 0xFFFEFFFF : powerUpData[upgrade * 3 + 2] & 0xFFFFFF00 | time;
        }
    }

    public void paintUpgrades(Graphics g2) {
    }

    public void startCollisionText(int whichCollision, int whichPoint) {
        collisionPoint = whichPoint;
        collisionAnim = whichCollision;
        collisionTime = MainCanvas.processTime;
    }

    public boolean isColliding() {
        return collisionPoint != -1;
    }

    public static void initTail() {
        for (int i2 = 0; i2 < TAIL_LENGTH; ++i2) {
            for (int j = 0; j < 4; ++j) {
                TrashCar.carTail[i2][j] = 0;
            }
        }
    }

    static {
        ANGLE_AMPLITUDE = (byte)15;
        CIRCLE_ANIM_INDEX = new byte[]{0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 5, 5, 4, 4, 3, 3, 2, 2, 1, 1, 0};
        collisionCount = 0;
        lastGoodPositions = new int[20];
        TAIL_LENGTH = 3;
        carTail = new int[TAIL_LENGTH][4];
        lastTailIndex = 0;
        indexGoodPositions = 0;
        oldestGoodPosition = 0;
        truckLife = 1000;
        invincibleTime = 0;
        powerUpData = new int[15];
    }
}

