/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me.graphics;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import z.playw.j2me.graphics.PWPifLifeAnimations;

public class PWPiFont {
    PWPifLifeAnimations thePif;
    public int fontHeight;
    public int lineSpacing;
    public int charSpacing;
    public int spaceSize;
    private short[] charFrames;
    private char[] chars;
    final int scrollTimePerPixel;
    int scrollTime = 0;
    int scrollExtraW = 10;

    public PWPiFont() {
        this.scrollTimePerPixel = 100;
    }

    public static PWPiFont loadPIFont(byte[] data) {
        return PWPiFont.load(data, null, false, 0);
    }

    public static PWPiFont loadPNGFont(byte[] data) {
        return PWPiFont.load(data);
    }

    private static PWPiFont load(byte[] data) {
        PWPiFont font = new PWPiFont();
        int i2 = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bais);
            byte versionFont = dis.readByte();
            ++i2;
            font.fontHeight = dis.readByte();
            ++i2;
            font.lineSpacing = dis.readByte();
            ++i2;
            font.charSpacing = dis.readByte();
            ++i2;
            font.spaceSize = dis.readByte();
            ++i2;
            int charQuantity = dis.readInt();
            i2 += 4;
            font.chars = new char[charQuantity];
            font.charFrames = new short[charQuantity];
            for (int j = 0; j < charQuantity; ++j) {
                font.chars[j] = dis.readChar();
                i2 += 2;
                font.charFrames[j] = dis.readShort();
                i2 += 2;
            }
            font.thePif = new PWPifLifeAnimations(data, i2);
            font.initialize();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return font;
    }

    public static PWPiFont load(byte[] data, int[] palettesToLoad, boolean cachePalettes, int sizeBuffer) {
        PWPiFont font = new PWPiFont();
        int i2 = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bais);
            byte versionFont = dis.readByte();
            ++i2;
            font.fontHeight = dis.readByte();
            ++i2;
            font.lineSpacing = dis.readByte();
            ++i2;
            font.charSpacing = dis.readByte();
            ++i2;
            font.spaceSize = dis.readByte();
            ++i2;
            int charQuantity = dis.readInt();
            i2 += 4;
            font.chars = new char[charQuantity];
            font.charFrames = new short[charQuantity];
            for (int j = 0; j < charQuantity; ++j) {
                font.chars[j] = dis.readChar();
                i2 += 2;
                font.charFrames[j] = dis.readShort();
                i2 += 2;
            }
            font.thePif = new PWPifLifeAnimations(data, i2, palettesToLoad, cachePalettes, sizeBuffer, false);
            font.initialize();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return font;
    }

    private void initialize() {
        this.sortChars(0, this.chars.length - 1);
    }

    private void sortChars(int low, int high) {
        int left = low;
        int right = high;
        char half = this.chars[(low + high) / 2];
        while (true) {
            if (this.chars[left] < half && left < high) {
                ++left;
                continue;
            }
            while (half < this.chars[right] && right > low) {
                --right;
            }
            if (left <= right) {
                char x = this.chars[left];
                short x2 = this.charFrames[left];
                this.chars[left] = this.chars[right];
                this.charFrames[left] = this.charFrames[right];
                this.chars[right] = x;
                this.charFrames[right] = x2;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (low < right) {
            this.sortChars(low, right);
        }
        if (left < high) {
            this.sortChars(left, high);
        }
    }

    public void selectColor(int number) {
        this.thePif.setPalette(number);
    }

    public short[][] drawString(Graphics graphics, String text, int x, int y, int width, int height, int anchor) {
        return this.drawString(graphics, text.toCharArray(), x, y, width, height, anchor);
    }

    public short[][] drawString(Graphics graphics, char[] data, int x, int y, int width, int height, int anchor) {
        short[][] mLineData = this.getLineData(data, width);
        this.drawFastString(graphics, data, x, y, width, height, anchor, mLineData);
        return mLineData;
    }

    public int drawString(Graphics graphics, String text, int x, int y, int anchor) {
        return this.drawString(graphics, text.toCharArray(), x, y, anchor);
    }

    public int drawString(Graphics graphics, char[] data, int x, int y, int anchor) {
        if (data.length == 0) {
            return 0;
        }
        if ((anchor & 0x10) != 0) {
            y += this.fontHeight;
        } else if ((anchor & 0x20) != 0) {
            y -= this.lineSpacing;
        } else if ((anchor & 2) != 0) {
            y += this.fontHeight / 2;
        }
        int textWidth = 0;
        if ((anchor & 8) != 0) {
            textWidth = this.getLineWidth(data);
            x -= textWidth;
        } else if ((anchor & 1) != 0) {
            textWidth = this.getLineWidth(data);
            x -= textWidth / 2;
        }
        if (textWidth == 0) {
            for (int i2 = 0; i2 < data.length; ++i2) {
                textWidth = textWidth + this.drawChar(graphics, data[i2], x + textWidth, y) + this.charSpacing;
            }
        } else {
            for (int i3 = 0; i3 < data.length; ++i3) {
                x = x + this.drawChar(graphics, data[i3], x, y) + this.charSpacing;
            }
        }
        return textWidth;
    }

    public void drawFastString(Graphics graphics, char[] data, short[][] mLineData, int x, int y, int width, int anchor, int firstLine, int linesToDraw) {
        int maxLines = firstLine + linesToDraw;
        if (maxLines > mLineData.length) {
            maxLines = mLineData.length;
        }
        y += this.fontHeight;
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        for (int i2 = firstLine; i2 < maxLines; ++i2) {
            if (mLineData[i2][2] != 0) {
                this.drawFastString(graphics, data, x, y, anchor, mLineData[i2]);
            }
            y = y + this.lineSpacing + this.fontHeight;
        }
    }

    public int getFontHeight() {
        return this.fontHeight;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public short[][] drawFastString(Graphics graphics, char[] data, int x, int y, int width, int height, int anchor, short[][] mLineData) {
        int textHeight;
        int maxLines = height / this.getFontHeight();
        int initX = x;
        if (mLineData.length < maxLines) {
            maxLines = mLineData.length;
        }
        int n = textHeight = maxLines == 1 ? maxLines * this.getFontHeight() : maxLines * (this.getLineSpacing() + this.getFontHeight());
        y = (anchor & 0x20) != 0 ? (y -= textHeight) : ((anchor & 2) != 0 ? y + this.getFontHeight() + (height - textHeight >> 1) : (y += this.getFontHeight()));
        if ((anchor & 8) != 0) {
            x += width;
        } else if ((anchor & 1) != 0) {
            x += width / 2;
        }
        for (int i2 = 0; i2 < maxLines; ++i2) {
            if (mLineData[i2][2] != 0) {
                if (mLineData[i2][2] > width) {
                    this.scrollTime = (mLineData[i2][2] - width + (this.scrollExtraW << 1)) * 100;
                    long t = System.currentTimeMillis() % (long)this.scrollTime;
                    long sign = System.currentTimeMillis() % (long)(2 * this.scrollTime);
                    if (sign > (long)this.scrollTime) {
                        t = (long)this.scrollTime - t;
                    }
                    int lineX = (int)((long)(initX + this.scrollExtraW) + (long)(width - mLineData[i2][2] - this.scrollExtraW * 2) * t / (long)this.scrollTime);
                    this.drawFastString(graphics, data, lineX, y, 4, mLineData[i2]);
                } else {
                    this.drawFastString(graphics, data, x, y, anchor, mLineData[i2]);
                }
            }
            y = y + this.getLineSpacing() + this.getFontHeight();
        }
        return mLineData;
    }

    public void drawFastString(Graphics graphics, char[] text, int x, int y, int anchor, short[] lineData) {
        if (text.length == 0) {
            return;
        }
        if ((anchor & 8) != 0) {
            x -= lineData[2];
        } else if ((anchor & 1) != 0) {
            x -= lineData[2] / 2;
        }
        for (int i2 = lineData[0]; i2 < lineData[1] + 1; ++i2) {
            x = x + this.drawChar(graphics, text[i2], x, y) + this.charSpacing;
        }
    }

    public int drawChar(Graphics g2, char character, int x, int y) {
        if (character == ' ') {
            return this.spaceSize;
        }
        int charIndex = this.binarySearchOnChars(character, 0, this.chars.length - 1);
        if (charIndex == -1) {
            return 0;
        }
        this.thePif.drawFrame(g2, this.charFrames[charIndex], x, y, 0);
        return this.thePif.getFrameWidth(this.charFrames[charIndex]);
    }

    public short[][] getLineData(char[] text, int width) {
        Vector<short[]> result = new Vector<short[]>();
        short[] currentLine = new short[]{0, 0, 0};
        for (int index = 0; index < text.length; index = (int)((char)(index + 1))) {
            int wordLength = 0;
            while (index < text.length && text[index] != '\n' && text[index] != ' ') {
                wordLength += this.getCharacterWidth(text[index]) + this.charSpacing;
                index = (char)(index + 1);
            }
            if (currentLine[2] == 0) {
                currentLine[1] = (short)(index - 1);
                currentLine[2] = (short)(currentLine[2] + wordLength);
            } else if (currentLine[2] + this.spaceSize + this.charSpacing + wordLength < width) {
                currentLine[1] = (short)(index - 1);
                currentLine[2] = (short)(currentLine[2] + (this.spaceSize + this.charSpacing + wordLength));
            } else {
                result.addElement(currentLine);
                currentLine = new short[]{(short)(((short[])result.elementAt(result.size() - 1))[1] + 2), (short)(index - 1), (short)wordLength};
            }
            if (index >= text.length || text[index] != '\n') continue;
            result.addElement(currentLine);
            currentLine = new short[]{(short)(index + 1), (short)(index + 1), 0};
        }
        if (currentLine[0] > text.length - 1) {
            currentLine[0] = (short)(text.length - 1);
        }
        if (currentLine[1] > text.length - 1) {
            currentLine[1] = (short)(text.length - 1);
        }
        if (currentLine[0] < 0) {
            currentLine[0] = 0;
        }
        if (currentLine[1] < 0) {
            currentLine[1] = 0;
        }
        result.addElement(currentLine);
        short[][] ret = new short[result.size()][];
        for (int i2 = 0; i2 < result.size(); ++i2) {
            short[] data = (short[])result.elementAt(i2);
            ret[i2] = new short[3];
            ret[i2][0] = data[0];
            ret[i2][1] = data[1];
            ret[i2][2] = data[2] >= this.charSpacing ? (short)(data[2] - this.charSpacing) : (short)0;
        }
        return ret;
    }

    public int getLineWidth(char[] text) {
        if (text.length < 1) {
            return 0;
        }
        int totalWidth = 0;
        totalWidth += this.getCharacterWidth(text[0]);
        for (int i2 = 1; i2 < text.length; ++i2) {
            char auxChar = text[i2];
            totalWidth = totalWidth + this.getCharacterWidth(auxChar) + this.charSpacing;
        }
        return totalWidth;
    }

    private int getCharacterWidth(char character) {
        if (character == ' ') {
            return this.spaceSize;
        }
        int charIndex = this.binarySearchOnChars(character, 0, this.chars.length - 1);
        if (charIndex < 0) {
            return 0;
        }
        return this.thePif.getFrameWidth(this.charFrames[charIndex]);
    }

    private int binarySearchOnChars(char character, int left, int right) {
        if (right < left) {
            return -1;
        }
        int mid = (left + right) / 2;
        if (this.chars[mid] == character) {
            return mid;
        }
        if (character < this.chars[mid]) {
            return this.binarySearchOnChars(character, left, mid - 1);
        }
        return this.binarySearchOnChars(character, mid + 1, right);
    }
}

