/*
 * Decompiled with CFR 0.152.
 */
package z.playw.j2me.util;

import java.util.Random;

public class Utils {
    public static final byte RED_COMPONENT = 0;
    public static final byte GREEN_COMPONENT = 1;
    public static final byte BLUE_COMPONENT = 2;
    public static final int CLEAN_MEMORY_DELAY = 400;
    public static final int CTE = 100;
    private static Random rnd = new Random(System.currentTimeMillis());

    public static final void cleanMemory() {
        System.gc();
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
    }

    public static final int getRandNumber(int min, int max) {
        int r = Math.abs(rnd.nextInt());
        return r % (max - min + 1) + min;
    }

    public static int linearInterpolation(int startV, int endV, long num, long den) {
        if (num <= 0L) {
            return startV;
        }
        if (num >= den) {
            return endV;
        }
        long coef = (num << 10) / den;
        return (int)((long)startV + (coef * (long)(endV - startV) >> 10));
    }

    public static final boolean isIntersectingRect(int ax, int ay, int aw, int ah, int bx, int by, int bw, int bh) {
        return by + bh >= ay && by <= ay + ah && bx + bw >= ax && bx <= ax + aw;
    }

    public static final void swap(int[] value1, int[] value2) {
        if (value1.length == value2.length) {
            int[] aux = new int[value1.length];
            for (int i2 = 0; i2 < aux.length; ++i2) {
                aux[i2] = value1[i2];
                value1[i2] = value2[i2];
                value2[i2] = aux[i2];
            }
        }
    }

    public static final int convertHSVtoRGB(int hue, int saturation, int value) {
        int[] rgb = new int[3];
        if (saturation == 0) {
            rgb[0] = value * 255 / 100;
            rgb[1] = value * 255 / 100;
            rgb[2] = value * 255 / 100;
        } else {
            if (hue == 360) {
                hue = 0;
            }
            int hex = hue * 100 / 60;
            int pColor = hue / 60 * 100;
            int sColor = hex - pColor;
            int p1 = value * (100 - saturation) / 100;
            int p2 = (100 - saturation * sColor / 100) * value / 100;
            int p3 = (100 - saturation * (100 - sColor) / 100) * value / 100;
            int i2 = pColor / 100;
            switch (i2) {
                case 0: {
                    rgb[0] = value * 255 / 100;
                    rgb[1] = p3 * 255 / 100;
                    rgb[2] = p1 * 255 / 100;
                    break;
                }
                case 1: {
                    rgb[0] = p2 * 255 / 100;
                    rgb[1] = value * 255 / 100;
                    rgb[2] = p1 * 255 / 100;
                    break;
                }
                case 2: {
                    rgb[0] = p1 * 255 / 100;
                    rgb[1] = value * 255 / 100;
                    rgb[2] = p3 * 255 / 100;
                    break;
                }
                case 3: {
                    rgb[0] = p1 * 255 / 100;
                    rgb[1] = p2 * 255 / 100;
                    rgb[2] = value * 255 / 100;
                    break;
                }
                case 4: {
                    rgb[0] = p3 * 255 / 100;
                    rgb[1] = p1 * 255 / 100;
                    rgb[2] = value * 255 / 100;
                    break;
                }
                case 5: {
                    rgb[0] = value * 255 / 100;
                    rgb[1] = p1 * 255 / 100;
                    rgb[2] = p2 * 255 / 100;
                }
            }
        }
        int red = rgb[0] << 16;
        int green = rgb[1] << 8;
        int blue = rgb[2];
        int color = red | green | blue;
        return color;
    }

    public static final boolean insideLimits(int min, int max, int value) {
        return value >= min && value < max;
    }
}

