/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Graphics;
import sk.inlogic.Jewel;
import sk.inlogic.util.RandomNum;
import sk.inlogic.util.Rectangle;

public class Storm {
    public static int[] _iPoints = new int[64];

    public static int getCount() {
        for (int i = 0; i < 64; ++i) {
            if (_iPoints[i] != -1) continue;
            return i - 1;
        }
        return 0;
    }

    public static void reset(int startPos) {
        Storm._iPoints[0] = startPos;
        for (int i = 1; i < 64; ++i) {
            Storm._iPoints[i] = -1;
        }
    }

    public static void addPoint(int pos) {
        int i = 0;
        for (i = 0; i < 64 && _iPoints[i] != -1; ++i) {
        }
        Storm._iPoints[i] = pos;
    }

    public static void paint(Graphics g, Rectangle rectGameArea) {
        for (int i = 1; i < 64 && _iPoints[i] != -1; ++i) {
            Storm.paintOne(g, _iPoints[i - 1], _iPoints[i], rectGameArea);
        }
    }

    private static void paintOne(Graphics g, int pos1, int pos2, Rectangle rectGameArea) {
        int yAdd;
        int xAdd;
        int x1 = rectGameArea.x + pos1 % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1);
        int y1 = rectGameArea.y + pos1 / 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1);
        int x2 = rectGameArea.x + pos2 % 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1);
        int y2 = rectGameArea.y + pos2 / 8 * Jewel.BLOCKSIZE + (Jewel.BLOCKSIZE >> 1);
        int c = Jewel.BLOCKSIZE >> 1;
        int c2 = Jewel.BLOCKSIZE >> 2;
        int color = 59107;
        int last_x2 = x2;
        int last_y2 = y2;
        int deltax = x2 - x1;
        int deltay = y2 - y1;
        int count = Math.abs(deltax) > Math.abs(deltay) ? Math.abs(deltax) : Math.abs(deltay);
        int skip_count = RandomNum.getRandomUInt(c);
        if (count != 0) {
            xAdd = (deltax << 8 << 8) / (count << 8);
            yAdd = (deltay << 8 << 8) / (count << 8);
        } else {
            xAdd = 0;
            yAdd = 0;
        }
        int x = x1 << 8;
        int y = y1 << 8;
        for (int k = 1; k <= count; ++k) {
            x += xAdd;
            y += yAdd;
            if (skip_count > 0) {
                --skip_count;
            } else {
                skip_count = RandomNum.getRandomUInt(c);
                x2 = (x >> 8) + RandomNum.getRandomInt(c2);
                y2 = (y >> 8) + RandomNum.getRandomInt(c2);
                g.setColor(color);
                g.drawLine(x1, y1, x2, y2);
                x1 = x2;
                y1 = y2;
            }
            if (k != count) continue;
            g.drawLine(x1, y1, last_x2, last_y2);
        }
    }
}

