/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.screen;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.AnimationComponent;
import sk.inlogic.MainCanvas;
import sk.inlogic.Resources;
import sk.inlogic.Settings;
import sk.inlogic.Sounds;
import sk.inlogic.screen.IScreen;
import sk.inlogic.screen.ScreenMenu;
import sk.inlogic.text.PreparedText;
import sk.inlogic.util.Keys;
import sk.inlogic.util.Rectangle;

public class ScreenSplash
implements IScreen {
    private static final int MODE_ENABLE_MUSIC_QUESTION = 0;
    private static final int MODE_COMPANY_LOGO = 1;
    private static final int MODE_SPLASH = 2;
    private static final int MODE_MENU = 3;
    private static final int MODE_TIME = 3000;
    private MainCanvas mainCanvas;
    private int _iMode;
    private int _iKcode;
    private int _iInteruption = 0;
    private int _WIDTH = 0;
    private int _HEIGHT = 0;
    private int COMP_ID_YES = 0;
    private int COMP_ID_NO = 1;
    private int _iSequence = 0;
    private int _iSequenceStop = 0;
    private int _iSequenceShow = 1;
    private int _iSequenceHide = 2;
    private int _iNextMode;
    private boolean _bChangeSequence = false;
    private long _iModeDelay;
    private Rectangle[] _rectItems = new Rectangle[2];
    private Rectangle _rectDialog;
    private Image _imgBg;
    private Image _imgSplash;
    private Image _imgMusic;
    private Image _imgCorpLogo;
    private Sprite _sprButtonRls;
    private Sprite _sprFkIcons;
    private PreparedText _ptTitle;
    private int[][] _animationSequence = new int[3][3];
    private AnimationComponent[] _animationComponents = new AnimationComponent[3];

    public ScreenSplash(MainCanvas mainCanvas) {
        this.mainCanvas = mainCanvas;
        this._iMode = 0;
        this.initDimensions();
    }

    public void beforeShow() {
        Resources.loadImages(new int[]{2, 7, 1, 3});
        Resources.loadSprites(new int[]{4, 0});
        Resources.loadGFont(0);
        Resources.loadText(0);
        this._iModeDelay = 3000L;
        this.initImages();
        this.initSprites();
        this.initFonts();
        this.prepareTxt();
        this.calculatePosition();
        this.initAnimationSequences();
        this.initAnimationComponents();
        this.startAnimation(true, 0);
    }

    public void afterHide() {
        Resources.freeImages(new int[]{2, 7, 1, 3});
        Resources.freeSprites(new int[]{4, 0});
        Resources.freeGFont(0);
        this.freeResources();
    }

    private void initDimensions() {
        this._WIDTH = this.mainCanvas.getWidth();
        this._HEIGHT = this.mainCanvas.getHeight();
    }

    private void initSprites() {
        this._sprButtonRls = Resources.resSprs[4];
        this._sprFkIcons = Resources.resSprs[0];
    }

    private void initImages() {
        this._imgBg = Resources.resImgs[2];
        this._imgSplash = Resources.resImgs[1];
        this._imgMusic = Resources.resImgs[7];
        this._imgCorpLogo = Resources.resImgs[3];
    }

    private void initFonts() {
        this._ptTitle = new PreparedText(Resources.resGFonts[0]);
    }

    private void initAnimationSequences() {
        this._animationSequence[0][0] = 0;
        this._animationSequence[0][1] = 1;
        this._animationSequence[0][2] = 2;
        this._animationSequence[1][0] = 0;
        this._animationSequence[1][1] = 1;
        this._animationSequence[1][2] = 2;
        this._animationSequence[2][0] = 0;
        this._animationSequence[2][1] = 2;
        this._animationSequence[2][2] = 1;
    }

    private void initAnimationComponents() {
        this._animationComponents[0] = new AnimationComponent(this.mainCanvas, this._rectDialog, this._WIDTH, this._HEIGHT);
        this._animationComponents[1] = new AnimationComponent(this.mainCanvas, this._rectItems[this.COMP_ID_NO], this._WIDTH, this._HEIGHT);
        this._animationComponents[2] = new AnimationComponent(this.mainCanvas, this._rectItems[this.COMP_ID_YES], this._WIDTH, this._HEIGHT);
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
    }

    private void showAnimationComponent() {
        this._animationComponents[0].startShowAnimation(2);
        this._animationComponents[1].startShowAnimation(1);
        this._animationComponents[2].startShowAnimation(0);
    }

    private void hideAnimationComponent() {
        this._animationComponents[0].startHideAnimation(2);
        this._animationComponents[1].startHideAnimation(0);
        this._animationComponents[2].startHideAnimation(1);
    }

    private void prepareTxt() {
        this._ptTitle.prepareText(Resources.resTexts[0].getHashedString(28), this.mainCanvas.getWidth());
    }

    private void freeResources() {
        this._imgBg = null;
        this._imgSplash = null;
        this._imgMusic = null;
        this._imgCorpLogo = null;
        this._sprButtonRls = null;
        this._sprFkIcons = null;
        this._ptTitle = null;
    }

    public void calculatePosition() {
        this._rectDialog = new Rectangle(0, 0, this._WIDTH, this._HEIGHT);
        this._rectItems[this.COMP_ID_YES] = new Rectangle(0, MainCanvas.HEIGHT - this._sprButtonRls.getHeight(), this._sprButtonRls.getWidth(), this._sprButtonRls.getHeight());
        this._rectItems[this.COMP_ID_NO] = new Rectangle(MainCanvas.WIDTH - this._sprButtonRls.getWidth(), MainCanvas.HEIGHT - this._sprButtonRls.getHeight(), this._sprButtonRls.getWidth(), this._sprButtonRls.getHeight());
    }

    public void beforeInteruption() {
        if (this._iMode == 0) {
            this.mainCanvas.getSoundManager().Stop();
        }
        this.mainCanvas.getSoundManager().Stop();
        this._iInteruption = 1;
    }

    public void afterInteruption() {
        if (this._iInteruption == 0 && this.mainCanvas.getSoundManager().IsSoundOn()) {
            this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
        if (this._iMode == 0) {
            this.mainCanvas.getSoundManager().Stop();
        }
    }

    public void update(long lastRunLenght) {
        switch (this._iMode) {
            case 1: {
                if (this._iModeDelay > 0L) {
                    this._iModeDelay -= lastRunLenght;
                    break;
                }
                this._iModeDelay = 3000L;
                this.nextMode();
                break;
            }
            case 2: {
                if (this._iModeDelay > 0L) {
                    this._iModeDelay -= lastRunLenght;
                    break;
                }
                this._iModeDelay = 3000L;
                this.nextMode();
                break;
            }
            case 0: {
                if (Keys.isFKRightCode(this._iKcode)) {
                    MainCanvas.music = false;
                    Settings.musicOn = false;
                    this.mainCanvas.getSoundManager().SetSoundOn(false);
                    break;
                }
                if (!Keys.isFKLeftCode(this._iKcode)) break;
                MainCanvas.music = true;
                Settings.musicOn = true;
                this.mainCanvas.getSoundManager().SetSoundOn(true);
            }
        }
        this.animationController();
        this.animationComponentsUpdate();
    }

    private void nextMode() {
        switch (this._iMode) {
            case 0: {
                this.startAnimation(true, 1);
                this.mainCanvas.repaint();
                this.mainCanvas.serviceRepaints();
                break;
            }
            case 1: {
                this.startAnimation(true, 2);
                this.mainCanvas.repaint();
                this.mainCanvas.serviceRepaints();
                break;
            }
            case 2: {
                this.startAnimation(true, 3);
                this.mainCanvas.repaint();
                this.mainCanvas.serviceRepaints();
            }
        }
    }

    private void startAnimation(boolean changeSequencem, int nextMode) {
        this._bChangeSequence = changeSequencem;
        this._iNextMode = nextMode;
        this._iSequence = this._iSequenceHide;
    }

    private boolean animationController() {
        if (this._bChangeSequence) {
            if (this._iSequence == this._iSequenceShow) {
                this.showAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceHide) {
                this.hideAnimationComponent();
                this._bChangeSequence = false;
            } else if (this._iSequence == this._iSequenceStop) {
                this._bChangeSequence = false;
            }
        }
        return false;
    }

    private void animationComponentsUpdate() {
        boolean _return = false;
        for (int i = 0; i < this._animationSequence[this._iMode].length; ++i) {
            if (this._animationSequence[this._iMode][i] == -1 || this._animationComponents[this._animationSequence[this._iMode][i]] == null || this._animationComponents[this._animationSequence[this._iMode][i]].isComponentAnimated()) continue;
            this._animationComponents[this._animationSequence[this._iMode][i]].update();
            this.mainCanvas.repaint();
            _return = true;
        }
        if (!_return) {
            if (this._iSequence == this._iSequenceHide) {
                if (this._iNextMode == 3) {
                    this.startMenuScreen();
                }
                this._iSequence = this._iSequenceShow;
                this._iMode = this._iNextMode;
                this._bChangeSequence = true;
            } else if (this._iSequence == this._iSequenceShow) {
                this._iSequence = this._iSequenceStop;
            }
        }
    }

    private void startMenuScreen() {
        ScreenMenu sg = new ScreenMenu(this.mainCanvas, 0);
        if (this.mainCanvas.getSoundManager().IsSoundOn()) {
            this.mainCanvas.getSoundManager().Play(Sounds.SOUND_MENU, -1);
        }
        this.mainCanvas.changeLastActiveScreen(sg);
    }

    public void paint(Graphics g) {
        this.paintBackground(g);
        switch (this._iMode) {
            case 0: {
                this.paintMusic(g);
                break;
            }
            case 1: {
                this.paintCorpLogo(g);
                break;
            }
            case 2: {
                this.paintSpash(g);
            }
        }
    }

    private void paintBackground(Graphics g) {
        g.drawImage(this._imgBg, 0, 0, 20);
    }

    private void paintMusic(Graphics g) {
        this.paintMusicBody(g);
        this.paintMusicFk(g);
    }

    private void paintCorpLogo(Graphics g) {
        g.drawImage(this._imgCorpLogo, this._rectDialog.getCenterX(), this._rectDialog.getCenterY(), 3);
    }

    private void paintSpash(Graphics g) {
        g.drawImage(this._imgSplash, this._rectDialog.getCenterX(), this._rectDialog.getCenterY(), 3);
    }

    private void paintMusicBody(Graphics g) {
        this.paintMusicImg(g);
    }

    private void paintMusicImg(Graphics g) {
        g.drawImage(this._imgMusic, this._rectDialog.getCenterX(), this._rectDialog.getCenterY(), 3);
    }

    private void paintMusicFk(Graphics g) {
        this._sprButtonRls.setFrame(0);
        this._sprButtonRls.setPosition(this._rectItems[this.COMP_ID_NO].x, this._rectItems[this.COMP_ID_NO].y);
        this._sprButtonRls.paint(g);
        this._sprButtonRls.setFrame(2);
        this._sprButtonRls.setPosition(this._rectItems[this.COMP_ID_YES].x, this._rectItems[this.COMP_ID_YES].y);
        this._sprButtonRls.paint(g);
        this._sprFkIcons.setFrame(2);
        this._sprFkIcons.setPosition(this._rectItems[this.COMP_ID_NO].x + (this._sprButtonRls.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1), this._rectItems[this.COMP_ID_NO].y + (this._sprButtonRls.getHeight() >> 1) - (this._sprFkIcons.getHeight() >> 1));
        this._sprFkIcons.paint(g);
        this._sprFkIcons.setFrame(1);
        this._sprFkIcons.setPosition(this._rectItems[this.COMP_ID_YES].x + (this._sprButtonRls.getWidth() >> 1) - (this._sprFkIcons.getWidth() >> 1), this._rectItems[this.COMP_ID_YES].y + (this._sprButtonRls.getHeight() >> 1) - (this._sprFkIcons.getHeight() >> 1));
        this._sprFkIcons.paint(g);
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
        switch (this._iMode) {
            case 0: {
                if (Keys.isFKLeftCode(keyCode)) {
                    this._iKcode = keyCode;
                    Settings.musicOn = true;
                    this.mainCanvas.getSoundManager().SetSoundOn(true);
                    this.nextMode();
                    break;
                }
                if (!Keys.isFKRightCode(keyCode)) break;
                this._iKcode = keyCode;
                Settings.musicOn = false;
                this.mainCanvas.getSoundManager().SetSoundOn(false);
                this.nextMode();
                break;
            }
            case 1: 
            case 2: {
                if (!Keys.isActionGeneratedByKey(5, keyCode)) break;
                this.nextMode();
            }
        }
    }

    public void pointerPressed(int x, int y) {
        switch (this._iMode) {
            case 0: {
                for (int i = 0; i < this._rectItems.length; ++i) {
                    if (!this._rectItems[i].contains(x, y)) continue;
                    if (i == this.COMP_ID_YES) {
                        Settings.musicOn = true;
                        MainCanvas.music = true;
                        this.mainCanvas.getSoundManager().SetSoundOn(true);
                        this.nextMode();
                        continue;
                    }
                    if (i != this.COMP_ID_NO) continue;
                    Settings.musicOn = false;
                    this.mainCanvas.getSoundManager().SetSoundOn(false);
                    this.nextMode();
                    MainCanvas.music = false;
                }
                break;
            }
            case 2: {
                Keys.keyPressed(53);
            }
        }
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        switch (this._iMode) {
            case 0: {
                for (int i = 0; i < this._rectItems.length; ++i) {
                    if (!this._rectItems[i].contains(x, y)) continue;
                    if (i == this.COMP_ID_YES) {
                        Settings.musicOn = true;
                        MainCanvas.music = true;
                        this.mainCanvas.getSoundManager().SetSoundOn(true);
                        this.nextMode();
                        continue;
                    }
                    if (i != this.COMP_ID_NO) continue;
                    Settings.musicOn = false;
                    this.mainCanvas.getSoundManager().SetSoundOn(false);
                    this.nextMode();
                    MainCanvas.music = false;
                }
                break;
            }
            case 1: 
            case 2: {
                if (!Keys.isKeyPressed(53)) break;
                this.keyReleased(53);
                Keys.keyReleased(53);
            }
        }
    }
}

