/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic;

import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.Common;
import sk.inlogic.X;
import sk.inlogic.graphics.GFont;
import sk.inlogic.text.ResourceBundle;

public class Resources {
    private static String graphicsBaseDir = "/";
    private static String graphicsDisplayDir = "/";
    private static String langDir = "/";
    public static final int _IMG_RES_ROTATION = 0;
    public static final int _IMG_SPLASH = 1;
    public static final int _IMG_BG = 2;
    public static final int _IMG_CORP_LOGO = 3;
    public static final int _IMG_GAME_LOGO = 4;
    public static final int _IMG_GAME_DARK_TILE = 5;
    public static final int _IMG_GAME_BRIGHT_TILE = 6;
    public static final int _IMG_MUSIC = 7;
    public static final int _IMG_LVL_LOCK = 8;
    public static final int _IMG_LVL_STAR = 9;
    public static final int _IMG_LANGUAGE_SELECTOR = 10;
    public static final int _IMG_LANGUAGE_ITALIANO = 11;
    public static final int TOTAL_IMGS = 12;
    public static Image[] resImgs = new Image[12];
    public static final int _SPR_FK_ICONS = 0;
    public static final int _SPR_MENU_ICONS = 1;
    public static final int _SPR_GAME_ICONS = 2;
    public static final int _SPR_BUTTON_PRS = 3;
    public static final int _SPR_BUTTON_RLS = 4;
    public static final int _SPR_BUTTON_BAR = 5;
    public static final int _SPR_GAME_JELLY = 6;
    public static final int _SPR_GAME_JELLY_SELECTOR = 7;
    public static final int _SPR_GAME_BONUS_SPECTRUM = 8;
    public static final int _SPR_GAME_BONUS_BOMB = 9;
    public static final int _SPR_GAME_BONUS_CROSS = 10;
    public static final int _SPR_GAME_BONUS_FALL_ESC = 11;
    public static final int _SPR_GAME_BLOCKS = 12;
    public static final int _SPR_GAME_PARTICLES = 13;
    public static final int _SPR_GAME_FLAME = 14;
    public static final int _SPR_GAME_TOP_BAR = 15;
    public static final int _SPR_ARROW = 16;
    public static final int _SPR_LANGUAGE = 17;
    public static final int _SPR_WINDOWS = 18;
    public static final int TOTAL_SPRS = 29;
    public static Sprite[] resSprs = new Sprite[29];
    public static final int GFONT_MAIN = 0;
    public static final int GFONT_GAME = 1;
    public static final int TOTAL_GFONTS = 2;
    public static GFont[] resGFonts = new GFont[2];
    public static final int TEXT_MAIN = 0;
    public static final int TOTAL_TEXTS = 1000;
    public static ResourceBundle[] resTexts = new ResourceBundle[1000];
    public static final int TEXT_MAIN_INSTRUCTIONS = 1;
    public static final int TEXT_REALY_QUIT = 2;
    public static final int TEXT_MAIN_ENABLE_MUSIC = 5;
    public static final int TEXT_MAIN_YES = 6;
    public static final int TEXT_MAIN_NO = 7;
    public static final int TEXT_LEVEL = 8;
    public static final int TEXT_COMPLETED = 9;
    public static final int TEXT_SCORE = 10;
    public static final int TEXT_TIMEISUP = 11;
    public static final int TEXT_NOMOREMOVES = 12;
    public static final int TEXT_GAMEOVER = 13;
    public static final int TEXT_CONTINUE = 14;
    public static final int TEXT_NEWRECORD = 15;
    public static final int TEXT_CONTROLS_NOTOUCH = 16;
    public static final int TEXT_CONTROLS_TOUCH_1 = 17;
    public static final int TEXT_MENU_ITEMS = 18;
    public static final int TEXT_MENU = 19;
    public static final int TEXT_BACK = 20;
    public static final int TEXT_NEW_GAME = 21;
    public static final int TEXT_INSTRUCT = 22;
    public static final int TEXT_ABOUT = 23;
    public static final int TEXT_CONT = 24;
    public static final int TEXT_RESTART = 25;
    public static final int TEXT_ON = 26;
    public static final int TEXT_OFF = 27;
    public static final int TEXT_SOUNDS = 28;
    public static final int TEXT_TUTORIAL_KEYBOARD = 29;
    public static final int TEXT_TUTORIAL_TOUCH = 30;
    public static final int TEXT_TUTORIAL_MOVES = 31;
    public static final int TEXT_TUTORIAL_BLOCKS = 32;
    public static final int TEXT_TUTORIAL_ESCAPE = 33;
    public static final int TEXT_TUTORIAL_DOWNFALL = 34;
    public static final int TEXT_TUTORIAL_TIME_ATTACK = 35;
    public static final int TEXT_GOALS_SCORE_GET = 36;
    public static final int TEXT_GOALS_SCORE_POINTS = 37;
    public static final int TEXT_GOALS_BLOCKS = 38;
    public static final int TEXT_GOALS_ESCAPE_POP = 39;
    public static final int TEXT_GOALS_ESCAPE_DIAMONDS = 40;
    public static final int TEXT_GOALS_DOWNFALL_BRING = 41;
    public static final int TEXT_GOALS_DOWNFALL_DIAMONDS = 42;
    public static final int TEXT_GOALS_MOVES_MAKE = 43;
    public static final int TEXT_GOALS_MOVES_TURNS = 44;
    public static final int TEXT_GOALS_TIME_ADD_WITHIN = 45;
    public static final int TEXT_GOALS_TIME_ADD_SECONDS = 46;
    public static final int TEXT_GOALS_TURNS_ADD_WITHIN = 47;
    public static final int TEXT_GOALS_TURNS_ADD_TURNS = 48;
    public static final int TEXT_RESULT_WELL_DONE = 49;
    public static final int TEXT_RESULT_GLAMOROUS = 50;
    public static final int TEXT_RESULT_SHINY = 51;
    public static final int TEXT_RESULT_GAME_OVER = 52;
    public static final int TEXT_CONTROLS_TOUCH_2 = 53;
    public static final int TEXT_CONTROLS_KEYS = 54;
    public static final int TEXT_RESULT_TITLE = 56;
    public static final int TEXT_RESULT_BOMB_LEFT = 57;
    public static final int TEXT_RESULT_DIAMOND = 58;
    public static final int TEXT_RESULT_RING = 59;
    public static final int TEXT_RESULT_TITLE_LOSE = 60;
    public static final int TEXT_RESULT_LOSE_OUT_OF_OPTIONS = 61;
    public static final int TEXT_RESULT_LOSE_BUBBLE_ESCAPED = 62;
    public static final int TEXT_RESULT_LOSE_OUT_OF_MOVES = 63;
    public static final int TEXT_RESULT_LOSE_OUT_OF_TIMES = 64;
    public static final int TEXT_RESULT_FAIL_POINTS = 65;
    public static final int TEXT_RESULT_FAIL_BLOCKS = 66;
    public static final int TEXT_RESULT_FAIL_RING = 67;
    public static final int TEXT_RESULT_FAIL_DIAMOND = 68;
    public static final int TEXT_RESULT_FAIL_MOVES = 69;
    public static final int TEXT_CLASSIC_PACK = 70;
    public static final int TEXT_BONUS_PACK = 71;
    public static final int TEXT_LAST_MESSAGE_FAIL = 72;
    public static final int TEXT_LAST_MESSAGE_OK = 73;
    public static final int TEXT_LAST_MESSAGE_SURPRISE = 74;
    public static final int TEXT_LAST_MESSAGE_BONUS_FAIL = 75;
    public static final int TEXT_LAST_MESSAGE_BONUS_OK = 76;
    public static final int TEXT_INGAME_REALY_QUIT = 77;
    public static final int TEXT_RESTART_QUESTIONS = 78;
    public static boolean sysFont;
    public static int widht;

    public static void initGraphicsDirs(int width, int height) {
        System.out.println(widht + " : " + width);
        graphicsBaseDir = "/" + width + "x" + height + "/";
        graphicsDisplayDir = "/" + width + "x" + height + "/";
        if (width == 240) {
            if (height > 320) {
                graphicsBaseDir = "/240x400/";
                graphicsDisplayDir = "/240x400/";
            } else {
                graphicsBaseDir = "/240x320/";
                graphicsDisplayDir = "/240x320/";
            }
        }
    }

    public static Image createImage(String imgName) {
        Image image = null;
        try {
            Common.trace(imgName);
            image = Image.createImage((String)imgName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return image;
    }

    public static Sprite createSprite(Image image, int slicesX, int slicesY) {
        Sprite sprite = null;
        try {
            int sprWidth = image.getWidth() / slicesX;
            int sprHeight = image.getHeight() / slicesY;
            sprite = new Sprite(image, sprWidth, sprHeight);
        }
        catch (Exception e) {
            sprite = null;
        }
        return sprite;
    }

    public static void loadImage(int imgIdx) {
        String imgPath = null;
        switch (imgIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "rot.png";
                break;
            }
            case 1: {
                imgPath = graphicsDisplayDir + "s.png";
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "background.png";
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "l.png";
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "jewels.png";
                break;
            }
            case 5: {
                imgPath = graphicsDisplayDir + "DarkTile.png";
                break;
            }
            case 6: {
                imgPath = graphicsDisplayDir + "BrightTile.png";
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "sound.png";
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "lock.png";
                break;
            }
            case 9: {
                imgPath = graphicsBaseDir + "star_level.png";
                break;
            }
            case 10: {
                imgPath = graphicsBaseDir + "LangSlctr.png";
                break;
            }
            case 11: {
                imgPath = graphicsBaseDir + "language2.png";
            }
        }
        if (imgPath != null && resImgs[imgIdx] == null) {
            Resources.resImgs[imgIdx] = Resources.createImage(imgPath);
        }
    }

    public static void freeImage(int imgIdx) {
        Resources.resImgs[imgIdx] = null;
    }

    public static void loadImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.loadImage(imgsIdx[i]);
        }
    }

    public static void freeImages(int[] imgsIdx) {
        for (int i = 0; i < imgsIdx.length; ++i) {
            Resources.resImgs[imgsIdx[i]] = null;
        }
    }

    public static void loadSprite(int sprIdx) {
        String imgPath = null;
        int slicesX = 1;
        int slicesY = 1;
        switch (sprIdx) {
            case 0: {
                imgPath = graphicsBaseDir + "MnuFK.png";
                slicesX = 11;
                slicesY = 1;
                break;
            }
            case 1: {
                imgPath = graphicsBaseDir + "menu_icons.png";
                slicesX = 7;
                slicesY = 1;
                break;
            }
            case 2: {
                imgPath = graphicsBaseDir + "level_icons.png";
                slicesX = 5;
                slicesY = 1;
                break;
            }
            case 3: {
                imgPath = graphicsBaseDir + "buton_bg.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 4: {
                imgPath = graphicsBaseDir + "buton_bg_2.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 5: {
                imgPath = graphicsBaseDir + "time_bar.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 6: {
                imgPath = graphicsBaseDir + "GamDiaAnm.png";
                slicesX = 2;
                slicesY = 7;
                break;
            }
            case 7: {
                imgPath = graphicsBaseDir + "GamSlctr.png";
                slicesX = 2;
                slicesY = 1;
                break;
            }
            case 8: {
                imgPath = graphicsBaseDir + "GamBnsSpectrum.png";
                slicesX = 5;
                slicesY = 1;
                break;
            }
            case 9: {
                imgPath = graphicsBaseDir + "GamBnsBomb.png";
                slicesX = 2;
                slicesY = 7;
                break;
            }
            case 10: {
                imgPath = graphicsBaseDir + "GamBnsCross.png";
                slicesX = 2;
                slicesY = 7;
                break;
            }
            case 11: {
                imgPath = graphicsBaseDir + "GamBnsFallF.png";
                slicesX = 8;
                slicesY = 1;
                break;
            }
            case 12: {
                imgPath = graphicsBaseDir + "GamBlock.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 13: {
                imgPath = graphicsBaseDir + "GamParticles.png";
                slicesX = 6;
                slicesY = 7;
                break;
            }
            case 14: {
                imgPath = graphicsBaseDir + "GamFlame.png";
                slicesX = 6;
                slicesY = 1;
                break;
            }
            case 15: {
                imgPath = graphicsBaseDir + "game_bar.png";
                slicesX = 3;
                slicesY = 1;
                break;
            }
            case 16: {
                imgPath = graphicsBaseDir + "menu_arow.png";
                slicesX = 1;
                slicesY = 1;
                break;
            }
            case 17: {
                imgPath = graphicsBaseDir + "language.png";
                slicesX = 2;
                slicesY = 3;
                break;
            }
            case 18: {
                imgPath = graphicsBaseDir + "inst_bg.png";
                slicesX = 3;
                slicesY = 3;
            }
        }
        if (imgPath != null && resSprs[sprIdx] == null) {
            Resources.resSprs[sprIdx] = Resources.createSprite(Resources.createImage(imgPath), slicesX, slicesY);
        }
    }

    public static void freeSprite(int sprIdx) {
        Resources.resSprs[sprIdx] = null;
    }

    public static void loadSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.loadSprite(sprsIdx[i]);
        }
    }

    public static void freeSprites(int[] sprsIdx) {
        for (int i = 0; i < sprsIdx.length; ++i) {
            Resources.resSprs[sprsIdx[i]] = null;
        }
    }

    private static GFont createGFontMenu(Image gFontImg) {
        char[] fontChars = new char[]{'A', 'B', '\u00c6', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c1', '\u00c0', '\u00c4', '\u00c5', '\u00c2', '\u00c3', '\u00c7', '\u010c', '\u010e', '\u00c9', '\u00c8', '\u00cb', '\u00ca', '\u00cc', '\u00cd', '\u00cf', '\u00ce', '\u013d', '\u00d1', '\u0147', '\u00d2', '\u00d3', '\u00d6', '\u00d4', '\u00d5', '\u00d9', '\u00da', '\u00dc', '\u00dd', '\u016e', '\u0154', '\u0158', '\u0160', '\u015a', '\u0164', '\u017d', '$', '\u00a3', '\u00a5', '#', '&', '*', '@', '\\', '\u20ac', '\u00ae', '\u00a9', '\u2122', '[', '(', '{', '}', ')', ']', '|', '%', '\u00b0', '<', '>', '+', '=', '.', ',', ':', ';', '\'', '`', '\u201c', '!', '?', '-', '_', '\u00f7', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u00df', '\u00d0', '\u00bf', '\u00a1', '/'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 9: {
                fontCharsWidth = new short[]{5, 4, 7, 4, 5, 4, 3, 5, 5, 2, 3, 4, 4, 5, 5, 6, 4, 6, 4, 4, 4, 5, 4, 6, 4, 5, 4, 5, 6, 6, 5, 5, 6, 4, 4, 5, 4, 4, 4, 4, 2, 3, 3, 3, 4, 5, 4, 5, 5, 5, 6, 6, 4, 5, 4, 4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 4, 2, 7, 3, 5, 7, 7, 6, 2, 3, 3, 3, 2, 2, 1, 4, 3, 4, 4, 5, 4, 2, 1, 2, 1, 2, 2, 2, 2, 4, 2, 4, 5, 4, 1, 4, 4, 4, 3, 4, 3, 4, 4, 7, 5, 4, 2, 3, 0};
                break;
            }
            case 13: {
                fontCharsWidth = new short[]{5, 5, 5, 5, 5, 5, 5, 5, 2, 5, 5, 4, 7, 5, 5, 5, 5, 5, 5, 6, 5, 5, 7, 5, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 2, 2, 3, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 6, 5, 5, 5, 5, 6, 7, 4, 4, 3, 3, 6, 4, 5, 5, 5, 5, 5, 1, 2, 1, 2, 2, 4, 1, 5, 1, 5, 6, 4, 5, 4, 5, 5, 6, 5, 5, 5, 5, 5};
                break;
            }
            case 14: {
                fontCharsWidth = new short[]{8, 10, 5, 6, 6, 7, 6, 5, 6, 6, 2, 5, 6, 5, 8, 6, 6, 6, 5, 6, 6, 5, 6, 6, 8, 10, 6, 6, 7, 8, 8, 8, 8, 8, 8, 6, 6, 6, 6, 6, 6, 6, 6, 3, 3, 4, 4, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 6, 7, 5, 6, 6, 6, 6, 7, 4, 9, 4, 7, 8, 8, 9, 3, 4, 4, 4, 4, 3, 2, 7, 4, 4, 4, 6, 5, 6, 5, 4, 2, 2, 2, 2, 2, 3, 4, 2, 6, 2, 5, 6, 3, 5, 3, 5, 5, 6, 5, 5, 5, 5, 5};
                break;
            }
            case 17: {
                fontCharsWidth = new short[]{10, 8, 13, 7, 9, 8, 7, 9, 10, 3, 7, 8, 7, 11, 9, 10, 8, 12, 8, 7, 7, 9, 8, 11, 8, 8, 8, 10, 9, 11, 10, 10, 9, 7, 8, 9, 8, 7, 7, 8, 4, 4, 6, 6, 7, 9, 9, 11, 10, 10, 10, 10, 9, 9, 9, 8, 8, 8, 8, 7, 6, 7, 8, 6, 8, 9, 9, 8, 5, 10, 5, 8, 12, 12, 12, 5, 5, 5, 5, 5, 5, 3, 8, 6, 7, 8, 8, 9, 3, 2, 3, 3, 3, 4, 5, 4, 7, 4, 9, 9, 7, 4, 7, 7, 7, 8, 8, 7, 7, 7, 12, 9, 7, 3, 5, 0};
                break;
            }
            case 23: {
                fontCharsWidth = new short[]{13, 11, 17, 9, 12, 10, 9, 12, 12, 4, 9, 12, 10, 16, 11, 14, 11, 15, 11, 9, 9, 12, 11, 15, 12, 10, 10, 13, 13, 13, 13, 13, 13, 10, 11, 12, 10, 9, 10, 9, 5, 5, 9, 8, 10, 12, 12, 14, 14, 14, 13, 14, 11, 12, 12, 11, 11, 11, 11, 8, 8, 10, 10, 8, 11, 11, 12, 12, 5, 15, 7, 11, 16, 16, 16, 7, 6, 8, 7, 6, 7, 4, 11, 7, 10, 9, 11, 11, 3, 4, 3, 4, 4, 5, 6, 4, 9, 5, 11, 11, 10, 5, 10, 9, 10, 9, 10, 9, 10, 10, 16, 13, 9, 4, 7, 0};
                break;
            }
            case 24: {
                fontCharsWidth = new short[]{13, 12, 12, 14, 13, 11, 13, 14, 7, 10, 14, 12, 17, 14, 14, 12, 15, 14, 11, 12, 13, 14, 17, 14, 14, 10, 13, 14, 13, 14, 13, 14, 11, 12, 14, 12, 12, 12, 13, 13, 7, 7, 7, 7, 12, 15, 15, 14, 14, 14, 14, 14, 13, 13, 13, 13, 13, 14, 13, 12, 11, 10, 11, 10, 10, 10, 13, 14, 16, 6, 12, 6, 6, 17, 6, 11, 11, 11, 12, 11, 4, 4, 4, 4, 5, 9, 4, 9, 3, 9, 9, 6, 11, 8, 10, 10, 10, 10, 10, 10, 11, 10};
                break;
            }
            case 26: {
                fontCharsWidth = new short[]{15, 12, 19, 11, 14, 11, 11, 14, 13, 6, 9, 13, 11, 16, 14, 15, 13, 18, 13, 9, 12, 13, 13, 17, 13, 12, 11, 15, 15, 15, 15, 15, 15, 11, 12, 14, 11, 11, 11, 11, 6, 6, 10, 9, 11, 13, 14, 15, 15, 16, 15, 15, 13, 13, 13, 13, 13, 12, 13, 9, 10, 11, 11, 10, 12, 13, 14, 13, 6, 17, 8, 12, 18, 18, 17, 7, 7, 8, 8, 7, 7, 4, 12, 8, 11, 11, 12, 13, 4, 4, 4, 4, 4, 5, 7, 5, 10, 5, 13, 13, 11, 5, 11, 10, 12, 10, 11, 11, 11, 11, 20, 14, 11, 4, 8, 0};
                break;
            }
            case 27: {
                fontCharsWidth = new short[]{15, 13, 13, 15, 13, 13, 16, 16, 8, 11, 15, 13, 19, 16, 15, 13, 17, 15, 12, 13, 15, 15, 20, 16, 15, 11, 15, 15, 15, 15, 15, 15, 13, 13, 15, 14, 14, 13, 14, 14, 8, 7, 8, 8, 13, 16, 17, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 12, 12, 13, 12, 12, 11, 14, 15, 18, 7, 13, 7, 7, 19, 7, 12, 12, 12, 13, 12, 4, 4, 4, 4, 6, 9, 4, 10, 3, 10, 10, 6, 11, 8, 11, 10, 11, 11, 11, 10, 11, 11};
                break;
            }
            case 35: {
                fontCharsWidth = new short[]{19, 17, 26, 14, 18, 15, 14, 18, 18, 7, 12, 17, 15, 22, 18, 21, 16, 24, 17, 13, 15, 18, 18, 23, 17, 17, 14, 19, 19, 20, 19, 20, 19, 14, 16, 19, 14, 14, 15, 15, 8, 8, 14, 10, 16, 18, 18, 20, 20, 20, 21, 20, 17, 18, 17, 16, 18, 16, 16, 13, 13, 14, 15, 12, 16, 17, 18, 17, 8, 23, 11, 16, 24, 24, 24, 10, 9, 11, 11, 9, 9, 6, 17, 11, 15, 15, 17, 16, 6, 5, 5, 6, 5, 7, 9, 6, 14, 7, 17, 17, 15, 7, 14, 14, 16, 14, 15, 14, 14, 15, 26, 19, 14, 6, 11, 0};
                break;
            }
            case 36: {
                fontCharsWidth = new short[]{19, 18, 17, 20, 17, 17, 20, 21, 11, 14, 21, 17, 24, 21, 20, 17, 22, 19, 16, 17, 19, 20, 25, 25, 16, 15, 20, 20, 21, 19, 19, 20, 17, 17, 20, 17, 17, 18, 18, 18, 10, 10, 11, 10, 17, 21, 21, 20, 20, 20, 20, 20, 19, 20, 19, 19, 19, 20, 19, 19, 15, 15, 17, 17, 15, 14, 18, 21, 23, 9, 16, 9, 9, 24, 9, 16, 15, 16, 18, 16, 6, 6, 5, 5, 7, 12, 6, 13, 5, 12, 14, 8, 15, 12, 14, 14, 16, 14, 14, 14, 15, 14};
                break;
            }
            case 39: {
                fontCharsWidth = new short[]{22, 19, 29, 16, 21, 16, 16, 21, 21, 8, 14, 18, 16, 25, 21, 22, 18, 27, 19, 14, 17, 20, 21, 26, 19, 19, 17, 22, 22, 22, 21, 22, 22, 16, 18, 20, 16, 16, 16, 16, 8, 9, 16, 12, 16, 20, 21, 23, 23, 23, 23, 23, 20, 19, 19, 19, 20, 19, 19, 14, 14, 16, 17, 13, 18, 19, 21, 20, 10, 26, 12, 19, 26, 27, 27, 11, 10, 12, 12, 10, 11, 7, 18, 12, 16, 17, 19, 19, 6, 7, 7, 6, 7, 8, 10, 7, 15, 9, 19, 18, 17, 8, 16, 15, 18, 15, 17, 16, 17, 17, 29, 21, 16, 7, 12, 0};
                break;
            }
            default: {
                fontCharsWidth = new short[]{13, 18, 11, 13, 12, 13, 11, 10, 14, 12, 4, 9, 12, 9, 14, 12, 14, 14, 11, 14, 13, 12, 12, 12, 14, 20, 13, 14, 11, 13, 13, 13, 13, 14, 14, 13, 12, 13, 11, 11, 11, 11, 12, 4, 5, 6, 6, 10, 11, 12, 14, 13, 14, 14, 14, 12, 12, 12, 11, 12, 13, 13, 13, 12, 12, 12, 12, 11, 10, 10, 11, 11, 12, 7, 18, 7, 11, 15, 15, 16, 5, 6, 6, 7, 6, 5, 3, 16, 6, 10, 10, 10, 10, 10, 11, 9, 3, 3, 4, 4, 3, 4, 6, 3, 10, 3, 10, 12, 6, 10, 6, 11, 10, 10, 10, 11, 10, 10, 10};
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, fontCharsWidth[0]);
    }

    private static GFont createGFontGame(Image gFontImg) {
        char[] fontChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', '/', 'm', 'd', '*'};
        short[] fontCharsWidth = null;
        int spaceBetweenChars = 1;
        switch (gFontImg.getHeight()) {
            case 8: {
                fontCharsWidth = new short[]{5, 4, 5, 5, 6, 5, 5, 5, 5, 5, 2, 4, 7, 5, 7};
                break;
            }
            case 9: {
                fontCharsWidth = new short[]{5, 2, 4, 5, 5, 4, 5, 5, 5, 5, 1, 3, 7, 7, 7, 0};
                break;
            }
            case 11: {
                fontCharsWidth = new short[]{3, 2, 3, 4, 7, 4, 7, 7, 7, 6, 7, 6, 7, 6};
                break;
            }
            case 12: {
                fontCharsWidth = new short[]{3, 3, 3, 4, 8, 5, 7, 7, 8, 8, 7, 7, 7, 7};
                break;
            }
            case 14: {
                spaceBetweenChars = 1;
                fontCharsWidth = new short[]{11, 8, 9, 9, 10, 9, 10, 10, 10, 10, 4, 6, 9, 12, 13};
                break;
            }
            case 17: {
                fontCharsWidth = new short[]{9, 5, 9, 9, 9, 8, 9, 8, 9, 9, 3, 7, 13, 13, 13, 0};
                break;
            }
            case 19: {
                fontCharsWidth = new short[]{14, 10, 13, 13, 13, 12, 13, 12, 13, 13, 5, 7, 15, 14, 15};
                break;
            }
            case 21: {
                fontCharsWidth = new short[]{15, 11, 14, 13, 15, 14, 14, 14, 15, 14, 5, 9, 16, 15, 18};
                break;
            }
            case 23: {
                fontCharsWidth = new short[]{12, 5, 12, 11, 13, 10, 13, 11, 12, 12, 4, 9, 17, 16, 17, 0};
                break;
            }
            case 26: {
                fontCharsWidth = new short[]{13, 6, 13, 12, 14, 13, 14, 13, 14, 13, 4, 10, 19, 19, 19};
                break;
            }
            case 28: {
                fontCharsWidth = new short[]{19, 13, 17, 17, 19, 18, 18, 18, 18, 17, 5, 11, 20, 19, 22};
                break;
            }
            case 31: {
                fontCharsWidth = new short[]{20, 13, 18, 18, 19, 18, 18, 18, 19, 18, 6, 11, 21, 20, 24};
                break;
            }
            case 35: {
                fontCharsWidth = new short[]{18, 9, 18, 17, 19, 17, 18, 17, 18, 17, 7, 13, 25, 25, 25, 0};
                break;
            }
            case 39: {
                fontCharsWidth = new short[]{20, 10, 19, 19, 22, 19, 20, 19, 20, 20, 7, 15, 28, 28, 29, 0};
                break;
            }
            default: {
                fontCharsWidth = new short[]{7, 8, 8, 12, 18, 14, 19, 19, 20, 19, 18, 19, 18, 18};
            }
        }
        return new GFont(gFontImg, fontChars, fontCharsWidth, spaceBetweenChars, fontCharsWidth[0]);
    }

    public static void loadGFont(int gFontIdx) {
        Image gFontImg = null;
        if (resGFonts[gFontIdx] != null) {
            return;
        }
        switch (gFontIdx) {
            case 1: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fontGame.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontGame(gFontImg);
                break;
            }
            case 0: {
                gFontImg = Resources.createImage(graphicsBaseDir + "fnt.png");
                if (gFontImg == null) break;
                Resources.resGFonts[gFontIdx] = Resources.createGFontMenu(gFontImg);
            }
        }
    }

    public static void freeGFont(int gFontIdx) {
        Resources.resGFonts[gFontIdx] = null;
    }

    public static void loadGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.loadGFont(gFontsIdx[i]);
        }
    }

    public static void freeGFonts(int[] gFontsIdx) {
        for (int i = 0; i < gFontsIdx.length; ++i) {
            Resources.resGFonts[gFontsIdx[i]] = null;
        }
    }

    public static void initLangDirs(String langCode) {
        langDir = "/lang/" + langCode + "/";
        if (langCode == "ru" || langCode == "cn") {
            sysFont = true;
        }
    }

    public static void loadText(int textIdx) {
        String textPath = null;
        switch (textIdx) {
            case 0: {
                textPath = langDir + "m.csr";
            }
        }
        Resources.resTexts[textIdx] = new ResourceBundle(X.singleton, textPath);
    }

    public static void freeText(int textIdx) {
        Resources.resTexts[textIdx] = null;
    }

    static {
        widht = 0;
    }
}

