/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.powV2;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import sk.inlogic.powV2.PowV2ScoreItem;
import sk.inlogic.rms.RMSHandler;

public class PowV2LocalScores
implements RMSHandler {
    private static final String DEFAULT_USER_NAME = "ME";
    public int userDeviceId;
    public String userName;
    public int facebookId;
    public int googleId;
    private Vector scores = null;

    public PowV2LocalScores() {
        this.setAllToDefaults();
    }

    public void setAllToDefaults() {
        this.userDeviceId = 0;
        this.userName = DEFAULT_USER_NAME;
        this.facebookId = 0;
        this.googleId = 0;
        this.scores = new Vector();
    }

    public Vector getScoresForGame(int gameId) {
        Vector<PowV2ScoreItem> scoresForGame = new Vector<PowV2ScoreItem>();
        int scoresCount = this.scores.size();
        System.out.println("scoresCount: " + scoresCount);
        System.out.println("gameid: " + gameId);
        for (int i = 0; i < scoresCount; ++i) {
            if (((PowV2ScoreItem)this.scores.elementAt((int)i)).powGameId != gameId) continue;
            if (scoresForGame == null) {
                scoresForGame = new Vector();
            }
            scoresForGame.addElement((PowV2ScoreItem)this.scores.elementAt(i));
        }
        return scoresForGame;
    }

    public void insertScoreItem(PowV2ScoreItem scoreItem, int level) {
        System.out.println("size: " + this.scores.size() + " " + " level: " + level);
        if (this.scores.isEmpty()) {
            System.out.println("som tu 1");
            this.scores.addElement(scoreItem);
        } else {
            if (this.scores.size() <= level) {
                System.out.println("som tu 2");
                this.scores.addElement(scoreItem);
            } else {
                System.out.println("som tu 3");
            }
            for (int i = 0; i < this.scores.size(); ++i) {
                PowV2ScoreItem siTmp = (PowV2ScoreItem)this.scores.elementAt(i);
                if (!scoreItem.userName.equals(siTmp.userName) || scoreItem.scoreValue <= siTmp.scoreValue) continue;
                this.scores.setElementAt(scoreItem, level);
            }
        }
    }

    public void load(DataInputStream dis, String rmsName) throws IOException {
        this.userDeviceId = dis.readInt();
        this.userName = dis.readUTF();
        this.facebookId = dis.readInt();
        this.googleId = dis.readInt();
        this.scores.removeAllElements();
        int localScoresCount = dis.readInt();
        for (int i = 0; i < localScoresCount; ++i) {
            PowV2ScoreItem score = new PowV2ScoreItem();
            score.powGameId = dis.readInt();
            score.userName = dis.readUTF();
            score.scorePos = dis.readInt();
            score.scoreValue = dis.readInt();
            this.scores.addElement(score);
        }
    }

    public void save(DataOutputStream dos, String rmsName) throws IOException {
        dos.writeInt(this.userDeviceId);
        dos.writeUTF(this.userName);
        dos.writeInt(this.facebookId);
        dos.writeInt(this.googleId);
        int localScoresCount = this.scores.size();
        dos.writeInt(localScoresCount);
        PowV2ScoreItem score = null;
        for (int i = 0; i < localScoresCount; ++i) {
            score = (PowV2ScoreItem)this.scores.elementAt(i);
            dos.writeInt(score.powGameId);
            dos.writeUTF(score.userName);
            dos.writeInt(score.scorePos);
            dos.writeInt(score.scoreValue);
        }
    }

    public void setDefault(DataOutputStream dos, String rmsName) throws IOException {
        dos.writeInt(0);
        dos.writeUTF(DEFAULT_USER_NAME);
        dos.writeInt(0);
        dos.writeInt(0);
        dos.writeInt(0);
    }
}

